/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.MethodDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Protocol;
import org.apache.avro.grpc.AvroGrpcUtils;
import org.apache.avro.grpc.AvroRequestMarshaller;
import org.apache.avro.grpc.AvroResponseMarshaller;

class ServiceDescriptor {
    private static final ConcurrentMap<String, ServiceDescriptor> SERVICE_DESCRIPTORS = new ConcurrentHashMap<String, ServiceDescriptor>();
    private final String serviceName;
    private final Protocol protocol;
    private final ConcurrentMap<String, MethodDescriptor<Object[], Object>> methods = new ConcurrentHashMap<String, MethodDescriptor<Object[], Object>>();

    private ServiceDescriptor(Class iface, String serviceName) {
        this.serviceName = serviceName;
        this.protocol = AvroGrpcUtils.getProtocol(iface);
    }

    public static ServiceDescriptor create(Class iface) {
        String serviceName = AvroGrpcUtils.getServiceName(iface);
        return SERVICE_DESCRIPTORS.computeIfAbsent(serviceName, key -> new ServiceDescriptor(iface, serviceName));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public MethodDescriptor<Object[], Object> getMethod(String methodName, MethodDescriptor.MethodType methodType) {
        return this.methods.computeIfAbsent(methodName, key -> MethodDescriptor.newBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)this.serviceName, (String)methodName)).setType(methodType).setRequestMarshaller((MethodDescriptor.Marshaller)new AvroRequestMarshaller((Protocol.Message)this.protocol.getMessages().get(methodName))).setResponseMarshaller((MethodDescriptor.Marshaller)new AvroResponseMarshaller((Protocol.Message)this.protocol.getMessages().get(methodName))).build());
    }
}

