/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.jdbc.core.ADBDriverContext;
import org.apache.asterix.jdbc.core.ADBDriverProperty;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBProtocolBase;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonParser;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonToken;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

final class ADBProtocol
extends ADBProtocolBase {
    private static final String QUERY_SERVICE_ENDPOINT_PATH = "/query/service";
    private static final String QUERY_RESULT_ENDPOINT_PATH = "/query/service/result";
    private static final String ACTIVE_REQUESTS_ENDPOINT_PATH = "/admin/requests/running";
    static final List<Class<? extends IOException>> TIMEOUT_CONNECTION_ERRORS = Collections.singletonList(ConnectTimeoutException.class);
    static final List<Class<? extends IOException>> TRANSIENT_CONNECTION_ERRORS = Arrays.asList(NoRouteToHostException.class, NoHttpResponseException.class, HttpHostConnectException.class);
    final URI queryEndpoint;
    final URI queryResultEndpoint;
    final URI activeRequestsEndpoint;
    final HttpClientConnectionManager httpConnectionManager;
    final HttpClientContext httpClientContext;
    final CloseableHttpClient httpClient;

    public ADBProtocol(String host, int port, Map<ADBDriverProperty, Object> params, ADBDriverContext driverContext) throws SQLException {
        super(driverContext, params);
        boolean sslEnabled = (Boolean)ADBDriverProperty.Common.SSL.fetchPropertyValue(params);
        URI queryEndpoint = ADBProtocol.createEndpointUri(sslEnabled, host, port, QUERY_SERVICE_ENDPOINT_PATH, driverContext.getErrorReporter());
        URI queryResultEndpoint = ADBProtocol.createEndpointUri(sslEnabled, host, port, QUERY_RESULT_ENDPOINT_PATH, driverContext.getErrorReporter());
        URI activeRequestsEndpoint = ADBProtocol.createEndpointUri(sslEnabled, host, port, this.getActiveRequestsEndpointPath(params), driverContext.getErrorReporter());
        PoolingHttpClientConnectionManager httpConnectionManager = new PoolingHttpClientConnectionManager();
        int maxConnections = Math.max(16, Runtime.getRuntime().availableProcessors());
        httpConnectionManager.setDefaultMaxPerRoute(maxConnections);
        httpConnectionManager.setMaxTotal(maxConnections);
        SocketConfig.Builder socketConfigBuilder = null;
        Number socketTimeoutMillis = (Number)ADBDriverProperty.Common.SOCKET_TIMEOUT.fetchPropertyValue(params);
        if (socketTimeoutMillis != null) {
            socketConfigBuilder = SocketConfig.custom();
            socketConfigBuilder.setSoTimeout(socketTimeoutMillis.intValue());
        }
        if (socketConfigBuilder != null) {
            httpConnectionManager.setDefaultSocketConfig(socketConfigBuilder.build());
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Number connectTimeoutMillis = (Number)ADBDriverProperty.Common.CONNECT_TIMEOUT.fetchPropertyValue(params);
        if (connectTimeoutMillis != null) {
            requestConfigBuilder.setConnectionRequestTimeout(connectTimeoutMillis.intValue());
            requestConfigBuilder.setConnectTimeout(connectTimeoutMillis.intValue());
        }
        if (socketTimeoutMillis != null) {
            requestConfigBuilder.setSocketTimeout(socketTimeoutMillis.intValue());
        }
        RequestConfig requestConfig = requestConfigBuilder.build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager(httpConnectionManager);
        httpClientBuilder.setConnectionManagerShared(true);
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.user != null) {
            String password = (String)ADBDriverProperty.Common.PASSWORD.fetchPropertyValue(params);
            httpClientBuilder.setDefaultCredentialsProvider(ADBProtocol.createCredentialsProvider(this.user, password));
        }
        this.queryEndpoint = queryEndpoint;
        this.queryResultEndpoint = queryResultEndpoint;
        this.activeRequestsEndpoint = activeRequestsEndpoint;
        this.httpConnectionManager = httpConnectionManager;
        this.httpClient = httpClientBuilder.build();
        this.httpClientContext = ADBProtocol.createHttpClientContext(queryEndpoint);
    }

    @Override
    public void close() throws SQLException {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorClosingResource(e);
        }
        finally {
            this.httpConnectionManager.shutdown();
        }
    }

    @Override
    public String connect() throws SQLException {
        String databaseVersion = this.pingImpl(-1, true);
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, String.format("connected to '%s' at %s", databaseVersion, this.queryEndpoint));
        }
        return databaseVersion;
    }

    @Override
    public boolean ping(int timeoutSeconds) {
        try {
            this.pingImpl(timeoutSeconds, false);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String pingImpl(int timeoutSeconds, boolean fetchDatabaseVersion) throws SQLException {
        HttpOptions httpOptions = new HttpOptions(this.queryEndpoint);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpOptions, this.httpClientContext);){
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    Header serverHeader;
                    String databaseVersion = null;
                    if (fetchDatabaseVersion && (serverHeader = response.getFirstHeader("Server")) != null) {
                        databaseVersion = serverHeader.getValue();
                    }
                    String string = databaseVersion;
                    return string;
                }
                case 401: 
                case 403: {
                    throw this.getErrorReporter().errorAuth();
                }
            }
            throw this.getErrorReporter().errorInConnection(String.valueOf(response.getStatusLine()));
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorInConnection(e);
        }
    }

    @Override
    public ADBProtocolBase.QueryServiceResponse submitStatement(String sql, List<?> args, ADBProtocolBase.SubmitStatementOptions options) throws SQLException {
        ADBProtocolBase.QueryServiceResponse queryServiceResponse;
        block20: {
            HttpPost httpPost = new HttpPost(this.queryEndpoint);
            httpPost.setHeader("Accept", ContentType.APPLICATION_JSON.withParameters(new BasicNameValuePair("lossless-adm", Boolean.TRUE.toString())).toString());
            ByteArrayOutputStreamImpl baos = new ByteArrayOutputStreamImpl(512);
            try {
                JsonGenerator jsonGen = this.driverContext.getGenericObjectWriter().getFactory().createGenerator(baos, JsonEncoding.UTF8);
                jsonGen.writeStartObject();
                jsonGen.writeStringField("client-type", "jdbc");
                jsonGen.writeStringField("mode", "deferred");
                jsonGen.writeStringField("statement", sql);
                jsonGen.writeBooleanField("signature", true);
                jsonGen.writeStringField("plan-format", "string");
                jsonGen.writeNumberField("max-warnings", this.maxWarnings);
                if (options.compileOnly) {
                    jsonGen.writeBooleanField("compile-only", true);
                }
                if (options.forceReadOnly) {
                    jsonGen.writeBooleanField("readonly", true);
                }
                if (options.sqlCompatMode) {
                    jsonGen.writeBooleanField("sql-compat", true);
                }
                if (options.timeoutSeconds > 0) {
                    jsonGen.writeStringField("timeout", options.timeoutSeconds + "s");
                }
                if (options.dataverseName != null) {
                    jsonGen.writeStringField("dataverse", options.dataverseName);
                }
                if (options.executionId != null) {
                    jsonGen.writeStringField("client_context_id", options.executionId.toString());
                }
                if (args != null && !args.isEmpty()) {
                    jsonGen.writeFieldName("args");
                    this.driverContext.getAdmFormatObjectWriter().writeValue(jsonGen, args);
                }
                jsonGen.writeEndObject();
                jsonGen.flush();
            }
            catch (InvalidDefinitionException e) {
                throw this.getErrorReporter().errorUnexpectedType(e.getType().getRawClass());
            }
            catch (IOException e) {
                throw this.getErrorReporter().errorInRequestGeneration(e);
            }
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, String.format("%s { %s } with args { %s }", options.compileOnly ? "compile" : "execute", sql, args != null ? args : ""));
            }
            httpPost.setEntity(new EntityTemplateImpl(baos, ContentType.APPLICATION_JSON));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost, this.httpClientContext);
            try {
                queryServiceResponse = this.handlePostQueryResponse(httpResponse);
                if (httpResponse == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    throw this.getErrorReporter().errorInProtocol(e);
                }
                catch (IOException e) {
                    throw this.getErrorReporter().errorInConnection(e);
                }
            }
            httpResponse.close();
        }
        return queryServiceResponse;
    }

    private ADBProtocolBase.QueryServiceResponse handlePostQueryResponse(CloseableHttpResponse httpResponse) throws SQLException, IOException {
        ADBProtocolBase.QueryServiceResponse response;
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        switch (httpStatus) {
            case 200: 
            case 400: 
            case 500: 
            case 503: {
                break;
            }
            case 401: 
            case 403: {
                throw this.getErrorReporter().errorAuth();
            }
            default: {
                throw this.getErrorReporter().errorInProtocol(httpResponse.getStatusLine().toString());
            }
        }
        try (InputStream contentStream = httpResponse.getEntity().getContent();){
            response = (ADBProtocolBase.QueryServiceResponse)this.driverContext.getGenericObjectReader().forType(ADBProtocolBase.QueryServiceResponse.class).readValue(contentStream);
        }
        ADBProtocolBase.QueryServiceResponse.Status status = response.status;
        if (httpStatus == 200 && status == ADBProtocolBase.QueryServiceResponse.Status.SUCCESS) {
            return response;
        }
        if (status == ADBProtocolBase.QueryServiceResponse.Status.TIMEOUT) {
            throw this.getErrorReporter().errorTimeout();
        }
        SQLException exc = this.getErrorIfExists(response);
        if (exc != null) {
            throw exc;
        }
        throw this.getErrorReporter().errorInProtocol(httpResponse.getStatusLine().toString());
    }

    @Override
    public JsonParser fetchResult(ADBProtocolBase.QueryServiceResponse response, ADBProtocolBase.SubmitStatementOptions options) throws SQLException {
        URI resultRequestURI;
        if (response.handle == null) {
            throw this.getErrorReporter().errorInProtocol();
        }
        int p = response.handle.lastIndexOf("/");
        if (p < 0) {
            throw this.getErrorReporter().errorInProtocol(response.handle);
        }
        String handlePath = response.handle.substring(p);
        try {
            resultRequestURI = new URI(this.queryResultEndpoint + handlePath);
        }
        catch (URISyntaxException e) {
            throw this.getErrorReporter().errorInProtocol(handlePath);
        }
        HttpGet httpGet = new HttpGet(resultRequestURI);
        httpGet.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        CloseableHttpResponse httpResponse = null;
        InputStream httpContentStream = null;
        JsonParser parser = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpGet, this.httpClientContext);
            int httpStatus = httpResponse.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                throw this.getErrorReporter().errorNoResult();
            }
            HttpEntity entity = httpResponse.getEntity();
            httpContentStream = entity.getContent();
            parser = this.driverContext.getGenericObjectReader().getFactory().createParser(new InputStreamWithAttachedResource(httpContentStream, httpResponse));
            if (!this.advanceToArrayField(parser, "results")) {
                throw this.getErrorReporter().errorInProtocol();
            }
            parser.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
            return parser;
        }
        catch (SQLException e) {
            ADBProtocol.closeQuietly(e, parser, httpContentStream, httpResponse);
            throw e;
        }
        catch (JsonProcessingException e) {
            ADBProtocol.closeQuietly(e, parser, httpContentStream, httpResponse);
            throw this.getErrorReporter().errorInProtocol(e);
        }
        catch (IOException e) {
            ADBProtocol.closeQuietly(e, parser, httpContentStream, httpResponse);
            throw this.getErrorReporter().errorInConnection(e);
        }
    }

    private boolean advanceToArrayField(JsonParser parser, String fieldName) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            return false;
        }
        JsonToken token;
        while ((token = parser.nextValue()) != null && token != JsonToken.END_OBJECT) {
            if (parser.currentName().equals(fieldName)) {
                return token == JsonToken.START_ARRAY;
            }
            if (token.isStructStart()) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cancelRunningStatement(UUID executionId) throws SQLException {
        HttpDelete httpDelete;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.activeRequestsEndpoint);
            uriBuilder.setParameter("client_context_id", String.valueOf(executionId));
            httpDelete = new HttpDelete(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw this.getErrorReporter().errorInRequestURIGeneration(e);
        }
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpDelete, this.httpClientContext);){
            int httpStatus = httpResponse.getStatusLine().getStatusCode();
            switch (httpStatus) {
                case 200: 
                case 404: {
                    return;
                }
                case 401: 
                case 403: {
                    throw this.getErrorReporter().errorAuth();
                }
                default: {
                    throw this.getErrorReporter().errorInProtocol(httpResponse.getStatusLine().toString());
                }
            }
        }
        catch (IOException e) {
            throw this.getErrorReporter().errorInConnection(e);
        }
    }

    @Override
    public ADBErrorReporter getErrorReporter() {
        return this.driverContext.getErrorReporter();
    }

    @Override
    public Logger getLogger() {
        return this.driverContext.getLogger();
    }

    private static CredentialsProvider createCredentialsProvider(String user, String password) {
        BasicCredentialsProvider cp = new BasicCredentialsProvider();
        cp.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(user, password));
        return cp;
    }

    private static HttpClientContext createHttpClientContext(URI uri) {
        HttpClientContext hcCtx = HttpClientContext.create();
        BasicAuthCache ac = new BasicAuthCache();
        ac.put(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), new BasicScheme());
        hcCtx.setAuthCache(ac);
        return hcCtx;
    }

    private static void closeQuietly(Exception mainExc, Closeable ... closeableList) {
        for (Closeable closeable : closeableList) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (mainExc == null) continue;
                mainExc.addSuppressed(e);
            }
        }
    }

    private static URI createEndpointUri(boolean sslEnabled, String host, int port, String path, ADBErrorReporter errorReporter) throws SQLException {
        try {
            return new URI(sslEnabled ? "https" : "http", null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            throw errorReporter.errorParameterValueNotSupported("endpoint " + host + ":" + port);
        }
    }

    private String getActiveRequestsEndpointPath(Map<ADBDriverProperty, Object> params) {
        String path = (String)ADBDriverProperty.Common.ACTIVE_REQUESTS_PATH.fetchPropertyValue(params);
        return path != null ? path : ACTIVE_REQUESTS_ENDPOINT_PATH;
    }

    static final class ByteArrayOutputStreamImpl
    extends ByteArrayOutputStream
    implements ContentProducer {
        private ByteArrayOutputStreamImpl(int size) {
            super(size);
        }
    }

    static final class EntityTemplateImpl
    extends EntityTemplate {
        private final long contentLength;

        private EntityTemplateImpl(ByteArrayOutputStreamImpl baos, ContentType contentType) {
            super(baos);
            this.contentLength = baos.size();
            this.setContentType(contentType.toString());
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }
    }

    static final class InputStreamWithAttachedResource
    extends FilterInputStream {
        private final Closeable resource;

        private InputStreamWithAttachedResource(InputStream delegate, Closeable resource) {
            super(delegate);
            this.resource = Objects.requireNonNull(resource);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.resource.close();
            }
        }
    }
}

