/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.WebReturnsGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.TableRow;
import com.teradata.tpcds.row.WebReturnsRow;
import com.teradata.tpcds.row.WebSalesRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Pricing;
import java.util.Collections;
import java.util.List;

public class WebReturnsRowGenerator
extends AbstractRowGenerator {
    public WebReturnsRowGenerator() {
        super(Table.WEB_RETURNS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        RowGeneratorResult salesAndReturnsResult = parentRowGenerator.generateRowAndChildRows(rowNumber, session, null, this);
        if (salesAndReturnsResult.getRowAndChildRows().size() == 2) {
            return new RowGeneratorResult((List<TableRow>)ImmutableList.of((Object)salesAndReturnsResult.getRowAndChildRows().get(1)), salesAndReturnsResult.shouldEndRow());
        }
        return new RowGeneratorResult(Collections.emptyList(), salesAndReturnsResult.shouldEndRow());
    }

    public WebReturnsRow generateRow(Session session, WebSalesRow salesRow) {
        long nullBitMap = Nulls.createNullBitMap(Table.WEB_RETURNS, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_NULLS));
        long wrItemSk = salesRow.getWsItemSk();
        long wrOrderNumber = salesRow.getWsOrderNumber();
        long wrWebPageSk = salesRow.getWsWebPageSk();
        Scaling scaling = session.getScaling();
        long wrReturnedDateSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_RETURNED_DATE_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_RETURNED_DATE_SK), Table.DATE_DIM, salesRow.getWsShipDateSk(), scaling);
        long wrReturnedTimeSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_RETURNED_TIME_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_RETURNED_TIME_SK), Table.TIME_DIM, 1L, scaling);
        long wrRefundedCustomerSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_REFUNDED_CUSTOMER_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_REFUNDED_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        long wrRefundedCdemoSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_REFUNDED_CDEMO_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_REFUNDED_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long wrRefundedHdemoSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_REFUNDED_HDEMO_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_REFUNDED_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long wrRefundedAddrSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_REFUNDED_ADDR_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_REFUNDED_ADDR_SK), Table.CUSTOMER_ADDRESS, 1L, scaling);
        if (RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_RETURNING_CUSTOMER_SK)) < 7) {
            wrRefundedCustomerSk = salesRow.getWsShipCustomerSk();
            wrRefundedCdemoSk = salesRow.getWsShipCdemoSk();
            wrRefundedHdemoSk = salesRow.getWsShipHdemoSk();
            wrRefundedAddrSk = salesRow.getWsShipAddrSk();
        }
        long wrReturningCustomerSk = wrRefundedCustomerSk;
        long wrReturningCdemoSk = wrRefundedCdemoSk;
        long wrReturningHdemoSk = wrRefundedHdemoSk;
        long wrReturningAddrSk = wrRefundedAddrSk;
        long wrReasonSk = JoinKeyUtils.generateJoinKey(WebReturnsGeneratorColumn.WR_REASON_SK, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_REASON_SK), Table.REASON, 1L, scaling);
        int quantity = RandomValueGenerator.generateUniformRandomInt(1, salesRow.getWsPricing().getQuantity(), this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_PRICING));
        Pricing wrPricing = Pricing.generatePricingForReturnsTable(WebReturnsGeneratorColumn.WR_PRICING, this.getRandomNumberStream(WebReturnsGeneratorColumn.WR_PRICING), quantity, salesRow.getWsPricing());
        return new WebReturnsRow(nullBitMap, wrReturnedDateSk, wrReturnedTimeSk, wrItemSk, wrRefundedCustomerSk, wrRefundedCdemoSk, wrRefundedHdemoSk, wrRefundedAddrSk, wrReturningCustomerSk, wrReturningCdemoSk, wrReturningHdemoSk, wrReturningAddrSk, wrWebPageSk, wrReasonSk, wrOrderNumber, wrPricing);
    }
}

