/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc.task;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetrieveLibrariesTask
implements INCLifecycleTask {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Pair<URI, String>> nodes;

    public RetrieveLibrariesTask(List<Pair<URI, String>> nodes) {
        this.nodes = nodes;
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("No nodes specified to retrieve from");
        }
    }

    public void perform(CcId ccId, IControllerService cs) throws HyracksDataException {
        INcApplicationContext appContext = (INcApplicationContext)cs.getApplicationContext();
        boolean success = false;
        for (Pair<URI, String> referenceNode : this.nodes) {
            try {
                LOGGER.info("Retrieving UDFs from " + NetworkUtil.toHostPort((HttpHost)URIUtils.extractHost((URI)((URI)referenceNode.getFirst()))));
                this.retrieveLibrary((URI)referenceNode.getFirst(), (String)referenceNode.getSecond(), appContext);
                success = true;
                break;
            }
            catch (HyracksDataException e) {
                LOGGER.error("Unable to retrieve UDFs from: " + referenceNode.getFirst() + ", trying another node.", (Throwable)e);
            }
        }
        if (!success) {
            LOGGER.error("Unable to retrieve UDFs from any participant node");
            throw HyracksDataException.create((ErrorCode)ErrorCode.TIMEOUT, (Serializable[])new Serializable[0]);
        }
    }

    private void retrieveLibrary(URI baseURI, String authToken, INcApplicationContext appContext) throws HyracksDataException {
        ILibraryManager libraryManager = appContext.getLibraryManager();
        FileReference distributionDir = appContext.getLibraryManager().getDistributionDir();
        URI libraryURI = this.getNCUdfRetrievalURL(baseURI);
        try {
            FileUtil.forceMkdirs((File)distributionDir.getFile());
            Path targetFile = Files.createTempFile(Paths.get(distributionDir.getAbsolutePath(), new String[0]), "all_", ".zip", new FileAttribute[0]);
            FileReference targetFileRef = distributionDir.getChild(targetFile.getFileName().toString());
            libraryManager.download(targetFileRef, authToken, libraryURI);
            Path outputDirPath = libraryManager.getStorageDir().getFile().toPath().toAbsolutePath().normalize();
            FileReference outPath = appContext.getIoManager().resolveAbsolutePath(outputDirPath.toString());
            libraryManager.unzip(targetFileRef, outPath);
        }
        catch (IOException e) {
            LOGGER.error("Unable to retrieve UDFs from " + libraryURI.toString() + " before timeout");
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public URI getNCUdfRetrievalURL(URI baseURL) {
        String endpoint = "/admin/libraryrecovery/*".substring(0, "/admin/libraryrecovery/*".length() - 1) + "/all";
        URIBuilder builder = new URIBuilder(baseURL).setPath(endpoint);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Could not find URL for NC recovery", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "{ \"class\" : \"" + this.getClass().getSimpleName() + "\" }";
    }
}

