/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class GetActivityClusterGraphJSONWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private ObjectNode json;

    public GetActivityClusterGraphJSONWork(ClusterControllerService ccs, JobId jobId) {
        this.ccs = ccs;
        this.jobId = jobId;
    }

    protected void doRun() throws Exception {
        IJobManager jobManager = this.ccs.getJobManager();
        ObjectMapper om = new ObjectMapper();
        JobRun run = jobManager.get(this.jobId);
        if (run == null) {
            this.json = om.createObjectNode();
            return;
        }
        this.json = run.getActivityClusterGraph().toJSON();
    }

    public ObjectNode getJSON() {
        return this.json;
    }
}

