/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallback;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMPrimaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    protected final PermutingFrameTupleReference key;
    private MultiComparator keySearchCmp;
    private ArrayTupleBuilder missingTupleBuilder;
    private final IMissingWriter missingWriter;
    protected ArrayTupleBuilder tb;
    private DataOutput dos;
    protected RangePredicate searchPred;
    protected IIndexCursor cursor;
    protected ITupleReference prevTuple;
    protected final int numOfPrimaryKeys;
    protected boolean isFiltered = false;
    private final ArrayTupleReference prevTupleWithFilter = new ArrayTupleReference();
    private ArrayTupleBuilder prevRecWithPKWithFilterValue;
    private Integer filterSourceIndicator = null;
    private ARecordType filterItemType;
    private int presetFieldIndex = -1;
    private ARecordPointable recPointable;
    private DataOutput prevDos;
    private final boolean hasMeta;
    private final int filterFieldIndex;
    private final int metaFieldIndex;
    protected LockThenSearchOperationCallback searchCallback;
    protected IFrameOperationCallback frameOpCallback;
    private final IFrameOperationCallbackFactory frameOpCallbackFactory;
    protected AbstractIndexModificationOperationCallback abstractModCallback;
    private final ISearchOperationCallbackFactory searchCallbackFactory;
    private final IFrameTupleProcessor processor;
    protected LSMTreeIndexAccessor lsmAccessor;
    private final ITracer tracer;
    private final long traceCategory;
    private long lastRecordInTimeStamp = 0L;

    public LSMPrimaryUpsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IModificationOperationCallbackFactory modCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numOfPrimaryKeys, Integer filterSourceIndicator, ARecordType filterItemType, int filterFieldIndex, IFrameOperationCallbackFactory frameOpCallbackFactory, IMissingWriterFactory missingWriterFactory, boolean hasSecondaries) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, null);
        this.key = new PermutingFrameTupleReference();
        this.searchCallbackFactory = searchCallbackFactory;
        this.numOfPrimaryKeys = numOfPrimaryKeys;
        this.frameOpCallbackFactory = frameOpCallbackFactory;
        this.missingWriter = missingWriterFactory.createMissingWriter();
        int[] searchKeyPermutations = new int[numOfPrimaryKeys];
        for (int i = 0; i < searchKeyPermutations.length; ++i) {
            searchKeyPermutations[i] = fieldPermutation[i];
        }
        this.key.setFieldPermutation(searchKeyPermutations);
        this.hasMeta = fieldPermutation.length > numOfPrimaryKeys + 1 && (filterFieldIndex < 0 || filterFieldIndex >= 0 && fieldPermutation.length > numOfPrimaryKeys + 2);
        this.metaFieldIndex = numOfPrimaryKeys + 1;
        this.filterFieldIndex = numOfPrimaryKeys + (this.hasMeta ? 2 : 1);
        if (filterFieldIndex >= 0) {
            this.isFiltered = true;
            this.filterItemType = filterItemType;
            this.presetFieldIndex = filterFieldIndex;
            this.filterSourceIndicator = filterSourceIndicator;
            this.recPointable = ARecordPointable.FACTORY.createPointable();
            this.prevRecWithPKWithFilterValue = new ArrayTupleBuilder(fieldPermutation.length + (this.hasMeta ? 1 : 0));
            this.prevDos = this.prevRecWithPKWithFilterValue.getDataOutput();
        }
        this.processor = this.createTupleProcessor(hasSecondaries);
        this.tracer = ctx.getJobletContext().getServiceContext().getTracer();
        this.traceCategory = this.tracer.getRegistry().get("Latency");
    }

    protected void beforeModification(ITupleReference tuple) {
    }

    protected IFrameTupleProcessor createTupleProcessor(final boolean hasSecondaries) {
        return new IFrameTupleProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(ITupleReference tuple, int index) throws HyracksDataException {
                try {
                    LSMPrimaryUpsertOperatorNodePushable.this.tb.reset();
                    boolean recordWasInserted = false;
                    boolean recordWasDeleted = false;
                    boolean isDelete = LSMPrimaryUpsertOperatorNodePushable.isDeleteOperation(tuple, LSMPrimaryUpsertOperatorNodePushable.this.numOfPrimaryKeys);
                    LSMPrimaryUpsertOperatorNodePushable.this.resetSearchPredicate(index);
                    if (LSMPrimaryUpsertOperatorNodePushable.this.isFiltered || isDelete || hasSecondaries) {
                        LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.search(LSMPrimaryUpsertOperatorNodePushable.this.cursor, (ISearchPredicate)LSMPrimaryUpsertOperatorNodePushable.this.searchPred);
                        try {
                            if (LSMPrimaryUpsertOperatorNodePushable.this.cursor.hasNext()) {
                                LSMPrimaryUpsertOperatorNodePushable.this.cursor.next();
                                LSMPrimaryUpsertOperatorNodePushable.this.prevTuple = LSMPrimaryUpsertOperatorNodePushable.this.cursor.getTuple();
                                LSMPrimaryUpsertOperatorNodePushable.this.appendUpsertIndicator(!isDelete);
                                LSMPrimaryUpsertOperatorNodePushable.this.appendFilterToPrevTuple();
                                LSMPrimaryUpsertOperatorNodePushable.this.appendPrevRecord();
                                LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousMeta();
                                LSMPrimaryUpsertOperatorNodePushable.this.appendFilterToOutput();
                            }
                            LSMPrimaryUpsertOperatorNodePushable.this.appendUpsertIndicator(!isDelete);
                            LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousTupleAsMissing();
                        }
                        finally {
                            LSMPrimaryUpsertOperatorNodePushable.this.cursor.close();
                        }
                    } else {
                        LSMPrimaryUpsertOperatorNodePushable.this.searchCallback.before((ITupleReference)LSMPrimaryUpsertOperatorNodePushable.this.key);
                        LSMPrimaryUpsertOperatorNodePushable.this.appendUpsertIndicator(!isDelete);
                        LSMPrimaryUpsertOperatorNodePushable.this.appendPreviousTupleAsMissing();
                    }
                    LSMPrimaryUpsertOperatorNodePushable.this.beforeModification(tuple);
                    if (isDelete && LSMPrimaryUpsertOperatorNodePushable.this.prevTuple != null) {
                        LSMPrimaryUpsertOperatorNodePushable.this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                        LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.forceDelete(tuple);
                        recordWasDeleted = true;
                    } else if (!isDelete) {
                        LSMPrimaryUpsertOperatorNodePushable.this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.UPSERT);
                        LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.forceUpsert(tuple);
                        recordWasInserted = true;
                    }
                    if (LSMPrimaryUpsertOperatorNodePushable.this.isFiltered && LSMPrimaryUpsertOperatorNodePushable.this.prevTuple != null) {
                        LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.updateFilter(LSMPrimaryUpsertOperatorNodePushable.this.prevTuple);
                    }
                    LSMPrimaryUpsertOperatorNodePushable.this.writeOutput(index, recordWasInserted, recordWasDeleted);
                }
                catch (Exception e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void start() throws HyracksDataException {
                LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.getCtx().setOperation(IndexOperation.UPSERT);
            }

            public void finish() throws HyracksDataException {
                LSMPrimaryUpsertOperatorNodePushable.this.lsmAccessor.getCtx().setOperation(IndexOperation.UPSERT);
            }

            public void fail(Throwable th) {
                LSMPrimaryUpsertOperatorNodePushable.this.frameOpCallback.fail(th);
            }
        };
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.writer.open();
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            if (this.ctx.getSharedObject() != null) {
                PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)((AbstractLSMIndex)this.index));
                TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
            }
            this.missingTupleBuilder = new ArrayTupleBuilder(1);
            DataOutput out = this.missingTupleBuilder.getDataOutput();
            try {
                this.missingWriter.writeMissing(out);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.missingTupleBuilder.addFieldEndOffset();
            this.searchPred = this.createSearchPredicate();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            this.modCallback = this.modOpCallbackFactory.createModificationOperationCallback(this.indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
            this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
            this.searchCallback = (LockThenSearchOperationCallback)this.searchCallbackFactory.createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, (IOperatorNodePushable)this);
            IndexAccessParameters iap = new IndexAccessParameters((IModificationOperationCallback)this.abstractModCallback, (ISearchOperationCallback)this.searchCallback);
            this.indexAccessor = this.index.createAccessor((IIndexAccessParameters)iap);
            this.lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessor;
            this.cursor = this.indexAccessor.createSearchCursor(false);
            this.frameTuple = new FrameTupleReference();
            INcApplicationContext appCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)this.index), (ILogManager)appCtx.getTransactionSubsystem().getLogManager());
            this.frameOpCallback = new IFrameOperationCallback(){
                IFrameOperationCallback callback;
                {
                    this.callback = LSMPrimaryUpsertOperatorNodePushable.this.frameOpCallbackFactory.createFrameOperationCallback(LSMPrimaryUpsertOperatorNodePushable.this.ctx, (ILSMIndexAccessor)LSMPrimaryUpsertOperatorNodePushable.this.indexAccessor);
                }

                public void frameCompleted() throws HyracksDataException {
                    LSMPrimaryUpsertOperatorNodePushable.this.appender.write(LSMPrimaryUpsertOperatorNodePushable.this.writer, true);
                    this.callback.frameCompleted();
                }

                public void close() throws IOException {
                    this.callback.close();
                }

                public void fail(Throwable th) {
                    this.callback.fail(th);
                }
            };
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void resetSearchPredicate(int tupleIndex) {
        this.key.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        this.searchPred.reset((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp);
    }

    protected void writeOutput(int tupleIndex, boolean recordWasInserted, boolean recordWasDeleted) throws IOException {
        if (recordWasInserted || recordWasDeleted) {
            this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
            for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
        } else {
            try {
                this.searchCallback.release();
            }
            catch (ACIDException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    protected static boolean isDeleteOperation(ITupleReference t1, int field) {
        return TypeTagUtil.isType((ITupleReference)t1, (int)field, (byte)ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
    }

    private void writeMissingField() throws IOException {
        this.dos.write(this.missingTupleBuilder.getByteArray());
        this.tb.addFieldEndOffset();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int itemCount = this.accessor.getTupleCount();
        this.lsmAccessor.batchOperate(this.accessor, (FrameTupleReference)this.tuple, this.processor, this.frameOpCallback);
        if (itemCount > 0) {
            this.lastRecordInTimeStamp = System.currentTimeMillis();
        }
    }

    protected void appendFilterToOutput() throws IOException {
        if (this.isFiltered) {
            this.dos.write(this.prevTuple.getFieldData(this.filterFieldIndex), this.prevTuple.getFieldStart(this.filterFieldIndex), this.prevTuple.getFieldLength(this.filterFieldIndex));
            this.tb.addFieldEndOffset();
        }
    }

    protected void appendUpsertIndicator(boolean isUpsert) throws IOException {
        this.recordDesc.getFields()[0].serialize((Object)(isUpsert ? ABoolean.TRUE : ABoolean.FALSE), this.dos);
        this.tb.addFieldEndOffset();
    }

    protected void appendPrevRecord() throws IOException {
        this.dos.write(this.prevTuple.getFieldData(this.numOfPrimaryKeys), this.prevTuple.getFieldStart(this.numOfPrimaryKeys), this.prevTuple.getFieldLength(this.numOfPrimaryKeys));
        this.tb.addFieldEndOffset();
    }

    protected void appendPreviousMeta() throws IOException {
        if (this.hasMeta) {
            this.dos.write(this.prevTuple.getFieldData(this.metaFieldIndex), this.prevTuple.getFieldStart(this.metaFieldIndex), this.prevTuple.getFieldLength(this.metaFieldIndex));
            this.tb.addFieldEndOffset();
        }
    }

    protected void appendPreviousTupleAsMissing() throws IOException {
        this.prevTuple = null;
        this.writeMissingField();
        if (this.hasMeta) {
            this.writeMissingField();
        }
        if (this.isFiltered) {
            this.writeMissingField();
        }
    }

    public void flushPartialFrame() throws HyracksDataException {
        this.appender.write(this.writer, true);
    }

    protected void appendFilterToPrevTuple() throws IOException {
        if (this.isFiltered) {
            this.prevRecWithPKWithFilterValue.reset();
            for (int i = 0; i < this.prevTuple.getFieldCount(); ++i) {
                this.prevDos.write(this.prevTuple.getFieldData(i), this.prevTuple.getFieldStart(i), this.prevTuple.getFieldLength(i));
                this.prevRecWithPKWithFilterValue.addFieldEndOffset();
            }
            if (this.filterSourceIndicator == 0) {
                this.recPointable.set(this.prevTuple.getFieldData(this.numOfPrimaryKeys), this.prevTuple.getFieldStart(this.numOfPrimaryKeys), this.prevTuple.getFieldLength(this.numOfPrimaryKeys));
            } else {
                this.recPointable.set(this.prevTuple.getFieldData(this.metaFieldIndex), this.prevTuple.getFieldStart(this.metaFieldIndex), this.prevTuple.getFieldLength(this.metaFieldIndex));
            }
            byte tag = this.recPointable.getClosedFieldType(this.filterItemType, this.presetFieldIndex).getTypeTag().serialize();
            this.prevDos.write(tag);
            this.prevDos.write(this.recPointable.getByteArray(), this.recPointable.getClosedFieldOffset(this.filterItemType, this.presetFieldIndex), this.recPointable.getClosedFieldSize(this.filterItemType, this.presetFieldIndex));
            this.prevRecWithPKWithFilterValue.addFieldEndOffset();
            this.prevTupleWithFilter.reset(this.prevRecWithPKWithFilterValue.getFieldEndOffsets(), this.prevRecWithPKWithFilterValue.getByteArray());
            this.prevTuple = this.prevTupleWithFilter;
        }
    }

    private RangePredicate createSearchPredicate() {
        this.keySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])((ITreeIndex)this.index).getComparatorFactories(), (ITupleReference)this.key);
        return new RangePredicate((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp, null, null);
    }

    public void close() throws HyracksDataException {
        this.traceLastRecordIn();
        Throwable failure = CleanupUtils.close((AutoCloseable)this.frameOpCallback, null);
        failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.cursor});
        failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        failure = CleanupUtils.close((AutoCloseable)this.indexHelper, (Throwable)failure);
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    private void traceLastRecordIn() {
        try {
            if (this.tracer.isEnabled(this.traceCategory) && this.lastRecordInTimeStamp > 0L && this.indexHelper != null && this.indexHelper.getIndexInstance() != null) {
                this.tracer.instant("UpsertClose", this.traceCategory, ITracer.Scope.t, "{\"last-record-in\":\"" + DATE_FORMAT.get().format(new Date(this.lastRecordInTimeStamp)) + "\", \"index\":" + this.indexHelper.getIndexInstance().toString() + "}");
            }
        }
        catch (Throwable traceFailure) {
            try {
                LOGGER.warn("Tracing last record in failed", traceFailure);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
    }
}

