/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.utils.NormalizedKeyUtils;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.sort.IFrameSorter;
import org.apache.hyracks.util.IntSerDeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractFrameSorter
implements IFrameSorter {
    protected Logger LOGGER = LogManager.getLogger();
    protected static final int ID_FRAME_ID = 0;
    protected static final int ID_TUPLE_START = 1;
    protected static final int ID_TUPLE_END = 2;
    protected static final int ID_NORMALIZED_KEY = 3;
    protected final int[] normalizedKeyLength;
    protected final int normalizedKeyTotalLength;
    protected final boolean normalizedKeysDecisive;
    protected final int ptrSize;
    protected final int[] sortFields;
    protected final IBinaryComparator[] comparators;
    protected final INormalizedKeyComputer[] nkcs;
    protected final IFrameBufferManager bufferManager;
    protected final FrameTupleAccessor inputTupleAccessor;
    protected final IFrameTupleAppender outputAppender;
    protected final IFrame outputFrame;
    protected final int outputLimit;
    protected final long maxSortMemory;
    protected long totalMemoryUsed;
    protected int[] tPointers;
    protected final int[] tmpPointer;
    protected int tupleCount;
    private final FrameTupleAccessor fta2;
    private final BufferInfo info = new BufferInfo(null, -1, -1);

    public AbstractFrameSorter(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int maxSortFrames, int[] sortFields, INormalizedKeyComputerFactory[] normalizedKeyComputerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int outputLimit) throws HyracksDataException {
        this.bufferManager = bufferManager;
        this.maxSortMemory = maxSortFrames == -1 ? Long.MAX_VALUE : (long)ctx.getInitialFrameSize() * (long)maxSortFrames;
        this.sortFields = sortFields;
        int runningNormalizedKeyTotalLength = 0;
        if (normalizedKeyComputerFactories != null) {
            int decisivePrefixLength = NormalizedKeyUtils.getDecisivePrefixLength((INormalizedKeyComputerFactory[])normalizedKeyComputerFactories);
            int normalizedKeys = decisivePrefixLength < normalizedKeyComputerFactories.length ? decisivePrefixLength + 1 : decisivePrefixLength;
            this.nkcs = new INormalizedKeyComputer[normalizedKeys];
            this.normalizedKeyLength = new int[normalizedKeys];
            for (int i = 0; i < normalizedKeys; ++i) {
                this.nkcs[i] = normalizedKeyComputerFactories[i].createNormalizedKeyComputer();
                this.normalizedKeyLength[i] = normalizedKeyComputerFactories[i].getNormalizedKeyProperties().getNormalizedKeyLength();
                runningNormalizedKeyTotalLength += this.normalizedKeyLength[i];
            }
            this.normalizedKeysDecisive = decisivePrefixLength == comparatorFactories.length;
        } else {
            this.nkcs = null;
            this.normalizedKeyLength = null;
            this.normalizedKeysDecisive = false;
        }
        this.normalizedKeyTotalLength = runningNormalizedKeyTotalLength;
        this.ptrSize = 3 + this.normalizedKeyTotalLength;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.inputTupleAccessor = new FrameTupleAccessor(recordDescriptor);
        this.outputAppender = new FrameTupleAppender();
        this.outputFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.outputLimit = outputLimit;
        this.fta2 = new FrameTupleAccessor(recordDescriptor);
        this.tmpPointer = new int[this.ptrSize];
    }

    @Override
    public void reset() throws HyracksDataException {
        this.tupleCount = 0;
        this.totalMemoryUsed = 0L;
        this.bufferManager.reset();
    }

    @Override
    public boolean insertFrame(ByteBuffer inputBuffer) throws HyracksDataException {
        this.inputTupleAccessor.reset(inputBuffer);
        long requiredMemory = this.getRequiredMemory(this.inputTupleAccessor);
        if (this.totalMemoryUsed + requiredMemory <= this.maxSortMemory && this.bufferManager.insertFrame(inputBuffer) >= 0) {
            this.totalMemoryUsed += requiredMemory;
            this.tupleCount += this.inputTupleAccessor.getTupleCount();
            return true;
        }
        if (this.getFrameCount() == 0) {
            throw new HyracksDataException("The input frame is too big for the sorting buffer, please allocate bigger buffer size");
        }
        return false;
    }

    protected long getRequiredMemory(FrameTupleAccessor frameAccessor) {
        return (long)frameAccessor.getBuffer().capacity() + (long)(this.ptrSize * frameAccessor.getTupleCount() * 4);
    }

    @Override
    public void sort() throws HyracksDataException {
        if (this.tPointers == null || this.tPointers.length < this.tupleCount * this.ptrSize) {
            this.tPointers = new int[this.tupleCount * this.ptrSize];
        }
        int ptr = 0;
        for (int i = 0; i < this.bufferManager.getNumFrames(); ++i) {
            this.bufferManager.getFrame(i, this.info);
            this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
            int tCount = this.inputTupleAccessor.getTupleCount();
            byte[] array = this.inputTupleAccessor.getBuffer().array();
            int fieldSlotsLength = this.inputTupleAccessor.getFieldSlotsLength();
            int j = 0;
            while (j < tCount) {
                int tStart = this.inputTupleAccessor.getTupleStartOffset(j);
                int tEnd = this.inputTupleAccessor.getTupleEndOffset(j);
                this.tPointers[ptr * this.ptrSize + 0] = i;
                this.tPointers[ptr * this.ptrSize + 1] = tStart;
                this.tPointers[ptr * this.ptrSize + 2] = tEnd;
                if (this.nkcs != null) {
                    int keyPos = ptr * this.ptrSize + 3;
                    for (int k = 0; k < this.nkcs.length; ++k) {
                        int sortField = this.sortFields[k];
                        int fieldStartOffsetRel = this.inputTupleAccessor.getFieldStartOffset(j, sortField);
                        int fieldEndOffsetRel = this.inputTupleAccessor.getFieldEndOffset(j, sortField);
                        int fieldStartOffset = fieldStartOffsetRel + tStart + fieldSlotsLength;
                        this.nkcs[k].normalize(array, fieldStartOffset, fieldEndOffsetRel - fieldStartOffsetRel, this.tPointers, keyPos);
                        keyPos += this.normalizedKeyLength[k];
                    }
                }
                ++j;
                ++ptr;
            }
        }
        if (this.tupleCount > 0) {
            this.sortTupleReferences();
        }
    }

    abstract void sortTupleReferences() throws HyracksDataException;

    @Override
    public int getFrameCount() {
        return this.bufferManager.getNumFrames();
    }

    @Override
    public boolean hasRemaining() {
        return this.getFrameCount() > 0;
    }

    @Override
    public int flush(IFrameWriter writer) throws HyracksDataException {
        this.outputAppender.reset(this.outputFrame, true);
        int maxFrameSize = this.outputFrame.getFrameSize();
        int limit = Math.min(this.tupleCount, this.outputLimit);
        int io = 0;
        for (int ptr = 0; ptr < limit; ++ptr) {
            int i = this.tPointers[ptr * this.ptrSize + 0];
            int tStart = this.tPointers[ptr * this.ptrSize + 1];
            int tEnd = this.tPointers[ptr * this.ptrSize + 2];
            this.bufferManager.getFrame(i, this.info);
            this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
            int flushed = FrameUtils.appendToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.outputAppender, (IFrameTupleAccessor)this.inputTupleAccessor, (int)tStart, (int)tEnd);
            if (flushed <= 0) continue;
            maxFrameSize = Math.max(maxFrameSize, flushed);
            ++io;
        }
        maxFrameSize = Math.max(maxFrameSize, this.outputFrame.getFrameSize());
        this.outputAppender.write(writer, true);
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("Flushed records:" + limit + " out of " + this.tupleCount + "; Flushed through " + (io + 1) + " frames");
        }
        return maxFrameSize;
    }

    protected final int compare(int tp1, int tp2) throws HyracksDataException {
        return this.compare(this.tPointers, tp1, this.tPointers, tp2);
    }

    protected final int compare(int[] tPointers1, int tp1, int[] tPointers2, int tp2) throws HyracksDataException {
        int cmpNormalizedKey;
        if (this.nkcs != null && ((cmpNormalizedKey = NormalizedKeyUtils.compareNormalizeKeys((int[])tPointers1, (int)(tp1 * this.ptrSize + 3), (int[])tPointers2, (int)(tp2 * this.ptrSize + 3), (int)this.normalizedKeyTotalLength)) != 0 || this.normalizedKeysDecisive)) {
            return cmpNormalizedKey;
        }
        int i1 = tPointers1[tp1 * this.ptrSize + 0];
        int j1 = tPointers1[tp1 * this.ptrSize + 1];
        int i2 = tPointers2[tp2 * this.ptrSize + 0];
        int j2 = tPointers2[tp2 * this.ptrSize + 1];
        this.bufferManager.getFrame(i1, this.info);
        byte[] b1 = this.info.getBuffer().array();
        this.inputTupleAccessor.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
        this.bufferManager.getFrame(i2, this.info);
        byte[] b2 = this.info.getBuffer().array();
        this.fta2.reset(this.info.getBuffer(), this.info.getStartOffset(), this.info.getLength());
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])b1, (int)(j1 + (fIdx - 1) * 4));
            int f1End = IntSerDeUtils.getInt((byte[])b1, (int)(j1 + fIdx * 4));
            int s1 = j1 + this.inputTupleAccessor.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])b2, (int)(j2 + (fIdx - 1) * 4));
            int f2End = IntSerDeUtils.getInt((byte[])b2, (int)(j2 + fIdx * 4));
            int s2 = j2 + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public void close() {
        this.tupleCount = 0;
        this.totalMemoryUsed = 0L;
        this.bufferManager.close();
        this.tPointers = null;
    }
}

