/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.net.InetSocketAddress;
import org.apache.hyracks.ipc.api.IIPCEventListener;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReconnectingIPCHandle
implements IIPCHandle {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IPCSystem ipc;
    private final int reconnectAttempts;
    private final IIPCEventListener listener;
    private IIPCHandle delegate;

    ReconnectingIPCHandle(IPCSystem ipc, IIPCEventListener listener, InetSocketAddress remoteAddress, int maxRetries, int reconnectAttempts) throws IPCException {
        this.ipc = ipc;
        this.listener = listener;
        this.reconnectAttempts = reconnectAttempts;
        this.delegate = ipc.getHandle(remoteAddress, maxRetries);
        listener.ipcHandleConnected(this.delegate);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public long send(long requestId, Object payload, Exception exception) throws IPCException {
        return this.ensureConnected().send(requestId, payload, exception);
    }

    @Override
    public void setAttachment(Object attachment) {
        this.delegate.setAttachment(attachment);
    }

    @Override
    public Object getAttachment() {
        return this.delegate.getAttachment();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIPCHandle ensureConnected() throws IPCException {
        if (this.delegate.isConnected()) {
            return this.delegate;
        }
        ReconnectingIPCHandle reconnectingIPCHandle = this;
        synchronized (reconnectingIPCHandle) {
            if (this.delegate.isConnected()) {
                return this.delegate;
            }
            LOGGER.warn("ipcHandle {} disconnected; will attempt to reconnect {} times", (Object)this.delegate, (Object)this.reconnectAttempts);
            this.listener.ipcHandleDisconnected(this.delegate);
            this.delegate = this.ipc.getHandle(NetworkUtil.refresh((InetSocketAddress)this.getRemoteAddress()), this.reconnectAttempts);
            LOGGER.warn("ipcHandle {} restored", (Object)this.delegate);
            this.listener.ipcHandleRestored(this.delegate);
            return this.delegate;
        }
    }
}

