/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.ArrayList;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.translator.LangExpressionToPlanTranslator;
import org.apache.asterix.translator.PositionWriter;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingPositionWriter;

class AqlExpressionToPlanTranslator
extends LangExpressionToPlanTranslator
implements ILangExpressionToPlanTranslator,
IAQLVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>> {
    public AqlExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounterValue) throws AlgebricksException {
        super(metadataProvider, currentVarCounterValue);
    }

    public AqlExpressionToPlanTranslator(MetadataProvider metadataProvider, Counter currentVarCounter) throws AlgebricksException {
        super(metadataProvider, currentVarCounter);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(ForClause fc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        UnnestOperator returnedOp;
        LogicalVariable v = this.context.newVarFromExpression((Expression)fc.getVarExpr());
        Expression inExpr = fc.getInExpr();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(inExpr, tupSource);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> pUnnestExpr = this.makeUnnestExpression((ILogicalExpression)eo.first, (Mutable<ILogicalOperator>)((Mutable)eo.second));
        if (fc.getPosVarExpr() == null) {
            returnedOp = new UnnestOperator(v, (Mutable)new MutableObject(pUnnestExpr.first));
        } else {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)fc.getPosVarExpr());
            returnedOp = new UnnestOperator(v, (Mutable)new MutableObject(pUnnestExpr.first), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter());
        }
        returnedOp.getInputs().add(pUnnestExpr.second);
        return new Pair((Object)returnedOp, (Object)v);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FLWOGRExpression flwor, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalOperator, LogicalVariable> result;
        MutableObject flworPlan = tupSource;
        boolean isTop = this.context.isTopFlwor();
        if (!isTop) {
            this.context.enterSubplan();
        }
        if (isTop) {
            this.context.setTopFlwor(false);
        }
        for (Clause c : flwor.getClauseList()) {
            Pair pC = (Pair)c.accept((ILangVisitor)this, flworPlan);
            flworPlan = new MutableObject(pC.first);
        }
        Expression r = flwor.getReturnExpr();
        boolean noForClause = flwor.noForClause();
        if (r.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            VariableExpr v = (VariableExpr)r;
            LogicalVariable var = this.context.getVar(v.getVar().getId());
            result = this.produceFlworPlan(noForClause, isTop, (Mutable<ILogicalOperator>)flworPlan, var);
        } else {
            ILogicalOperator resOp;
            MutableObject baseOp = new MutableObject(flworPlan.getValue());
            Pair rRes = (Pair)r.accept((ILangVisitor)this, (Object)baseOp);
            ILogicalOperator rOp = (ILogicalOperator)rRes.first;
            if (this.expressionNeedsNoNesting(r)) {
                baseOp.setValue(flworPlan.getValue());
                resOp = rOp;
            } else {
                SubplanOperator s = new SubplanOperator(rOp);
                s.getInputs().add(flworPlan);
                resOp = s;
                baseOp.setValue((Object)new NestedTupleSourceOperator((Mutable)new MutableObject((Object)s)));
            }
            MutableObject resOpRef = new MutableObject((Object)resOp);
            result = this.produceFlworPlan(noForClause, isTop, (Mutable<ILogicalOperator>)resOpRef, (LogicalVariable)rRes.second);
        }
        if (!isTop) {
            this.context.exitSubplan();
        }
        return result;
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return (Pair)q.getBody().accept((ILangVisitor)this, tupSource);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(DistinctClause dc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ArrayList<MutableObject> exprList = new ArrayList<MutableObject>();
        Mutable input = null;
        for (Expression expr : dc.getDistinctByExpr()) {
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(expr, tupSource);
            exprList.add(new MutableObject(p.first));
            input = (Mutable)p.second;
        }
        DistinctOperator opDistinct = new DistinctOperator(exprList);
        opDistinct.getInputs().add(input);
        return new Pair((Object)opDistinct, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnionExpr unionExpr, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        ArrayList<ILangExpression> inputExprs = new ArrayList<ILangExpression>();
        inputExprs.addAll(unionExpr.getExprs());
        Pair<ILogicalOperator, LogicalVariable> result = this.translateUnionAllFromInputExprs(inputExprs, tupSource, null);
        return this.aggListifyForSubquery((LogicalVariable)result.second, (Mutable<ILogicalOperator>)new MutableObject(result.first), false);
    }

    @Override
    protected boolean expressionNeedsNoNesting(Expression expr) throws CompilationException {
        boolean isFLWOGR = expr.getKind() == Expression.Kind.FLWOGR_EXPRESSION;
        boolean letOnly = true;
        if (isFLWOGR) {
            FLWOGRExpression flwor = (FLWOGRExpression)expr;
            for (Clause clause : flwor.getClauseList()) {
                letOnly &= clause.getClauseType() == Clause.ClauseType.LET_CLAUSE;
            }
        }
        return isFLWOGR && letOnly || super.expressionNeedsNoNesting(expr);
    }

    private Pair<ILogicalOperator, LogicalVariable> produceFlworPlan(boolean noForClause, boolean isTop, Mutable<ILogicalOperator> resOpRef, LogicalVariable resVar) {
        if (isTop) {
            ProjectOperator pr = new ProjectOperator(resVar);
            pr.getInputs().add(resOpRef);
            return new Pair((Object)pr, (Object)resVar);
        }
        if (noForClause) {
            ILogicalOperator resOp = (ILogicalOperator)resOpRef.getValue();
            if (resOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                return new Pair((Object)resOp, (Object)resVar);
            }
            LogicalVariable newResVar = this.context.newVar();
            AssignOperator assign = new AssignOperator(newResVar, (Mutable)new MutableObject((Object)new VariableReferenceExpression(resVar)));
            assign.getInputs().add(resOpRef);
            return new Pair((Object)assign, (Object)newResVar);
        }
        return this.aggListifyForSubquery(resVar, resOpRef, false);
    }
}

