/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.AbstractConstVarFunVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.util.LogRedactionUtil;

public class SetClosedRecordConstructorsRule
implements IAlgebraicRewriteRule {
    private final SettingClosedRecordVisitor recordVisitor = new SettingClosedRecordVisitor();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext ctx) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (ctx.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        ctx.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        this.recordVisitor.setOptimizationContext(ctx, op.computeInputTypeEnvironment((ITypingContext)ctx));
        boolean res = op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.recordVisitor);
        if (res) {
            ctx.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        return res;
    }

    private static class ClosedDataInfo {
        boolean expressionChanged;
        boolean dataIsClosed;
        ILogicalExpression expression;

        public ClosedDataInfo(boolean expressionChanged, boolean dataIsClosed, ILogicalExpression expression) {
            this.expressionChanged = expressionChanged;
            this.dataIsClosed = dataIsClosed;
            this.expression = expression;
        }
    }

    private static class SettingClosedRecordVisitor
    extends AbstractConstVarFunVisitor<ClosedDataInfo, Void>
    implements ILogicalExpressionReferenceTransform {
        private IOptimizationContext context;
        private IVariableTypeEnvironment env;

        private SettingClosedRecordVisitor() {
        }

        public void setOptimizationContext(IOptimizationContext context, IVariableTypeEnvironment env) {
            this.context = context;
            this.env = env;
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            AbstractLogicalExpression expr = (AbstractLogicalExpression)exprRef.getValue();
            ClosedDataInfo cdi = (ClosedDataInfo)expr.accept((ILogicalExpressionVisitor)this, null);
            if (cdi.expressionChanged) {
                exprRef.setValue((Object)cdi.expression);
            }
            return cdi.expressionChanged;
        }

        public ClosedDataInfo visitConstantExpression(ConstantExpression expr, Void arg) throws AlgebricksException {
            return new ClosedDataInfo(false, this.hasClosedType((ILogicalExpression)expr), (ILogicalExpression)expr);
        }

        public ClosedDataInfo visitFunctionCallExpression(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed;
            block9: {
                IAType reqType;
                boolean allClosed;
                block8: {
                    allClosed = true;
                    changed = false;
                    if (!expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR)) break block8;
                    ARecordType reqType2 = (ARecordType)TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)expr);
                    if (reqType2 != null && reqType2.isOpen()) break block9;
                    int n = expr.getArguments().size();
                    if (n % 2 > 0) {
                        throw new CompilationException(1079, expr.getSourceLocation(), new Serializable[]{"Record constructor expected to have an even number of arguments: " + LogRedactionUtil.userData((String)expr.toString())});
                    }
                    for (int i = 0; i < n / 2; ++i) {
                        ILogicalExpression a0 = (ILogicalExpression)((Mutable)expr.getArguments().get(2 * i)).getValue();
                        if (a0.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                            allClosed = false;
                        }
                        Mutable aRef1 = (Mutable)expr.getArguments().get(2 * i + 1);
                        ILogicalExpression a1 = (ILogicalExpression)aRef1.getValue();
                        ClosedDataInfo cdi = (ClosedDataInfo)a1.accept((ILogicalExpressionVisitor)this, (Object)arg);
                        if (!cdi.dataIsClosed) {
                            allClosed = false;
                        }
                        if (!cdi.expressionChanged) continue;
                        aRef1.setValue((Object)cdi.expression);
                        changed = true;
                    }
                    if (!allClosed) break block9;
                    expr.setFunctionInfo(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR));
                    AlgebricksConfig.ALGEBRICKS_LOGGER.trace(() -> "Switching to CLOSED record constructor in " + LogRedactionUtil.userData((String)expr.toString()) + ".\n");
                    changed = true;
                    break block9;
                }
                boolean rewrite = true;
                if ((expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR) || expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR)) && (reqType = TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)expr)) == null) {
                    rewrite = false;
                }
                if (rewrite) {
                    for (Mutable e : expr.getArguments()) {
                        ILogicalExpression ale = (ILogicalExpression)e.getValue();
                        ClosedDataInfo cdi = (ClosedDataInfo)ale.accept((ILogicalExpressionVisitor)this, (Object)arg);
                        if (!cdi.dataIsClosed) {
                            allClosed = false;
                        }
                        if (!cdi.expressionChanged) continue;
                        e.setValue((Object)cdi.expression);
                        changed = true;
                    }
                }
            }
            return new ClosedDataInfo(changed, this.hasClosedType((ILogicalExpression)expr), (ILogicalExpression)expr);
        }

        public ClosedDataInfo visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) throws AlgebricksException {
            Object varType = this.env.getVarType(expr.getVariableReference());
            if (varType == null) {
                throw new CompilationException(1079, expr.getSourceLocation(), new Serializable[]{"Could not infer type for variable '" + expr.getVariableReference() + "'."});
            }
            return new ClosedDataInfo(false, TypeHelper.isClosed((IAType)((IAType)varType)), (ILogicalExpression)expr);
        }

        private boolean hasClosedType(ILogicalExpression expr) throws AlgebricksException {
            IAType t = (IAType)this.context.getExpressionTypeComputer().getType(expr, this.context.getMetadataProvider(), this.env);
            return TypeHelper.isClosed((IAType)t);
        }
    }
}

