/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.rewriter.rules.PushAssignBelowUnionAllRule;

public class AsterixPushAssignBelowUnionAllRule
extends PushAssignBelowUnionAllRule {
    protected boolean modifyExpression(ILogicalExpression expression, UnionAllOperator unionOp, IOptimizationContext ctx, int inputIndex) throws AlgebricksException {
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return true;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)expression;
        List arguments = functionCall.getArguments();
        int size = arguments.size();
        for (int k = 0; k < size; ++k) {
            if (this.modifyExpression((ILogicalExpression)((Mutable)arguments.get(k)).getValue(), unionOp, ctx, inputIndex)) continue;
            return false;
        }
        return !functionCall.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX) || AsterixPushAssignBelowUnionAllRule.mapFieldIndex(functionCall, unionOp, ctx, inputIndex);
    }

    private static boolean mapFieldIndex(AbstractFunctionCallExpression functionCall, UnionAllOperator unionOp, IOptimizationContext ctx, int inputIndex) throws AlgebricksException {
        ILogicalExpression recordExpr = (ILogicalExpression)((Mutable)functionCall.getArguments().get(0)).getValue();
        if (recordExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        Integer fieldIndex = ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)functionCall, (int)1);
        if (fieldIndex == null) {
            return false;
        }
        LogicalVariable recordVar = ((VariableReferenceExpression)recordExpr).getVariableReference();
        for (Triple varMap : unionOp.getVariableMappings()) {
            String fieldName;
            if (!((LogicalVariable)varMap.third).equals((Object)recordVar)) continue;
            ARecordType unionType = (ARecordType)ctx.getOutputTypeEnvironment((ILogicalOperator)unionOp).getVarType((LogicalVariable)varMap.third);
            ILogicalOperator inputOpToUnion = (ILogicalOperator)((Mutable)unionOp.getInputs().get(inputIndex)).getValue();
            ARecordType inputType = inputIndex == 0 ? (ARecordType)ctx.getOutputTypeEnvironment(inputOpToUnion).getVarType((LogicalVariable)varMap.first) : (ARecordType)ctx.getOutputTypeEnvironment(inputOpToUnion).getVarType((LogicalVariable)varMap.second);
            fieldIndex = inputType.getFieldIndex(fieldName = unionType.getFieldNames()[fieldIndex]);
            if (fieldIndex < 0) {
                return false;
            }
            ((Mutable)functionCall.getArguments().get(1)).setValue((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(fieldIndex.intValue()))));
            return true;
        }
        return false;
    }
}

