/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.aqlplus.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.aqlplus.parser.AQLPlusParserConstants;
import org.apache.asterix.aqlplus.parser.AQLPlusParserTokenManager;
import org.apache.asterix.aqlplus.parser.ParseException;
import org.apache.asterix.aqlplus.parser.SimpleCharStream;
import org.apache.asterix.aqlplus.parser.Token;
import org.apache.asterix.aqlplus.parser.TokenMgrError;
import org.apache.asterix.common.annotations.AutoDataGen;
import org.apache.asterix.common.annotations.DateBetweenYearsDataGen;
import org.apache.asterix.common.annotations.DatetimeAddRandHoursDataGen;
import org.apache.asterix.common.annotations.DatetimeBetweenYearsDataGen;
import org.apache.asterix.common.annotations.FieldIntervalDataGen;
import org.apache.asterix.common.annotations.FieldValFileDataGen;
import org.apache.asterix.common.annotations.FieldValFileSameIndexDataGen;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.InsertRandIntDataGen;
import org.apache.asterix.common.annotations.ListDataGen;
import org.apache.asterix.common.annotations.ListValFileDataGen;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.clause.JoinClause;
import org.apache.asterix.lang.aql.clause.MetaVariableClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.MetaVariableExpr;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.util.AQLFormatPrintUtil;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.RangeMapBuilder;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;

public class AQLPlusParser
extends ScopeChecker
implements IParser,
AQLPlusParserConstants {
    private static final String AUTO_HINT = "auto";
    private static final String HASH_BROADCAST_JOIN_HINT = "hash-bcast";
    private static final String COMPOSE_VAL_FILES_HINT = "compose-val-files";
    private static final String DATE_BETWEEN_YEARS_HINT = "date-between-years";
    private static final String DATETIME_ADD_RAND_HOURS_HINT = "datetime-add-rand-hours";
    private static final String DATETIME_BETWEEN_YEARS_HINT = "datetime-between-years";
    private static final String HASH_GROUP_BY_HINT = "hash";
    private static final String INDEXED_NESTED_LOOP_JOIN_HINT = "indexnl";
    private static final String INMEMORY_HINT = "inmem";
    private static final String INSERT_RAND_INT_HINT = "insert-rand-int";
    private static final String INTERVAL_HINT = "interval";
    private static final String LIST_HINT = "list";
    private static final String LIST_VAL_FILE_HINT = "list-val-file";
    private static final String RANGE_HINT = "range";
    private static final String SKIP_SECONDARY_INDEX_SEARCH_HINT = "skip-index";
    private static final String VAL_FILE_HINT = "val-files";
    private static final String VAL_FILE_SAME_INDEX_HINT = "val-file-same-idx";
    private static final String GEN_FIELDS_HINT = "gen-fields";
    private static final String DGEN_HINT = "dgen";
    private static final String INT_TYPE_NAME = "int";
    private static final char VAR_PREFIX = '$';
    private DataverseName defaultDataverse;
    public AQLPlusParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[122];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private static String getHint(Token t) {
        if (t.specialToken == null) {
            return null;
        }
        String s = t.specialToken.image;
        int n = s.length();
        if (n < 2) {
            return null;
        }
        return s.substring(1).trim();
    }

    private static void checkBindingVariable(Expression returnExpression, VariableExpr var, ILangExpression bodyExpression) throws ParseException {
        if (returnExpression != null && var == null) {
            try {
                throw new ParseException("Need a binding variable for the enclosed expression: " + AQLFormatPrintUtil.toString((ILangExpression)bodyExpression));
            }
            catch (CompilationException e) {
                throw new ParseException(e.getLocalizedMessage());
            }
        }
    }

    private static IRecordFieldDataGen parseFieldDataGen(String hint) throws ParseException {
        FieldValFileDataGen rfdg = null;
        String[] splits = hint.split(" +");
        if (splits[0].equals(VAL_FILE_HINT)) {
            File[] valFiles = new File[splits.length - 1];
            for (int k = 1; k < splits.length; ++k) {
                valFiles[k - 1] = new File(splits[k]);
            }
            rfdg = new FieldValFileDataGen(valFiles);
        } else if (splits[0].equals(VAL_FILE_SAME_INDEX_HINT)) {
            rfdg = new FieldValFileSameIndexDataGen(new File(splits[1]), splits[2]);
        } else if (splits[0].equals(LIST_VAL_FILE_HINT)) {
            rfdg = new ListValFileDataGen(new File(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3]));
        } else if (splits[0].equals(LIST_HINT)) {
            rfdg = new ListDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(INTERVAL_HINT)) {
            FieldIntervalDataGen.ValueType vt;
            if (splits[1].equals(INT_TYPE_NAME)) {
                vt = FieldIntervalDataGen.ValueType.INT;
            } else if (splits[1].equals("long")) {
                vt = FieldIntervalDataGen.ValueType.LONG;
            } else if (splits[1].equals("float")) {
                vt = FieldIntervalDataGen.ValueType.FLOAT;
            } else if (splits[1].equals("double")) {
                vt = FieldIntervalDataGen.ValueType.DOUBLE;
            } else {
                throw new ParseException("Unknown type for interval data gen: " + splits[1]);
            }
            rfdg = new FieldIntervalDataGen(vt, splits[2], splits[3]);
        } else if (splits[0].equals(INSERT_RAND_INT_HINT)) {
            rfdg = new InsertRandIntDataGen(splits[1], splits[2]);
        } else if (splits[0].equals(DATE_BETWEEN_YEARS_HINT)) {
            rfdg = new DateBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(DATETIME_BETWEEN_YEARS_HINT)) {
            rfdg = new DatetimeBetweenYearsDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
        } else if (splits[0].equals(DATETIME_ADD_RAND_HOURS_HINT)) {
            rfdg = new DatetimeAddRandHoursDataGen(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), splits[3]);
        } else if (splits[0].equals(AUTO_HINT)) {
            rfdg = new AutoDataGen(splits[1]);
        }
        return rfdg;
    }

    public AQLPlusParser(String s) {
        this(new StringReader(s));
        super.setInput(s);
    }

    public static void main(String[] args) throws ParseException, TokenMgrError, IOException, FileNotFoundException, CompilationException {
        File file = new File(args[0]);
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        AQLPlusParser parser = new AQLPlusParser(fis);
        List<Statement> st = parser.parse();
    }

    public List<Statement> parse() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<Statement>>(){

            @Override
            public List<Statement> parse() throws ParseException {
                return AQLPlusParser.this.Statement();
            }
        });
    }

    private Expression parseExpression() throws CompilationException {
        return this.parseImpl(new ParseFunction<Expression>(){

            @Override
            public Expression parse() throws ParseException {
                return AQLPlusParser.this.Expression();
            }
        });
    }

    private static Expression parseExpression(String text) throws CompilationException {
        return new AQLPlusParser(text).parseExpression();
    }

    public FunctionDecl parseFunctionBody(final FunctionSignature signature, final List<String> paramNames) throws CompilationException {
        return this.parseImpl(new ParseFunction<FunctionDecl>(){

            @Override
            public FunctionDecl parse() throws ParseException {
                DataverseName dataverse = AQLPlusParser.this.defaultDataverse;
                AQLPlusParser.this.defaultDataverse = signature.getDataverseName();
                AQLPlusParser.this.createNewScope();
                ArrayList<VarIdentifier> paramVars = new ArrayList<VarIdentifier>(paramNames.size());
                for (String paramName : paramNames) {
                    VarIdentifier var = new VarIdentifier('$' + paramName);
                    paramVars.add(var);
                    AQLPlusParser.this.getCurrentScope().addNewVarSymbolToScope(var);
                }
                Expression functionBodyExpr = AQLPlusParser.this.FunctionBody();
                AQLPlusParser.this.removeCurrentScope();
                AQLPlusParser.this.defaultDataverse = dataverse;
                return new FunctionDecl(signature, paramVars, functionBodyExpr);
            }
        });
    }

    private <T> T parseImpl(ParseFunction<T> parseFunction) throws CompilationException {
        try {
            return parseFunction.parse();
        }
        catch (Error e) {
            throw new CompilationException((Throwable)new ParseException(e.getMessage()));
        }
        catch (ParseException e) {
            throw new CompilationException(e.getMessage());
        }
    }

    public void initScope() {
        this.scopeStack.push(RootScopeFactory.createRootScope((ScopeChecker)this));
    }

    public final LimitClause LimitClause() throws ParseException, ParseException {
        LimitClause lc = new LimitClause();
        this.pushForbiddenScope(this.getCurrentScope());
        this.jj_consume_token(51);
        Expression expr = this.Expression();
        lc.setLimitExpr(expr);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                expr = this.Expression();
                lc.setOffset(expr);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.popForbiddenScope();
        if ("" != null) {
            return lc;
        }
        throw new Error("Missing return statement in function");
    }

    public final String StringLiteral() throws ParseException, ParseException {
        this.jj_consume_token(131);
        if ("" != null) {
            return AQLPlusParser.removeQuotesAndEscapes((String)this.token.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final RefreshExternalDatasetStatement RefreshExternalDatasetStatement() throws ParseException, ParseException {
        RefreshExternalDatasetStatement redss = new RefreshExternalDatasetStatement();
        Pair<DataverseName, Identifier> nameComponents = null;
        Object datasetName = null;
        this.jj_consume_token(64);
        this.jj_consume_token(30);
        this.jj_consume_token(16);
        nameComponents = this.QualifiedName();
        redss.setDataverseName((DataverseName)nameComponents.first);
        redss.setDatasetName((Identifier)nameComponents.second);
        if ("" != null) {
            return redss;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<Integer, Pair<List<String>, IndexedTypeExpression>> OpenField() throws ParseException, ParseException {
        IndexedTypeExpression fieldType = null;
        Pair<Integer, List<String>> fieldList = null;
        fieldList = this.NestedField();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                this.jj_consume_token(99);
                fieldType = this.IndexedTypeExpr();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new Pair(fieldList.first, (Object)new Pair(fieldList.second, (Object)fieldType));
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement CompactStatement() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        CompactStatement stmt = null;
        this.jj_consume_token(12);
        this.jj_consume_token(16);
        nameComponents = this.QualifiedName();
        stmt = new CompactStatement((DataverseName)nameComponents.first, (Identifier)nameComponents.second);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression AndExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.RelExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 112: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(112);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.RelExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeDecl TypeSpecification(String hint, boolean dgen) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        TypeExpression typeExpr = null;
        this.jj_consume_token(79);
        nameComponents = this.TypeName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(5);
        typeExpr = this.TypeExpr();
        long numValues = -1L;
        String filename = null;
        if (dgen) {
            String[] splits = hint.split(" +");
            if (splits.length != 3) {
                throw new ParseException("Expecting /*+ dgen <filename> <numberOfItems> */");
            }
            filename = splits[1];
            numValues = Long.parseLong(splits[2]);
        }
        TypeDataGen tddg = new TypeDataGen(dgen, filename, numValues);
        if ("" != null) {
            return new TypeDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, typeExpr, tddg, ifNotExists);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement WriteStatement() throws ParseException, ParseException {
        String nodeName = null;
        String fileName = null;
        String writerClass = null;
        Object nameComponents = null;
        this.jj_consume_token(87);
        this.jj_consume_token(59);
        this.jj_consume_token(78);
        nodeName = this.Identifier();
        this.jj_consume_token(99);
        fileName = this.StringLiteral();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                writerClass = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new WriteStatement(new Identifier(nodeName), fileName, writerClass);
        }
        throw new Error("Missing return statement in function");
    }

    public final boolean IfExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(29);
                if ("" == null) break;
                return true;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if ("" != null) {
            return false;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression Index() throws ParseException, ParseException {
        Expression expr = null;
        this.jj_consume_token(97);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 50: 
            case 75: 
            case 86: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: 
            case 155: {
                Literal lit;
                expr = this.Expression();
                if (expr.getKind() != Expression.Kind.LITERAL_EXPRESSION || (lit = ((LiteralExpr)expr).getValue()).getLiteralType() == Literal.Type.INTEGER || lit.getLiteralType() == Literal.Type.LONG) break;
                throw new ParseException("Index should be an INTEGER");
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(98);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final IndexParams IndexType() throws ParseException, ParseException {
        DatasetConfig.IndexType type = null;
        int gramLength = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                type = DatasetConfig.IndexType.BTREE;
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                type = DatasetConfig.IndexType.RTREE;
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX;
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                type = DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(95);
                this.jj_consume_token(120);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                gramLength = Integer.valueOf(this.token.image);
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new IndexParams(type, gramLength);
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionDecl FunctionDeclaration() throws ParseException, ParseException {
        List<Object> paramList_typ = new ArrayList();
        ArrayList<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
        this.createNewScope();
        this.jj_consume_token(18);
        this.jj_consume_token(37);
        String functionName = this.Identifier();
        paramList_typ = this.ParameterList();
        this.jj_consume_token(116);
        Expression funcBody = this.Expression();
        this.jj_consume_token(117);
        for (VarIdentifier varIdentifier : paramList_typ) {
            paramList.add(varIdentifier);
        }
        FunctionSignature signature = new FunctionSignature(this.defaultDataverse, functionName, paramList.size());
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        FunctionDecl funcDecl = new FunctionDecl(signature, paramList, funcBody);
        this.removeCurrentScope();
        if ("" != null) {
            return funcDecl;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Clause> Clauses() throws ParseException, ParseException {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        Clause c = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 24: 
                case 33: 
                case 35: 
                case 38: 
                case 50: 
                case 51: 
                case 58: 
                case 85: 
                case 86: 
                case 155: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            c = this.Clause();
            clauses.add(c);
        }
        if ("" != null) {
            return clauses;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression MultExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        OperatorType opType = null;
        Expression operand = null;
        operand = this.ExponentExpr();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: 
                case 90: 
                case 92: 
                case 93: 
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 93: {
                    this.jj_consume_token(93);
                    opType = OperatorType.MUL;
                    break;
                }
                case 89: {
                    this.jj_consume_token(89);
                    opType = OperatorType.DIVIDE;
                    break;
                }
                case 90: {
                    this.jj_consume_token(90);
                    opType = OperatorType.DIV;
                    break;
                }
                case 92: 
                case 102: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 92: {
                            this.jj_consume_token(92);
                            break;
                        }
                        case 102: {
                            this.jj_consume_token(102);
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    opType = OperatorType.MOD;
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            op.addOperator(opType);
            operand = this.ExponentExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final InsertStatement InsertStatement() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Expression returnExpression = null;
        this.jj_consume_token(44);
        this.jj_consume_token(46);
        this.jj_consume_token(16);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        if (var != null) {
            this.getCurrentScope().addNewVarSymbolToScope(var.getVar());
        }
        Query query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        AQLPlusParser.checkBindingVariable(returnExpression, var, (ILangExpression)query);
        query.setTopLevel(true);
        if ("" != null) {
            return new InsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        }
        throw new Error("Missing return statement in function");
    }

    public final void ApplyFunction(List<FunctionSignature> funcSigs) throws ParseException, ParseException {
        FunctionName functioName = null;
        String fqFunctionName = null;
        this.jj_consume_token(4);
        this.jj_consume_token(37);
        functioName = this.FunctionName();
        fqFunctionName = functioName.library == null ? functioName.function : functioName.library + "#" + functioName.function;
        funcSigs.add(new FunctionSignature(functioName.dataverse, fqFunctionName, 1));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            functioName = this.FunctionName();
            fqFunctionName = functioName.library == null ? functioName.function : functioName.library + "#" + functioName.function;
            funcSigs.add(new FunctionSignature(functioName.dataverse, fqFunctionName, 1));
        }
    }

    public final Expression FunctionCallExpr() throws ParseException, ParseException {
        ArrayList<Expression> argList = new ArrayList<Expression>();
        int arity = 0;
        FunctionName funcName = null;
        String hint = null;
        funcName = this.FunctionName();
        hint = funcName.hint;
        this.jj_consume_token(95);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 50: 
            case 75: 
            case 86: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: 
            case 155: {
                Expression tmp = this.Expression();
                argList.add(tmp);
                ++arity;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(100);
                    tmp = this.Expression();
                    argList.add(tmp);
                    ++arity;
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(96);
        String fqFunctionName = funcName.library == null ? funcName.function : funcName.library + "#" + funcName.function;
        FunctionSignature signature = this.lookupFunctionSignature(funcName.dataverse, fqFunctionName, arity);
        if (signature == null) {
            signature = new FunctionSignature(funcName.dataverse, fqFunctionName, arity);
        }
        CallExpr callExpr = new CallExpr(signature, argList);
        if (hint != null) {
            if (hint.startsWith(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                callExpr.addHint((IExpressionAnnotation)IndexedNLJoinExpressionAnnotation.INSTANCE);
            } else if (hint.startsWith(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                callExpr.addHint((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
            }
        }
        if ("" != null) {
            return callExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause Clause() throws ParseException, ParseException {
        Clause clause;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: 
            case 35: {
                clause = this.ForClause();
                break;
            }
            case 50: 
            case 86: {
                clause = this.LetClause();
                break;
            }
            case 85: {
                clause = this.WhereClause();
                break;
            }
            case 58: {
                clause = this.OrderbyClause();
                break;
            }
            case 38: {
                clause = this.GroupClause();
                break;
            }
            case 51: {
                clause = this.LimitClause();
                break;
            }
            case 24: {
                clause = this.DistinctClause();
                break;
            }
            case 155: {
                clause = this.MetaVariableClause();
                break;
            }
            case 2: 
            case 3: {
                clause = this.JoinClause();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return clause;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<Integer, List<String>> NestedField() throws ParseException, ParseException {
        ArrayList<String> exprList = new ArrayList<String>();
        String lit = null;
        int source = 0;
        lit = this.Identifier();
        boolean meetParens = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                this.jj_consume_token(96);
                if (!lit.equals("meta")) {
                    throw new ParseException("The string before () has to be \"meta\".");
                }
                meetParens = true;
                source = 1;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        if (!meetParens) {
            exprList.add(lit);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(101);
            lit = this.Identifier();
            exprList.add(lit);
        }
        if ("" != null) {
            return new Pair((Object)source, exprList);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression Literal() throws ParseException, ParseException {
        LiteralExpr lit = new LiteralExpr();
        String str = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                str = this.StringLiteral();
                lit.setValue((Literal)new StringLiteral(str));
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                lit.setValue((Literal)new LongIntegerLiteral(new Long(this.token.image)));
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                lit.setValue((Literal)new FloatLiteral(new Float(this.token.image)));
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                lit.setValue((Literal)new DoubleLiteral(new Double(this.token.image).doubleValue()));
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                lit.setValue((Literal)MissingLiteral.INSTANCE);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                lit.setValue((Literal)NullLiteral.INSTANCE);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                lit.setValue((Literal)TrueLiteral.INSTANCE);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                lit.setValue((Literal)FalseLiteral.INSTANCE);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return lit;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression OperatorExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AndExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(113);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.AndExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression AddExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.MultExpr();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 91: 
                case 94: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 94: {
                    this.jj_consume_token(94);
                    break;
                }
                case 91: {
                    this.jj_consume_token(91);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.MultExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SetStatement() throws ParseException, ParseException {
        String pn = null;
        String pv = null;
        this.jj_consume_token(72);
        pn = this.Identifier();
        pv = this.StringLiteral();
        if ("" != null) {
            return new SetStatement(pn, pv);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Statement> Statement() throws ParseException, ParseException {
        this.scopeStack.push(RootScopeFactory.createRootScope((ScopeChecker)this));
        ArrayList<Statement> decls = new ArrayList<Statement>();
        Statement stmt = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 21: 
                case 23: 
                case 25: 
                case 28: 
                case 33: 
                case 35: 
                case 40: 
                case 44: 
                case 50: 
                case 52: 
                case 64: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 81: 
                case 82: 
                case 83: 
                case 86: 
                case 87: 
                case 91: 
                case 94: 
                case 95: 
                case 97: 
                case 116: 
                case 118: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 131: 
                case 141: 
                case 142: 
                case 154: 
                case 155: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block9;
                }
            }
            stmt = this.SingleStatement();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            decls.add(stmt);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(1);
        }
        this.jj_consume_token(0);
        if ("" != null) {
            return decls;
        }
        throw new Error("Missing return statement in function");
    }

    public final String GetPolicy() throws ParseException, ParseException {
        String policy = null;
        this.jj_consume_token(84);
        this.jj_consume_token(61);
        policy = this.Identifier();
        if ("" != null) {
            return policy;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression FLWOGR() throws ParseException, ParseException {
        Clause tmp;
        FLWOGRExpression flworg = new FLWOGRExpression();
        ArrayList<Clause> clauseList = new ArrayList<Clause>();
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: 
            case 35: {
                tmp = this.ForClause();
                clauseList.add(tmp);
                break;
            }
            case 50: 
            case 86: {
                tmp = this.LetClause();
                clauseList.add(tmp);
                break;
            }
            case 155: {
                tmp = this.MetaVariableClause();
                clauseList.add(tmp);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 24: 
                case 33: 
                case 35: 
                case 38: 
                case 50: 
                case 51: 
                case 58: 
                case 85: 
                case 86: 
                case 155: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block12;
                }
            }
            tmp = this.Clause();
            clauseList.add(tmp);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression returnExpr = this.Expression();
        flworg.setClauseList(clauseList);
        flworg.setReturnExpr(returnExpr);
        this.removeCurrentScope();
        if ("" != null) {
            return flworg;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<DataverseName, Identifier> QualifiedName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        first = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                second = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        DataverseName id1 = null;
        Identifier id2 = null;
        if (second == null) {
            id2 = new Identifier(first);
        } else {
            id1 = DataverseName.createSinglePartName((String)first);
            id2 = new Identifier(second);
        }
        if ("" != null) {
            return new Pair((Object)id1, (Object)id2);
        }
        throw new Error("Missing return statement in function");
    }

    public final DistinctClause DistinctClause() throws ParseException, ParseException {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        this.jj_consume_token(24);
        this.jj_consume_token(10);
        Expression expr = this.Expression();
        exprs.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            expr = this.Expression();
            exprs.add(expr);
        }
        if ("" != null) {
            return new DistinctClause(exprs);
        }
        throw new Error("Missing return statement in function");
    }

    public final Identifier Field() throws ParseException, ParseException {
        String ident = null;
        this.jj_consume_token(101);
        ident = this.Identifier();
        if ("" != null) {
            return new Identifier(ident);
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause MetaVariableClause() throws ParseException, ParseException {
        this.jj_consume_token(155);
        VarIdentifier var = new VarIdentifier(this.token.image);
        if ("" != null) {
            return new MetaVariableClause(var);
        }
        throw new Error("Missing return statement in function");
    }

    public final String Identifier() throws ParseException, ParseException {
        String lit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 141: {
                this.jj_consume_token(141);
                if ("" == null) break;
                return this.token.image;
            }
            case 131: {
                lit = this.StringLiteral();
                if ("" == null) break;
                return lit;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SingleStatement() throws ParseException, ParseException {
        DataverseDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 83: {
                stmt = this.DataverseDeclaration();
                break;
            }
            case 18: {
                stmt = this.FunctionDeclaration();
                break;
            }
            case 15: {
                stmt = this.CreateStatement();
                break;
            }
            case 52: {
                stmt = this.LoadStatement();
                break;
            }
            case 25: {
                stmt = this.DropStatement();
                break;
            }
            case 87: {
                stmt = this.WriteStatement();
                break;
            }
            case 72: {
                stmt = this.SetStatement();
                break;
            }
            case 44: {
                stmt = this.InsertStatement();
                break;
            }
            case 82: {
                stmt = this.UpsertStatement();
                break;
            }
            case 21: {
                stmt = this.DeleteStatement();
                break;
            }
            case 81: {
                stmt = this.UpdateStatement();
                break;
            }
            case 14: 
            case 23: 
            case 73: 
            case 74: {
                stmt = this.FeedStatement();
                break;
            }
            case 12: {
                stmt = this.CompactStatement();
                break;
            }
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 50: 
            case 75: 
            case 86: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: 
            case 155: {
                stmt = this.Query();
                break;
            }
            case 64: {
                stmt = this.RefreshExternalDatasetStatement();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause LetClause() throws ParseException, ParseException {
        LetClause lc = new LetClause();
        this.extendCurrentScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(111);
        Expression beExp = this.Expression();
        this.getCurrentScope().addNewVarSymbolToScope(varExp.getVar());
        lc.setVarExpr(varExp);
        lc.setBindingExpr(beExp);
        if ("" != null) {
            return lc;
        }
        throw new Error("Missing return statement in function");
    }

    public final ListConstructor UnorderedListConstructor() throws ParseException, ParseException {
        ListConstructor expr = new ListConstructor();
        List<Expression> exprList = null;
        expr.setType(ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR);
        this.jj_consume_token(118);
        exprList = this.ExpressionList();
        this.jj_consume_token(119);
        expr.setExprList(exprList);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression PrimaryExpr() throws ParseException, ParseException {
        Expression expr = null;
        if (this.jj_2_1(2)) {
            expr = this.FunctionCallExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 131: {
                    expr = this.Literal();
                    break;
                }
                case 16: {
                    expr = this.DatasetAccessExpression();
                    break;
                }
                case 142: {
                    expr = this.VariableRef();
                    if (!((VariableExpr)expr).getIsNewVar()) break;
                    throw new ParseException("can't find variable " + ((VariableExpr)expr).getVar());
                }
                case 97: 
                case 118: {
                    expr = this.ListConstructor();
                    break;
                }
                case 116: {
                    expr = this.RecordConstructor();
                    break;
                }
                case 95: {
                    expr = this.ParenthesizedExpression();
                    break;
                }
                case 154: {
                    expr = this.MetaVariableRef();
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression DatasetAccessExpression() throws ParseException, ParseException {
        Expression nameArg;
        String arg1 = null;
        String arg2 = null;
        this.jj_consume_token(16);
        String funcName = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: 
            case 141: {
                arg1 = this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 101: {
                        this.jj_consume_token(101);
                        arg2 = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                String name = arg2 == null ? arg1 : arg1 + "." + arg2;
                LiteralExpr ds = new LiteralExpr();
                ds.setValue((Literal)new StringLiteral(name));
                nameArg = ds;
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                nameArg = this.Expression();
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataverseName dataverse = MetadataConstants.METADATA_DATAVERSE_NAME;
        FunctionSignature signature = this.lookupFunctionSignature(dataverse, funcName, 1);
        if (signature == null) {
            signature = new FunctionSignature(dataverse, funcName, 1);
        }
        ArrayList<Expression> argList = new ArrayList<Expression>();
        argList.add(nameArg);
        if ("" != null) {
            return new CallExpr(signature, argList);
        }
        throw new Error("Missing return statement in function");
    }

    public final UpdateClause UpdateClause() throws ParseException, ParseException {
        Expression target = null;
        Expression value = null;
        InsertStatement is = null;
        DeleteStatement ds = null;
        UpdateStatement us = null;
        Expression condition = null;
        UpdateClause ifbranch = null;
        UpdateClause elsebranch = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                target = this.Expression();
                this.jj_consume_token(111);
                value = this.Expression();
                break;
            }
            case 44: {
                is = this.InsertStatement();
                break;
            }
            case 21: {
                ds = this.DeleteStatement();
                break;
            }
            case 81: {
                us = this.UpdateStatement();
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(95);
                condition = this.Expression();
                this.jj_consume_token(96);
                this.jj_consume_token(77);
                ifbranch = this.UpdateClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        elsebranch = this.UpdateClause();
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                    }
                }
                if ("" == null) break;
                return new UpdateClause(target, value, is, ds, us, condition, ifbranch, elsebranch);
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause ForClause() throws ParseException, ParseException {
        ForClause fc = new ForClause();
        VariableExpr varPos = null;
        this.extendCurrentScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        VariableExpr varExp = this.Variable();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                varPos = this.Variable();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        this.jj_consume_token(41);
        Expression inExp = this.Expression();
        fc.setVarExpr(varExp);
        this.getCurrentScope().addNewVarSymbolToScope(varExp.getVar());
        fc.setInExpr(inExp);
        if (varPos != null) {
            fc.setPosExpr(varPos);
            this.getCurrentScope().addNewVarSymbolToScope(varPos.getVar());
        }
        if ("" != null) {
            return fc;
        }
        throw new Error("Missing return statement in function");
    }

    public final Triple<DataverseName, Identifier, Identifier> DoubleQualifiedName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        String third = null;
        first = this.Identifier();
        this.jj_consume_token(101);
        second = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 101: {
                this.jj_consume_token(101);
                third = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        DataverseName id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        if (third == null) {
            id2 = new Identifier(first);
            id3 = new Identifier(second);
        } else {
            id1 = DataverseName.createSinglePartName((String)first);
            id2 = new Identifier(second);
            id3 = new Identifier(third);
        }
        if ("" != null) {
            return new Triple((Object)id1, (Object)id2, (Object)id3);
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause OrderbyClause() throws ParseException, ParseException {
        OrderbyClause oc = new OrderbyClause();
        ArrayList<Expression> orderbyList = new ArrayList<Expression>();
        ArrayList<OrderbyClause.OrderModifier> modifierList = new ArrayList<OrderbyClause.OrderModifier>();
        boolean numOfOrderby = false;
        this.jj_consume_token(58);
        String hint = AQLPlusParser.getHint(this.token);
        if (hint != null) {
            if (hint.startsWith(INMEMORY_HINT)) {
                String[] splits = hint.split(" +");
                int numFrames = Integer.parseInt(splits[1]);
                int numTuples = Integer.parseInt(splits[2]);
                oc.setNumFrames(numFrames);
                oc.setNumTuples(numTuples);
            } else if (hint.startsWith(RANGE_HINT)) {
                try {
                    oc.setRangeMap(RangeMapBuilder.parseHint((Expression)AQLPlusParser.parseExpression(hint.substring(RANGE_HINT.length()))));
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
            }
        }
        this.jj_consume_token(10);
        Expression orderbyExpr = this.Expression();
        orderbyList.add(orderbyExpr);
        OrderbyClause.OrderModifier modif = OrderbyClause.OrderModifier.ASC;
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        modif = OrderbyClause.OrderModifier.ASC;
                        break block1;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        modif = OrderbyClause.OrderModifier.DESC;
                        break block1;
                    }
                }
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        modifierList.add(modif);
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(100);
            orderbyExpr = this.Expression();
            orderbyList.add(orderbyExpr);
            modif = OrderbyClause.OrderModifier.ASC;
            block11 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: {
                            this.jj_consume_token(6);
                            modif = OrderbyClause.OrderModifier.ASC;
                            break block11;
                        }
                        case 22: {
                            this.jj_consume_token(22);
                            modif = OrderbyClause.OrderModifier.DESC;
                            break block11;
                        }
                    }
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                }
            }
            modifierList.add(modif);
        }
        oc.setModifierList(modifierList);
        oc.setOrderbyList(orderbyList);
        if ("" != null) {
            return oc;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression IfThenElse() throws ParseException, ParseException {
        IfExpr ifExpr = new IfExpr();
        this.jj_consume_token(40);
        this.jj_consume_token(95);
        Expression condExpr = this.Expression();
        this.jj_consume_token(96);
        this.jj_consume_token(77);
        Expression thenExpr = this.Expression();
        this.jj_consume_token(26);
        Expression elseExpr = this.Expression();
        ifExpr.setCondExpr(condExpr);
        ifExpr.setThenExpr(thenExpr);
        ifExpr.setElseExpr(elseExpr);
        if ("" != null) {
            return ifExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final void RecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeExpression type = null;
        boolean nullable = false;
        boolean missable = false;
        String fieldName = this.Identifier();
        String hint = AQLPlusParser.getHint(this.token);
        IRecordFieldDataGen rfdg = hint != null ? AQLPlusParser.parseFieldDataGen(hint) : null;
        this.jj_consume_token(99);
        type = this.TypeExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                nullable = true;
                missable = true;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        recType.addField(fieldName, type, nullable, missable, rfdg);
    }

    public final Expression UnionExpr() throws ParseException, ParseException {
        UnionExpr union = null;
        Expression operand1 = null;
        Expression operand2 = null;
        operand1 = this.UnaryExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 80: {
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(80);
            operand2 = this.UnaryExpr();
            if (union == null) {
                union = new UnionExpr();
                union.addExpr(operand1);
            }
            union.addExpr(operand2);
        }
        if ("" != null) {
            return union == null ? operand1 : union;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression RelExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        IndexedNLJoinExpressionAnnotation annotation = null;
        operand = this.AddExpr();
        if (this.jj_2_2(2)) {
            String hint;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 104: {
                    this.jj_consume_token(104);
                    break;
                }
                case 105: {
                    this.jj_consume_token(105);
                    break;
                }
                case 106: {
                    this.jj_consume_token(106);
                    break;
                }
                case 107: {
                    this.jj_consume_token(107);
                    break;
                }
                case 108: {
                    this.jj_consume_token(108);
                    break;
                }
                case 109: {
                    this.jj_consume_token(109);
                    break;
                }
                case 110: {
                    this.jj_consume_token(110);
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String mhint = AQLPlusParser.getHint(this.token);
            if (mhint != null) {
                if (mhint.equals(INDEXED_NESTED_LOOP_JOIN_HINT)) {
                    annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
                } else if (mhint.equals(SKIP_SECONDARY_INDEX_SEARCH_HINT)) {
                    annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
            }
            try {
                op.addOperator(this.token.image);
            }
            catch (CompilationException e) {
                throw new ParseException(e.getMessage());
            }
            operand = this.AddExpr();
            if (operand instanceof VariableExpr && (hint = AQLPlusParser.getHint(this.token)) != null && hint.equals(HASH_BROADCAST_JOIN_HINT)) {
                annotation = new BroadcastExpressionAnnotation();
                annotation.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
            }
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final String FilterField() throws ParseException, ParseException {
        String filterField = null;
        filterField = this.Identifier();
        if ("" != null) {
            return filterField;
        }
        throw new Error("Missing return statement in function");
    }

    public final String CompactionPolicy() throws ParseException, ParseException {
        String compactionPolicy = null;
        compactionPolicy = this.Identifier();
        if ("" != null) {
            return compactionPolicy;
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionName FunctionName() throws ParseException, ParseException {
        String first = null;
        String second = null;
        String third = null;
        boolean secondAfterDot = false;
        first = this.Identifier();
        FunctionName result = new FunctionName();
        result.hint = AQLPlusParser.getHint(this.token);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 101: 
            case 115: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 101: {
                        this.jj_consume_token(101);
                        second = this.Identifier();
                        secondAfterDot = true;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 115: {
                                this.jj_consume_token(115);
                                third = this.Identifier();
                                break block0;
                            }
                        }
                        this.jj_la1[50] = this.jj_gen;
                        break block0;
                    }
                    case 115: {
                        this.jj_consume_token(115);
                        second = this.Identifier();
                        break block0;
                    }
                }
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        if (second == null) {
            result.dataverse = this.defaultDataverse;
            result.library = null;
            result.function = first;
        } else if (third == null) {
            if (secondAfterDot) {
                result.dataverse = DataverseName.createSinglePartName((String)first);
                result.library = null;
                result.function = second;
            } else {
                result.dataverse = this.defaultDataverse;
                result.library = first;
                result.function = second;
            }
        } else {
            result.dataverse = DataverseName.createSinglePartName((String)first);
            result.library = second;
            result.function = third;
        }
        if (result.function.equalsIgnoreCase(INT_TYPE_NAME)) {
            result.function = BuiltinType.AINT64.getTypeName();
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Expression> ExpressionList() throws ParseException, ParseException {
        Expression expr = null;
        List<Expression> list = null;
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 50: 
            case 75: 
            case 86: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: 
            case 155: {
                expr = this.Expression();
                exprList.add(expr);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 100: {
                        this.jj_consume_token(100);
                        list = this.ExpressionList();
                        exprList.addAll(list);
                        break block0;
                    }
                }
                this.jj_la1[53] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 100: {
                this.Comma();
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        if ("" != null) {
            return exprList;
        }
        throw new Error("Missing return statement in function");
    }

    public final DeleteStatement DeleteStatement() throws ParseException, ParseException {
        VariableExpr var = null;
        Expression condition = null;
        this.jj_consume_token(21);
        var = this.Variable();
        this.getCurrentScope().addNewVarSymbolToScope(var.getVar());
        this.jj_consume_token(35);
        this.jj_consume_token(16);
        Pair<DataverseName, Identifier> nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                condition = this.Expression();
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new DeleteStatement(var, (DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), condition, this.getVarCounter());
        }
        throw new Error("Missing return statement in function");
    }

    public final Map<String, String> Properties() throws ParseException, ParseException {
        HashMap<String, String> properties = new HashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                Pair<String, String> property = this.Property();
                properties.put((String)property.first, (String)property.second);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(100);
                    property = this.Property();
                    properties.put((String)property.first, (String)property.second);
                }
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        if ("" != null) {
            return properties;
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause GroupClause() throws ParseException, ParseException {
        GroupbyClause gbc = new GroupbyClause();
        ArrayList<GbyVariableExpressionPair> vePairList = new ArrayList<GbyVariableExpressionPair>();
        ArrayList<GbyVariableExpressionPair> decorPairList = new ArrayList<GbyVariableExpressionPair>();
        HashMap<VariableExpr, VariableExpr> withVarMap = new HashMap<VariableExpr, VariableExpr>();
        VariableExpr var = null;
        VariableExpr withVar = null;
        Expression expr = null;
        VariableExpr decorVar = null;
        Expression decorExpr = null;
        Scope newScope = this.extendCurrentScopeNoPush(true);
        this.jj_consume_token(38);
        String hint = AQLPlusParser.getHint(this.token);
        if (hint != null && hint.equals(HASH_GROUP_BY_HINT)) {
            gbc.setHashGroupByHint(true);
        }
        this.jj_consume_token(10);
        if (this.jj_2_3(2)) {
            var = this.Variable();
            newScope.addNewVarSymbolToScope(var.getVar());
            this.jj_consume_token(111);
        }
        expr = this.Expression();
        GbyVariableExpressionPair pair1 = new GbyVariableExpressionPair(var, expr);
        vePairList.add(pair1);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(100);
            if (this.jj_2_4(2)) {
                var = this.Variable();
                newScope.addNewVarSymbolToScope(var.getVar());
                this.jj_consume_token(111);
            }
            expr = this.Expression();
            GbyVariableExpressionPair pair2 = new GbyVariableExpressionPair(var, expr);
            vePairList.add(pair2);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                decorVar = this.Variable();
                this.jj_consume_token(111);
                decorExpr = this.Expression();
                newScope.addNewVarSymbolToScope(decorVar.getVar());
                GbyVariableExpressionPair pair3 = new GbyVariableExpressionPair(decorVar, decorExpr);
                decorPairList.add(pair3);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(100);
                    this.jj_consume_token(19);
                    decorVar = this.Variable();
                    this.jj_consume_token(111);
                    decorExpr = this.Expression();
                    newScope.addNewVarSymbolToScope(decorVar.getVar());
                    GbyVariableExpressionPair pair4 = new GbyVariableExpressionPair(decorVar, decorExpr);
                    decorPairList.add(pair4);
                }
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        withVar = this.VariableRef();
        if (withVar.getIsNewVar()) {
            throw new ParseException("can't find variable " + withVar.getVar());
        }
        withVarMap.put(withVar, withVar);
        newScope.addNewVarSymbolToScope(withVar.getVar());
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(100);
            withVar = this.VariableRef();
            if (withVar.getIsNewVar()) {
                throw new ParseException("can't find variable " + withVar.getVar());
            }
            withVarMap.put(withVar, withVar);
            newScope.addNewVarSymbolToScope(withVar.getVar());
        }
        gbc.setGbyPairList(Collections.singletonList(vePairList));
        gbc.setDecorPairList(decorPairList);
        gbc.setWithVarMap(withVarMap);
        this.replaceCurrentScope(newScope);
        if ("" != null) {
            return gbc;
        }
        throw new Error("Missing return statement in function");
    }

    public final OrderedListTypeDefinition OrderedListTypeDef() throws ParseException, ParseException {
        TypeExpression type = null;
        this.jj_consume_token(97);
        type = this.TypeExpr();
        this.jj_consume_token(98);
        if ("" != null) {
            return new OrderedListTypeDefinition(type);
        }
        throw new Error("Missing return statement in function");
    }

    public final boolean IfNotExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(141);
                if (!this.token.image.equals("not")) {
                    throw new ParseException("Expect word \"not\" at line " + this.token.beginLine + ", column " + this.token.beginColumn + "!");
                }
                this.jj_consume_token(29);
                if ("" == null) break;
                return true;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        if ("" != null) {
            return false;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ListConstructor() throws ParseException, ParseException {
        ListConstructor expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: {
                expr = this.OrderedListConstructor();
                break;
            }
            case 118: {
                expr = this.UnorderedListConstructor();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final LoadStatement LoadStatement() throws ParseException, ParseException {
        DataverseName dataverseName = null;
        Identifier datasetName = null;
        boolean alreadySorted = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(52);
        this.jj_consume_token(16);
        nameComponents = this.QualifiedName();
        dataverseName = (DataverseName)nameComponents.first;
        datasetName = (Identifier)nameComponents.second;
        this.jj_consume_token(84);
        String adapterName = this.AdapterName();
        Map<String, String> properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 62: {
                this.jj_consume_token(62);
                alreadySorted = true;
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new LoadStatement(dataverseName, datasetName.getValue(), adapterName, properties, alreadySorted);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression UnaryExpr() throws ParseException, ParseException {
        UnaryExpr uexpr = null;
        Expression expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 91: 
            case 94: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: {
                        this.jj_consume_token(94);
                        break;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                uexpr = new UnaryExpr();
                try {
                    uexpr.setExprType(this.token.image);
                    break;
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        expr = this.ValueExpr();
        if (uexpr != null) {
            uexpr.setExpr(expr);
            if ("" != null) {
                return uexpr;
            }
        } else if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Query Query() throws ParseException, ParseException {
        Query query = new Query(false);
        Expression expr = this.Expression();
        query.setBody(expr);
        query.setVarCounter(this.getVarCounter());
        if ("" != null) {
            return query;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ValueExpr() throws ParseException, ParseException {
        FieldAccessor fa;
        Expression expr;
        block9: {
            expr = null;
            Identifier ident = null;
            fa = null;
            Expression indexExpr = null;
            expr = this.PrimaryExpr();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 97: 
                    case 101: {
                        break;
                    }
                    default: {
                        this.jj_la1[69] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 101: {
                        ident = this.Field();
                        fa = fa == null ? new FieldAccessor(expr, ident) : new FieldAccessor(fa, ident);
                        continue block7;
                    }
                    case 97: {
                        indexExpr = this.Index();
                        fa = fa == null ? new IndexAccessor(expr, indexExpr) : new IndexAccessor(fa, indexExpr);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[70] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return fa == null ? expr : fa;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeReferenceExpression TypeReference() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> id = null;
        id = this.QualifiedName();
        if (id.first == null && ((Identifier)id.second).getValue().equalsIgnoreCase(INT_TYPE_NAME)) {
            id.second = new Identifier(BuiltinType.AINT64.getTypeName());
        }
        if ("" != null) {
            return new TypeReferenceExpression(id);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement DropStatement() throws ParseException, ParseException {
        String id = null;
        Pair<DataverseName, Identifier> pairId = null;
        Triple<DataverseName, Identifier, Identifier> tripleId = null;
        FunctionSignature funcSig = null;
        boolean ifExists = false;
        FunctionDropStatement stmt = null;
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new DropDatasetStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                tripleId = this.DoubleQualifiedName();
                ifExists = this.IfExists();
                stmt = new IndexDropStatement((DataverseName)tripleId.first, (Identifier)tripleId.second, (Identifier)tripleId.third, ifExists);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                id = this.Identifier();
                ifExists = this.IfExists();
                stmt = new NodeGroupDropStatement(new Identifier(id), ifExists);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                pairId = this.TypeName();
                ifExists = this.IfExists();
                stmt = new TypeDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                id = this.Identifier();
                ifExists = this.IfExists();
                stmt = new DataverseDropStatement(DataverseName.createSinglePartName((String)id), ifExists);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                funcSig = this.FunctionSignature();
                ifExists = this.IfExists();
                stmt = new FunctionDropStatement(funcSig, ifExists);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new FeedDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                this.jj_consume_token(61);
                pairId = this.QualifiedName();
                ifExists = this.IfExists();
                stmt = new FeedPolicyDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ParenthesizedExpression() throws ParseException, ParseException {
        this.jj_consume_token(95);
        Expression expr = this.Expression();
        this.jj_consume_token(96);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement CreateStatement() throws ParseException, ParseException {
        String hint = null;
        boolean dgen = false;
        NodegroupDecl stmt = null;
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                hint = AQLPlusParser.getHint(this.token);
                if (hint != null && hint.startsWith(DGEN_HINT)) {
                    dgen = true;
                }
                stmt = this.TypeSpecification(hint, dgen);
                break;
            }
            case 54: {
                stmt = this.NodegroupSpecification();
                break;
            }
            case 16: 
            case 30: 
            case 45: {
                stmt = this.DatasetSpecification();
                break;
            }
            case 42: 
            case 63: {
                stmt = this.IndexSpecification();
                break;
            }
            case 17: {
                stmt = this.DataverseSpecification();
                break;
            }
            case 37: {
                stmt = this.FunctionSpecification();
                break;
            }
            case 31: {
                stmt = this.FeedSpecification();
                break;
            }
            case 43: {
                stmt = this.FeedPolicySpecification();
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final QuantifiedExpression QuantifiedExpression() throws ParseException, ParseException {
        QuantifiedExpression qc = new QuantifiedExpression();
        ArrayList<QuantifiedPair> quantifiedList = new ArrayList<QuantifiedPair>();
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                qc.setQuantifier(QuantifiedExpression.Quantifier.SOME);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                qc.setQuantifier(QuantifiedExpression.Quantifier.EVERY);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        VariableExpr var = this.Variable();
        this.jj_consume_token(41);
        Expression inExpr = this.Expression();
        QuantifiedPair pair = new QuantifiedPair(var, inExpr);
        this.getCurrentScope().addNewVarSymbolToScope(var.getVar());
        quantifiedList.add(pair);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(100);
            var = this.Variable();
            this.jj_consume_token(41);
            inExpr = this.Expression();
            pair = new QuantifiedPair(var, inExpr);
            this.getCurrentScope().addNewVarSymbolToScope(var.getVar());
            quantifiedList.add(pair);
        }
        this.jj_consume_token(69);
        Expression satisfiesExpr = this.Expression();
        qc.setSatisfiesExpr(satisfiesExpr);
        qc.setQuantifiedList(quantifiedList);
        this.removeCurrentScope();
        if ("" != null) {
            return qc;
        }
        throw new Error("Missing return statement in function");
    }

    public final String AdapterName() throws ParseException, ParseException {
        String adapterName = null;
        adapterName = this.Identifier();
        if ("" != null) {
            return adapterName;
        }
        throw new Error("Missing return statement in function");
    }

    public final DataverseDecl DataverseDeclaration() throws ParseException, ParseException {
        String dvName = null;
        this.jj_consume_token(83);
        this.jj_consume_token(17);
        dvName = this.Identifier();
        this.defaultDataverse = DataverseName.createSinglePartName((String)dvName);
        if ("" != null) {
            return new DataverseDecl(this.defaultDataverse);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedStatement FeedSpecification() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        CreateFeedStatement cfs = null;
        RecordConstructor withRecord = null;
        this.jj_consume_token(31);
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(86);
        withRecord = this.RecordConstructor();
        try {
            cfs = new CreateFeedStatement(nameComponents, withRecord, ifNotExists);
            if ("" != null) {
                return cfs;
            }
        }
        catch (AlgebricksException e) {
            throw new ParseException(e.getMessage());
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionSignature FunctionSignature() throws ParseException, ParseException {
        String fqFunctionName;
        FunctionName fctName = null;
        int arity = 0;
        fctName = this.FunctionName();
        this.jj_consume_token(114);
        this.jj_consume_token(120);
        arity = new Integer(this.token.image);
        if (arity < 0 && arity != -1) {
            throw new ParseException(" invalid arity:" + arity);
        }
        String string = fqFunctionName = fctName.library == null ? fctName.function : fctName.library + "#" + fctName.function;
        if ("" != null) {
            return new FunctionSignature(fctName.dataverse, fqFunctionName, arity);
        }
        throw new Error("Missing return statement in function");
    }

    public final FieldBinding FieldBinding() throws ParseException, ParseException {
        Expression left = this.Expression();
        this.jj_consume_token(99);
        Expression right = this.Expression();
        if ("" != null) {
            return new FieldBinding(left, right);
        }
        throw new Error("Missing return statement in function");
    }

    public final MetaVariableExpr MetaVariableRef() throws ParseException, ParseException {
        this.jj_consume_token(154);
        VarIdentifier var = new VarIdentifier(this.token.image);
        if ("" != null) {
            return new MetaVariableExpr(var);
        }
        throw new Error("Missing return statement in function");
    }

    public final DatasetDecl DatasetSpecification() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        Pair<DataverseName, Identifier> typeComponents = null;
        Pair<DataverseName, Identifier> metaTypeComponents = null;
        String adapterName = null;
        Map<String, String> properties = null;
        Object appliedFunction = null;
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        String nodeGroupName = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl dsetDecl = null;
        boolean autogenerated = false;
        Pair<Integer, List<String>> filterField = null;
        RecordConstructor withRecord = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                this.jj_consume_token(16);
                nameComponents = this.QualifiedName();
                this.jj_consume_token(95);
                typeComponents = this.TypeName();
                this.jj_consume_token(96);
                ifNotExists = this.IfNotExists();
                this.jj_consume_token(84);
                adapterName = this.AdapterName();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        nodeGroupName = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        hints = this.Properties();
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 86: {
                        this.jj_consume_token(86);
                        withRecord = this.RecordConstructor();
                        break;
                    }
                    default: {
                        this.jj_la1[77] = this.jj_gen;
                    }
                }
                ExternalDetailsDecl edd = new ExternalDetailsDecl();
                edd.setAdapter(adapterName);
                edd.setProperties(properties);
                try {
                    dsetDecl = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, (TypeExpression)new TypeReferenceExpression(typeComponents), null, nodeGroupName != null ? new Identifier(nodeGroupName) : null, hints, DatasetConfig.DatasetType.EXTERNAL, (IDatasetDetailsDecl)edd, withRecord, ifNotExists);
                    break;
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            case 16: 
            case 45: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 45: {
                        this.jj_consume_token(45);
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                    }
                }
                this.jj_consume_token(16);
                nameComponents = this.QualifiedName();
                this.jj_consume_token(95);
                typeComponents = this.TypeName();
                this.jj_consume_token(96);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 86: {
                        this.jj_consume_token(86);
                        String name = this.Identifier();
                        if (!name.equals("meta")) {
                            throw new ParseException("We can only support one additional associated field called \"meta\".");
                        }
                        this.jj_consume_token(95);
                        metaTypeComponents = this.TypeName();
                        this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                    }
                }
                ifNotExists = this.IfNotExists();
                primaryKeyFields = this.PrimaryKey();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        autogenerated = true;
                        break;
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        nodeGroupName = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        hints = this.Properties();
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                    }
                }
                if (this.jj_2_5(2)) {
                    this.jj_consume_token(86);
                    this.jj_consume_token(32);
                    this.jj_consume_token(56);
                    filterField = this.NestedField();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 86: {
                        this.jj_consume_token(86);
                        withRecord = this.RecordConstructor();
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                if (filterField != null && (Integer)filterField.first != 0) {
                    throw new ParseException("A filter field can only be a field in the main record of the dataset.");
                }
                InternalDetailsDecl idd = new InternalDetailsDecl((List)primaryKeyFields.second, (List)primaryKeyFields.first, autogenerated, filterField == null ? null : (List)filterField.second);
                try {
                    dsetDecl = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, (TypeExpression)new TypeReferenceExpression(typeComponents), (TypeExpression)(metaTypeComponents != null ? new TypeReferenceExpression(metaTypeComponents) : null), nodeGroupName != null ? new Identifier(nodeGroupName) : null, hints, DatasetConfig.DatasetType.INTERNAL, (IDatasetDetailsDecl)idd, withRecord, ifNotExists);
                    break;
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return dsetDecl;
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause WhereClause() throws ParseException, ParseException {
        WhereClause wc = new WhereClause();
        this.jj_consume_token(85);
        Expression whereExpr = this.Expression();
        wc.setWhereExpr(whereExpr);
        if ("" != null) {
            return wc;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<String, String> KeyValuePair() throws ParseException, ParseException {
        String value;
        this.jj_consume_token(95);
        String key = this.StringLiteral();
        this.jj_consume_token(108);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                value = this.StringLiteral();
                break;
            }
            case 123: 
            case 124: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 123: {
                        this.jj_consume_token(123);
                        break;
                    }
                    case 124: {
                        this.jj_consume_token(124);
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                value = this.token.image.toLowerCase();
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(96);
        if ("" != null) {
            return new Pair((Object)key, (Object)value);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement FeedStatement() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        Pair<DataverseName, Identifier> datasetNameComponents = null;
        Object configuration = null;
        ArrayList<FunctionSignature> appliedFunctions = new ArrayList<FunctionSignature>();
        StartFeedStatement stmt = null;
        String policy = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.jj_consume_token(31);
                feedNameComponents = this.QualifiedName();
                this.jj_consume_token(78);
                this.jj_consume_token(16);
                datasetNameComponents = this.QualifiedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.ApplyFunction(appliedFunctions);
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 84: {
                        policy = this.GetPolicy();
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                    }
                }
                stmt = new ConnectFeedStatement(feedNameComponents, datasetNameComponents, appliedFunctions, policy, null, this.getVarCounter());
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(31);
                feedNameComponents = this.QualifiedName();
                this.jj_consume_token(35);
                this.jj_consume_token(16);
                datasetNameComponents = this.QualifiedName();
                stmt = new DisconnectFeedStatement(feedNameComponents, datasetNameComponents);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                this.jj_consume_token(31);
                feedNameComponents = this.QualifiedName();
                stmt = new StartFeedStatement(feedNameComponents);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                this.jj_consume_token(31);
                feedNameComponents = this.QualifiedName();
                stmt = new StopFeedStatement(feedNameComponents);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedPolicyStatement FeedPolicySpecification() throws ParseException, ParseException {
        String policyName = null;
        String basePolicyName = null;
        String sourcePolicyFile = null;
        String definition = null;
        boolean ifNotExists = false;
        Map<String, String> properties = null;
        CreateFeedPolicyStatement cfps = null;
        this.jj_consume_token(43);
        this.jj_consume_token(61);
        policyName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(35);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: {
                this.jj_consume_token(61);
                basePolicyName = this.Identifier();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        definition = this.StringLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                    }
                }
                cfps = new CreateFeedPolicyStatement(policyName, basePolicyName, properties, definition, ifNotExists);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                sourcePolicyFile = this.StringLiteral();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        definition = this.StringLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                    }
                }
                cfps = new CreateFeedPolicyStatement(policyName, sourcePolicyFile, definition, ifNotExists);
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return cfps;
        }
        throw new Error("Missing return statement in function");
    }

    public final VariableExpr VariableRef() throws ParseException, ParseException {
        VariableExpr varExp;
        this.jj_consume_token(142);
        String varName = this.token.image;
        Identifier ident = this.lookupSymbol(varName);
        if (this.isInForbiddenScopes(varName)) {
            throw new ParseException("Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
        if (ident != null) {
            varExp = new VariableExpr((VarIdentifier)ident);
            varExp.setIsNewVar(false);
        } else {
            varExp = new VariableExpr(new VarIdentifier(varName));
        }
        if ("" != null) {
            return varExp;
        }
        throw new Error("Missing return statement in function");
    }

    public final ListConstructor OrderedListConstructor() throws ParseException, ParseException {
        ListConstructor expr = new ListConstructor();
        List<Expression> exprList = null;
        expr.setType(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR);
        this.jj_consume_token(97);
        exprList = this.ExpressionList();
        this.jj_consume_token(98);
        expr.setExprList(exprList);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final VariableExpr Variable() throws ParseException, ParseException {
        this.jj_consume_token(142);
        String varName = this.token.image;
        Identifier ident = this.lookupSymbol(varName);
        VariableExpr varExp = new VariableExpr(new VarIdentifier(varName));
        if (ident != null) {
            varExp.setIsNewVar(false);
        }
        if ("" != null) {
            return varExp;
        }
        throw new Error("Missing return statement in function");
    }

    public final UpdateStatement UpdateStatement() throws ParseException, ParseException {
        ArrayList<UpdateClause> ucs = new ArrayList<UpdateClause>();
        this.jj_consume_token(81);
        VariableExpr vars = this.Variable();
        this.jj_consume_token(41);
        Expression target = this.Expression();
        this.jj_consume_token(85);
        Expression condition = this.Expression();
        this.jj_consume_token(95);
        UpdateClause uc = this.UpdateClause();
        ucs.add(uc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            uc = this.UpdateClause();
            ucs.add(uc);
        }
        this.jj_consume_token(96);
        if ("" != null) {
            return new UpdateStatement(vars, target, condition, ucs);
        }
        throw new Error("Missing return statement in function");
    }

    public final UpsertStatement UpsertStatement() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Expression returnExpression = null;
        this.jj_consume_token(82);
        this.jj_consume_token(46);
        this.jj_consume_token(16);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
            }
        }
        if (var != null) {
            this.getCurrentScope().addNewVarSymbolToScope(var.getVar());
        }
        Query query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
            }
        }
        AQLPlusParser.checkBindingVariable(returnExpression, var, (ILangExpression)query);
        query.setTopLevel(true);
        if ("" != null) {
            return new UpsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordConstructor RecordConstructor() throws ParseException, ParseException {
        RecordConstructor expr = new RecordConstructor();
        FieldBinding tmp = null;
        ArrayList<FieldBinding> fbList = new ArrayList<FieldBinding>();
        this.jj_consume_token(116);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 28: 
            case 33: 
            case 35: 
            case 40: 
            case 50: 
            case 75: 
            case 86: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: 
            case 155: {
                tmp = this.FieldBinding();
                fbList.add(tmp);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[96] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(100);
                    tmp = this.FieldBinding();
                    fbList.add(tmp);
                }
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        this.jj_consume_token(117);
        expr.setFbList(fbList);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ExponentExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.UnionExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                if (op == null) {
                    op = new OperatorExpr();
                    op.addOperand(operand);
                    op.setCurrentop(true);
                }
                try {
                    op.addOperator(this.token.image);
                }
                catch (CompilationException e) {
                    throw new ParseException(e.getMessage());
                }
                operand = this.UnionExpr();
                op.addOperand(operand);
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFunctionStatement FunctionSpecification() throws ParseException, ParseException {
        boolean ifNotExists = false;
        Object var = null;
        FunctionName fctName = null;
        ArrayList<Pair> bodge = new ArrayList<Pair>();
        this.createNewScope();
        this.jj_consume_token(37);
        fctName = this.FunctionName();
        ifNotExists = this.IfNotExists();
        List<VarIdentifier> paramList = this.ParameterList();
        this.jj_consume_token(116);
        Token beginPos = this.token;
        Expression functionBodyExpr = this.FunctionBody();
        this.jj_consume_token(117);
        Token endPos = this.token;
        String functionBody = this.extractFragment(beginPos.beginLine, beginPos.beginColumn, endPos.beginLine, endPos.beginColumn);
        FunctionSignature signature = new FunctionSignature(fctName.dataverse, fctName.function, paramList.size());
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        this.removeCurrentScope();
        for (VarIdentifier v : paramList) {
            bodge.add(new Pair((Object)v, null));
        }
        if ("" != null) {
            return new CreateFunctionStatement(signature, bodge, functionBody, functionBodyExpr, ifNotExists);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<VarIdentifier> ParameterList() throws ParseException, ParseException {
        ArrayList<VarIdentifier> paramList = new ArrayList<VarIdentifier>();
        VarIdentifier var = null;
        this.jj_consume_token(95);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 142: {
                this.jj_consume_token(142);
                var = new VarIdentifier(this.token.image);
                paramList.add(var);
                this.getCurrentScope().addNewVarSymbolToScope(var);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[99] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(100);
                    this.jj_consume_token(142);
                    var = new VarIdentifier(this.token.image);
                    paramList.add(var);
                    this.getCurrentScope().addNewVarSymbolToScope(var);
                }
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
            }
        }
        this.jj_consume_token(96);
        if ("" != null) {
            return paramList;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateDataverseStatement DataverseSpecification() throws ParseException, ParseException {
        String dvName = null;
        boolean ifNotExists = false;
        String format = null;
        this.jj_consume_token(17);
        dvName = this.Identifier();
        ifNotExists = this.IfNotExists();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(34);
                format = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new CreateDataverseStatement(DataverseName.createSinglePartName((String)dvName), format, ifNotExists);
        }
        throw new Error("Missing return statement in function");
    }

    public final void Comma() throws ParseException {
        this.jj_consume_token(100);
    }

    public final IndexedTypeExpression IndexedTypeExpr() throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        boolean isUnknownable = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: 
            case 141: {
                typeExpr = this.TypeReference();
                break;
            }
            case 97: {
                typeExpr = this.OrderedListTypeDef();
                break;
            }
            case 118: {
                typeExpr = this.UnorderedListTypeDef();
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                isUnknownable = true;
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new IndexedTypeExpression((TypeExpression)typeExpr, isUnknownable);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<String, String> Property() throws ParseException, ParseException {
        String value;
        String key = this.Identifier();
        this.jj_consume_token(108);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                value = this.StringLiteral();
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                try {
                    value = "" + Long.valueOf(this.token.image);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("inapproriate value: " + this.token.image);
                }
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new Pair((Object)key.toUpperCase(), (Object)value);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<DataverseName, Identifier> TypeName() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> name = null;
        name = this.QualifiedName();
        if (name.first == null) {
            name.first = this.defaultDataverse;
        }
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression Expression() throws ParseException {
        Expression expr = null;
        Object exprP = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 131: 
            case 141: 
            case 142: 
            case 154: {
                expr = this.OperatorExpr();
                break;
            }
            case 40: {
                expr = this.IfThenElse();
                break;
            }
            case 33: 
            case 35: 
            case 50: 
            case 86: 
            case 155: {
                expr = this.FLWOGR();
                break;
            }
            case 28: 
            case 75: {
                expr = this.QuantifiedExpression();
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return exprP == null ? expr : exprP;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateIndexStatement IndexSpecification() throws ParseException, ParseException {
        CreateIndexStatement cis = new CreateIndexStatement();
        String indexName = null;
        boolean ifNotExists = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        Pair<Integer, Pair<List<String>, IndexedTypeExpression>> fieldPair = null;
        IndexParams indexType = null;
        boolean enforced = false;
        boolean isPrimaryIdx = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                indexName = this.Identifier();
                ifNotExists = this.IfNotExists();
                this.jj_consume_token(56);
                nameComponents = this.QualifiedName();
                this.jj_consume_token(95);
                fieldPair = this.OpenField();
                cis.addFieldExprPair((Pair)fieldPair.second);
                cis.addFieldIndexIndicator((Integer)fieldPair.first);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[106] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(100);
                    fieldPair = this.OpenField();
                    cis.addFieldExprPair((Pair)fieldPair.second);
                    cis.addFieldIndexIndicator((Integer)fieldPair.first);
                }
                this.jj_consume_token(96);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 79: {
                        this.jj_consume_token(79);
                        indexType = this.IndexType();
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        enforced = true;
                        break block0;
                    }
                }
                this.jj_la1[108] = this.jj_gen;
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                this.jj_consume_token(42);
                isPrimaryIdx = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 131: 
                    case 141: {
                        indexName = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                    }
                }
                ifNotExists = this.IfNotExists();
                this.jj_consume_token(56);
                nameComponents = this.QualifiedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 79: {
                        this.jj_consume_token(79);
                        this.jj_consume_token(9);
                        break block0;
                    }
                }
                this.jj_la1[110] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (isPrimaryIdx && indexName == null) {
            indexName = "primary_idx_" + nameComponents.second;
        }
        cis.setIndexName(new Identifier(indexName));
        cis.setIfNotExists(ifNotExists);
        cis.setDataverseName((DataverseName)nameComponents.first);
        cis.setDatasetName((Identifier)nameComponents.second);
        if (indexType != null) {
            cis.setIndexType(indexType.type);
            cis.setGramLength(indexType.gramLength);
        }
        cis.setEnforced(enforced);
        if ("" != null) {
            return cis;
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordTypeDefinition RecordTypeDef() throws ParseException, ParseException {
        String[] splits;
        RecordTypeDefinition recType = new RecordTypeDefinition();
        RecordTypeDefinition.RecordKind recordKind = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 57: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        recordKind = RecordTypeDefinition.RecordKind.CLOSED;
                        break block0;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        recordKind = RecordTypeDefinition.RecordKind.OPEN;
                        break block0;
                    }
                }
                this.jj_la1[112] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
            }
        }
        this.jj_consume_token(116);
        String hint = AQLPlusParser.getHint(this.token);
        if (hint != null && (splits = hint.split(" +"))[0].equals(GEN_FIELDS_HINT)) {
            if (splits.length != 5) {
                throw new ParseException("Expecting: /*+ gen-fields <type> <min> <max> <prefix>*/");
            }
            if (!splits[1].equals(INT_TYPE_NAME)) {
                throw new ParseException("The only supported type for gen-fields is int.");
            }
            UndeclaredFieldsDataGen ufdg = new UndeclaredFieldsDataGen(UndeclaredFieldsDataGen.Type.INT, Integer.parseInt(splits[2]), Integer.parseInt(splits[3]), splits[4]);
            recType.setUndeclaredFieldsDataGen(ufdg);
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: 
            case 141: {
                this.RecordField(recType);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(100);
                    this.RecordField(recType);
                }
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
            }
        }
        this.jj_consume_token(117);
        if (recordKind == null) {
            recordKind = RecordTypeDefinition.RecordKind.OPEN;
        }
        recType.setRecordKind(recordKind);
        if ("" != null) {
            return recType;
        }
        throw new Error("Missing return statement in function");
    }

    public final UnorderedListTypeDefinition UnorderedListTypeDef() throws ParseException, ParseException {
        TypeExpression type = null;
        this.jj_consume_token(118);
        type = this.TypeExpr();
        this.jj_consume_token(119);
        if ("" != null) {
            return new UnorderedListTypeDefinition(type);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression FunctionBody() throws ParseException, ParseException {
        Expression functionBodyExpr = null;
        functionBodyExpr = this.Expression();
        if ("" != null) {
            return functionBodyExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final NodegroupDecl NodegroupSpecification() throws ParseException, ParseException {
        String name = null;
        String tmp = null;
        boolean ifNotExists = false;
        ArrayList<Identifier> ncNames = null;
        this.jj_consume_token(54);
        name = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(56);
        tmp = this.Identifier();
        ncNames = new ArrayList<Identifier>();
        ncNames.add(new Identifier(tmp));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            tmp = this.Identifier();
            ncNames.add(new Identifier(tmp));
        }
        if ("" != null) {
            return new NodegroupDecl(new Identifier(name), ncNames, ifNotExists);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<List<Integer>, List<List<String>>> PrimaryKey() throws ParseException, ParseException {
        Pair<Integer, List<String>> tmp = null;
        ArrayList<Object> keyFieldSourceIndicators = new ArrayList<Object>();
        ArrayList<Object> primaryKeyFields = new ArrayList<Object>();
        this.jj_consume_token(63);
        this.jj_consume_token(47);
        tmp = this.NestedField();
        keyFieldSourceIndicators.add(tmp.first);
        primaryKeyFields.add(tmp.second);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[117] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            tmp = this.NestedField();
            keyFieldSourceIndicators.add(tmp.first);
            primaryKeyFields.add(tmp.second);
        }
        if ("" != null) {
            return new Pair(keyFieldSourceIndicators, primaryKeyFields);
        }
        throw new Error("Missing return statement in function");
    }

    public final Clause JoinClause() throws ParseException, ParseException {
        JoinClause.JoinKind kind = JoinClause.JoinKind.INNER;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                kind = JoinClause.JoinKind.LEFT_OUTER;
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(95);
        this.jj_consume_token(95);
        List<Clause> leftClauses = this.Clauses();
        this.jj_consume_token(96);
        this.jj_consume_token(100);
        this.jj_consume_token(95);
        List<Clause> rightClauses = this.Clauses();
        this.jj_consume_token(96);
        this.jj_consume_token(100);
        Expression whereExpr = this.Expression();
        this.jj_consume_token(96);
        JoinClause jc = new JoinClause(kind);
        jc.setLeftClauses(leftClauses);
        jc.setRightClauses(rightClauses);
        jc.setWhereExpr(whereExpr);
        if ("" != null) {
            return jc;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression TypeExpr() throws ParseException, ParseException {
        RecordTypeDefinition typeExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 57: 
            case 116: {
                typeExpr = this.RecordTypeDef();
                break;
            }
            case 131: 
            case 141: {
                typeExpr = this.TypeReference();
                break;
            }
            case 97: {
                typeExpr = this.OrderedListTypeDef();
                break;
            }
            case 118: {
                typeExpr = this.UnorderedListTypeDef();
                break;
            }
            default: {
                this.jj_la1[119] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return typeExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Map<String, String> Configuration() throws ParseException, ParseException {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        Pair<String, String> keyValuePair = null;
        this.jj_consume_token(95);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95: {
                keyValuePair = this.KeyValuePair();
                configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[120] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(100);
                    keyValuePair = this.KeyValuePair();
                    configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                }
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
            }
        }
        this.jj_consume_token(96);
        if ("" != null) {
            return configuration;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(115);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(118);
    }

    private boolean jj_3_4() {
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(131);
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(127);
    }

    private boolean jj_3R_33() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_69() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_62() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_61() {
        return this.jj_3R_42();
    }

    private boolean jj_3_3() {
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_62()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_63()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_64()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_65()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_66()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_67()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_68()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(104)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(105)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(106)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(107)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(108)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(109)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(110)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_30();
    }

    private boolean jj_3R_29() {
        if (this.jj_3R_32()) {
            return true;
        }
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_30() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_36() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_71() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_41() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(116);
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_38() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(141);
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_38()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_53() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3R_52() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_70() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_51() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_50() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_49() {
        return this.jj_3R_56();
    }

    private boolean jj_3R_48() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_47() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_68() {
        return this.jj_scan_token(124);
    }

    private boolean jj_3_1() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_47()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_48()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_49()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_50()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_51()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_52()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_53()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(123);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0x10010000, 512, 0x100000C, 0, 0, 0, 32, 0, 0, 0, 0x10010000, 0x100000C, 0, 0, 0, 0, 0, 0, 312856576, 2, 2, 0, 0x100000C, 0, 0, 0, 0, 312856576, 0, 65536, 0, 0, 0x4000000, 0x200000, 0, 128, 0, 0x400040, 0x400040, 0, 0x400040, 0x400040, 0, 0, 0, 0, 0, 0, 0, 0x10010000, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2147287040, -1073545216, 0x10000000, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0x40010000, 0, 0, 16, 0, 0x804000, 0x100000, 0x100000, 0, 0, 32, 0, 0, 0x10010000, 0, 0, 0, 0, 0, 0, 0, 0x10010000, 0, 0, 0x8000000, 0, 0, 0, 2048, 2048, 0, 0, 0, 0, 12, 2048, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x800000, 0, 0, 0, 256, 262410, 0x210010, 67895370, 0, 0, 0, 0, 0, 0, 0, 262410, 67895370, 0, 0, 0, 0, 0, 0, 1315082, 0, 0, 262154, 67895370, 0, 0, 0, 0, 1315082, 262144, 0, 0, 0, 0, 4352, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262410, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 256, 0, 0x40000000, 0, 0, 0, 0, 4197408, -2143278048, 0, 0, 0x1000000, 128, 0, 8192, 0, 0, 0x1000000, 128, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0x30000000, 0, 0, 0, 0, 262410, 0, 0, 0, 0, 0, 0, 0, 262410, 0, 0, 0, 0, 0, -2147482624, 0x2000000, 0x2000000, 0, 0, 0, 0, 0, 0x2000000, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0x100000, 0, -935327744, 8, 0x600000, 0x36000000, 0x10000000, 0x36000000, 0, 4, 0, 0, -935327744, 0x600000, Integer.MIN_VALUE, 0, 0, 0, 0x48000000, 0x48000000, -926019839, 0, 0, 0x400000, 0x600000, 130, 0, 0, 0, -926019839, 0x400000, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 131328, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, -935327744, 0, 0x200000, 0, Integer.MIN_VALUE, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0x48000000, 0x48000000, 0, 0, 32768, 32768, 2048, 0, 0, 0, 0x400000, 0, 0x400000, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0x100000, 1536, 0, 0, 0, 0, 0, 4, 0, -935327744, 0x1000000, 0, 0, 0x400000, 0, 0, 0, -935327744, 0, 32768, 0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 8, 65536, 0, 0, -548405118, 0, 0, 64, 64, 64, 0, 0, 16, 16, -548405246, 0, 0, 32, -553648128, 131072, 0, 0, -548405246, 0, 0, 0, 0, 0, 32, 16, 0, -548405246, 0, -548405246, 32, 0, 0, 0, 0, 0, 32, 0, 0, 16, 0, 0, 128, 0, 32512, 524288, 524320, 524320, 16, -548405246, 16, 0, 16, 0, 16, 16, 0, 0, 16, 0, 0x400002, 0, 0, 0, 34, 34, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x18000000, 0x18000000, 0, 0, 0, 0, 0, 0, 16, 0, 0, 16, -548405246, 0, 16, 0, 0, 0x400002, 128, 0x1000000, -548405246, 16, 0, 0, 0, 0, 0, 0, 0, 16, 0, 16, 16, 0, 0x500002, 16, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 201351176, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 201351176, 0x8000000, 0, 0, 8, 0, 0, 0, 201351176, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 8200, 201351176, 0, 0x4004008, 0, 8200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201351176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201351176, 0, 0, 16384, 0, 8200, 0, 8, 201351176, 0, 0, 0, 8200, 0, 0, 0, 0, 0, 8200, 0, 0, 0, 8200, 0, 0};
    }

    public AQLPlusParser(InputStream stream) {
        this(stream, null);
    }

    public AQLPlusParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new AQLPlusParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public AQLPlusParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new AQLPlusParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new AQLPlusParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public AQLPlusParser(AQLPlusParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(AQLPlusParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 122; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[156];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 122; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 156; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 5; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        AQLPlusParser.jj_la1_init_0();
        AQLPlusParser.jj_la1_init_1();
        AQLPlusParser.jj_la1_init_2();
        AQLPlusParser.jj_la1_init_3();
        AQLPlusParser.jj_la1_init_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    @FunctionalInterface
    private static interface ParseFunction<T> {
        public T parse() throws ParseException;
    }

    private static class FunctionName {
        public DataverseName dataverse = null;
        public String library = null;
        public String function = null;
        public String hint = null;

        private FunctionName() {
        }
    }

    private static class IndexParams {
        public DatasetConfig.IndexType type;
        public int gramLength;

        public IndexParams(DatasetConfig.IndexType type, int gramLength) {
            this.type = type;
            this.gramLength = gramLength;
        }
    }
}

