/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppContainsExpressionVisitor;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Function;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public final class CheckNonFunctionalExpressionVisitor
extends AbstractSqlppContainsExpressionVisitor<Void> {
    private final MetadataProvider metadataProvider;

    public CheckNonFunctionalExpressionVisitor(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Boolean visit(CallExpr callExpr, Void arg) throws CompilationException {
        FunctionSignature fs = callExpr.getFunctionSignature();
        IFunctionInfo fi = FunctionUtil.getBuiltinFunctionInfo((String)fs.getName(), (int)fs.getArity());
        if (fi != null) {
            if (!fi.isFunctional()) {
                return true;
            }
        } else {
            try {
                Function function = FunctionUtil.lookupUserDefinedFunctionDecl((MetadataTransactionContext)this.metadataProvider.getMetadataTxnContext(), (FunctionSignature)fs);
                if (function != null && function.getDeterministic() != null && !function.getDeterministic().booleanValue()) {
                    return true;
                }
            }
            catch (AlgebricksException e) {
                throw new CompilationException(1070, (Throwable)e, callExpr.getSourceLocation(), new Serializable[0]);
            }
        }
        return super.visit(callExpr, (Object)arg);
    }
}

