/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.FunctionParser;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.GatherFunctionCallsVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppFunctionBodyRewriterFactory;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.GenerateColumnNameVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineColumnAliasVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineWithExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.OperatorExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppBuiltinFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppCaseRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupingSetsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppInlineUdfsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppListInputFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SubstituteGroupbyExpressionWithVariableVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.VariableCheckAndRewriteVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppAstPrintUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlppQueryRewriter
implements IQueryRewriter {
    private static final Logger LOGGER = LogManager.getLogger(SqlppQueryRewriter.class);
    public static final String INLINE_WITH_OPTION = "inline_with";
    private static final boolean INLINE_WITH_OPTION_DEFAULT = true;
    private final IParserFactory parserFactory;
    private final FunctionParser functionParser;
    private IReturningStatement topExpr;
    private List<FunctionDecl> declaredFunctions;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;
    private Collection<VarIdentifier> externalVars;
    private boolean isLogEnabled;

    public SqlppQueryRewriter(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
        this.functionParser = new FunctionParser(parserFactory);
    }

    protected void setup(List<FunctionDecl> declaredFunctions, IReturningStatement topExpr, MetadataProvider metadataProvider, LangRewritingContext context, Collection<VarIdentifier> externalVars) throws CompilationException {
        this.topExpr = topExpr;
        this.context = context;
        this.declaredFunctions = declaredFunctions;
        this.metadataProvider = metadataProvider;
        this.externalVars = externalVars;
        this.isLogEnabled = LOGGER.isTraceEnabled();
        this.logExpression("Starting AST rewrites on", "");
    }

    public void rewrite(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context, boolean inlineUdfs, Collection<VarIdentifier> externalVars) throws CompilationException {
        if (topStatement == null) {
            return;
        }
        this.setup(declaredFunctions, topStatement, metadataProvider, context, externalVars);
        this.generateColumnNames();
        this.substituteGroupbyKeyExpression();
        this.rewriteGroupBys();
        this.rewriteSetOperations();
        this.inlineColumnAlias();
        this.rewriteWindowExpressions();
        this.rewriteGroupingSets();
        this.variableCheckAndRewrite();
        this.rewriteCaseExpressions();
        this.rewriteGroupByAggregationSugar();
        this.rewriteWindowAggregationSugar();
        this.rewriteOperatorExpression();
        this.rewriteListInputFunctions();
        this.inlineDeclaredUdfs(inlineUdfs);
        this.rewriteFunctionNames();
        this.inlineWithExpressions();
        topStatement.setVarCounter(context.getVarCounter().get());
    }

    protected void rewriteGroupByAggregationSugar() throws CompilationException {
        SqlppGroupByAggregationSugarVisitor visitor = new SqlppGroupByAggregationSugarVisitor(this.context);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteListInputFunctions() throws CompilationException {
        SqlppListInputFunctionRewriteVisitor listInputFunctionVisitor = new SqlppListInputFunctionRewriteVisitor();
        this.rewriteTopExpr(listInputFunctionVisitor, null);
    }

    protected void rewriteFunctionNames() throws CompilationException {
        SqlppBuiltinFunctionRewriteVisitor functionNameMapVisitor = new SqlppBuiltinFunctionRewriteVisitor();
        this.rewriteTopExpr(functionNameMapVisitor, null);
    }

    protected void inlineWithExpressions() throws CompilationException {
        if (!this.metadataProvider.getBooleanProperty(INLINE_WITH_OPTION, true)) {
            return;
        }
        InlineWithExpressionVisitor inlineWithExpressionVisitor = new InlineWithExpressionVisitor(this.context, this.metadataProvider);
        this.rewriteTopExpr(inlineWithExpressionVisitor, null);
    }

    protected void generateColumnNames() throws CompilationException {
        GenerateColumnNameVisitor generateColumnNameVisitor = new GenerateColumnNameVisitor(this.context);
        this.rewriteTopExpr(generateColumnNameVisitor, null);
    }

    protected void substituteGroupbyKeyExpression() throws CompilationException {
        SubstituteGroupbyExpressionWithVariableVisitor substituteGbyExprVisitor = new SubstituteGroupbyExpressionWithVariableVisitor(this.context);
        this.rewriteTopExpr(substituteGbyExprVisitor, null);
    }

    protected void rewriteSetOperations() throws CompilationException {
        SetOperationVisitor setOperationVisitor = new SetOperationVisitor(this.context);
        this.rewriteTopExpr(setOperationVisitor, null);
    }

    protected void rewriteOperatorExpression() throws CompilationException {
        OperatorExpressionVisitor operatorExpressionVisitor = new OperatorExpressionVisitor(this.context);
        this.rewriteTopExpr(operatorExpressionVisitor, null);
    }

    protected void inlineColumnAlias() throws CompilationException {
        InlineColumnAliasVisitor inlineColumnAliasVisitor = new InlineColumnAliasVisitor(this.context);
        this.rewriteTopExpr(inlineColumnAliasVisitor, null);
    }

    protected void variableCheckAndRewrite() throws CompilationException {
        VariableCheckAndRewriteVisitor variableCheckAndRewriteVisitor = new VariableCheckAndRewriteVisitor(this.context, this.metadataProvider, this.externalVars);
        this.rewriteTopExpr(variableCheckAndRewriteVisitor, null);
    }

    protected void rewriteGroupBys() throws CompilationException {
        SqlppGroupByVisitor groupByVisitor = new SqlppGroupByVisitor(this.context);
        this.rewriteTopExpr(groupByVisitor, null);
    }

    protected void rewriteGroupingSets() throws CompilationException {
        SqlppGroupingSetsVisitor groupingSetsVisitor = new SqlppGroupingSetsVisitor(this.context);
        this.rewriteTopExpr(groupingSetsVisitor, null);
    }

    protected void rewriteWindowExpressions() throws CompilationException {
        SqlppWindowRewriteVisitor windowVisitor = new SqlppWindowRewriteVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void rewriteWindowAggregationSugar() throws CompilationException {
        SqlppWindowAggregationSugarVisitor windowVisitor = new SqlppWindowAggregationSugarVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void rewriteCaseExpressions() throws CompilationException {
        SqlppCaseRewriteVisitor visitor = new SqlppCaseRewriteVisitor(this.context);
        this.rewriteTopExpr(visitor, null);
    }

    protected void inlineDeclaredUdfs(boolean inlineUdfs) throws CompilationException {
        ArrayList<FunctionSignature> funIds = new ArrayList<FunctionSignature>();
        for (FunctionDecl functionDecl : this.declaredFunctions) {
            funIds.add(functionDecl.getSignature());
        }
        ArrayList usedStoredFunctionDecls = new ArrayList();
        for (Expression topLevelExpr : this.topExpr.getDirectlyEnclosedExpressions()) {
            usedStoredFunctionDecls.addAll(FunctionUtil.retrieveUsedStoredFunctions((MetadataProvider)this.metadataProvider, (Expression)topLevelExpr, funIds, null, expr -> this.getFunctionCalls(expr), (FunctionParser)this.functionParser, (signature, sourceLoc) -> FunctionMapUtil.normalizeBuiltinFunctionSignature(signature, false, sourceLoc)));
        }
        this.declaredFunctions.addAll(usedStoredFunctionDecls);
        if (inlineUdfs && !this.declaredFunctions.isEmpty()) {
            SqlppInlineUdfsVisitor sqlppInlineUdfsVisitor = new SqlppInlineUdfsVisitor(this.context, new SqlppFunctionBodyRewriterFactory(this.parserFactory), this.declaredFunctions, this.metadataProvider);
            while (this.rewriteTopExpr(sqlppInlineUdfsVisitor, this.declaredFunctions).booleanValue()) {
            }
        }
        this.declaredFunctions.removeAll(usedStoredFunctionDecls);
    }

    private <R, T> R rewriteTopExpr(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        Object result = this.topExpr.accept(visitor, arg);
        this.logExpression(">>>> AST After", visitor.getClass().getSimpleName());
        return (R)result;
    }

    private void logExpression(String p0, String p1) throws CompilationException {
        if (this.isLogEnabled) {
            LOGGER.trace("{} {}\n{}", (Object)p0, (Object)p1, (Object)LogRedactionUtil.userData((String)SqlppAstPrintUtil.toString((ILangExpression)this.topExpr)));
        }
    }

    public Set<CallExpr> getFunctionCalls(Expression expression) throws CompilationException {
        GatherFunctionCalls gfc = new GatherFunctionCalls();
        expression.accept((ILangVisitor)gfc, null);
        return gfc.getCalls();
    }

    public Set<VariableExpr> getExternalVariables(Expression expr) throws CompilationException {
        Set<VariableExpr> freeVars = SqlppVariableUtil.getFreeVariables((ILangExpression)expr);
        HashSet<VariableExpr> extVars = new HashSet<VariableExpr>();
        for (VariableExpr ve : freeVars) {
            if (!SqlppVariableUtil.isExternalVariableReference(ve)) continue;
            extVars.add(ve);
        }
        return extVars;
    }

    private static class GatherFunctionCalls
    extends GatherFunctionCallsVisitor
    implements ISqlppVisitor<Void, Void> {
        @Override
        public Void visit(FromClause fromClause, Void arg) throws CompilationException {
            for (FromTerm fromTerm : fromClause.getFromTerms()) {
                fromTerm.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(FromTerm fromTerm, Void arg) throws CompilationException {
            fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)arg);
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                correlateClause.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(JoinClause joinClause, Void arg) throws CompilationException {
            joinClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(NestClause nestClause, Void arg) throws CompilationException {
            nestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(Projection projection, Void arg) throws CompilationException {
            if (!projection.star()) {
                projection.getExpression().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectBlock selectBlock, Void arg) throws CompilationException {
            if (selectBlock.hasFromClause()) {
                selectBlock.getFromClause().accept(this, arg);
            }
            if (selectBlock.hasLetWhereClauses()) {
                for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                    letWhereClause.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (selectBlock.hasGroupbyClause()) {
                selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg);
            }
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                    letHavingClause.accept((ILangVisitor)this, (Object)arg);
                }
            }
            selectBlock.getSelectClause().accept(this, arg);
            return null;
        }

        @Override
        public Void visit(SelectClause selectClause, Void arg) throws CompilationException {
            if (selectClause.selectElement()) {
                selectClause.getSelectElement().accept(this, arg);
            } else {
                selectClause.getSelectRegular().accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectElement selectElement, Void arg) throws CompilationException {
            selectElement.getExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(SelectRegular selectRegular, Void arg) throws CompilationException {
            for (Projection projection : selectRegular.getProjections()) {
                projection.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectSetOperation selectSetOperation, Void arg) throws CompilationException {
            selectSetOperation.getLeftInput().accept(this, arg);
            for (SetOperationRight setOperationRight : selectSetOperation.getRightInputs()) {
                setOperationRight.getSetOperationRightInput().accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectExpression selectStatement, Void arg) throws CompilationException {
            selectStatement.getSelectSetOperation().accept(this, arg);
            if (selectStatement.hasOrderby()) {
                selectStatement.getOrderbyClause().accept((ILangVisitor)this, (Object)arg);
            }
            if (selectStatement.hasLimit()) {
                selectStatement.getLimitClause().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(UnnestClause unnestClause, Void arg) throws CompilationException {
            unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(HavingClause havingClause, Void arg) throws CompilationException {
            havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(CaseExpression caseExpression, Void arg) throws CompilationException {
            caseExpression.getConditionExpr().accept((ILangVisitor)this, (Object)arg);
            for (Expression expr : caseExpression.getWhenExprs()) {
                expr.accept((ILangVisitor)this, (Object)arg);
            }
            for (Expression expr : caseExpression.getThenExprs()) {
                expr.accept((ILangVisitor)this, (Object)arg);
            }
            caseExpression.getElseExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(WindowExpression winExpr, Void arg) throws CompilationException {
            if (winExpr.hasPartitionList()) {
                for (Expression expression : winExpr.getPartitionList()) {
                    expression.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (winExpr.hasOrderByList()) {
                for (Expression expression : winExpr.getOrderbyList()) {
                    expression.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (winExpr.hasFrameStartExpr()) {
                winExpr.getFrameStartExpr().accept((ILangVisitor)this, (Object)arg);
            }
            if (winExpr.hasFrameEndExpr()) {
                winExpr.getFrameEndExpr().accept((ILangVisitor)this, (Object)arg);
            }
            if (winExpr.hasWindowFieldList()) {
                for (Pair pair : winExpr.getWindowFieldList()) {
                    ((Expression)pair.first).accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (winExpr.hasAggregateFilterExpr()) {
                winExpr.getAggregateFilterExpr().accept((ILangVisitor)this, (Object)arg);
            }
            for (Expression expression : winExpr.getExprList()) {
                expression.accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        public Void visit(ListSliceExpression expression, Void arg) throws CompilationException {
            expression.getExpr().accept((ILangVisitor)this, (Object)arg);
            expression.getStartIndexExpression().accept((ILangVisitor)this, (Object)arg);
            if (expression.hasEndExpression()) {
                expression.getEndIndexExpression().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }
    }
}

