/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.AutoDataGen;
import org.apache.asterix.common.annotations.DateBetweenYearsDataGen;
import org.apache.asterix.common.annotations.DatetimeAddRandHoursDataGen;
import org.apache.asterix.common.annotations.DatetimeBetweenYearsDataGen;
import org.apache.asterix.common.annotations.FieldIntervalDataGen;
import org.apache.asterix.common.annotations.FieldValFileDataGen;
import org.apache.asterix.common.annotations.FieldValFileSameIndexDataGen;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.InsertRandIntDataGen;
import org.apache.asterix.common.annotations.ListDataGen;
import org.apache.asterix.common.annotations.ListValFileDataGen;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.WarningCollector;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.AbstractLangExpression;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.AbstractAccessor;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.RefreshExternalDatasetStatement;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.SynonymDropStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.RangeMapBuilder;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.parser.JavaCharStream;
import org.apache.asterix.lang.sqlpp.parser.ParseException;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserConstants;
import org.apache.asterix.lang.sqlpp.parser.SQLPPParserTokenManager;
import org.apache.asterix.lang.sqlpp.parser.SqlppGroupingSetsParser;
import org.apache.asterix.lang.sqlpp.parser.SqlppHint;
import org.apache.asterix.lang.sqlpp.parser.SqlppParseException;
import org.apache.asterix.lang.sqlpp.parser.Token;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.ExpressionToVariableUtil;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.StringUtil;

class SQLPPParser
extends ScopeChecker
implements IParser,
SQLPPParserConstants {
    private static final String CUBE = "CUBE";
    private static final String CURRENT = "CURRENT";
    private static final String EXCLUDE = "EXCLUDE";
    private static final String FIRST = "FIRST";
    private static final String FOLLOWING = "FOLLOWING";
    private static final String GROUPING = "GROUPING";
    private static final String GROUPS = "GROUPS";
    private static final String IGNORE = "IGNORE";
    private static final String LAST = "LAST";
    private static final String NO = "NO";
    private static final String NULLS = "NULLS";
    private static final String OTHERS = "OTHERS";
    private static final String PARTITION = "PARTITION";
    private static final String PRECEDING = "PRECEDING";
    private static final String RANGE = "RANGE";
    private static final String RESPECT = "RESPECT";
    private static final String ROLLUP = "ROLLUP";
    private static final String ROW = "ROW";
    private static final String ROWS = "ROWS";
    private static final String SETS = "SETS";
    private static final String TIES = "TIES";
    private static final String UNBOUNDED = "UNBOUNDED";
    private static final String ACTION = "ACTION";
    private static final String LANGUAGE = "LANGUAGE";
    private static final String CALL = "CALL";
    private static final String DETERMINISTIC = "DETERMINISTIC";
    private static final String RETURNS = "RETURNS";
    private static final String INLINE = "INLINE";
    private static final String INT_TYPE_NAME = "int";
    protected static final boolean REPORT_EXPECTED_TOKENS = false;
    private int externalVarCounter;
    private DataverseName defaultDataverse;
    private SqlppGroupingSetsParser groupingSetsParser;
    private final WarningCollector warningCollector = new WarningCollector();
    private final Map<SourceLocation, String> hintCollector = new HashMap<SourceLocation, String>();
    public SQLPPParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[208];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[19];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private IRecordFieldDataGen parseFieldDataGen(Token hintToken) throws ParseException {
        String[] splits = hintToken.hintParams != null ? hintToken.hintParams.split("\\s+") : null;
        switch (hintToken.hint) {
            case VAL_FILE_HINT: {
                File[] valFiles = new File[splits.length];
                for (int k = 0; k < splits.length; ++k) {
                    valFiles[k] = new File(splits[k]);
                }
                return new FieldValFileDataGen(valFiles);
            }
            case VAL_FILE_SAME_INDEX_HINT: {
                return new FieldValFileSameIndexDataGen(new File(splits[0]), splits[1]);
            }
            case LIST_VAL_FILE_HINT: {
                return new ListValFileDataGen(new File(splits[0]), Integer.parseInt(splits[1]), Integer.parseInt(splits[2]));
            }
            case LIST_HINT: {
                return new ListDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case INTERVAL_HINT: {
                FieldIntervalDataGen.ValueType vt;
                switch (splits[0]) {
                    case "int": {
                        vt = FieldIntervalDataGen.ValueType.INT;
                        break;
                    }
                    case "long": {
                        vt = FieldIntervalDataGen.ValueType.LONG;
                        break;
                    }
                    case "float": {
                        vt = FieldIntervalDataGen.ValueType.FLOAT;
                        break;
                    }
                    case "double": {
                        vt = FieldIntervalDataGen.ValueType.DOUBLE;
                        break;
                    }
                    default: {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Unknown type for interval data gen: " + splits[0]);
                    }
                }
                return new FieldIntervalDataGen(vt, splits[1], splits[2]);
            }
            case INSERT_RAND_INT_HINT: {
                return new InsertRandIntDataGen(splits[0], splits[1]);
            }
            case DATE_BETWEEN_YEARS_HINT: {
                return new DateBetweenYearsDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case DATETIME_BETWEEN_YEARS_HINT: {
                return new DatetimeBetweenYearsDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]));
            }
            case DATETIME_ADD_RAND_HOURS_HINT: {
                return new DatetimeAddRandHoursDataGen(Integer.parseInt(splits[0]), Integer.parseInt(splits[1]), splits[2]);
            }
            case AUTO_HINT: {
                return new AutoDataGen(splits[0]);
            }
        }
        return null;
    }

    public SQLPPParser(String s) {
        this(new StringReader(s));
        super.setInput(s);
        this.token_source.hintCollector = this.hintCollector;
    }

    public static void main(String[] args) throws ParseException, TokenMgrError, IOException, FileNotFoundException, CompilationException {
        File file = new File(args[0]);
        BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        SQLPPParser parser = new SQLPPParser(fis);
        List<Statement> st = parser.parse();
    }

    public List<Statement> parse() throws CompilationException {
        return this.parseImpl(new ParseFunction<List<Statement>>(){

            @Override
            public List<Statement> parse() throws ParseException {
                return SQLPPParser.this.Statement();
            }
        });
    }

    private Expression parseExpression() throws CompilationException {
        return this.parseImpl(new ParseFunction<Expression>(){

            @Override
            public Expression parse() throws ParseException {
                return SQLPPParser.this.Expression();
            }
        });
    }

    private static Expression parseExpression(String text) throws CompilationException {
        return new SQLPPParser(text).parseExpression();
    }

    public FunctionDecl parseFunctionBody(final FunctionSignature signature, final List<String> paramNames) throws CompilationException {
        return this.parseImpl(new ParseFunction<FunctionDecl>(){

            @Override
            public FunctionDecl parse() throws ParseException {
                DataverseName dataverse = SQLPPParser.this.defaultDataverse;
                SQLPPParser.this.defaultDataverse = signature.getDataverseName();
                SQLPPParser.this.createNewScope();
                ArrayList<VarIdentifier> paramVars = new ArrayList<VarIdentifier>(paramNames.size());
                for (String paramName : paramNames) {
                    paramVars.add(SqlppVariableUtil.toInternalVariableIdentifier(paramName));
                }
                Expression functionBodyExpr = SQLPPParser.this.FunctionBody();
                SQLPPParser.this.removeCurrentScope();
                SQLPPParser.this.defaultDataverse = dataverse;
                return new FunctionDecl(signature, paramVars, functionBodyExpr);
            }
        });
    }

    private <T> T parseImpl(ParseFunction<T> parseFunction) throws CompilationException {
        this.warningCollector.clear();
        this.hintCollector.clear();
        try {
            T t = parseFunction.parse();
            return t;
        }
        catch (SqlppParseException e) {
            throw new CompilationException(1001, e.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)this.getMessage(e))});
        }
        catch (ParseException e) {
            throw new CompilationException(1001, new Serializable[]{LogRedactionUtil.userData((String)this.getMessage(e))});
        }
        catch (Error e) {
            String msg = e.getClass().getSimpleName() + (e.getMessage() != null ? ": " + e.getMessage() : "");
            throw new CompilationException(1001, new Serializable[]{LogRedactionUtil.userData((String)msg)});
        }
        finally {
            this.reportUnclaimedHints();
        }
    }

    public void getWarnings(Collection<? super Warning> outWarnings, long maxWarnings) {
        this.warningCollector.getWarnings(outWarnings, maxWarnings);
    }

    public long getTotalWarningsCount() {
        return this.warningCollector.getTotalWarningsCount();
    }

    protected String getMessage(ParseException pe) {
        Token currentToken = pe.currentToken;
        if (currentToken == null) {
            return pe.getMessage();
        }
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String sep = " ";
        StringBuilder expected = null;
        int maxSize = this.appendExpected(expected, expectedTokenSequences, tokenImage);
        Token tok = currentToken.next;
        int line = tok.beginLine;
        StringBuilder message = new StringBuilder(128);
        message.append("In line ").append(line).append(" >>").append(this.getLine(line)).append("<<").append(sep).append("Encountered ");
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                message.append(' ');
            }
            if (tok.kind == 0) {
                message.append(SQLPPParser.fixQuotes((String)tokenImage[0]));
                break;
            }
            String fixedTokenImage = tokenImage[tok.kind];
            if (!tok.image.equalsIgnoreCase(SQLPPParser.stripQuotes((String)fixedTokenImage))) {
                message.append(SQLPPParser.fixQuotes((String)fixedTokenImage)).append(' ');
            }
            message.append(quot).append(SQLPPParser.addEscapes((String)tok.image)).append(quot);
            tok = tok.next;
        }
        message.append(" at column ").append(currentToken.next.beginColumn).append('.').append(sep);
        return message.toString();
    }

    protected static SourceLocation getSourceLocation(Token token) {
        return token == null ? null : (token.sourceLocation != null ? token.sourceLocation : new SourceLocation(token.beginLine, token.beginColumn));
    }

    protected static <T extends AbstractLangExpression> T addSourceLocation(T expr, Token token) {
        expr.setSourceLocation(SQLPPParser.getSourceLocation(token));
        return expr;
    }

    private boolean isToken(String image) {
        return this.token.image.equalsIgnoreCase(image);
    }

    private void expectToken(String image) throws SqlppParseException {
        if (!this.isToken(image)) {
            throw this.createUnexpectedTokenError();
        }
    }

    private SqlppParseException createUnexpectedTokenError() {
        return this.createUnexpectedTokenError(this.token, null);
    }

    private SqlppParseException createUnexpectedTokenError(Token t) {
        return this.createUnexpectedTokenError(t, null);
    }

    private SqlppParseException createUnexpectedTokenError(String expected) {
        return this.createUnexpectedTokenError(this.token, expected);
    }

    private SqlppParseException createUnexpectedTokenError(Token t, String expected) {
        String message = "Unexpected token: " + LogRedactionUtil.userData((String)t.image) + (expected == null ? "" : ". Expected: " + LogRedactionUtil.userData((String)expected));
        return new SqlppParseException(SQLPPParser.getSourceLocation(t), message);
    }

    private boolean laToken(int idx, int kind) {
        Token t = this.getToken(idx);
        return t.kind == kind;
    }

    private boolean laToken(int idx, int kind, String image) {
        Token t = this.getToken(idx);
        return t.kind == kind && t.image.equalsIgnoreCase(image);
    }

    private boolean laIdentifier(int idx, String image) {
        return this.laToken(idx, 172, image);
    }

    private boolean laIdentifier(String image) {
        return this.laIdentifier(1, image);
    }

    private Token fetchHint(Token token, SqlppHint ... expectedHints) {
        Token hintToken = token.specialToken;
        if (hintToken == null) {
            return null;
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(hintToken);
        this.hintCollector.remove(sourceLoc);
        if (hintToken.hint == null) {
            this.warnUnexpectedHint(hintToken.hintParams, sourceLoc, expectedHints);
            return null;
        }
        if (!ArrayUtils.contains((Object[])expectedHints, (Object)((Object)hintToken.hint))) {
            this.warnUnexpectedHint(hintToken.hint.getIdentifier(), sourceLoc, expectedHints);
            return null;
        }
        return hintToken;
    }

    private void reportUnclaimedHints() {
        for (Map.Entry<SourceLocation, String> me : this.hintCollector.entrySet()) {
            this.warnUnexpectedHint(me.getValue(), me.getKey(), "None");
        }
    }

    private void warnUnexpectedHint(String actualHint, SourceLocation sourceLoc, SqlppHint ... expectedHints) {
        this.warnUnexpectedHint(actualHint, sourceLoc, StringUtil.join((Object[])expectedHints, (String)", ", (String)"\""));
    }

    private void warnUnexpectedHint(String actualHint, SourceLocation sourceLoc, String expectedHints) {
        if (this.warningCollector.shouldWarn()) {
            this.warningCollector.warn(WarningUtil.forAsterix((SourceLocation)sourceLoc, (int)1107, (Serializable[])new Serializable[]{actualHint, expectedHints}));
        }
    }

    private void ensureNoTypeDeclsInFunction(String fnName, List<Pair<VarIdentifier, TypeExpression>> paramList, TypeExpression returnType, Token startToken) throws SqlppParseException {
        for (Pair<VarIdentifier, TypeExpression> p : paramList) {
            if (p.second == null) continue;
            String paramName = SqlppVariableUtil.toUserDefinedName(((VarIdentifier)p.first).getValue());
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startToken), "Unexpected type declaration for parameter " + paramName + " in function " + fnName);
        }
        if (returnType != null) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startToken), "Unexpected return type declaration for function " + fnName);
        }
    }

    public final List<Statement> Statement() throws ParseException, ParseException {
        this.scopeStack.push(RootScopeFactory.createRootScope((ScopeChecker)this));
        ArrayList<Statement> decls = new ArrayList<Statement>();
        Statement stmt = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 23: 
                case 25: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 38: 
                case 44: 
                case 57: 
                case 66: 
                case 67: 
                case 70: 
                case 74: 
                case 88: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 108: 
                case 109: 
                case 110: 
                case 116: 
                case 117: 
                case 121: 
                case 123: 
                case 124: 
                case 126: 
                case 131: 
                case 134: 
                case 135: 
                case 145: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 156: 
                case 161: 
                case 162: 
                case 172: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 23: 
                case 25: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 38: 
                case 44: 
                case 57: 
                case 66: 
                case 67: 
                case 70: 
                case 74: 
                case 88: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 108: 
                case 109: 
                case 110: 
                case 116: 
                case 117: 
                case 121: 
                case 123: 
                case 124: 
                case 126: 
                case 131: 
                case 134: 
                case 145: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 156: 
                case 161: 
                case 162: 
                case 172: {
                    stmt = this.ExplainStatement();
                    decls.add(stmt);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            block10: while (true) {
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 135: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
        }
        this.jj_consume_token(0);
        if ("" != null) {
            return decls;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement ExplainStatement() throws ParseException, ParseException {
        Statement stmt = null;
        Token explainToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                explainToken = this.token;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        stmt = this.SingleStatement();
        if (explainToken != null) {
            if (stmt.getKind() == Statement.Kind.QUERY) {
                ((Query)stmt).setExplain(true);
            } else {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(explainToken), "EXPLAIN is not supported for this kind of statement");
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SingleStatement() throws ParseException, ParseException {
        DataverseDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                stmt = this.DataverseDeclaration();
                break;
            }
            case 23: {
                stmt = this.FunctionDeclaration();
                break;
            }
            case 15: {
                stmt = this.CreateStatement();
                break;
            }
            case 70: {
                stmt = this.LoadStatement();
                break;
            }
            case 30: {
                stmt = this.DropStatement();
                break;
            }
            case 117: {
                stmt = this.WriteStatement();
                break;
            }
            case 96: {
                stmt = this.SetStatement();
                break;
            }
            case 57: {
                stmt = this.InsertStatement();
                break;
            }
            case 25: {
                stmt = this.DeleteStatement();
                break;
            }
            case 108: {
                stmt = this.UpdateStatement();
                break;
            }
            case 109: {
                stmt = this.UpsertStatement();
                break;
            }
            case 18: 
            case 27: 
            case 98: 
            case 99: {
                stmt = this.ConnectionStatement();
                break;
            }
            case 17: {
                stmt = this.CompactStatement();
                break;
            }
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 44: 
            case 66: 
            case 67: 
            case 74: 
            case 95: 
            case 97: 
            case 116: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                stmt = this.Query();
                break;
            }
            case 88: {
                stmt = this.RefreshExternalDatasetStatement();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final DataverseDecl DataverseDeclaration() throws ParseException, ParseException {
        Token startToken = null;
        List<String> dvName = null;
        this.jj_consume_token(110);
        startToken = this.token;
        dvName = this.MultipartIdentifier();
        this.defaultDataverse = DataverseName.create(dvName);
        DataverseDecl dvDecl = new DataverseDecl(this.defaultDataverse);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(dvDecl, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement CreateStatement() throws ParseException, ParseException {
        Token startToken = null;
        TypeDecl stmt = null;
        this.jj_consume_token(15);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                stmt = this.CreateTypeStatement(startToken);
                break;
            }
            case 72: {
                stmt = this.CreateNodegroupStatement(startToken);
                break;
            }
            case 20: 
            case 21: 
            case 39: 
            case 58: {
                stmt = this.CreateDatasetStatement(startToken);
                break;
            }
            case 54: 
            case 86: {
                stmt = this.CreateIndexStatement(startToken);
                break;
            }
            case 22: {
                stmt = this.CreateDataverseStatement(startToken);
                break;
            }
            case 47: {
                stmt = this.CreateFunctionStatement(startToken);
                break;
            }
            case 1: {
                stmt = this.CreateAdapterStatement(startToken);
                break;
            }
            case 100: {
                stmt = this.CreateSynonymStatement(startToken);
                break;
            }
            case 40: {
                stmt = this.CreateFeedStatement(startToken);
                break;
            }
            case 55: {
                stmt = this.CreateFeedPolicyStatement(startToken);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeDecl CreateTypeStatement(Token startStmtToken) throws ParseException, ParseException {
        TypeDecl stmt = null;
        this.jj_consume_token(103);
        stmt = this.TypeSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeDecl TypeSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        RecordTypeDefinition typeExpr = null;
        nameComponents = this.TypeName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(6);
        typeExpr = this.RecordTypeDef();
        boolean dgen = false;
        long numValues = -1L;
        String filename = null;
        Token hintToken = this.fetchHint(startStmtToken, SqlppHint.DGEN_HINT);
        if (hintToken != null) {
            String[] splits;
            String hintParams = hintToken.hintParams;
            String[] stringArray = splits = hintParams != null ? hintParams.split("\\s+") : null;
            if (splits == null || splits.length != 2) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expecting /*+ dgen <filename> <numberOfItems> */");
            }
            dgen = true;
            filename = splits[0];
            numValues = Long.parseLong(splits[1]);
        }
        TypeDataGen tddg = new TypeDataGen(dgen, filename, numValues);
        TypeDecl stmt = new TypeDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, (TypeExpression)typeExpr, tddg, ifNotExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final NodegroupDecl CreateNodegroupStatement(Token startStmtToken) throws ParseException, ParseException {
        NodegroupDecl stmt = null;
        this.jj_consume_token(72);
        stmt = this.NodegroupSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final NodegroupDecl NodegroupSpecification(Token startStmtToken) throws ParseException, ParseException {
        String name = null;
        String tmp = null;
        boolean ifNotExists = false;
        ArrayList<Identifier> ncNames = new ArrayList<Identifier>();
        name = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(76);
        tmp = this.Identifier();
        ncNames.add(new Identifier(tmp));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            tmp = this.Identifier();
            ncNames.add(new Identifier(tmp));
        }
        NodegroupDecl stmt = new NodegroupDecl(new Identifier(name), ncNames, ifNotExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final void Dataset() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final DatasetDecl CreateDatasetStatement(Token startStmtToken) throws ParseException, ParseException {
        DatasetDecl stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 21: 
            case 58: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                this.Dataset();
                stmt = this.DatasetSpecification(startStmtToken);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                this.Dataset();
                stmt = this.ExternalDatasetSpecification(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final DatasetDecl DatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        TypeExpression typeExpr = null;
        TypeExpression metaTypeExpr = null;
        Pair<List<Integer>, List<List<String>>> primaryKeyFields = null;
        String nodeGroupName = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl stmt = null;
        boolean autogenerated = false;
        Pair<Integer, List<String>> filterField = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        typeExpr = this.DatasetTypeSpecification();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                String name = this.Identifier();
                if (!name.equalsIgnoreCase("meta")) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), "We can only support one additional associated field called \"meta\".");
                }
                metaTypeExpr = this.DatasetTypeSpecification();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        ifNotExists = this.IfNotExists();
        primaryKeyFields = this.PrimaryKey();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                autogenerated = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                nodeGroupName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                hints = this.Properties();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (this.jj_2_1(2)) {
            this.jj_consume_token(116);
            this.jj_consume_token(41);
            this.jj_consume_token(76);
            filterField = this.NestedField();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                withRecord = this.RecordConstructor();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (filterField != null && (Integer)filterField.first != 0) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), "A filter field can only be a field in the main record of the dataset.");
        }
        InternalDetailsDecl idd = new InternalDetailsDecl((List)primaryKeyFields.second, (List)primaryKeyFields.first, autogenerated, filterField == null ? null : (List)filterField.second);
        try {
            stmt = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, typeExpr, metaTypeExpr, nodeGroupName != null ? new Identifier(nodeGroupName) : null, hints, DatasetConfig.DatasetType.INTERNAL, (IDatasetDetailsDecl)idd, withRecord, ifNotExists);
            if ("" != null) {
                return SQLPPParser.addSourceLocation(stmt, startStmtToken);
            }
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
        throw new Error("Missing return statement in function");
    }

    public final DatasetDecl ExternalDatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        TypeExpression typeExpr = null;
        boolean ifNotExists = false;
        String adapterName = null;
        Map<String, String> properties = null;
        String nodeGroupName = null;
        Map<Object, Object> hints = new HashMap();
        DatasetDecl stmt = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        typeExpr = this.DatasetTypeSpecification();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(111);
        adapterName = this.AdapterName();
        properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                nodeGroupName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                hints = this.Properties();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                withRecord = this.RecordConstructor();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        ExternalDetailsDecl edd = new ExternalDetailsDecl();
        edd.setAdapter(adapterName);
        edd.setProperties(properties);
        try {
            stmt = new DatasetDecl((DataverseName)nameComponents.first, (Identifier)nameComponents.second, typeExpr, null, nodeGroupName != null ? new Identifier(nodeGroupName) : null, hints, DatasetConfig.DatasetType.EXTERNAL, (IDatasetDetailsDecl)edd, withRecord, ifNotExists);
            if ("" != null) {
                return SQLPPParser.addSourceLocation(stmt, startStmtToken);
            }
        }
        catch (CompilationException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression DatasetTypeSpecification() throws ParseException, ParseException {
        TypeExpression typeExpr = null;
        if (this.jj_2_2(3)) {
            typeExpr = this.DatasetRecordTypeSpecification(true);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 124: {
                    typeExpr = this.DatasetReferenceTypeSpecification();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return typeExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression DatasetReferenceTypeSpecification() throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        this.jj_consume_token(124);
        typeExpr = this.TypeReference();
        this.jj_consume_token(125);
        if ("" != null) {
            return typeExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression DatasetRecordTypeSpecification(boolean allowRecordKindModifier) throws ParseException, ParseException {
        RecordTypeDefinition recordTypeDef = null;
        RecordTypeDefinition.RecordKind recordKind = null;
        Token startToken = null;
        Token recordKindToken = null;
        this.jj_consume_token(124);
        startToken = this.token;
        recordTypeDef = this.DatasetRecordTypeDef();
        this.jj_consume_token(125);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 77: {
                recordKind = this.RecordTypeKind();
                recordKindToken = this.token;
                this.jj_consume_token(103);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        if (recordKind == null) {
            recordKind = RecordTypeDefinition.RecordKind.CLOSED;
        } else if (!allowRecordKindModifier) {
            throw this.createUnexpectedTokenError(recordKindToken);
        }
        recordTypeDef.setRecordKind(recordKind);
        if ("" != null) {
            return (TypeExpression)SQLPPParser.addSourceLocation(recordTypeDef, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordTypeDefinition DatasetRecordTypeDef() throws ParseException, ParseException {
        RecordTypeDefinition recType = new RecordTypeDefinition();
        this.DatasetRecordField(recType);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            this.DatasetRecordField(recType);
        }
        if ("" != null) {
            return recType;
        }
        throw new Error("Missing return statement in function");
    }

    public final void DatasetRecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeReferenceExpression type = null;
        boolean nullable = true;
        boolean missable = true;
        String fieldName = this.Identifier();
        type = this.TypeReference();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                this.jj_consume_token(106);
                nullable = false;
                missable = false;
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        recType.addField(fieldName, (TypeExpression)type, nullable, missable);
    }

    public final RefreshExternalDatasetStatement RefreshExternalDatasetStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        Object datasetName = null;
        this.jj_consume_token(88);
        startToken = this.token;
        this.jj_consume_token(39);
        this.Dataset();
        nameComponents = this.QualifiedName();
        RefreshExternalDatasetStatement stmt = new RefreshExternalDatasetStatement();
        stmt.setDataverseName((DataverseName)nameComponents.first);
        stmt.setDatasetName((Identifier)nameComponents.second);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateIndexStatement CreateIndexStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateIndexStatement stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                stmt = this.IndexSpecification(startStmtToken);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(54);
                stmt = this.PrimaryIndexSpecification(startStmtToken);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateIndexStatement IndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        CreateIndexStatement stmt = new CreateIndexStatement();
        String indexName = null;
        boolean ifNotExists = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        Pair<Integer, Pair<List<String>, IndexedTypeExpression>> fieldPair = null;
        IndexParams indexType = null;
        boolean enforced = false;
        indexName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(76);
        nameComponents = this.QualifiedName();
        this.jj_consume_token(124);
        fieldPair = this.OpenField();
        stmt.addFieldExprPair((Pair)fieldPair.second);
        stmt.addFieldIndexIndicator((Integer)fieldPair.first);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(130);
            fieldPair = this.OpenField();
            stmt.addFieldExprPair((Pair)fieldPair.second);
            stmt.addFieldIndexIndicator((Integer)fieldPair.first);
        }
        this.jj_consume_token(125);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                indexType = this.IndexType();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                enforced = true;
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        stmt.setIndexName(new Identifier(indexName));
        stmt.setIfNotExists(ifNotExists);
        stmt.setDataverseName((DataverseName)nameComponents.first);
        stmt.setDatasetName((Identifier)nameComponents.second);
        if (indexType != null) {
            stmt.setIndexType(indexType.type);
            stmt.setGramLength(indexType.gramLength);
        }
        stmt.setEnforced(enforced);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateIndexStatement PrimaryIndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        CreateIndexStatement stmt = new CreateIndexStatement();
        String indexName = null;
        boolean ifNotExists = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                indexName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(76);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (indexName == null) {
            indexName = "primary_idx_" + nameComponents.second;
        }
        stmt.setIndexName(new Identifier(indexName));
        stmt.setIfNotExists(ifNotExists);
        stmt.setDataverseName((DataverseName)nameComponents.first);
        stmt.setDatasetName((Identifier)nameComponents.second);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final String CompactionPolicy() throws ParseException, ParseException {
        String compactionPolicy = null;
        compactionPolicy = this.Identifier();
        if ("" != null) {
            return compactionPolicy;
        }
        throw new Error("Missing return statement in function");
    }

    public final String FilterField() throws ParseException, ParseException {
        String filterField = null;
        filterField = this.Identifier();
        if ("" != null) {
            return filterField;
        }
        throw new Error("Missing return statement in function");
    }

    public final IndexParams IndexType() throws ParseException, ParseException {
        DatasetConfig.IndexType type = null;
        int gramLength = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                type = DatasetConfig.IndexType.BTREE;
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                type = DatasetConfig.IndexType.RTREE;
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                type = DatasetConfig.IndexType.SINGLE_PARTITION_WORD_INVIX;
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                this.jj_consume_token(124);
                this.jj_consume_token(149);
                type = DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                gramLength = Integer.valueOf(this.token.image);
                this.jj_consume_token(125);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new IndexParams(type, gramLength);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateDataverseStatement CreateDataverseStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateDataverseStatement stmt = null;
        this.jj_consume_token(22);
        stmt = this.DataverseSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateDataverseStatement DataverseSpecification(Token startStmtToken) throws ParseException, ParseException {
        List<String> dvName = null;
        boolean ifNotExists = false;
        dvName = this.MultipartIdentifier();
        ifNotExists = this.IfNotExists();
        CreateDataverseStatement stmt = new CreateDataverseStatement(DataverseName.create(dvName), null, ifNotExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFunctionStatement CreateFunctionStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFunctionStatement stmt = null;
        this.jj_consume_token(47);
        stmt = this.FunctionSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateAdapterStatement CreateAdapterStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateAdapterStatement stmt = null;
        this.jj_consume_token(1);
        stmt = this.AdapterSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateAdapterStatement AdapterSpecification(Token startStmtToken) throws ParseException, ParseException {
        AdapterIdentifier signature = null;
        Pair<DataverseName, Identifier> adaptName = null;
        DataverseName currentDataverse = this.defaultDataverse;
        String lang = null;
        String libName = "";
        String externalIdent = "";
        Object resources = null;
        boolean ifNotExists = false;
        adaptName = this.QualifiedName();
        this.jj_consume_token(172);
        this.expectToken(LANGUAGE);
        lang = this.Identifier();
        this.jj_consume_token(6);
        libName = this.ConstantString();
        this.jj_consume_token(130);
        externalIdent = this.ConstantString();
        ifNotExists = this.IfNotExists();
        signature = new AdapterIdentifier((DataverseName)adaptName.getFirst(), ((Identifier)adaptName.getSecond()).getValue());
        CreateAdapterStatement stmt = new CreateAdapterStatement(signature, lang, libName, externalIdent, ifNotExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFunctionStatement FunctionSpecification(Token startStmtToken) throws ParseException, ParseException {
        FunctionSignature signature = null;
        boolean ifNotExists = false;
        String functionBody = null;
        Object var = null;
        Expression functionBodyExpr = null;
        FunctionName fctName = null;
        DataverseName currentDataverse = this.defaultDataverse;
        TypeExpression returnType = null;
        boolean deterministic = false;
        boolean nullCall = false;
        String lang = null;
        String libName = "";
        String externalIdent = "";
        ArrayList<String> externalIdentList = null;
        List<Pair<VarIdentifier, TypeExpression>> params = null;
        RecordConstructor resources = null;
        fctName = this.FunctionName();
        this.defaultDataverse = fctName.dataverse;
        ifNotExists = this.IfNotExists();
        params = this.FunctionParameters();
        returnType = this.FunctionReturnType();
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                this.createNewScope();
                Token beginPos = this.token;
                functionBodyExpr = this.FunctionBody();
                this.jj_consume_token(146);
                Token endPos = this.token;
                functionBody = this.extractFragment(beginPos.beginLine, beginPos.beginColumn, endPos.beginLine, endPos.beginColumn);
                signature = new FunctionSignature(fctName.dataverse, fctName.function, params.size());
                this.getCurrentScope().addFunctionDescriptor(signature, false);
                this.removeCurrentScope();
                this.defaultDataverse = currentDataverse;
                this.ensureNoTypeDeclsInFunction(fctName.function, params, returnType, startStmtToken);
                CreateFunctionStatement stmt = new CreateFunctionStatement(signature, params, functionBody, functionBodyExpr, ifNotExists);
                if ("" == null) break;
                return SQLPPParser.addSourceLocation(stmt, startStmtToken);
            }
            case 172: {
                this.jj_consume_token(172);
                this.expectToken(LANGUAGE);
                if (this.laIdentifier(INLINE)) {
                    this.jj_consume_token(172);
                    this.jj_consume_token(6);
                    this.createNewScope();
                    Token beginPos = this.token;
                    functionBodyExpr = this.FunctionBody();
                    Token endPos = this.token;
                    functionBody = this.extractFragment(beginPos.endLine, beginPos.beginColumn + 1, endPos.endLine, endPos.endColumn + 1);
                    signature = new FunctionSignature(fctName.dataverse, fctName.function, params.size());
                    this.getCurrentScope().addFunctionDescriptor(signature, false);
                    this.removeCurrentScope();
                    this.defaultDataverse = currentDataverse;
                    this.ensureNoTypeDeclsInFunction(fctName.function, params, returnType, startStmtToken);
                    CreateFunctionStatement stmt = new CreateFunctionStatement(signature, params, functionBody, functionBodyExpr, ifNotExists);
                    if ("" == null) break;
                    return SQLPPParser.addSourceLocation(stmt, startStmtToken);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 161: 
                    case 172: {
                        lang = this.Identifier();
                        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 74: 
                            case 172: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 74: {
                                        this.jj_consume_token(74);
                                        this.jj_consume_token(172);
                                        this.expectToken(DETERMINISTIC);
                                        deterministic = false;
                                        break block8;
                                    }
                                    case 172: {
                                        this.jj_consume_token(172);
                                        this.expectToken(DETERMINISTIC);
                                        deterministic = true;
                                        break block8;
                                    }
                                }
                                this.jj_la1[29] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 151: {
                                this.jj_consume_token(151);
                                this.jj_consume_token(172);
                                this.expectToken(CALL);
                                nullCall = true;
                                break;
                            }
                            default: {
                                this.jj_la1[31] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(6);
                        libName = this.ConstantString();
                        externalIdentList = new ArrayList<String>(2);
                        block25: while (true) {
                            this.jj_consume_token(130);
                            externalIdent = this.ConstantString();
                            externalIdentList.add(externalIdent);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 130: {
                                    continue block25;
                                }
                            }
                            break;
                        }
                        this.jj_la1[32] = this.jj_gen;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 116: {
                                this.jj_consume_token(116);
                                resources = this.RecordConstructor();
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                            }
                        }
                        signature = new FunctionSignature(fctName.dataverse, fctName.function, params.size());
                        this.defaultDataverse = currentDataverse;
                        CreateFunctionStatement stmt = null;
                        try {
                            stmt = new CreateFunctionStatement(signature, params, returnType, deterministic, nullCall, lang, libName, externalIdentList, resources, ifNotExists);
                        }
                        catch (AlgebricksException e) {
                            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
                        }
                        if ("" == null) break block1;
                        return SQLPPParser.addSourceLocation(stmt, startStmtToken);
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Pair<VarIdentifier, TypeExpression>> FunctionParameters() throws ParseException {
        List<Pair<VarIdentifier, TypeExpression>> paramList = Collections.emptyList();
        this.jj_consume_token(124);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                paramList = this.FunctionParameterList();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.jj_consume_token(125);
        if ("" != null) {
            return paramList;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Pair<VarIdentifier, TypeExpression>> FunctionParameterList() throws ParseException {
        ArrayList<Pair<VarIdentifier, TypeExpression>> paramList = new ArrayList<Pair<VarIdentifier, TypeExpression>>();
        Pair<VarIdentifier, TypeExpression> param = null;
        param = this.FunctionParameter();
        paramList.add(param);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            param = this.FunctionParameter();
            paramList.add(param);
        }
        if ("" != null) {
            return paramList;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<VarIdentifier, TypeExpression> FunctionParameter() throws ParseException, ParseException {
        String name = null;
        TypeExpression type = null;
        name = this.VariableIdentifier();
        if (this.jj_2_3(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: {
                    this.jj_consume_token(129);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                }
            }
            type = this.TypeExpr(false);
        }
        if ("" != null) {
            return new Pair((Object)new VarIdentifier(name), type);
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression FunctionReturnType() throws ParseException, ParseException {
        TypeExpression returnType = null;
        if (this.laIdentifier(RETURNS)) {
            this.jj_consume_token(172);
            returnType = this.TypeExpr(false);
        }
        if ("" != null) {
            return returnType;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression FunctionBody() throws ParseException, ParseException {
        Object functionBodyExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: 
            case 66: 
            case 67: 
            case 95: 
            case 116: {
                functionBodyExpr = this.SelectExpression(true);
                break;
            }
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                functionBodyExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return functionBodyExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedStatement CreateFeedStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFeedStatement stmt = null;
        this.jj_consume_token(40);
        stmt = this.FeedSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedStatement FeedSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        boolean ifNotExists = false;
        Object adapterName = null;
        Object properties = null;
        CreateFeedStatement stmt = null;
        Object sourceNameComponents = null;
        RecordConstructor withRecord = null;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(116);
        withRecord = this.RecordConstructor();
        try {
            stmt = new CreateFeedStatement(nameComponents, withRecord, ifNotExists);
            if ("" != null) {
                return SQLPPParser.addSourceLocation(stmt, startStmtToken);
            }
        }
        catch (AlgebricksException e) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(startStmtToken), e.getMessage());
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedPolicyStatement CreateFeedPolicyStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateFeedPolicyStatement stmt = null;
        this.jj_consume_token(55);
        this.jj_consume_token(84);
        stmt = this.FeedPolicySpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateFeedPolicyStatement FeedPolicySpecification(Token startStmtToken) throws ParseException, ParseException {
        String policyName = null;
        String basePolicyName = null;
        String sourcePolicyFile = null;
        String definition = null;
        boolean ifNotExists = false;
        Map<String, String> properties = null;
        CreateFeedPolicyStatement stmt = null;
        policyName = this.Identifier();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(44);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                basePolicyName = this.Identifier();
                properties = this.Configuration();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                    }
                }
                stmt = new CreateFeedPolicyStatement(policyName, basePolicyName, properties, definition, ifNotExists);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                sourcePolicyFile = this.ConstantString();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        definition = this.ConstantString();
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                    }
                }
                stmt = new CreateFeedPolicyStatement(policyName, sourcePolicyFile, definition, ifNotExists);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateSynonymStatement CreateSynonymStatement(Token startStmtToken) throws ParseException, ParseException {
        CreateSynonymStatement stmt = null;
        this.jj_consume_token(100);
        stmt = this.SynonymSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final CreateSynonymStatement SynonymSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> nameComponents = null;
        Pair<DataverseName, Identifier> objectNameComponents = null;
        boolean ifNotExists = false;
        nameComponents = this.QualifiedName();
        ifNotExists = this.IfNotExists();
        this.jj_consume_token(43);
        objectNameComponents = this.QualifiedName();
        CreateSynonymStatement stmt = new CreateSynonymStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), (DataverseName)objectNameComponents.first, ((Identifier)objectNameComponents.second).getValue(), ifNotExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final boolean IfNotExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(74);
                this.jj_consume_token(38);
                if ("" == null) break;
                return true;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        if ("" != null) {
            return false;
        }
        throw new Error("Missing return statement in function");
    }

    public final void ApplyFunction(List<FunctionSignature> funcSigs) throws ParseException, ParseException {
        FunctionName functionName = null;
        String fqFunctionName = null;
        this.jj_consume_token(5);
        this.jj_consume_token(47);
        functionName = this.FunctionName();
        fqFunctionName = functionName.library == null ? functionName.function : functionName.library + "#" + functionName.function;
        funcSigs.add(new FunctionSignature(functionName.dataverse, fqFunctionName, 1));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            functionName = this.FunctionName();
            fqFunctionName = functionName.library == null ? functionName.function : functionName.library + "#" + functionName.function;
            funcSigs.add(new FunctionSignature(functionName.dataverse, fqFunctionName, 1));
        }
    }

    public final String GetPolicy() throws ParseException, ParseException {
        String policy = null;
        this.jj_consume_token(111);
        this.jj_consume_token(84);
        policy = this.Identifier();
        if ("" != null) {
            return policy;
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionSignature FunctionSignature() throws ParseException, ParseException {
        String fqFunctionName;
        FunctionName fctName = null;
        int arity = 0;
        fctName = this.FunctionName();
        this.jj_consume_token(128);
        this.jj_consume_token(149);
        arity = new Integer(this.token.image);
        if (arity < 0 && arity != -1) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Invalid arity:" + arity);
        }
        String string = fqFunctionName = fctName.library == null ? fctName.function : fctName.library + "#" + fctName.function;
        if ("" != null) {
            return new FunctionSignature(fctName.dataverse, fqFunctionName, arity);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<List<Integer>, List<List<String>>> PrimaryKey() throws ParseException, ParseException {
        Pair<Integer, List<String>> tmp = null;
        ArrayList<Object> keyFieldSourceIndicators = new ArrayList<Object>();
        ArrayList<Object> primaryKeyFields = new ArrayList<Object>();
        this.jj_consume_token(86);
        this.jj_consume_token(63);
        tmp = this.NestedField();
        keyFieldSourceIndicators.add(tmp.first);
        primaryKeyFields.add(tmp.second);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            tmp = this.NestedField();
            keyFieldSourceIndicators.add(tmp.first);
            primaryKeyFields.add(tmp.second);
        }
        if ("" != null) {
            return new Pair(keyFieldSourceIndicators, primaryKeyFields);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement DropStatement() throws ParseException, ParseException {
        Token startToken = null;
        DropDatasetStatement stmt = null;
        this.jj_consume_token(30);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 21: {
                stmt = this.DropDatasetStatement(startToken);
                break;
            }
            case 54: {
                stmt = this.DropIndexStatement(startToken);
                break;
            }
            case 72: {
                stmt = this.DropNodeGroupStatement(startToken);
                break;
            }
            case 103: {
                stmt = this.DropTypeStatement(startToken);
                break;
            }
            case 22: {
                stmt = this.DropDataverseStatement(startToken);
                break;
            }
            case 47: {
                stmt = this.DropFunctionStatement(startToken);
                break;
            }
            case 40: {
                stmt = this.DropFeedStatement(startToken);
                break;
            }
            case 55: {
                stmt = this.DropFeedPolicyStatement(startToken);
                break;
            }
            case 100: {
                stmt = this.DropSynonymStatement(startToken);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final DropDatasetStatement DropDatasetStatement(Token startStmtToken) throws ParseException, ParseException {
        DropDatasetStatement stmt = null;
        this.Dataset();
        stmt = this.DropDatasetSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final DropDatasetStatement DropDatasetSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        DropDatasetStatement stmt = new DropDatasetStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final IndexDropStatement DropIndexStatement(Token startStmtToken) throws ParseException, ParseException {
        IndexDropStatement stmt = null;
        this.jj_consume_token(54);
        stmt = this.DropIndexSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final IndexDropStatement DropIndexSpecification(Token startStmtToken) throws ParseException, ParseException {
        Triple<DataverseName, Identifier, Identifier> tripleId = null;
        boolean ifExists = false;
        tripleId = this.DoubleQualifiedName();
        ifExists = this.IfExists();
        IndexDropStatement stmt = new IndexDropStatement((DataverseName)tripleId.first, (Identifier)tripleId.second, (Identifier)tripleId.third, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final NodeGroupDropStatement DropNodeGroupStatement(Token startStmtToken) throws ParseException, ParseException {
        NodeGroupDropStatement stmt = null;
        this.jj_consume_token(72);
        stmt = this.DropNodeGroupSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final NodeGroupDropStatement DropNodeGroupSpecification(Token startStmtToken) throws ParseException, ParseException {
        String id = null;
        boolean ifExists = false;
        id = this.Identifier();
        ifExists = this.IfExists();
        NodeGroupDropStatement stmt = new NodeGroupDropStatement(new Identifier(id), ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeDropStatement DropTypeStatement(Token startStmtToken) throws ParseException, ParseException {
        TypeDropStatement stmt = null;
        this.jj_consume_token(103);
        stmt = this.DropTypeSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeDropStatement DropTypeSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.TypeName();
        ifExists = this.IfExists();
        TypeDropStatement stmt = new TypeDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final DataverseDropStatement DropDataverseStatement(Token startStmtToken) throws ParseException, ParseException {
        DataverseDropStatement stmt = null;
        this.jj_consume_token(22);
        stmt = this.DropDataverseSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final DataverseDropStatement DropDataverseSpecification(Token startStmtToken) throws ParseException, ParseException {
        List<String> multipartId = null;
        boolean ifExists = false;
        multipartId = this.MultipartIdentifier();
        ifExists = this.IfExists();
        DataverseDropStatement stmt = new DataverseDropStatement(DataverseName.create(multipartId), ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionDropStatement DropFunctionStatement(Token startStmtToken) throws ParseException, ParseException {
        FunctionDropStatement stmt = null;
        this.jj_consume_token(47);
        stmt = this.DropFunctionSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionDropStatement DropFunctionSpecification(Token startStmtToken) throws ParseException, ParseException {
        FunctionSignature funcSig = null;
        boolean ifExists = false;
        funcSig = this.FunctionSignature();
        ifExists = this.IfExists();
        FunctionDropStatement stmt = new FunctionDropStatement(funcSig, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FeedDropStatement DropFeedStatement(Token startStmtToken) throws ParseException, ParseException {
        FeedDropStatement stmt = null;
        this.jj_consume_token(40);
        stmt = this.DropFeedSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final FeedDropStatement DropFeedSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        FeedDropStatement stmt = new FeedDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FeedPolicyDropStatement DropFeedPolicyStatement(Token startStmtToken) throws ParseException, ParseException {
        FeedPolicyDropStatement stmt = null;
        this.jj_consume_token(55);
        this.jj_consume_token(84);
        stmt = this.DropFeedPolicySpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final FeedPolicyDropStatement DropFeedPolicySpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        FeedPolicyDropStatement stmt = new FeedPolicyDropStatement((DataverseName)pairId.first, (Identifier)pairId.second, ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final SynonymDropStatement DropSynonymStatement(Token startStmtToken) throws ParseException, ParseException {
        SynonymDropStatement stmt = null;
        this.jj_consume_token(100);
        stmt = this.DropSynonymSpecification(startStmtToken);
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final SynonymDropStatement DropSynonymSpecification(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> pairId = null;
        boolean ifExists = false;
        pairId = this.QualifiedName();
        ifExists = this.IfExists();
        SynonymDropStatement stmt = new SynonymDropStatement((DataverseName)pairId.first, ((Identifier)pairId.second).getValue(), ifExists);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final boolean IfExists() throws ParseException, ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(38);
                if ("" == null) break;
                return true;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        if ("" != null) {
            return false;
        }
        throw new Error("Missing return statement in function");
    }

    public final InsertStatement InsertStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(57);
        startToken = this.token;
        this.jj_consume_token(52);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        if (var == null && returnExpression != null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        query.setTopLevel(true);
        InsertStatement stmt = new InsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final UpsertStatement UpsertStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        VariableExpr var = null;
        Query query = null;
        Expression returnExpression = null;
        this.jj_consume_token(109);
        startToken = this.token;
        this.jj_consume_token(52);
        nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        query = this.Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                returnExpression = this.Expression();
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        if (var == null && returnExpression != null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        query.setTopLevel(true);
        UpsertStatement stmt = new UpsertStatement((DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), query, this.getVarCounter(), var, returnExpression);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final DeleteStatement DeleteStatement() throws ParseException, ParseException {
        Token startToken = null;
        VariableExpr var = null;
        Expression condition = null;
        this.jj_consume_token(25);
        startToken = this.token;
        this.jj_consume_token(44);
        Pair<DataverseName, Identifier> nameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 161: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                    }
                }
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 115: {
                this.jj_consume_token(115);
                condition = this.Expression();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        if (var == null) {
            var = new VariableExpr(SqlppVariableUtil.toInternalVariableIdentifier(((Identifier)nameComponents.second).getValue()));
            SQLPPParser.addSourceLocation(var, startToken);
        }
        DeleteStatement stmt = new DeleteStatement(var, (DataverseName)nameComponents.first, ((Identifier)nameComponents.second).getValue(), condition, this.getVarCounter());
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final UpdateStatement UpdateStatement() throws ParseException, ParseException {
        Token startToken = null;
        ArrayList<UpdateClause> ucs = new ArrayList<UpdateClause>();
        this.jj_consume_token(108);
        startToken = this.token;
        VariableExpr vars = this.Variable();
        this.jj_consume_token(53);
        Expression target = this.Expression();
        this.jj_consume_token(115);
        Expression condition = this.Expression();
        this.jj_consume_token(124);
        UpdateClause uc = this.UpdateClause();
        ucs.add(uc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            uc = this.UpdateClause();
            ucs.add(uc);
        }
        this.jj_consume_token(125);
        UpdateStatement stmt = new UpdateStatement(vars, target, condition, ucs);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final UpdateClause UpdateClause() throws ParseException, ParseException {
        Expression target = null;
        Expression value = null;
        InsertStatement is = null;
        DeleteStatement ds = null;
        UpdateStatement us = null;
        Expression condition = null;
        UpdateClause ifbranch = null;
        UpdateClause elsebranch = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                target = this.Expression();
                this.jj_consume_token(141);
                value = this.Expression();
                break;
            }
            case 57: {
                is = this.InsertStatement();
                break;
            }
            case 25: {
                ds = this.DeleteStatement();
                break;
            }
            case 108: {
                us = this.UpdateStatement();
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(124);
                condition = this.Expression();
                this.jj_consume_token(125);
                this.jj_consume_token(102);
                ifbranch = this.UpdateClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        elsebranch = this.UpdateClause();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                if ("" == null) break;
                return new UpdateClause(target, value, is, ds, us, condition, ifbranch, elsebranch);
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement SetStatement() throws ParseException, ParseException {
        Token startToken = null;
        String pn = null;
        String pv = null;
        this.jj_consume_token(96);
        startToken = this.token;
        pn = this.Identifier();
        pv = this.ConstantString();
        SetStatement stmt = new SetStatement(pn, pv);
        if ("" != null) {
            return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement WriteStatement() throws ParseException, ParseException {
        Token startToken = null;
        String nodeName = null;
        String fileName = null;
        String writerClass = null;
        Object nameComponents = null;
        this.jj_consume_token(117);
        startToken = this.token;
        this.jj_consume_token(81);
        this.jj_consume_token(104);
        nodeName = this.Identifier();
        this.jj_consume_token(129);
        fileName = this.ConstantString();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 111: {
                this.jj_consume_token(111);
                writerClass = this.ConstantString();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        WriteStatement stmt = new WriteStatement(new Identifier(nodeName), fileName, writerClass);
        if ("" != null) {
            return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final LoadStatement LoadStatement() throws ParseException, ParseException {
        Token startToken = null;
        DataverseName dataverseName = null;
        Identifier datasetName = null;
        boolean alreadySorted = false;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(70);
        startToken = this.token;
        this.Dataset();
        nameComponents = this.QualifiedName();
        dataverseName = (DataverseName)nameComponents.first;
        datasetName = (Identifier)nameComponents.second;
        this.jj_consume_token(111);
        String adapterName = this.AdapterName();
        Map<String, String> properties = this.Configuration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                alreadySorted = true;
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        LoadStatement stmt = new LoadStatement(dataverseName, datasetName.getValue(), adapterName, properties, alreadySorted);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final String AdapterName() throws ParseException, ParseException {
        String adapterName = null;
        adapterName = this.Identifier();
        if ("" != null) {
            return adapterName;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement CompactStatement() throws ParseException, ParseException {
        Token startToken = null;
        Pair<DataverseName, Identifier> nameComponents = null;
        this.jj_consume_token(17);
        startToken = this.token;
        this.Dataset();
        nameComponents = this.QualifiedName();
        CompactStatement stmt = new CompactStatement((DataverseName)nameComponents.first, (Identifier)nameComponents.second);
        if ("" != null) {
            return (Statement)SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement ConnectionStatement() throws ParseException, ParseException {
        Token startToken = null;
        AbstractStatement stmt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                startToken = this.token;
                stmt = this.ConnectStatement(startToken);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                startToken = this.token;
                stmt = this.DisconnectStatement(startToken);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                startToken = this.token;
                stmt = this.StartStatement(startToken);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                startToken = this.token;
                stmt = this.StopStatement(startToken);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    public final Statement StartStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        StartFeedStatement stmt = null;
        this.jj_consume_token(40);
        feedNameComponents = this.QualifiedName();
        stmt = new StartFeedStatement(feedNameComponents);
        if ("" != null) {
            return (Statement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final AbstractStatement StopStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        StopFeedStatement stmt = null;
        this.jj_consume_token(40);
        feedNameComponents = this.QualifiedName();
        stmt = new StopFeedStatement(feedNameComponents);
        if ("" != null) {
            return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final AbstractStatement DisconnectStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        Pair<DataverseName, Identifier> datasetNameComponents = null;
        DisconnectFeedStatement stmt = null;
        this.jj_consume_token(40);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(44);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        stmt = new DisconnectFeedStatement(feedNameComponents, datasetNameComponents);
        if ("" != null) {
            return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final AbstractStatement ConnectStatement(Token startStmtToken) throws ParseException, ParseException {
        Pair<DataverseName, Identifier> feedNameComponents = null;
        Pair<DataverseName, Identifier> datasetNameComponents = null;
        Object configuration = null;
        ArrayList<FunctionSignature> appliedFunctions = new ArrayList<FunctionSignature>();
        ConnectFeedStatement stmt = null;
        String policy = null;
        String whereClauseBody = null;
        WhereClause whereClause = null;
        Token beginPos = null;
        Token endPos = null;
        this.jj_consume_token(40);
        feedNameComponents = this.QualifiedName();
        this.jj_consume_token(104);
        this.Dataset();
        datasetNameComponents = this.QualifiedName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.ApplyFunction(appliedFunctions);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 111: {
                policy = this.GetPolicy();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 115: {
                this.jj_consume_token(115);
                beginPos = this.token;
                whereClause = new WhereClause();
                Expression whereExpr = this.Expression();
                whereClause.setWhereExpr(whereExpr);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        if (whereClause != null) {
            endPos = this.token;
            whereClauseBody = this.extractFragment(beginPos.endLine, beginPos.endColumn, endPos.endLine, endPos.endColumn + 1);
        }
        stmt = new ConnectFeedStatement(feedNameComponents, datasetNameComponents, appliedFunctions, policy, whereClauseBody, this.getVarCounter());
        if ("" != null) {
            return (AbstractStatement)SQLPPParser.addSourceLocation(stmt, startStmtToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Map<String, String> Configuration() throws ParseException, ParseException {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        Pair<String, String> keyValuePair = null;
        this.jj_consume_token(124);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                keyValuePair = this.KeyValuePair();
                configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    keyValuePair = this.KeyValuePair();
                    configuration.put((String)keyValuePair.first, (String)keyValuePair.second);
                }
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        this.jj_consume_token(125);
        if ("" != null) {
            return configuration;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<String, String> KeyValuePair() throws ParseException, ParseException {
        String value;
        this.jj_consume_token(124);
        String key = this.ConstantString();
        this.jj_consume_token(141);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 162: {
                value = this.ConstantString();
                break;
            }
            case 152: 
            case 153: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 152: {
                        this.jj_consume_token(152);
                        break;
                    }
                    case 153: {
                        this.jj_consume_token(153);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                value = this.token.image.toLowerCase();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(125);
        if ("" != null) {
            return new Pair((Object)key, (Object)value);
        }
        throw new Error("Missing return statement in function");
    }

    public final Map<String, String> Properties() throws ParseException, ParseException {
        HashMap<String, String> properties = new HashMap<String, String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                Pair<String, String> property = this.Property();
                properties.put((String)property.first, (String)property.second);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(130);
                    property = this.Property();
                    properties.put((String)property.first, (String)property.second);
                }
                this.jj_consume_token(125);
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        if ("" != null) {
            return properties;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<String, String> Property() throws ParseException, ParseException {
        String key = null;
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                key = this.Identifier();
                break;
            }
            case 162: {
                key = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(141);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 162: {
                value = this.ConstantString();
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                try {
                    value = String.valueOf(Long.parseLong(this.token.image));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "inapproriate value: " + this.token.image);
                }
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new Pair((Object)key.toUpperCase(), (Object)value);
        }
        throw new Error("Missing return statement in function");
    }

    public final IndexedTypeExpression IndexedTypeExpr() throws ParseException, ParseException {
        TypeExpression typeExpr = null;
        boolean isUnknownable = false;
        typeExpr = this.TypeExpr(false);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 134: {
                this.jj_consume_token(134);
                isUnknownable = true;
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new IndexedTypeExpression(typeExpr, isUnknownable);
        }
        throw new Error("Missing return statement in function");
    }

    public final TypeExpression TypeExpr(boolean allowRecordTypeDef) throws ParseException, ParseException {
        TypeReferenceExpression typeExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                typeExpr = this.TypeReference();
                break;
            }
            case 126: {
                typeExpr = this.OrderedListTypeDef(allowRecordTypeDef);
                break;
            }
            case 147: {
                typeExpr = this.UnorderedListTypeDef(allowRecordTypeDef);
                break;
            }
            case 14: 
            case 77: 
            case 145: {
                typeExpr = this.RecordTypeDef();
                if (allowRecordTypeDef) break;
                throw new SqlppParseException(typeExpr.getSourceLocation(), "Unexpected record type declaration");
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return typeExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordTypeDefinition.RecordKind RecordTypeKind() throws ParseException, ParseException {
        RecordTypeDefinition.RecordKind recordKind = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                recordKind = RecordTypeDefinition.RecordKind.CLOSED;
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                recordKind = RecordTypeDefinition.RecordKind.OPEN;
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return recordKind;
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordTypeDefinition RecordTypeDef() throws ParseException, ParseException {
        Token startToken = null;
        RecordTypeDefinition recType = new RecordTypeDefinition();
        RecordTypeDefinition.RecordKind recordKind = RecordTypeDefinition.RecordKind.OPEN;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: 
            case 77: {
                recordKind = this.RecordTypeKind();
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
            }
        }
        this.jj_consume_token(145);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.GEN_FIELDS_HINT);
        if (hintToken != null) {
            String[] splits;
            String hintParams = hintToken.hintParams;
            String[] stringArray = splits = hintParams != null ? hintParams.split("\\s+") : null;
            if (splits == null || splits.length != 4) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "Expecting: /*+ gen-fields <type> <min> <max> <prefix>*/");
            }
            if (!splits[0].equals(INT_TYPE_NAME)) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), "The only supported type for gen-fields is int.");
            }
            UndeclaredFieldsDataGen ufdg = new UndeclaredFieldsDataGen(UndeclaredFieldsDataGen.Type.INT, Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), splits[3]);
            recType.setUndeclaredFieldsDataGen(ufdg);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                this.RecordField(recType);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(130);
                    this.RecordField(recType);
                }
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        this.jj_consume_token(146);
        recType.setRecordKind(recordKind);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(recType, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final void RecordField(RecordTypeDefinition recType) throws ParseException, ParseException {
        TypeExpression type = null;
        boolean nullable = false;
        boolean missable = false;
        String fieldName = this.Identifier();
        Token hintToken = this.fetchHint(this.token, SqlppHint.VAL_FILE_HINT, SqlppHint.VAL_FILE_SAME_INDEX_HINT, SqlppHint.LIST_VAL_FILE_HINT, SqlppHint.LIST_HINT, SqlppHint.INTERVAL_HINT, SqlppHint.INSERT_RAND_INT_HINT, SqlppHint.DATE_BETWEEN_YEARS_HINT, SqlppHint.DATETIME_ADD_RAND_HOURS_HINT, SqlppHint.AUTO_HINT);
        IRecordFieldDataGen rfdg = hintToken != null ? this.parseFieldDataGen(hintToken) : null;
        this.jj_consume_token(129);
        type = this.TypeExpr(true);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 134: {
                this.jj_consume_token(134);
                nullable = true;
                missable = true;
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        recType.addField(fieldName, type, nullable, missable, rfdg);
    }

    public final TypeReferenceExpression TypeReference() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> id = null;
        id = this.QualifiedName();
        if (id.first == null && ((Identifier)id.second).getValue().equalsIgnoreCase(INT_TYPE_NAME)) {
            id.second = new Identifier(BuiltinType.AINT64.getTypeName());
        }
        TypeReferenceExpression typeRef = new TypeReferenceExpression(id);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(typeRef, this.token);
        }
        throw new Error("Missing return statement in function");
    }

    public final OrderedListTypeDefinition OrderedListTypeDef(boolean allowRecordTypeDef) throws ParseException, ParseException {
        Token startToken = null;
        TypeExpression type = null;
        this.jj_consume_token(126);
        startToken = this.token;
        type = this.TypeExpr(allowRecordTypeDef);
        this.jj_consume_token(127);
        OrderedListTypeDefinition typeDef = new OrderedListTypeDefinition(type);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(typeDef, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final UnorderedListTypeDefinition UnorderedListTypeDef(boolean allowRecordTypeDef) throws ParseException, ParseException {
        Token startToken = null;
        TypeExpression type = null;
        this.jj_consume_token(147);
        startToken = this.token;
        type = this.TypeExpr(allowRecordTypeDef);
        this.jj_consume_token(148);
        UnorderedListTypeDefinition typeDef = new UnorderedListTypeDefinition(type);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(typeDef, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionName FunctionName() throws ParseException, ParseException {
        Triple<List<String>, SourceLocation, SqlppHint> prefix = null;
        String suffix = null;
        prefix = this.MultipartIdentifierWithHints(SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                suffix = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        FunctionName result = new FunctionName();
        result.sourceLoc = (SourceLocation)prefix.second;
        result.hint = (SqlppHint)((Object)prefix.third);
        List list = (List)prefix.first;
        int ln = list.size();
        String last = (String)list.get(ln - 1);
        if (suffix == null) {
            result.function = last;
        } else {
            result.library = last;
            result.function = suffix;
        }
        result.dataverse = ln > 1 ? DataverseName.create((List)list, (int)0, (int)(ln - 1)) : this.defaultDataverse;
        if (result.function.equalsIgnoreCase(INT_TYPE_NAME)) {
            result.function = BuiltinType.AINT64.getTypeName();
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<DataverseName, Identifier> TypeName() throws ParseException, ParseException {
        Pair<DataverseName, Identifier> name = null;
        name = this.QualifiedName();
        if (name.first == null) {
            name.first = this.defaultDataverse;
        }
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    public final String Identifier() throws ParseException, ParseException {
        String lit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 172: {
                this.jj_consume_token(172);
                if ("" == null) break;
                return this.token.image;
            }
            case 161: {
                lit = this.QuotedString();
                if ("" == null) break;
                return lit;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<Integer, Pair<List<String>, IndexedTypeExpression>> OpenField() throws ParseException, ParseException {
        IndexedTypeExpression fieldType = null;
        Pair<Integer, List<String>> fieldList = null;
        fieldList = this.NestedField();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 129: {
                this.jj_consume_token(129);
                fieldType = this.IndexedTypeExpr();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new Pair(fieldList.first, (Object)new Pair(fieldList.second, (Object)fieldType));
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<Integer, List<String>> NestedField() throws ParseException, ParseException {
        ArrayList<String> exprList = new ArrayList<String>();
        String lit = null;
        Token litToken = null;
        int source = 0;
        lit = this.Identifier();
        boolean meetParens = false;
        litToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                this.jj_consume_token(125);
                if (!lit.equalsIgnoreCase("meta")) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(litToken), "The string before () has to be \"meta\".");
                }
                meetParens = true;
                source = 1;
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
            }
        }
        if (!meetParens) {
            exprList.add(lit);
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(132);
            lit = this.Identifier();
            exprList.add(lit);
        }
        if ("" != null) {
            return new Pair((Object)source, exprList);
        }
        throw new Error("Missing return statement in function");
    }

    public final String ConstantString() throws ParseException, ParseException {
        String value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: {
                value = this.QuotedString();
                break;
            }
            case 162: {
                value = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return value;
        }
        throw new Error("Missing return statement in function");
    }

    public final String QuotedString() throws ParseException, ParseException {
        this.jj_consume_token(161);
        if ("" != null) {
            return SQLPPParser.removeQuotesAndEscapes((String)this.token.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final String StringLiteral() throws ParseException, ParseException {
        this.jj_consume_token(162);
        if ("" != null) {
            return SQLPPParser.removeQuotesAndEscapes((String)this.token.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<String> MultipartIdentifier() throws ParseException, ParseException {
        Triple<List<String>, SourceLocation, SqlppHint> result = null;
        result = this.MultipartIdentifierWithHints(null);
        if ("" != null) {
            return (List)result.first;
        }
        throw new Error("Missing return statement in function");
    }

    public final Triple<List<String>, SourceLocation, SqlppHint> MultipartIdentifierWithHints(SqlppHint ... expectedHints) throws ParseException, ParseException {
        Token hintToken;
        ArrayList<String> list = new ArrayList<String>();
        SourceLocation sourceLoc = null;
        SqlppHint hint = null;
        String item = null;
        item = this.Identifier();
        list.add(item);
        sourceLoc = SQLPPParser.getSourceLocation(this.token);
        if (expectedHints != null && expectedHints.length > 0 && (hintToken = this.fetchHint(this.token, expectedHints)) != null) {
            hint = hintToken.hint;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(132);
            item = this.Identifier();
            list.add(item);
        }
        if ("" != null) {
            return new Triple(list, (Object)sourceLoc, (Object)hint);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<DataverseName, Identifier> QualifiedName() throws ParseException, ParseException {
        List<String> list = null;
        list = this.MultipartIdentifier();
        int len = list.size();
        DataverseName id1 = len > 1 ? DataverseName.create(list, (int)0, (int)(len - 1)) : null;
        Identifier id2 = new Identifier(list.get(len - 1));
        if ("" != null) {
            return new Pair((Object)id1, (Object)id2);
        }
        throw new Error("Missing return statement in function");
    }

    public final Triple<DataverseName, Identifier, Identifier> DoubleQualifiedName() throws ParseException, ParseException {
        ArrayList<String> list = new ArrayList<String>();
        String item = null;
        item = this.Identifier();
        list.add(item);
        block3: while (true) {
            this.jj_consume_token(132);
            item = this.Identifier();
            list.add(item);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[86] = this.jj_gen;
        int len = list.size();
        DataverseName id1 = len > 2 ? DataverseName.create(list, (int)0, (int)(len - 2)) : null;
        Identifier id2 = new Identifier((String)list.get(len - 2));
        Identifier id3 = new Identifier((String)list.get(len - 1));
        if ("" != null) {
            return new Triple((Object)id1, (Object)id2, (Object)id3);
        }
        throw new Error("Missing return statement in function");
    }

    public final FunctionDecl FunctionDeclaration() throws ParseException, ParseException {
        Token startToken = null;
        this.createNewScope();
        this.jj_consume_token(23);
        startToken = this.token;
        this.jj_consume_token(47);
        String functionName = this.Identifier();
        List<Pair<VarIdentifier, TypeExpression>> paramList = this.FunctionParameters();
        this.jj_consume_token(145);
        Expression funcBody = this.FunctionBody();
        this.jj_consume_token(146);
        FunctionSignature signature = new FunctionSignature(this.defaultDataverse, functionName, paramList.size());
        this.getCurrentScope().addFunctionDescriptor(signature, false);
        this.ensureNoTypeDeclsInFunction(functionName, paramList, null, startToken);
        ArrayList<Object> params = new ArrayList<Object>(paramList.size());
        for (Pair<VarIdentifier, TypeExpression> p : paramList) {
            params.add(p.getFirst());
        }
        FunctionDecl stmt = new FunctionDecl(signature, params, funcBody);
        this.removeCurrentScope();
        if ("" != null) {
            return SQLPPParser.addSourceLocation(stmt, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Query Query() throws ParseException, ParseException {
        Object expr;
        Query query = new Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                expr = this.Expression();
                break;
            }
            case 44: 
            case 66: 
            case 67: 
            case 95: 
            case 116: {
                expr = this.SelectExpression(false);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        query.setBody(expr);
        query.setSourceLocation(expr.getSourceLocation());
        if ("" != null) {
            return query;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression Expression() throws ParseException {
        Expression expr = null;
        Object exprP = null;
        if (this.jj_2_4(2)) {
            expr = this.OperatorExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 36: 
                case 97: {
                    expr = this.QuantifiedExpression();
                    break;
                }
                default: {
                    this.jj_la1[88] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return exprP == null ? expr : exprP;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression OperatorExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AndExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(78);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (Exception e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.AndExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression AndExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.NotExpr();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(3);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(this.token.image.toLowerCase());
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.NotExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression NotExpr() throws ParseException, ParseException {
        boolean not = false;
        Token startToken = null;
        if (this.jj_2_5(2)) {
            this.jj_consume_token(74);
            not = true;
            startToken = this.token;
        }
        Expression inputExpr = this.RelExpr();
        if (not) {
            FunctionSignature signature = new FunctionSignature(BuiltinFunctions.NOT);
            CallExpr callExpr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(inputExpr)));
            if ("" != null) {
                return (Expression)SQLPPParser.addSourceLocation(callExpr, startToken);
            }
        } else if ("" != null) {
            return inputExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression RelExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        IndexedNLJoinExpressionAnnotation annotation = null;
        operand = this.BetweenExpr();
        if (this.jj_2_6(2)) {
            String operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    this.jj_consume_token(137);
                    break;
                }
                case 138: {
                    this.jj_consume_token(138);
                    break;
                }
                case 139: {
                    this.jj_consume_token(139);
                    break;
                }
                case 140: {
                    this.jj_consume_token(140);
                    break;
                }
                case 141: {
                    this.jj_consume_token(141);
                    break;
                }
                case 142: {
                    this.jj_consume_token(142);
                    break;
                }
                case 143: {
                    this.jj_consume_token(143);
                    break;
                }
                case 144: {
                    this.jj_consume_token(144);
                    break;
                }
                case 53: 
                case 74: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 74: {
                            this.jj_consume_token(74);
                            not = true;
                            break;
                        }
                        default: {
                            this.jj_la1[91] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(53);
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Token hintToken = this.fetchHint(this.token, SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT, SqlppHint.HASH_BROADCAST_JOIN_HINT);
            if (hintToken != null) {
                switch (hintToken.hint) {
                    case INDEXED_NESTED_LOOP_JOIN_HINT: {
                        annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
                        break;
                    }
                    case SKIP_SECONDARY_INDEX_SEARCH_HINT: {
                        annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
                        break;
                    }
                    case HASH_BROADCAST_JOIN_HINT: {
                        annotation = new BroadcastExpressionAnnotation();
                        annotation.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
                    }
                }
            }
            if ((operator = this.token.image.toLowerCase()).equals("<>")) {
                operator = "!=";
            }
            if (not) {
                operator = "not_" + operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.BetweenExpr();
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression BetweenExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        IndexedNLJoinExpressionAnnotation annotation = null;
        operand = this.IsExpr();
        if (this.jj_2_7(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 74: {
                    this.jj_consume_token(74);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                }
            }
            this.jj_consume_token(10);
            Token hintToken = this.fetchHint(this.token, SqlppHint.INDEXED_NESTED_LOOP_JOIN_HINT, SqlppHint.SKIP_SECONDARY_INDEX_SEARCH_HINT);
            if (hintToken != null) {
                switch (hintToken.hint) {
                    case INDEXED_NESTED_LOOP_JOIN_HINT: {
                        annotation = IndexedNLJoinExpressionAnnotation.INSTANCE;
                        break;
                    }
                    case SKIP_SECONDARY_INDEX_SEARCH_HINT: {
                        annotation = SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE;
                    }
                }
            }
            String operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + operator;
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.IsExpr();
            op.addOperand(operand);
            this.jj_consume_token(3);
            operand = this.IsExpr();
            op.addOperator(OperatorType.AND);
            op.addOperand(operand);
        }
        if (annotation != null) {
            op.addHint(annotation);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression IsExpr() throws ParseException, ParseException {
        Token notToken = null;
        CallExpr expr = null;
        Expression operand = null;
        boolean not = false;
        FunctionIdentifier fn = null;
        operand = this.LikeExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 74: {
                        this.jj_consume_token(74);
                        not = true;
                        notToken = this.token;
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 151: {
                        this.jj_consume_token(151);
                        fn = BuiltinFunctions.IS_NULL;
                        break;
                    }
                    case 150: {
                        this.jj_consume_token(150);
                        fn = BuiltinFunctions.IS_MISSING;
                        break;
                    }
                    case 106: {
                        this.jj_consume_token(106);
                        fn = BuiltinFunctions.IS_UNKNOWN;
                        break;
                    }
                    case 64: 
                    case 113: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 64: {
                                this.jj_consume_token(64);
                                break;
                            }
                            case 113: {
                                this.jj_consume_token(113);
                                break;
                            }
                            default: {
                                this.jj_la1[95] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        not = !not;
                        fn = BuiltinFunctions.IS_UNKNOWN;
                        break;
                    }
                    default: {
                        this.jj_la1[96] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                FunctionSignature signature = new FunctionSignature(fn);
                expr = new CallExpr(signature, new ArrayList<Expression>(Collections.singletonList(operand)));
                SQLPPParser.addSourceLocation(expr, this.token);
                if (!not) break;
                FunctionSignature notSignature = new FunctionSignature(BuiltinFunctions.NOT);
                expr = new CallExpr(notSignature, new ArrayList<CallExpr>(Collections.singletonList(expr)));
                SQLPPParser.addSourceLocation(expr, notToken);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        if ("" != null) {
            return expr == null ? operand : expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression LikeExpr() throws ParseException, ParseException {
        boolean not = false;
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.ConcatExpr();
        if (this.jj_2_8(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 74: {
                    this.jj_consume_token(74);
                    not = true;
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                }
            }
            this.jj_consume_token(68);
            op = new OperatorExpr();
            op.addOperand(operand);
            op.setCurrentop(true);
            SQLPPParser.addSourceLocation(op, this.token);
            String operator = this.token.image.toLowerCase();
            if (not) {
                operator = "not_" + operator;
            }
            try {
                op.addOperator(operator);
            }
            catch (CompilationException e) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
            }
            operand = this.ConcatExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ConcatExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.AddExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: {
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(119);
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(OperatorType.CONCAT);
            operand = this.AddExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression AddExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        OperatorType opType = null;
        Expression operand = null;
        operand = this.MultExpr();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 121: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 123: {
                    this.jj_consume_token(123);
                    opType = OperatorType.PLUS;
                    break;
                }
                case 121: {
                    this.jj_consume_token(121);
                    opType = OperatorType.MINUS;
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(opType);
            operand = this.MultExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression MultExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        OperatorType opType = null;
        Expression operand = null;
        operand = this.ExponentExpr();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 29: 
                case 71: 
                case 120: 
                case 122: 
                case 133: {
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 122: {
                    this.jj_consume_token(122);
                    opType = OperatorType.MUL;
                    break;
                }
                case 120: {
                    this.jj_consume_token(120);
                    opType = OperatorType.DIVIDE;
                    break;
                }
                case 29: {
                    this.jj_consume_token(29);
                    opType = OperatorType.DIV;
                    break;
                }
                case 71: 
                case 133: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 71: {
                            this.jj_consume_token(71);
                            break;
                        }
                        case 133: {
                            this.jj_consume_token(133);
                            break;
                        }
                        default: {
                            this.jj_la1[103] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    opType = OperatorType.MOD;
                    break;
                }
                default: {
                    this.jj_la1[104] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (op == null) {
                op = new OperatorExpr();
                op.addOperand(operand);
                op.setCurrentop(true);
                SQLPPParser.addSourceLocation(op, this.token);
            }
            op.addOperator(opType);
            operand = this.ExponentExpr();
            op.addOperand(operand);
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ExponentExpr() throws ParseException, ParseException {
        OperatorExpr op = null;
        Expression operand = null;
        operand = this.UnaryExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                if (op == null) {
                    op = new OperatorExpr();
                    op.addOperand(operand);
                    op.setCurrentop(true);
                    SQLPPParser.addSourceLocation(op, this.token);
                }
                op.addOperator(OperatorType.CARET);
                operand = this.UnaryExpr();
                op.addOperand(operand);
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        if ("" != null) {
            return op == null ? operand : op;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression UnaryExpr() throws ParseException, ParseException {
        boolean not = false;
        UnaryExpr uexpr = null;
        Expression expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 74: 
            case 121: 
            case 123: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 123: {
                        this.jj_consume_token(123);
                        break;
                    }
                    case 121: {
                        this.jj_consume_token(121);
                        break;
                    }
                    case 38: 
                    case 74: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 74: {
                                this.jj_consume_token(74);
                                not = true;
                                break;
                            }
                            default: {
                                this.jj_la1[106] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(38);
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String exprType = this.token.image.toLowerCase();
                if (not) {
                    exprType = "not_" + exprType;
                }
                uexpr = new UnaryExpr();
                SQLPPParser.addSourceLocation(uexpr, this.token);
                try {
                    uexpr.setExprType(exprType);
                    break;
                }
                catch (CompilationException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), e.getMessage());
                }
            }
            default: {
                this.jj_la1[108] = this.jj_gen;
            }
        }
        expr = this.ValueExpr();
        if (uexpr == null) {
            if ("" != null) {
                return expr;
            }
        } else {
            uexpr.setExpr(expr);
            if ("" != null) {
                return uexpr;
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ValueExpr() throws ParseException, ParseException {
        Expression accessor;
        Expression expr;
        block9: {
            expr = null;
            accessor = null;
            expr = this.PrimaryExpr();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 126: 
                    case 132: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 132: {
                        accessor = this.FieldAccessor(accessor != null ? accessor : expr);
                        continue block7;
                    }
                    case 126: {
                        accessor = this.IndexAccessor(accessor != null ? accessor : expr);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[110] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return accessor == null ? expr : accessor;
        }
        throw new Error("Missing return statement in function");
    }

    public final FieldAccessor FieldAccessor(Expression inputExpr) throws ParseException, ParseException {
        Token startToken = null;
        String ident = null;
        this.jj_consume_token(132);
        startToken = this.token;
        ident = this.Identifier();
        FieldAccessor fa = new FieldAccessor(inputExpr, new Identifier(ident));
        if ("" != null) {
            return SQLPPParser.addSourceLocation(fa, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final AbstractAccessor IndexAccessor(Expression inputExpr) throws ParseException, ParseException {
        Literal lit;
        Token startToken = null;
        boolean isListSliceExpression = false;
        Object resultExpression = null;
        Expression argumentExpression1 = null;
        Expression argumentExpression2 = null;
        this.jj_consume_token(126);
        startToken = this.token;
        argumentExpression1 = this.Expression();
        if (argumentExpression1.getKind() == Expression.Kind.LITERAL_EXPRESSION && (lit = ((LiteralExpr)argumentExpression1).getValue()).getLiteralType() != Literal.Type.INTEGER && lit.getLiteralType() != Literal.Type.LONG) {
            throw new SqlppParseException(argumentExpression1.getSourceLocation(), "Index should be an INTEGER");
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 129: {
                this.jj_consume_token(129);
                isListSliceExpression = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 13: 
                    case 36: 
                    case 38: 
                    case 74: 
                    case 97: 
                    case 121: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 134: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 156: 
                    case 161: 
                    case 162: 
                    case 172: {
                        argumentExpression2 = this.Expression();
                        if (argumentExpression2.getKind() != Expression.Kind.LITERAL_EXPRESSION || (lit = ((LiteralExpr)argumentExpression2).getValue()).getLiteralType() == Literal.Type.INTEGER || lit.getLiteralType() == Literal.Type.LONG) break block0;
                        throw new SqlppParseException(argumentExpression2.getSourceLocation(), "Index should be an INTEGER");
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
            }
        }
        this.jj_consume_token(127);
        resultExpression = !isListSliceExpression ? new IndexAccessor(inputExpr, argumentExpression1) : new ListSliceExpression(inputExpr, argumentExpression1, argumentExpression2);
        if ("" != null) {
            return (AbstractAccessor)SQLPPParser.addSourceLocation(resultExpression, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression PrimaryExpr() throws ParseException, ParseException {
        Expression expr = null;
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            expr = this.FunctionCallExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    expr = this.CaseExpr();
                    break;
                }
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 156: 
                case 162: {
                    expr = this.Literal();
                    break;
                }
                case 161: 
                case 172: {
                    expr = this.VariableRef();
                    break;
                }
                case 131: 
                case 134: {
                    expr = this.ExternalVariableRef();
                    break;
                }
                case 126: 
                case 147: {
                    expr = this.ListConstructor();
                    break;
                }
                case 145: {
                    expr = this.RecordConstructor();
                    break;
                }
                case 124: {
                    expr = this.ParenthesizedExpression();
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression Literal() throws ParseException, ParseException {
        LiteralExpr lit = new LiteralExpr();
        String str = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 162: {
                str = this.StringLiteral();
                lit.setValue((Literal)new StringLiteral(str));
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                try {
                    lit.setValue((Literal)new LongIntegerLiteral(Long.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + '\"');
                }
            }
            case 156: {
                this.jj_consume_token(156);
                try {
                    lit.setValue((Literal)new FloatLiteral(Float.valueOf(this.token.image)));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + '\"');
                }
            }
            case 155: {
                this.jj_consume_token(155);
                try {
                    lit.setValue((Literal)new DoubleLiteral(Double.valueOf(this.token.image).doubleValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Could not parse numeric literal \"" + LogRedactionUtil.userData((String)this.token.image) + '\"');
                }
            }
            case 150: {
                this.jj_consume_token(150);
                lit.setValue((Literal)MissingLiteral.INSTANCE);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                lit.setValue((Literal)NullLiteral.INSTANCE);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                lit.setValue((Literal)TrueLiteral.INSTANCE);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                lit.setValue((Literal)FalseLiteral.INSTANCE);
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return (Expression)SQLPPParser.addSourceLocation(lit, this.token);
        }
        throw new Error("Missing return statement in function");
    }

    public final VariableExpr VariableRef() throws ParseException, ParseException {
        VariableExpr varExp;
        String id = null;
        id = this.VariableIdentifier();
        Identifier ident = this.lookupSymbol(id);
        if (this.isInForbiddenScopes(id)) {
            throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
        if (ident != null) {
            varExp = new VariableExpr((VarIdentifier)ident);
        } else {
            varExp = new VariableExpr(new VarIdentifier(id));
            varExp.setIsNewVar(false);
        }
        if ("" != null) {
            return SQLPPParser.addSourceLocation(varExp, this.token);
        }
        throw new Error("Missing return statement in function");
    }

    public final VariableExpr Variable() throws ParseException, ParseException {
        String id = null;
        id = this.VariableIdentifier();
        Identifier ident = this.lookupSymbol(id);
        VariableExpr varExp = new VariableExpr(new VarIdentifier(id));
        if (ident != null) {
            varExp.setIsNewVar(false);
        }
        if ("" != null) {
            return SQLPPParser.addSourceLocation(varExp, this.token);
        }
        throw new Error("Missing return statement in function");
    }

    public final String VariableIdentifier() throws ParseException, ParseException {
        String id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 172: {
                this.jj_consume_token(172);
                id = this.token.image;
                break;
            }
            case 161: {
                id = this.QuotedString();
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return SqlppVariableUtil.toInternalVariableName(id);
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<VariableExpr, List<Pair<Expression, Identifier>>> VariableWithFieldMap() throws ParseException, ParseException {
        VariableExpr var = null;
        ArrayList<Pair> fieldList = new ArrayList<Pair>();
        var = this.Variable();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                VariableExpr fieldVarExpr = null;
                String fieldIdentifierStr = null;
                this.jj_consume_token(124);
                fieldVarExpr = this.VariableRef();
                this.jj_consume_token(6);
                fieldIdentifierStr = this.Identifier();
                fieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[116] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(130);
                    fieldVarExpr = this.VariableRef();
                    this.jj_consume_token(6);
                    fieldIdentifierStr = this.Identifier();
                    fieldList.add(new Pair((Object)fieldVarExpr, (Object)new Identifier(fieldIdentifierStr)));
                }
                this.jj_consume_token(125);
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new Pair((Object)var, fieldList);
        }
        throw new Error("Missing return statement in function");
    }

    public final VariableExpr ExternalVariableRef() throws ParseException, ParseException {
        String name = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 149: {
                        this.jj_consume_token(149);
                        name = this.token.image;
                        break block0;
                    }
                    case 172: {
                        this.jj_consume_token(172);
                        name = this.token.image;
                        break block0;
                    }
                    case 161: {
                        name = this.QuotedString();
                        break block0;
                    }
                }
                this.jj_la1[118] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 134: {
                this.jj_consume_token(134);
                name = String.valueOf(++this.externalVarCounter);
                break;
            }
            default: {
                this.jj_la1[119] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String idName = SqlppVariableUtil.toExternalVariableName(name);
        VarIdentifier id = new VarIdentifier(idName);
        VariableExpr varExp = new VariableExpr(id);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(varExp, this.token);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ListConstructor() throws ParseException, ParseException {
        ListConstructor expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 126: {
                expr = this.OrderedListConstructor();
                break;
            }
            case 147: {
                expr = this.UnorderedListConstructor();
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final ListConstructor OrderedListConstructor() throws ParseException, ParseException {
        Token startToken = null;
        List<Expression> exprList = null;
        this.jj_consume_token(126);
        startToken = this.token;
        exprList = this.ExpressionList();
        this.jj_consume_token(127);
        ListConstructor expr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, exprList);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(expr, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final ListConstructor UnorderedListConstructor() throws ParseException, ParseException {
        Token startToken = null;
        List<Expression> exprList = null;
        this.jj_consume_token(147);
        startToken = this.token;
        exprList = this.ExpressionList();
        this.jj_consume_token(148);
        ListConstructor expr = new ListConstructor(ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR, exprList);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(expr, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<Expression> ExpressionList() throws ParseException, ParseException {
        Expression expr = null;
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                expr = this.Expression();
                exprList.add(expr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[121] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    expr = this.Expression();
                    exprList.add(expr);
                }
            }
            default: {
                this.jj_la1[122] = this.jj_gen;
            }
        }
        if ("" != null) {
            return exprList;
        }
        throw new Error("Missing return statement in function");
    }

    public final RecordConstructor RecordConstructor() throws ParseException, ParseException {
        Token startToken = null;
        FieldBinding fb = null;
        ArrayList<FieldBinding> fbList = new ArrayList<FieldBinding>();
        this.jj_consume_token(145);
        startToken = this.token;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                fb = this.FieldBinding();
                fbList.add(fb);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[123] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    fb = this.FieldBinding();
                    fbList.add(fb);
                }
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
            }
        }
        this.jj_consume_token(146);
        RecordConstructor expr = new RecordConstructor(fbList);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(expr, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FieldBinding FieldBinding() throws ParseException, ParseException {
        Expression right = null;
        Expression left = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 129: {
                this.jj_consume_token(129);
                right = this.Expression();
                break;
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
            }
        }
        if (right == null) {
            String generatedIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier(left, false);
            if (generatedIdentifier == null) {
                throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "Cannot infer field name");
            }
            String generatedName = SqlppVariableUtil.toUserDefinedName(generatedIdentifier);
            LiteralExpr generatedNameExpr = new LiteralExpr((Literal)new StringLiteral(generatedName));
            generatedNameExpr.setSourceLocation(left.getSourceLocation());
            if ("" != null) {
                return new FieldBinding((Expression)generatedNameExpr, left);
            }
        } else if ("" != null) {
            return new FieldBinding(left, right);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression FunctionCallExpr() throws ParseException, ParseException {
        int arity;
        String fqFunctionName;
        FunctionSignature signature;
        ArrayList<Expression> argList = new ArrayList<Expression>();
        Expression argExpr = null;
        FunctionName funcName = null;
        boolean star = false;
        boolean distinct = false;
        Expression filterExpr = null;
        WindowExpression windowExpr = null;
        funcName = this.FunctionName();
        this.jj_consume_token(124);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 28: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[126] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 13: 
                    case 36: 
                    case 38: 
                    case 74: 
                    case 97: 
                    case 121: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 134: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 156: 
                    case 161: 
                    case 162: 
                    case 172: {
                        argExpr = this.Expression();
                        break;
                    }
                    case 122: {
                        this.jj_consume_token(122);
                        star = true;
                        break;
                    }
                    default: {
                        this.jj_la1[127] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (star) {
                    if (funcName.function.equalsIgnoreCase(BuiltinFunctions.SCALAR_COUNT.getName())) {
                        argExpr = new LiteralExpr((Literal)new LongIntegerLiteral(Long.valueOf(1L)));
                    } else {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(this.token), "The parameter * can only be used in " + BuiltinFunctions.SCALAR_COUNT.getName() + "().");
                    }
                }
                argList.add(argExpr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[128] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    argExpr = this.Expression();
                    argList.add(argExpr);
                }
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
            }
        }
        this.jj_consume_token(125);
        String name = funcName.function;
        if (distinct) {
            name = name + "-distinct";
        }
        if ((signature = this.lookupFunctionSignature(funcName.dataverse, fqFunctionName = funcName.library == null ? name : funcName.library + "#" + name, arity = argList.size())) == null) {
            signature = new FunctionSignature(funcName.dataverse, fqFunctionName, arity);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                this.jj_consume_token(124);
                this.jj_consume_token(115);
                filterExpr = this.Expression();
                this.jj_consume_token(125);
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
            }
        }
        if (this.jj_2_10(5)) {
            windowExpr = this.WindowExpr(signature, argList, filterExpr);
        }
        if (windowExpr != null) {
            if ("" != null) {
                return windowExpr;
            }
        } else {
            CallExpr callExpr = new CallExpr(signature, argList, filterExpr);
            if (funcName.hint != null) {
                switch (funcName.hint) {
                    case INDEXED_NESTED_LOOP_JOIN_HINT: {
                        callExpr.addHint((IExpressionAnnotation)IndexedNLJoinExpressionAnnotation.INSTANCE);
                        break;
                    }
                    case SKIP_SECONDARY_INDEX_SEARCH_HINT: {
                        callExpr.addHint((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE);
                    }
                }
            }
            FunctionMapUtil.normalizedListInputFunctions(callExpr);
            callExpr.setSourceLocation(funcName.sourceLoc);
            if ("" != null) {
                return callExpr;
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final WindowExpression WindowExpr(FunctionSignature signature, List<Expression> argList, Expression aggFilterExpr) throws ParseException, ParseException {
        Boolean fromLast = null;
        Boolean ignoreNulls = null;
        if (this.jj_2_11(5)) {
            this.jj_consume_token(44);
            this.jj_consume_token(172);
            if (this.isToken(FIRST)) {
                fromLast = false;
            } else if (this.isToken(LAST)) {
                fromLast = true;
            } else {
                throw this.createUnexpectedTokenError();
            }
        }
        if (this.jj_2_12(3)) {
            this.jj_consume_token(172);
            if (this.isToken(RESPECT)) {
                ignoreNulls = false;
            } else if (this.isToken(IGNORE)) {
                ignoreNulls = true;
            } else {
                throw this.createUnexpectedTokenError();
            }
            this.jj_consume_token(172);
            if (!this.isToken(NULLS)) {
                throw this.createUnexpectedTokenError();
            }
        }
        this.jj_consume_token(82);
        if ("" != null) {
            return this.OverClause(signature, argList, aggFilterExpr, this.token, fromLast, ignoreNulls);
        }
        throw new Error("Missing return statement in function");
    }

    public final WindowExpression OverClause(FunctionSignature signature, List<Expression> argList, Expression aggFilterExpr, Token startToken, Boolean fromLast, Boolean ignoreNulls) throws ParseException, ParseException {
        Expression partitionExpr = null;
        ArrayList<Expression> partitionExprs = new ArrayList<Expression>();
        OrderbyClause orderByClause = null;
        List orderbyList = null;
        List orderbyModifierList = null;
        WindowExpression.FrameMode frameMode = null;
        Pair<WindowExpression.FrameBoundaryKind, Expression> frameStart = null;
        Pair<WindowExpression.FrameBoundaryKind, Expression> frameEnd = null;
        WindowExpression.FrameBoundaryKind frameStartKind = null;
        WindowExpression.FrameBoundaryKind frameEndKind = null;
        Expression frameStartExpr = null;
        Expression frameEndExpr = null;
        WindowExpression.FrameExclusionKind frameExclusionKind = null;
        Pair<VariableExpr, List<Pair<Expression, Identifier>>> windowVarWithFieldList = null;
        VariableExpr windowVar = null;
        List windowFieldList = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: 
            case 172: {
                windowVarWithFieldList = this.VariableWithFieldMap();
                this.jj_consume_token(6);
                windowVar = (VariableExpr)windowVarWithFieldList.first;
                windowFieldList = (List)windowVarWithFieldList.second;
                break;
            }
            default: {
                this.jj_la1[131] = this.jj_gen;
            }
        }
        this.jj_consume_token(124);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 172: {
                this.jj_consume_token(172);
                this.expectToken(PARTITION);
                this.jj_consume_token(12);
                partitionExpr = this.Expression();
                partitionExprs.add(partitionExpr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[132] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(130);
                    partitionExpr = this.Expression();
                    partitionExprs.add(partitionExpr);
                }
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                orderByClause = this.OrderbyClause();
                orderbyList = orderByClause.getOrderbyList();
                orderbyModifierList = orderByClause.getModifierList();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 172: {
                        frameMode = this.WindowFrameMode();
                        if (this.jj_2_13(1)) {
                            frameStart = this.WindowFrameBoundary();
                        } else {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 10: {
                                    this.jj_consume_token(10);
                                    frameStart = this.WindowFrameBoundary();
                                    this.jj_consume_token(3);
                                    frameEnd = this.WindowFrameBoundary();
                                    break;
                                }
                                default: {
                                    this.jj_la1[134] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 172: {
                                frameExclusionKind = this.WindowFrameExclusion();
                                break;
                            }
                            default: {
                                this.jj_la1[135] = this.jj_gen;
                            }
                        }
                        frameStartKind = (WindowExpression.FrameBoundaryKind)((Object)frameStart.first);
                        frameStartExpr = (Expression)frameStart.second;
                        if (frameEnd == null) {
                            frameEndKind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
                        } else {
                            frameEndKind = (WindowExpression.FrameBoundaryKind)((Object)frameEnd.first);
                            frameEndExpr = (Expression)frameEnd.second;
                        }
                        if (frameExclusionKind != null) break block9;
                        frameExclusionKind = WindowExpression.FrameExclusionKind.NO_OTHERS;
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
            }
        }
        this.jj_consume_token(125);
        WindowExpression winExpr = new WindowExpression(signature, argList, aggFilterExpr, partitionExprs, orderbyList, orderbyModifierList, frameMode, frameStartKind, frameStartExpr, frameEndKind, frameEndExpr, frameExclusionKind, windowVar, windowFieldList, ignoreNulls, fromLast);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(winExpr, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final WindowExpression.FrameMode WindowFrameMode() throws ParseException, ParseException {
        this.jj_consume_token(172);
        if (this.isToken(RANGE)) {
            if ("" != null) {
                return WindowExpression.FrameMode.RANGE;
            }
        } else if (this.isToken(ROWS)) {
            if ("" != null) {
                return WindowExpression.FrameMode.ROWS;
            }
        } else if (this.isToken(GROUPS)) {
            if ("" != null) {
                return WindowExpression.FrameMode.GROUPS;
            }
        } else {
            throw this.createUnexpectedTokenError();
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair<WindowExpression.FrameBoundaryKind, Expression> WindowFrameBoundary() throws ParseException, ParseException {
        WindowExpression.FrameBoundaryKind kind;
        boolean current = false;
        Expression expr = null;
        if (this.laIdentifier(CURRENT) || this.laIdentifier(UNBOUNDED)) {
            this.jj_consume_token(172);
            current = this.isToken(CURRENT);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 13: 
                case 36: 
                case 38: 
                case 74: 
                case 97: 
                case 121: 
                case 123: 
                case 124: 
                case 126: 
                case 131: 
                case 134: 
                case 145: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 156: 
                case 161: 
                case 162: 
                case 172: {
                    expr = this.Expression();
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(172);
        if (current && this.isToken(ROW)) {
            kind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
        } else if (!current && this.isToken(PRECEDING)) {
            kind = expr == null ? WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING : WindowExpression.FrameBoundaryKind.BOUNDED_PRECEDING;
        } else if (!current && this.isToken(FOLLOWING)) {
            kind = expr == null ? WindowExpression.FrameBoundaryKind.UNBOUNDED_FOLLOWING : WindowExpression.FrameBoundaryKind.BOUNDED_FOLLOWING;
        } else {
            throw this.createUnexpectedTokenError();
        }
        if ("" != null) {
            return new Pair((Object)kind, (Object)expr);
        }
        throw new Error("Missing return statement in function");
    }

    public final WindowExpression.FrameExclusionKind WindowFrameExclusion() throws ParseException, ParseException {
        boolean current = false;
        boolean no = false;
        this.jj_consume_token(172);
        this.expectToken(EXCLUDE);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                if ("" == null) break;
                return WindowExpression.FrameExclusionKind.GROUP;
            }
            case 172: {
                this.jj_consume_token(172);
                if (this.isToken(TIES)) {
                    if ("" != null) {
                        return WindowExpression.FrameExclusionKind.TIES;
                    }
                } else if (this.isToken(CURRENT)) {
                    current = true;
                } else if (this.isToken(NO)) {
                    no = true;
                } else {
                    throw this.createUnexpectedTokenError();
                }
                this.jj_consume_token(172);
                if (current && this.isToken(ROW)) {
                    if ("" == null) break;
                    return WindowExpression.FrameExclusionKind.CURRENT_ROW;
                }
                if (no && this.isToken(OTHERS)) {
                    if ("" == null) break;
                    return WindowExpression.FrameExclusionKind.NO_OTHERS;
                }
                throw this.createUnexpectedTokenError();
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression ParenthesizedExpression() throws ParseException, ParseException {
        Object expr;
        if (this.jj_2_14(2)) {
            this.jj_consume_token(124);
            expr = this.Expression();
            this.jj_consume_token(125);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 124: {
                    expr = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expression CaseExpr() throws ParseException, ParseException {
        Token startToken = null;
        Expression conditionExpr = null;
        ArrayList<Expression> whenExprs = new ArrayList<Expression>();
        ArrayList<Expression> thenExprs = new ArrayList<Expression>();
        Expression elseExpr = null;
        Expression whenExpr = null;
        Expression thenExpr = null;
        this.jj_consume_token(13);
        startToken = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                conditionExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: {
                    break;
                }
                default: {
                    this.jj_la1[142] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(114);
            whenExpr = this.Expression();
            whenExprs.add(whenExpr);
            this.jj_consume_token(102);
            thenExpr = this.Expression();
            thenExprs.add(thenExpr);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                elseExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
            }
        }
        this.jj_consume_token(35);
        if (conditionExpr == null) {
            LiteralExpr litExpr = new LiteralExpr((Literal)TrueLiteral.INSTANCE);
            conditionExpr = (Expression)SQLPPParser.addSourceLocation(litExpr, startToken);
        }
        CaseExpression caseExpr = new CaseExpression(conditionExpr, whenExprs, thenExprs, elseExpr);
        if ("" != null) {
            return (Expression)SQLPPParser.addSourceLocation(caseExpr, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectExpression SelectExpression(boolean subquery) throws ParseException, ParseException {
        ArrayList<LetClause> letClauses = new ArrayList();
        OrderbyClause orderbyClause = null;
        LimitClause limitClause = null;
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: 
            case 67: 
            case 116: {
                letClauses = this.LetClause();
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
            }
        }
        SelectSetOperation selectSetOperation = this.SelectSetOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                orderbyClause = this.OrderbyClause();
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                limitClause = this.LimitClause();
                break;
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
            }
        }
        SelectExpression selectExpr = new SelectExpression(letClauses, selectSetOperation, orderbyClause, limitClause, subquery);
        selectExpr.setSourceLocation((!letClauses.isEmpty() ? (AbstractClause)letClauses.get(0) : selectSetOperation).getSourceLocation());
        if ("" != null) {
            return selectExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectSetOperation SelectSetOperation() throws ParseException, ParseException {
        ArrayList<SetOperationRight> setOperationRights = new ArrayList<SetOperationRight>();
        SelectBlock selectBlockLeft = null;
        SelectExpression subqueryLeft = null;
        Object expr = null;
        selectBlockLeft = this.SelectBlock();
        SetOperationInput setOperationInputLeft = new SetOperationInput(selectBlockLeft, subqueryLeft);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: 
                case 59: 
                case 105: {
                    break;
                }
                default: {
                    this.jj_la1[147] = this.jj_gen;
                    break block15;
                }
            }
            SetOpType opType = SetOpType.UNION;
            boolean setSemantics = true;
            SelectBlock selectBlockRight = null;
            SelectExpression subqueryRight = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 105: {
                    this.jj_consume_token(105);
                    opType = SetOpType.UNION;
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    opType = SetOpType.INTERSECT;
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    opType = SetOpType.EXCEPT;
                    break;
                }
                default: {
                    this.jj_la1[148] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: {
                    this.jj_consume_token(2);
                    setSemantics = false;
                    break;
                }
                default: {
                    this.jj_la1[149] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: 
                case 95: {
                    selectBlockRight = this.SelectBlock();
                    break;
                }
                case 124: {
                    subqueryRight = this.Subquery();
                    break;
                }
                default: {
                    this.jj_la1[150] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            setOperationRights.add(new SetOperationRight(opType, setSemantics, new SetOperationInput(selectBlockRight, subqueryRight)));
        }
        SelectSetOperation selectSetOp = new SelectSetOperation(setOperationInputLeft, setOperationRights);
        selectSetOp.setSourceLocation(selectBlockLeft.getSourceLocation());
        if ("" != null) {
            return selectSetOp;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectExpression Subquery() throws ParseException, ParseException {
        SelectExpression selectExpr = null;
        this.jj_consume_token(124);
        selectExpr = this.SelectExpression(true);
        this.jj_consume_token(125);
        if ("" != null) {
            return selectExpr;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectBlock SelectBlock() throws ParseException, ParseException {
        SelectClause selectClause = null;
        FromClause fromClause = null;
        List<LetClause> fromLetClauses = null;
        WhereClause whereClause = null;
        ArrayList<AbstractClause> fromLetWhereClauses = new ArrayList<AbstractClause>();
        GroupbyClause groupbyClause = null;
        List<LetClause> gbyLetClauses = null;
        HavingClause havingClause = null;
        ArrayList<AbstractClause> gbyLetHavingClauses = new ArrayList<AbstractClause>();
        SourceLocation startSrcLoc = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95: {
                selectClause = this.SelectClause();
                startSrcLoc = selectClause.getSourceLocation();
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 44: 
                    case 66: 
                    case 67: 
                    case 116: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 44: {
                                fromClause = this.FromClause();
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 66: 
                                    case 67: 
                                    case 116: {
                                        fromLetClauses = this.LetClause();
                                        break block4;
                                    }
                                }
                                this.jj_la1[151] = this.jj_gen;
                                break block4;
                            }
                            case 66: 
                            case 67: 
                            case 116: {
                                fromLetClauses = this.LetClause();
                                SourceLocation sourceLoc = SQLPPParser.getSourceLocation(this.token);
                                LiteralExpr missingExpr = new LiteralExpr((Literal)MissingLiteral.INSTANCE);
                                missingExpr.setSourceLocation(sourceLoc);
                                ArrayList<LiteralExpr> list = new ArrayList<LiteralExpr>(1);
                                list.add(missingExpr);
                                ListConstructor listExpr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, list);
                                listExpr.setSourceLocation(sourceLoc);
                                ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>(1);
                                VariableExpr fromVar = new VariableExpr(new VarIdentifier("#0"));
                                fromVar.setSourceLocation(sourceLoc);
                                fromTerms.add(new FromTerm((Expression)listExpr, fromVar, null, new ArrayList<AbstractBinaryCorrelateClause>()));
                                fromClause = new FromClause(fromTerms);
                                break block4;
                            }
                        }
                        this.jj_la1[152] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[153] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 115: {
                        whereClause = this.WhereClause();
                        break;
                    }
                    default: {
                        this.jj_la1[154] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        groupbyClause = this.GroupbyClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 66: 
                            case 67: 
                            case 116: {
                                gbyLetClauses = this.LetClause();
                                break;
                            }
                            default: {
                                this.jj_la1[155] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 49: {
                                havingClause = this.HavingClause();
                                break block0;
                            }
                        }
                        this.jj_la1[156] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[157] = this.jj_gen;
                break;
            }
            case 44: {
                fromClause = this.FromClause();
                startSrcLoc = fromClause.getSourceLocation();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 66: 
                    case 67: 
                    case 116: {
                        fromLetClauses = this.LetClause();
                        break;
                    }
                    default: {
                        this.jj_la1[158] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 115: {
                        whereClause = this.WhereClause();
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                    }
                }
                block32 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        groupbyClause = this.GroupbyClause();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 66: 
                            case 67: 
                            case 116: {
                                gbyLetClauses = this.LetClause();
                                break;
                            }
                            default: {
                                this.jj_la1[160] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 49: {
                                havingClause = this.HavingClause();
                                break block32;
                            }
                        }
                        this.jj_la1[161] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[162] = this.jj_gen;
                    }
                }
                selectClause = this.SelectClause();
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (fromLetClauses != null) {
            fromLetWhereClauses.addAll(fromLetClauses);
        }
        if (whereClause != null) {
            fromLetWhereClauses.add((AbstractClause)whereClause);
        }
        if (gbyLetClauses != null) {
            gbyLetHavingClauses.addAll(gbyLetClauses);
        }
        if (havingClause != null) {
            gbyLetHavingClauses.add(havingClause);
        }
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, fromLetWhereClauses, groupbyClause, gbyLetHavingClauses);
        selectBlock.setSourceLocation(startSrcLoc);
        if ("" != null) {
            return selectBlock;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectClause SelectClause() throws ParseException, ParseException {
        Token startToken = null;
        SelectRegular selectRegular = null;
        SelectElement selectElement = null;
        boolean distinct = false;
        this.jj_consume_token(95);
        startToken = this.token;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 28: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        distinct = true;
                        break block0;
                    }
                }
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[165] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 31: 
            case 36: 
            case 38: 
            case 74: 
            case 87: 
            case 97: 
            case 112: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 13: 
                    case 36: 
                    case 38: 
                    case 74: 
                    case 97: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 134: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 156: 
                    case 161: 
                    case 162: 
                    case 172: {
                        selectRegular = this.SelectRegular();
                        break block7;
                    }
                    case 31: 
                    case 87: 
                    case 112: {
                        selectElement = this.SelectElement();
                        break block7;
                    }
                }
                this.jj_la1[166] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
            }
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(startToken);
        if (selectRegular == null && selectElement == null) {
            Projection projection = new Projection(null, null, true, false);
            projection.setSourceLocation(sourceLoc);
            ArrayList<Projection> projections = new ArrayList<Projection>();
            projections.add(projection);
            selectRegular = new SelectRegular(projections);
            selectRegular.setSourceLocation(sourceLoc);
        }
        SelectClause selectClause = new SelectClause(selectElement, selectRegular, distinct);
        selectClause.setSourceLocation(sourceLoc);
        if ("" != null) {
            return selectClause;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectRegular SelectRegular() throws ParseException, ParseException {
        SourceLocation startSrcLoc = null;
        ArrayList<Projection> projections = new ArrayList<Projection>();
        Projection projection = null;
        projection = this.Projection();
        projections.add(projection);
        startSrcLoc = projection.getSourceLocation();
        while (this.jj_2_15(2)) {
            this.jj_consume_token(130);
            projection = this.Projection();
            projections.add(projection);
        }
        SelectRegular selectRegular = new SelectRegular(projections);
        selectRegular.setSourceLocation(startSrcLoc);
        if ("" != null) {
            return selectRegular;
        }
        throw new Error("Missing return statement in function");
    }

    public final SelectElement SelectElement() throws ParseException, ParseException {
        Token startToken = null;
        Expression expr = null;
        Object name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        startToken = this.token;
        expr = this.Expression();
        SelectElement selectElement = new SelectElement(expr);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(selectElement, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final Projection Projection() throws ParseException, ParseException {
        SourceLocation startSrcLoc = null;
        VariableExpr expr = null;
        Object identifier = null;
        String name = null;
        boolean star = false;
        boolean varStar = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                star = true;
                startSrcLoc = SQLPPParser.getSourceLocation(this.token);
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
                if (this.jj_2_16(3)) {
                    expr = this.VariableRef();
                    this.jj_consume_token(132);
                    this.jj_consume_token(122);
                    varStar = true;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 13: 
                    case 36: 
                    case 38: 
                    case 74: 
                    case 97: 
                    case 121: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 131: 
                    case 134: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 156: 
                    case 161: 
                    case 162: 
                    case 172: {
                        String generatedColumnIdentifier;
                        expr = this.Expression();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 6: 
                            case 161: 
                            case 172: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 6: {
                                        this.jj_consume_token(6);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[169] = this.jj_gen;
                                    }
                                }
                                name = this.Identifier();
                                break;
                            }
                            default: {
                                this.jj_la1[170] = this.jj_gen;
                            }
                        }
                        if (name != null || (generatedColumnIdentifier = ExpressionToVariableUtil.getGeneratedIdentifier((Expression)expr, false)) == null) break block0;
                        name = SqlppVariableUtil.toUserDefinedName(generatedColumnIdentifier);
                        break block0;
                    }
                    default: {
                        this.jj_la1[172] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        Projection projection = new Projection((Expression)expr, name, star, varStar);
        projection.setSourceLocation(expr != null ? expr.getSourceLocation() : startSrcLoc);
        if ("" != null) {
            return projection;
        }
        throw new Error("Missing return statement in function");
    }

    public final FromClause FromClause() throws ParseException, ParseException {
        Token startToken = null;
        ArrayList<FromTerm> fromTerms = new ArrayList<FromTerm>();
        this.extendCurrentScope();
        FromTerm fromTerm = null;
        this.jj_consume_token(44);
        startToken = this.token;
        fromTerm = this.FromTerm();
        fromTerms.add(fromTerm);
        while (this.jj_2_17(2)) {
            this.jj_consume_token(130);
            fromTerm = this.FromTerm();
            fromTerms.add(fromTerm);
        }
        FromClause fromClause = new FromClause(fromTerms);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(fromClause, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final FromTerm FromTerm() throws ParseException, ParseException {
        Expression leftExpr = null;
        VariableExpr leftVar = null;
        VariableExpr posVar = null;
        ArrayList<AbstractBinaryCorrelateClause> correlateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        leftExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 161: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[173] = this.jj_gen;
                    }
                }
                leftVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[175] = this.jj_gen;
            }
        }
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 19: 
                case 42: 
                case 56: 
                case 61: 
                case 65: 
                case 107: {
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    break block19;
                }
            }
            JoinType joinType = JoinType.INNER;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 56: 
                case 65: {
                    joinType = this.JoinType();
                    break;
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                }
            }
            AbstractBinaryCorrelateClause correlateClause = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 61: {
                    correlateClause = this.JoinClause(joinType);
                    break;
                }
                case 19: 
                case 42: 
                case 107: {
                    correlateClause = this.UnnestClause(joinType);
                    break;
                }
                default: {
                    this.jj_la1[178] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            correlateClauses.add(correlateClause);
        }
        if (leftVar == null) {
            leftVar = ExpressionToVariableUtil.getGeneratedVariable(leftExpr, true);
        }
        FromTerm fromTerm = new FromTerm(leftExpr, leftVar, posVar, correlateClauses);
        fromTerm.setSourceLocation(leftExpr.getSourceLocation());
        if ("" != null) {
            return fromTerm;
        }
        throw new Error("Missing return statement in function");
    }

    public final JoinClause JoinClause(JoinType joinType) throws ParseException, ParseException {
        Token startToken = null;
        Expression rightExpr = null;
        VariableExpr rightVar = null;
        VariableExpr posVar = null;
        Expression conditionExpr = null;
        this.jj_consume_token(61);
        startToken = this.token;
        rightExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 161: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[179] = this.jj_gen;
                    }
                }
                rightVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[180] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
            }
        }
        this.jj_consume_token(76);
        conditionExpr = this.Expression();
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        JoinClause joinClause = new JoinClause(joinType, rightExpr, rightVar, posVar, conditionExpr);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(joinClause, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final UnnestClause UnnestClause(JoinType joinType) throws ParseException, ParseException {
        Token startToken = null;
        VariableExpr posVar = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        startToken = this.token;
        Expression rightExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
            }
        }
        VariableExpr rightVar = this.Variable();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                posVar = this.Variable();
                break;
            }
            default: {
                this.jj_la1[184] = this.jj_gen;
            }
        }
        if (rightVar == null) {
            rightVar = ExpressionToVariableUtil.getGeneratedVariable(rightExpr, true);
        }
        UnnestClause unnestClause = new UnnestClause(joinType, rightExpr, rightVar, posVar);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(unnestClause, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final JoinType JoinType() throws ParseException, ParseException {
        JoinType joinType = JoinType.INNER;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 80: {
                        this.jj_consume_token(80);
                        break;
                    }
                    default: {
                        this.jj_la1[185] = this.jj_gen;
                    }
                }
                joinType = JoinType.LEFTOUTER;
                break;
            }
            default: {
                this.jj_la1[186] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return joinType;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<LetClause> LetClause() throws ParseException, ParseException {
        ArrayList<LetClause> letList = new ArrayList<LetClause>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: 
            case 67: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 67: {
                        this.jj_consume_token(67);
                        break;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    default: {
                        this.jj_la1[187] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                LetClause letClause = this.LetElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[188] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    letClause = this.LetElement();
                    letList.add(letClause);
                }
            }
            case 116: {
                this.jj_consume_token(116);
                LetClause letClause = this.WithElement();
                letList.add(letClause);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            break;
                        }
                        default: {
                            this.jj_la1[189] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(130);
                    letClause = this.WithElement();
                    letList.add(letClause);
                }
            }
            default: {
                this.jj_la1[190] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return letList;
        }
        throw new Error("Missing return statement in function");
    }

    public final WhereClause WhereClause() throws ParseException, ParseException {
        Token startToken = null;
        this.jj_consume_token(115);
        startToken = this.token;
        Expression whereExpr = this.Expression();
        WhereClause wc = new WhereClause(whereExpr);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(wc, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final OrderbyClause OrderbyClause() throws ParseException, ParseException {
        Token startToken = null;
        OrderbyClause oc = new OrderbyClause();
        ArrayList<Expression> orderbyList = new ArrayList<Expression>();
        ArrayList<OrderbyClause.OrderModifier> modifierList = new ArrayList<OrderbyClause.OrderModifier>();
        boolean numOfOrderby = false;
        this.jj_consume_token(79);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.INMEMORY_HINT, SqlppHint.RANGE_HINT);
        if (hintToken != null) {
            switch (hintToken.hint) {
                case INMEMORY_HINT: {
                    String[] splits = hintToken.hintParams.split("\\s+");
                    int numFrames = Integer.parseInt(splits[0]);
                    int numTuples = Integer.parseInt(splits[1]);
                    oc.setNumFrames(numFrames);
                    oc.setNumTuples(numTuples);
                    break;
                }
                case RANGE_HINT: {
                    try {
                        oc.setRangeMap(RangeMapBuilder.parseHint((Expression)SQLPPParser.parseExpression(hintToken.hintParams)));
                        break;
                    }
                    catch (CompilationException e) {
                        throw new SqlppParseException(SQLPPParser.getSourceLocation(hintToken), e.getMessage());
                    }
                }
            }
        }
        this.jj_consume_token(12);
        Expression orderbyExpr = this.Expression();
        orderbyList.add(orderbyExpr);
        OrderbyClause.OrderModifier modif = OrderbyClause.OrderModifier.ASC;
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 26: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        modif = OrderbyClause.OrderModifier.ASC;
                        break block5;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        modif = OrderbyClause.OrderModifier.DESC;
                        break block5;
                    }
                }
                this.jj_la1[191] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[192] = this.jj_gen;
            }
        }
        modifierList.add(modif);
        while (this.jj_2_18(2)) {
            this.jj_consume_token(130);
            orderbyExpr = this.Expression();
            orderbyList.add(orderbyExpr);
            modif = OrderbyClause.OrderModifier.ASC;
            block12 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 26: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 7: {
                            this.jj_consume_token(7);
                            modif = OrderbyClause.OrderModifier.ASC;
                            break block12;
                        }
                        case 26: {
                            this.jj_consume_token(26);
                            modif = OrderbyClause.OrderModifier.DESC;
                            break block12;
                        }
                    }
                    this.jj_la1[193] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[194] = this.jj_gen;
                }
            }
            modifierList.add(modif);
        }
        oc.setModifierList(modifierList);
        oc.setOrderbyList(orderbyList);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(oc, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final GroupbyClause GroupbyClause() throws ParseException, ParseException {
        Token startToken = null;
        GroupbyClause gbc = new GroupbyClause();
        List<List<GbyVariableExpressionPair>> gbyList = null;
        List<SqlppGroupingSetsParser.GroupingElement> groupingElementList = null;
        Pair<VariableExpr, List<Pair<Expression, Identifier>>> groupVarWithFieldList = null;
        VariableExpr groupVar = null;
        List groupFieldList = null;
        Scope newScope = this.extendCurrentScopeNoPush(true);
        this.jj_consume_token(48);
        startToken = this.token;
        Token hintToken = this.fetchHint(this.token, SqlppHint.HASH_GROUP_BY_HINT);
        if (hintToken != null) {
            gbc.setHashGroupByHint(true);
        }
        this.jj_consume_token(12);
        groupingElementList = this.GroupingElementList();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(6);
                groupVarWithFieldList = this.VariableWithFieldMap();
                groupVar = (VariableExpr)groupVarWithFieldList.first;
                groupFieldList = (List)groupVarWithFieldList.second;
                break;
            }
            default: {
                this.jj_la1[195] = this.jj_gen;
            }
        }
        if (this.groupingSetsParser == null) {
            this.groupingSetsParser = new SqlppGroupingSetsParser();
        }
        SourceLocation sourceLoc = SQLPPParser.getSourceLocation(startToken);
        try {
            gbyList = this.groupingSetsParser.parse(groupingElementList, sourceLoc);
        }
        catch (CompilationException e) {
            throw new SqlppParseException(sourceLoc, e.getMessage());
        }
        gbc.setGbyPairList(gbyList);
        gbc.setDecorPairList(new ArrayList());
        gbc.setWithVarMap(new HashMap());
        gbc.setGroupVar(groupVar);
        gbc.setGroupFieldList(groupFieldList);
        this.replaceCurrentScope(newScope);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(gbc, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<SqlppGroupingSetsParser.GroupingElement> GroupingElementList() throws ParseException, ParseException {
        ArrayList<SqlppGroupingSetsParser.GroupingElement> groupingElementList = new ArrayList<SqlppGroupingSetsParser.GroupingElement>();
        SqlppGroupingSetsParser.GroupingElement groupingElement = null;
        groupingElement = this.GroupingElement();
        groupingElementList.add(groupingElement);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            groupingElement = this.GroupingElement();
            groupingElementList.add(groupingElement);
        }
        if ("" != null) {
            return groupingElementList;
        }
        throw new Error("Missing return statement in function");
    }

    public final SqlppGroupingSetsParser.GroupingElement GroupingElement() throws ParseException, ParseException {
        SqlppGroupingSetsParser.GroupingElement groupingElement = null;
        List<SqlppGroupingSetsParser.GroupingSet> groupingSets = null;
        List<SqlppGroupingSetsParser.GroupingElement> groupingElements = null;
        if (this.jj_2_19(2)) {
            this.jj_consume_token(124);
            this.jj_consume_token(125);
            groupingElement = SqlppGroupingSetsParser.GroupingSet.EMPTY;
        } else if (this.laIdentifier(ROLLUP) && this.laToken(2, 124)) {
            this.jj_consume_token(172);
            this.expectToken(ROLLUP);
            this.jj_consume_token(124);
            groupingSets = this.OrdinaryGroupingSetList();
            this.jj_consume_token(125);
            groupingElement = new SqlppGroupingSetsParser.RollupCube(groupingSets, false);
        } else if (this.laIdentifier(CUBE) && this.laToken(2, 124)) {
            this.jj_consume_token(172);
            this.expectToken(CUBE);
            this.jj_consume_token(124);
            groupingSets = this.OrdinaryGroupingSetList();
            this.jj_consume_token(125);
            groupingElement = new SqlppGroupingSetsParser.RollupCube(groupingSets, true);
        } else if (this.laIdentifier(GROUPING) && this.laIdentifier(2, SETS) && this.laToken(3, 124)) {
            this.jj_consume_token(172);
            this.expectToken(GROUPING);
            this.jj_consume_token(172);
            this.expectToken(SETS);
            this.jj_consume_token(124);
            groupingElements = this.GroupingElementList();
            this.jj_consume_token(125);
            groupingElement = new SqlppGroupingSetsParser.GroupingSets(groupingElements);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 13: 
                case 36: 
                case 38: 
                case 74: 
                case 97: 
                case 121: 
                case 123: 
                case 124: 
                case 126: 
                case 131: 
                case 134: 
                case 145: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 156: 
                case 161: 
                case 162: 
                case 172: {
                    groupingElement = this.OrdinaryGroupingSet();
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return groupingElement;
        }
        throw new Error("Missing return statement in function");
    }

    public final SqlppGroupingSetsParser.GroupingSet OrdinaryGroupingSet() throws ParseException, ParseException {
        GbyVariableExpressionPair gbyExprPair = null;
        List<GbyVariableExpressionPair> items = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                items = this.GbyVariableExpressionPairList();
                this.jj_consume_token(125);
                break;
            }
            case 4: 
            case 13: 
            case 36: 
            case 38: 
            case 74: 
            case 97: 
            case 121: 
            case 123: 
            case 126: 
            case 131: 
            case 134: 
            case 145: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 161: 
            case 162: 
            case 172: {
                gbyExprPair = this.GbyVariableExpressionPair();
                items = Collections.singletonList(gbyExprPair);
                break;
            }
            default: {
                this.jj_la1[198] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return new SqlppGroupingSetsParser.GroupingSet(items);
        }
        throw new Error("Missing return statement in function");
    }

    public final List<SqlppGroupingSetsParser.GroupingSet> OrdinaryGroupingSetList() throws ParseException, ParseException {
        SqlppGroupingSetsParser.GroupingSet groupingSet = null;
        ArrayList<SqlppGroupingSetsParser.GroupingSet> items = new ArrayList<SqlppGroupingSetsParser.GroupingSet>();
        groupingSet = this.OrdinaryGroupingSet();
        items.add(groupingSet);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[199] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            groupingSet = this.OrdinaryGroupingSet();
            items.add(groupingSet);
        }
        if ("" != null) {
            return items;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<GbyVariableExpressionPair> GbyVariableExpressionPairList() throws ParseException, ParseException {
        GbyVariableExpressionPair gbyExprPair = null;
        ArrayList<GbyVariableExpressionPair> items = new ArrayList<GbyVariableExpressionPair>();
        gbyExprPair = this.GbyVariableExpressionPair();
        items.add(gbyExprPair);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[200] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            gbyExprPair = this.GbyVariableExpressionPair();
            items.add(gbyExprPair);
        }
        if ("" != null) {
            return items;
        }
        throw new Error("Missing return statement in function");
    }

    public final GbyVariableExpressionPair GbyVariableExpressionPair() throws ParseException, ParseException {
        Expression expr = null;
        VariableExpr var = null;
        expr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 161: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[201] = this.jj_gen;
                    }
                }
                var = this.Variable();
                break;
            }
            default: {
                this.jj_la1[202] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new GbyVariableExpressionPair(var, expr);
        }
        throw new Error("Missing return statement in function");
    }

    public final HavingClause HavingClause() throws ParseException, ParseException {
        Token startToken = null;
        Expression filterExpr = null;
        this.jj_consume_token(49);
        startToken = this.token;
        filterExpr = this.Expression();
        HavingClause havingClause = new HavingClause(filterExpr);
        if ("" != null) {
            return SQLPPParser.addSourceLocation(havingClause, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final LimitClause LimitClause() throws ParseException, ParseException {
        Token startToken = null;
        LimitClause lc = new LimitClause();
        this.pushForbiddenScope(this.getCurrentScope());
        this.jj_consume_token(69);
        startToken = this.token;
        Expression expr = this.Expression();
        lc.setLimitExpr(expr);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                expr = this.Expression();
                lc.setOffset(expr);
                break;
            }
            default: {
                this.jj_la1[203] = this.jj_gen;
            }
        }
        this.popForbiddenScope();
        if ("" != null) {
            return SQLPPParser.addSourceLocation(lc, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final QuantifiedExpression QuantifiedExpression() throws ParseException, ParseException {
        Token startToken = null;
        QuantifiedExpression qc = new QuantifiedExpression();
        ArrayList<QuantifiedPair> quantifiedList = new ArrayList<QuantifiedPair>();
        this.createNewScope();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 97: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        break;
                    }
                    case 97: {
                        this.jj_consume_token(97);
                        break;
                    }
                    default: {
                        this.jj_la1[204] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                startToken = this.token;
                qc.setQuantifier(QuantifiedExpression.Quantifier.SOME);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                startToken = this.token;
                qc.setQuantifier(QuantifiedExpression.Quantifier.EVERY);
                break;
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        VariableExpr var = this.Variable();
        this.jj_consume_token(53);
        Expression inExpr = this.Expression();
        QuantifiedPair pair = new QuantifiedPair(var, inExpr);
        quantifiedList.add(pair);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[206] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(130);
            var = this.Variable();
            this.jj_consume_token(53);
            inExpr = this.Expression();
            pair = new QuantifiedPair(var, inExpr);
            quantifiedList.add(pair);
        }
        this.jj_consume_token(93);
        Expression satisfiesExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[207] = this.jj_gen;
            }
        }
        qc.setSatisfiesExpr(satisfiesExpr);
        qc.setQuantifiedList(quantifiedList);
        this.removeCurrentScope();
        if ("" != null) {
            return SQLPPParser.addSourceLocation(qc, startToken);
        }
        throw new Error("Missing return statement in function");
    }

    public final LetClause LetElement() throws ParseException, ParseException {
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(141);
        Expression beExp = this.Expression();
        LetClause lc = new LetClause(varExp, beExp);
        lc.setSourceLocation(varExp.getSourceLocation());
        if ("" != null) {
            return lc;
        }
        throw new Error("Missing return statement in function");
    }

    public final LetClause WithElement() throws ParseException, ParseException {
        this.extendCurrentScope();
        VariableExpr varExp = this.Variable();
        this.jj_consume_token(6);
        Expression beExp = this.Expression();
        LetClause lc = new LetClause(varExp, beExp);
        lc.setSourceLocation(varExp.getSourceLocation());
        if ("" != null) {
            return lc;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    private boolean jj_3R_158() {
        return this.jj_scan_token(132);
    }

    private boolean jj_3R_82() {
        if (this.jj_scan_token(147)) {
            return true;
        }
        if (this.jj_3R_41()) {
            return true;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_178() {
        return this.jj_3R_180();
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_94();
    }

    private boolean jj_3R_157() {
        return this.jj_3R_159();
    }

    private boolean jj_3R_175() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_178()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_179()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_157()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_156() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_81() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_41()) {
            return true;
        }
        return this.jj_scan_token(127);
    }

    private boolean jj_3R_106() {
        Token xsp;
        if (this.jj_3R_110()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_155());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_121() {
        if (this.jj_3R_129()) {
            return true;
        }
        return this.jj_scan_token(124);
    }

    private boolean jj_3R_80() {
        return this.jj_3R_91();
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        return this.jj_3R_170();
    }

    private boolean jj_3R_85() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3R_84()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_85());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(123)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(121)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_109()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_106();
    }

    private boolean jj_3R_100() {
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(129);
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(130)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private boolean jj_3R_168() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_93() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_173() {
        return this.jj_3R_175();
    }

    private boolean jj_3R_163() {
        return this.jj_3R_168();
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(145)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_163()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(118);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_95() {
        if (this.jj_3R_101()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_150()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp;
        if (this.jj_3R_64()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_65());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_172() {
        return this.jj_3R_174();
    }

    private boolean jj_3R_170() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_172()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_173();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_99();
    }

    private boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_92()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(145)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_75() {
        return this.jj_3R_88();
    }

    private boolean jj_3R_171() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_169() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_171()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_145() {
        return this.jj_scan_token(121);
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_154() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(71)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(133)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_152() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3R_103() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_151() {
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_162() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_104()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_143() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_151()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_153()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_154()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_148() {
        if (this.jj_scan_token(147)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_86() {
        Token xsp;
        if (this.jj_3R_95()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_143());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_161() {
        return this.jj_scan_token(114);
    }

    private boolean jj_3R_160() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_177() {
        return this.jj_scan_token(116);
    }

    private boolean jj_3R_122() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_160()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_161());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_176() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(67)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(66)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_3R_83();
    }

    private boolean jj_3R_62() {
        return this.jj_3R_82();
    }

    private boolean jj_3R_174() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_176()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        return this.jj_3R_81();
    }

    private boolean jj_3R_60() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_147() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(127);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_62()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_63()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_141() {
        return this.jj_3R_148();
    }

    private boolean jj_3R_140() {
        return this.jj_3R_147();
    }

    private boolean jj_3R_142() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_144() {
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_125() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_140()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_141()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private boolean jj_3R_128() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_145()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_127() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        Token xsp;
        if (this.jj_3R_86()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_128());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_167() {
        return this.jj_3R_87();
    }

    private boolean jj_3R_139() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_166() {
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_165() {
        return this.jj_scan_token(149);
    }

    private boolean jj_3R_138() {
        if (this.jj_scan_token(131)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_167()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_139()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_120() {
        return this.jj_scan_token(119);
    }

    private boolean jj_3R_90() {
        return this.jj_3R_87();
    }

    private boolean jj_3R_48() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_120());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_3R_98();
    }

    private boolean jj_3R_107() {
        if (this.jj_scan_token(132)) {
            return true;
        }
        return this.jj_3R_49();
    }

    private boolean jj_3R_102() {
        Token xsp;
        if (this.jj_3R_49()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_107());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_58() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(68)) {
            return true;
        }
        return this.jj_3R_48();
    }

    private boolean jj_3R_74() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_97() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_67() {
        if (this.jj_3R_48()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.laIdentifier(CURRENT) || this.laIdentifier(UNBOUNDED);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_73()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_74()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(130)) {
            return true;
        }
        return this.jj_3R_58();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_79() {
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_3R_80();
    }

    private boolean jj_3R_98() {
        return this.jj_3R_102();
    }

    private boolean jj_3R_181() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_97()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(162);
    }

    private boolean jj_3R_59() {
        return this.jj_3R_79();
    }

    private boolean jj_3R_87() {
        return this.jj_scan_token(161);
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(129)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_41();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_108() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3_16() {
        if (this.jj_3R_57()) {
            return true;
        }
        if (this.jj_scan_token(132)) {
            return true;
        }
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_40() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        return this.jj_3R_59();
    }

    private boolean jj_3R_46() {
        if (this.jj_3R_67()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_76() {
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_57() {
        return this.jj_3R_78();
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_77()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(153);
    }

    private boolean jj_3R_136() {
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_135() {
        return this.jj_scan_token(151);
    }

    private boolean jj_3_2() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_134() {
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_51() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_3R_49();
    }

    private boolean jj_3R_133() {
        return this.jj_scan_token(155);
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(130)) {
            return true;
        }
        return this.jj_3R_56();
    }

    private boolean jj_3R_132() {
        return this.jj_scan_token(156);
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_50() {
        if (this.jj_scan_token(132)) {
            return true;
        }
        return this.jj_3R_49();
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(149);
    }

    private boolean jj_3R_130() {
        return this.jj_3R_146();
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_123() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_133()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_134()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_135()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_136()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_137()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_46();
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(172)) {
            return true;
        }
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_44() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_70() {
        return this.jj_3R_87();
    }

    private boolean jj_3_9() {
        Token xsp;
        if (this.jj_3R_49()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_50());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(124);
    }

    private boolean jj_3R_119() {
        return this.jj_3R_127();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(172)) {
            return true;
        }
        if (this.jj_scan_token(172)) {
            return true;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_118() {
        return this.jj_3R_126();
    }

    private boolean jj_3R_69() {
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_117() {
        return this.jj_3R_125();
    }

    private boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        return this.jj_3R_124();
    }

    private boolean jj_3R_180() {
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_115() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_114() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_113() {
        return this.jj_3R_122();
    }

    private boolean jj_3R_112() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_112()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_113()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_114()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_115()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_116()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_117()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_118()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_119()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        if (this.jj_scan_token(172)) {
            return true;
        }
        return this.jj_scan_token(172);
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_scan_token(172)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(116)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_71() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_scan_token(172);
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(82);
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        return this.jj_scan_token(125);
    }

    private boolean jj_3R_179() {
        return this.jj_3R_181();
    }

    private boolean jj_3R_164() {
        return this.jj_scan_token(136);
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(137)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(138)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(139)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(140)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(141)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(142)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(143)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(144)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_43()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_44();
    }

    private boolean jj_3R_129() {
        if (this.jj_3R_102()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_159() {
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_94() {
        if (this.jj_3R_44()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_3R_52();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1250336784, 1250336784, 0, 0, 1250336784, 0x700002, 0, 0x300000, 0, 0x300000, 0, 512, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8208, 0x1000000, 0x1000000, 0, 0, 0, 0, 0x700000, 0, 64, 0, 64, 0, 64, 64, 0, 0, 0, 0x2000000, 0, 0, 0x8040000, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 16384, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8208, 16, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 8208, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 8208, 0, 8208, 0, 0x10000000, 8208, 0, 0x10002010, 0, 0, 0, 0, 1024, 0, 0, 0, 8208, 0, 0, 8208, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000004, 0x10000004, -2147475440, -2147475440, Integer.MIN_VALUE, 64, 64, 0, 8208, 64, 64, 256, 524288, 0, 524288, 64, 64, 256, 524288, 64, 256, 0, 0, 0, 0, 0, 0, 0x4000080, 0x4000080, 0x4000080, 0x4000080, 0, 0, 8208, 8208, 0, 0, 64, 64, 0, 16, 16, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{33558609, 33558609, 0, 1, 33558608, 79724928, 0, 0, 0x4000000, 0x4000080, 0, 0, 0, 262144, 0, 0, 262144, 0, 0, 0, 0, 0, 0x400000, 0, 0, 4, 0, 0, 0x40004000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4176, 0, 0, 0, 524288, 0, 0, 12615936, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0x2080000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4176, 16, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 80, 0, 0, 80, 0, 80, 512, 0, 0, 0, 0, 0, 0, 0, 80, 65536, 0, 80, 0, 2, 0, 0, 0, 0x8000020, 0x8000020, 0, 4096, 0, 4096, 4096, 0, 0, 131072, 65536, 0, 0, 0, 131072, 65536, 4096, 0, 0, 80, 80, 0, 0, 0, 0, 80, 0, 0, 0, 553649152, 0x1000000, 0x20000400, 0, 0, 0, 1024, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 80, 80, 0, 0, 0, 0, 0, 0, 16, 0, 8};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{-2130705332, -2130705332, 0, 0, -2130705332, 0x400100, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 4096, 0, 0, 0, 8192, 0, 1024, 0x400000, 0, 0, 0, 0, 0, 0x8000200, 1024, 1024, 0, 0, 0, 0, 0, 0, 0, 0, -2147482612, 0, 0, 0x180000, 0, 0, 0, 256, 0, 0, 0x4000000, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 8192, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2147482612, 0, 16384, 0, 1024, 1024, 1024, 1024, 1, 1, 0, 1024, 0, 0, 0, 128, 128, 128, 0, 1024, 1024, 1024, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 1024, 0, 0, 1024, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 32768, 1024, 0, 0, 1024, 0, 0, 12, 32768, 32, 0, 0, 0, Integer.MIN_VALUE, 12, 12, 12, 0, 12, 0, 0, 12, 0, 12, 0, 0, Integer.MIN_VALUE, 0, 0, 0x800400, 0x800400, 0x800000, 0, 0, 0, 1024, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 65536, 2, 12, 0, 0, 12, 0, 0, 0, 0, 0, 0, 1024, 1024, 0, 0, 0, 0, 2048, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{1513123855, 1513123855, 0, 0, 1513123855, 144, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0x100000, 0, 0, 0x100000, 0x10000000, 0, 0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 1510998018, 0, 0, 0, 0, 0, 0, 144, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 4097, 32768, 0, 12, 0, 32768, 524288, 0, 0x10000000, 0, 0, 0, 0x10000000, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 1510998018, 2, 0, 0, 0, 0, 0, 0, 131072, 132096, 0, 0, 0x800000, 0xA000000, 0xA000000, 0x5000000, 0, 0x5000000, 0x400000, 0, 0xA000000, 0xA000000, 0x40000000, 0x40000000, 1509949442, 0, 0x50000000, 0, 0, 0, 0x10000000, 0, 0, 0x40000000, 0, 1509949442, 0, 1509949442, 0, 0, 1577058306, 0, 1577058306, 0, 0, 0, 0, 0, 0, 0, 0, 1509949442, 0, 0x10000000, 1509949442, 262144, 0, 0x100000, 0, 0, 512, 512, 0, 0x10000000, 0x100000, 0x100000, 0x100000, 524288, 0x100000, 0, 0, 0x100000, 524288, 0x100000, 0, 0, 0, 0, 0, 1577123842, 1577123842, 65536, 0, 0, 0x4000000, 1509949442, 0, 0, 0, 2048, 0, 2048, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 1509949442, 1509949442, 0, 0, 0, 0, 0, 2, 2, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{468320456, 468320328, 128, 0, 468320328, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0x800000, 4, 0, 0, 131072, 0, 4, 2, 468320328, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0x3000000, 0x3000000, 4, 0, 0, 0x200000, 64, 655360, 0, 0, 4, 0, 64, 256, 0, 2, 0, 16, 0, 16, 16, 468320328, 0, 0, 0, 0, 130560, 0, 0, 0, 0xC00000, 0, 0, 0, 0, 0, 32, 32, 32, 0, 0, 0, 0, 16, 16, 468320328, 2, 468320328, 467664896, 0, 4, 0, 0x200000, 72, 524288, 4, 468320328, 4, 468320328, 2, 0, 468320328, 4, 468320328, 0, 0, 4, 0, 0, 0, 0, 0, 468320328, 0, 0, 468320328, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 468320328, 468320328, 0, 0, 0, 0, 468320328, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 4, 468320328, 468320328, 4, 4, 0, 0, 0, 0, 0, 4, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{4102, 4102, 0, 0, 4102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4098, 0, 0, 4096, 4096, 0, 0, 0, 4098, 4096, 4098, 0, 0, 4102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4098, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 4102, 6, 0, 4098, 0, 0, 0, 4098, 0, 0, 4098, 0, 0, 0, 6, 0, 0, 4102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4102, 0, 4102, 4, 4098, 0, 0, 4098, 0, 0, 0, 4102, 0, 4102, 0, 0, 4102, 0, 4102, 0, 4098, 0, 4096, 0, 4096, 4096, 0, 4102, 4096, 0, 4102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4102, 4102, 0, 0, 4098, 0, 4102, 0, 4098, 0, 0, 0, 0, 0, 4098, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4102, 4102, 0, 0, 0, 4098, 0, 0, 0, 0, 0};
    }

    public SQLPPParser(InputStream stream) {
        this(stream, null);
    }

    public SQLPPParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SQLPPParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLPPParser(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SQLPPParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 208; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[186];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 208; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 186; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 19; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SQLPPParser.jj_la1_init_0();
        SQLPPParser.jj_la1_init_1();
        SQLPPParser.jj_la1_init_2();
        SQLPPParser.jj_la1_init_3();
        SQLPPParser.jj_la1_init_4();
        SQLPPParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    @FunctionalInterface
    private static interface ParseFunction<T> {
        public T parse() throws ParseException;
    }

    private static class FunctionName {
        public DataverseName dataverse;
        public String library;
        public String function;
        public SqlppHint hint;
        public SourceLocation sourceLoc;

        private FunctionName() {
        }
    }

    private static class IndexParams {
        public DatasetConfig.IndexType type;
        public int gramLength;

        public IndexParams(DatasetConfig.IndexType type, int gramLength) {
            this.type = type;
            this.gramLength = gramLength;
        }
    }
}

