/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectClause
extends AbstractClause {
    private SelectElement selectElement;
    private SelectRegular selectRegular;
    private boolean distinct;

    public SelectClause(SelectElement selectElement, SelectRegular selectRegular, boolean distinct) {
        this.selectElement = selectElement;
        this.selectRegular = selectRegular;
        this.distinct = distinct;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_CLAUSE;
    }

    public SelectElement getSelectElement() {
        return this.selectElement;
    }

    public SelectRegular getSelectRegular() {
        return this.selectRegular;
    }

    public boolean selectElement() {
        return this.selectElement != null;
    }

    public boolean selectRegular() {
        return this.selectRegular != null;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public String toString() {
        return "select " + (this.distinct ? "distinct " : "") + (this.selectElement() ? "element " + (Object)((Object)this.selectElement) : String.valueOf((Object)this.selectRegular));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.distinct, this.selectElement, this.selectRegular});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectClause)) {
            return false;
        }
        SelectClause target = (SelectClause)((Object)object);
        return this.distinct == target.distinct && Objects.equals((Object)this.selectElement, (Object)target.selectElement) && Objects.equals((Object)this.selectRegular, (Object)target.selectRegular);
    }
}

