/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public final class DataverseName
implements Serializable,
Comparable<DataverseName> {
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR_CHAR = '.';
    private static final char ESCAPE_CHAR = '@';
    private static final char[] SEPARATOR_AND_ESCAPE_CHARS = new char[]{'.', '@'};
    private final boolean isMultiPart;
    private final String canonicalForm;
    private volatile transient String displayForm;

    private DataverseName(String canonicalForm, boolean isMultiPart) {
        this.canonicalForm = Objects.requireNonNull(canonicalForm);
        this.isMultiPart = isMultiPart;
    }

    public boolean isMultiPart() {
        return this.isMultiPart;
    }

    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    public List<String> getParts() {
        ArrayList<String> parts = new ArrayList<String>(this.isMultiPart ? 4 : 1);
        this.getParts(parts);
        return parts;
    }

    public void getParts(Collection<? super String> outParts) {
        if (this.isMultiPart) {
            DataverseName.decodeCanonicalForm(this.canonicalForm, DataverseName::addPartToCollection, outParts);
        } else {
            outParts.add(this.decodeSinglePartNameFromCanonicalForm(this.canonicalForm));
        }
    }

    public String toString() {
        return this.getDisplayForm();
    }

    private String getDisplayForm() {
        String result = this.displayForm;
        if (result == null) {
            this.displayForm = result = this.createDisplayForm();
        }
        return result;
    }

    private String createDisplayForm() {
        if (this.isMultiPart) {
            StringBuilder displayForm = new StringBuilder(this.canonicalForm.length() + 1);
            DataverseName.decodeCanonicalForm(this.canonicalForm, DataverseName::addPartToDisplayForm, displayForm);
            return displayForm.substring(0, displayForm.length() - 1);
        }
        return this.decodeSinglePartNameFromCanonicalForm(this.canonicalForm);
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataverseName)) {
            return false;
        }
        DataverseName that = (DataverseName)obj;
        return this.canonicalForm.equals(that.canonicalForm);
    }

    @Override
    public int compareTo(DataverseName that) {
        return this.canonicalForm.compareTo(that.canonicalForm);
    }

    public static DataverseName create(List<String> parts) {
        return DataverseName.create(parts, 0, parts.size());
    }

    public static DataverseName create(List<String> parts, int fromIndex, int toIndex) {
        int partCount = toIndex - fromIndex;
        return partCount == 1 ? DataverseName.createSinglePartName(parts.get(fromIndex)) : DataverseName.createMultiPartName(parts, fromIndex, toIndex);
    }

    public static DataverseName createFromCanonicalForm(String canonicalForm) {
        boolean isMultiPart = DataverseName.isMultiPartCanonicalForm(canonicalForm);
        return new DataverseName(canonicalForm, isMultiPart);
    }

    public static DataverseName createSinglePartName(String singlePart) {
        String canonicalForm = DataverseName.encodeSinglePartNamePartIntoCanonicalForm(singlePart);
        return new DataverseName(canonicalForm, false);
    }

    public static DataverseName createBuiltinDataverseName(String singlePart) {
        if (StringUtils.containsAny((CharSequence)singlePart, (char[])SEPARATOR_AND_ESCAPE_CHARS)) {
            throw new IllegalArgumentException(singlePart);
        }
        DataverseName dataverseName = DataverseName.createSinglePartName(singlePart);
        String canonicalForm = dataverseName.getCanonicalForm();
        if (!canonicalForm.equals(singlePart)) {
            throw new IllegalStateException(canonicalForm + "!=" + singlePart);
        }
        return dataverseName;
    }

    private static DataverseName createMultiPartName(List<String> parts, int fromIndex, int toIndex) {
        String canonicalForm = DataverseName.encodeMultiPartNameIntoCanonicalForm(parts, fromIndex, toIndex);
        return new DataverseName(canonicalForm, true);
    }

    private static String encodeMultiPartNameIntoCanonicalForm(List<String> parts, int fromIndex, int toIndex) {
        Objects.requireNonNull(parts);
        int partCount = toIndex - fromIndex;
        if (partCount <= 0) {
            throw new IllegalArgumentException(fromIndex + "," + toIndex);
        }
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < partCount; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            DataverseName.encodePartIntoCanonicalForm(parts.get(fromIndex + i), sb);
        }
        return sb.toString();
    }

    private static String encodeSinglePartNamePartIntoCanonicalForm(String singlePart) {
        if (StringUtils.indexOfAny((CharSequence)singlePart, (char[])SEPARATOR_AND_ESCAPE_CHARS) < 0) {
            return singlePart;
        }
        StringBuilder sb = new StringBuilder(singlePart.length() + 4);
        DataverseName.encodePartIntoCanonicalForm(singlePart, sb);
        return sb.toString();
    }

    private static void encodePartIntoCanonicalForm(String part, StringBuilder out) {
        int ln = part.length();
        for (int i = 0; i < ln; ++i) {
            char c = part.charAt(i);
            if (c == '.' || c == '@') {
                out.append('@');
            }
            out.append(c);
        }
    }

    private static <T> void decodeCanonicalForm(String canonicalForm, BiConsumer<CharSequence, T> partConsumer, T partConsumerArg) {
        int ln = canonicalForm.length();
        StringBuilder sb = new StringBuilder(ln);
        block4: for (int i = 0; i < ln; ++i) {
            char c = canonicalForm.charAt(i);
            switch (c) {
                case '.': {
                    partConsumer.accept(sb, (CharSequence)partConsumerArg);
                    sb.setLength(0);
                    continue block4;
                }
                case '@': {
                    c = canonicalForm.charAt(++i);
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            partConsumer.accept(sb, (CharSequence)partConsumerArg);
        }
    }

    private String decodeSinglePartNameFromCanonicalForm(String canonicalForm) {
        if (canonicalForm.indexOf(64) < 0) {
            return canonicalForm;
        }
        StringBuilder singlePart = new StringBuilder(canonicalForm.length());
        int ln = canonicalForm.length();
        for (int i = 0; i < ln; ++i) {
            char c = canonicalForm.charAt(i);
            switch (c) {
                case '.': {
                    throw new IllegalStateException(canonicalForm);
                }
                case '@': {
                    c = canonicalForm.charAt(++i);
                }
            }
            singlePart.append(c);
        }
        return singlePart.toString();
    }

    private static boolean isMultiPartCanonicalForm(String canonicalForm) {
        int ln = canonicalForm.length();
        for (int i = 0; i < ln; ++i) {
            char c = canonicalForm.charAt(i);
            switch (c) {
                case '.': {
                    return true;
                }
                case '@': {
                    ++i;
                }
            }
        }
        return false;
    }

    private static void addPartToCollection(CharSequence part, Collection<? super String> out) {
        out.add(part.toString());
    }

    private static void addPartToDisplayForm(CharSequence part, StringBuilder out) {
        out.append(part).append('.');
    }
}

