/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.util.StorageUtil;
import org.apache.logging.log4j.Level;

public class OptionTypes {
    public static final IOptionType<Integer> INTEGER_BYTE_UNIT = new IOptionType<Integer>(){

        public Integer parse(String s) {
            if (s == null) {
                return null;
            }
            long result1 = StorageUtil.getByteValue((String)s);
            if (result1 > Integer.MAX_VALUE || result1 < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("The given value: " + result1 + " is not within the int range.");
            }
            return (int)result1;
        }

        public Integer parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Integer)value).intValue()) + ")";
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };
    public static final IOptionType<Long> LONG_BYTE_UNIT = new IOptionType<Long>(){

        public Long parse(String s) {
            return s == null ? null : Long.valueOf(StorageUtil.getByteValue((String)s));
        }

        public Long parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Long)value)) + ")";
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Long)value).longValue());
        }
    };
    public static final IOptionType<Short> SHORT = new IOptionType<Short>(){

        public Short parse(String s) {
            int value = Integer.decode(s);
            return this.validateShort(value);
        }

        private Short validateShort(int value) {
            if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                throw new IllegalArgumentException("The given value " + value + " does not fit in a short");
            }
            return (short)value;
        }

        public Short parse(JsonNode node) {
            return node.isNull() ? null : this.validateShort(node.asInt());
        }

        public Class<Short> targetType() {
            return Short.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Short)value).shortValue());
        }
    };
    public static final IOptionType<Integer> INTEGER = new IOptionType<Integer>(){

        public Integer parse(String s) {
            return Integer.parseInt(s);
        }

        public Integer parse(JsonNode node) {
            return node.isNull() ? null : Integer.valueOf(node.asInt());
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };
    public static final IOptionType<Double> DOUBLE = new IOptionType<Double>(){

        public Double parse(String s) {
            return Double.parseDouble(s);
        }

        public Double parse(JsonNode node) {
            return node.isNull() ? null : Double.valueOf(node.asDouble());
        }

        public Class<Double> targetType() {
            return Double.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Double)value).doubleValue());
        }
    };
    public static final IOptionType<String> STRING = new IOptionType<String>(){

        public String parse(String s) {
            return s;
        }

        public String parse(JsonNode node) {
            return node.isNull() ? null : node.asText();
        }

        public Class<String> targetType() {
            return String.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, (String)value);
        }
    };
    public static final IOptionType<Long> LONG = new IOptionType<Long>(){

        public Long parse(String s) {
            return Long.parseLong(s);
        }

        public Long parse(JsonNode node) {
            return node.isNull() ? null : Long.valueOf(node.asLong());
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Long)value).longValue());
        }
    };
    public static final IOptionType<Boolean> BOOLEAN = new IOptionType<Boolean>(){

        public Boolean parse(String s) {
            return Boolean.parseBoolean(s);
        }

        public Boolean parse(JsonNode node) {
            return node.isNull() ? null : Boolean.valueOf(node.asBoolean());
        }

        public Class<Boolean> targetType() {
            return Boolean.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Boolean)value).booleanValue());
        }
    };
    public static final IOptionType<Level> LEVEL = new IOptionType<Level>(){

        public Level parse(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Logging level cannot be null");
            }
            Level level = Level.getLevel((String)s);
            if (level == null) {
                throw new IllegalArgumentException("Unrecognized logging level: " + s);
            }
            return level;
        }

        public Level parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Level> targetType() {
            return Level.class;
        }

        public String serializeToJSON(Object value) {
            return value == null ? null : ((Level)value).name();
        }

        public String serializeToIni(Object value) {
            return ((Level)value).name();
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, this.serializeToJSON(value));
        }
    };
    public static final IOptionType<String[]> STRING_ARRAY = new IOptionType<String[]>(){

        public String[] parse(String s) {
            return s == null ? null : s.split("\\s*,\\s*");
        }

        public String[] parse(JsonNode node) {
            if (node.isNull()) {
                return null;
            }
            ArrayList strings = new ArrayList();
            if (node instanceof ArrayNode) {
                node.elements().forEachRemaining(n -> strings.add(n.asText()));
                return strings.toArray(new String[strings.size()]);
            }
            return this.parse(node.asText());
        }

        public Class<String[]> targetType() {
            return String[].class;
        }

        public String serializeToIni(Object value) {
            return String.join((CharSequence)",", (String[])value);
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            if (value == null) {
                node.putNull(fieldName);
            } else {
                ArrayNode array = node.putArray(fieldName);
                Stream.of((String[])value).forEachOrdered(arg_0 -> ((ArrayNode)array).add(arg_0));
            }
        }
    };
    public static final IOptionType<URL> URL = new IOptionType<URL>(){

        public URL parse(String s) {
            try {
                return s == null ? null : new URL(s);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public URL parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<URL> targetType() {
            return URL.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, value == null ? null : String.valueOf(value));
        }
    };
    public static final IOptionType<Integer> UNSIGNED_INTEGER = new IOptionType<Integer>(){

        public Integer parse(String s) {
            return Integer.parseUnsignedInt(s);
        }

        public Integer parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };
    public static final IOptionType<Integer> POSITIVE_INTEGER = new IOptionType<Integer>(){

        public Integer parse(String s) {
            int value = Integer.parseUnsignedInt(s);
            if (value == 0) {
                throw new IllegalArgumentException("Value must be greater than zero");
            }
            return value;
        }

        public Integer parse(JsonNode node) {
            return node.isNull() ? null : this.parse(node.asText());
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };

    private OptionTypes() {
    }
}

