/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.parser;

import java.io.Serializable;
import java.io.StringReader;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.metadata.entities.Function;

public class FunctionParser {
    private final IParserFactory parserFactory;

    public FunctionParser(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public String getLanguage() {
        return this.parserFactory.getLanguage();
    }

    public FunctionDecl getFunctionDecl(Function function) throws CompilationException {
        if (!function.getLanguage().equals(this.getLanguage())) {
            throw new CompilationException(1055, new Serializable[]{this.getLanguage(), function.getLanguage()});
        }
        IParser parser = this.parserFactory.createParser(new StringReader(function.getFunctionBody()));
        return parser.parseFunctionBody(function.getSignature(), function.getParameterNames());
    }
}

