/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.data.std.util.UTF8CharSequence;

public class RegExpMatcher {
    private Pattern pattern = null;
    private Matcher matcher = null;
    private final ByteArrayAccessibleOutputStream lastPatternStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastPatternPtr = new UTF8StringPointable();
    private final ByteArrayAccessibleOutputStream lastFlagsStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastFlagPtr = new UTF8StringPointable();
    private final UTF8CharSequence charSeq = new UTF8CharSequence();
    private final ByteArrayAccessibleOutputStream lastReplaceStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastReplaceStrPtr = new UTF8StringPointable();
    private String replaceStr = null;
    private final StringBuffer resultBuf = new StringBuffer();

    public void build(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr) throws HyracksDataException {
        this.build(srcPtr, patternPtr, null);
    }

    public void build(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr, UTF8StringPointable flagPtr) throws HyracksDataException {
        this.build(srcPtr, patternPtr, flagPtr, null);
    }

    public void build(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr, UTF8StringPointable flagPtr, IRegExpPatternGenerator patternGenerator) throws HyracksDataException {
        boolean newPattern = this.pattern == null || this.lastPatternPtr.compareTo((IPointable)patternPtr) != 0;
        boolean newFlag = flagPtr != null && (this.pattern == null || this.lastFlagPtr.compareTo((IPointable)flagPtr) != 0);
        this.charSeq.reset(srcPtr);
        if (newPattern || newFlag) {
            String patternString;
            if (newPattern) {
                StringEvaluatorUtils.copyResetUTF8Pointable(patternPtr, this.lastPatternStorage, this.lastPatternPtr);
                String inputPatternString = this.lastPatternPtr.toString();
                patternString = patternGenerator == null ? inputPatternString : patternGenerator.toRegExpPatternString(inputPatternString);
            } else {
                patternString = this.pattern.pattern();
            }
            int flags = 0;
            if (newFlag) {
                StringEvaluatorUtils.copyResetUTF8Pointable(flagPtr, this.lastFlagsStorage, this.lastFlagPtr);
                flags = StringEvaluatorUtils.toFlag(this.lastFlagPtr.toString());
            } else if (this.pattern != null) {
                flags = this.pattern.flags();
            }
            this.pattern = Pattern.compile(patternString, flags);
            this.matcher = this.pattern.matcher((CharSequence)this.charSeq);
        } else {
            this.matcher.reset((CharSequence)this.charSeq);
        }
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean find() {
        return this.matcher.find();
    }

    public String group() {
        return this.matcher.group();
    }

    public int position() {
        return this.matcher.find() ? this.matcher.start() : -1;
    }

    public String replace(UTF8StringPointable replaceStrPtr) {
        return this.replace(replaceStrPtr, Integer.MAX_VALUE);
    }

    public String replace(UTF8StringPointable replaceStrPtr, int replaceLimit) {
        boolean newReplace;
        if (replaceLimit < 0) {
            replaceLimit = Integer.MAX_VALUE;
        }
        boolean bl = newReplace = replaceStrPtr != null && (this.replaceStr == null || this.lastReplaceStrPtr.compareTo((IPointable)replaceStrPtr) != 0);
        if (newReplace) {
            StringEvaluatorUtils.copyResetUTF8Pointable(replaceStrPtr, this.lastReplaceStorage, this.lastReplaceStrPtr);
            this.replaceStr = replaceStrPtr.toString();
        }
        this.resultBuf.setLength(0);
        for (int i = 0; i < replaceLimit && this.matcher.find(); ++i) {
            this.matcher.appendReplacement(this.resultBuf, this.replaceStr);
        }
        this.matcher.appendTail(this.resultBuf);
        return this.resultBuf.toString();
    }

    @FunctionalInterface
    public static interface IRegExpPatternGenerator {
        public String toRegExpPatternString(String var1) throws HyracksDataException;
    }
}

