/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

class IntervalLogic {
    private final IBinaryComparator comp;
    private final ArrayBackedValueStorage s1 = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage e1 = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage s2 = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage e2 = new ArrayBackedValueStorage();

    IntervalLogic() {
        this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.ANY, (Object)BuiltinType.ANY, true).createBinaryComparator();
    }

    boolean before(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.e1.reset();
        this.s2.reset();
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        return this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) < 0;
    }

    boolean after(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.before(ip2, ip1);
    }

    boolean meets(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.e1.reset();
        this.s2.reset();
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        return this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) == 0;
    }

    boolean metBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.meets(ip2, ip1);
    }

    boolean overlaps(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.s1.reset();
        this.e1.reset();
        this.s2.reset();
        this.e2.reset();
        ip1.getTaggedStart(this.s1.getDataOutput());
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        ip2.getTaggedEnd(this.e2.getDataOutput());
        return this.comp.compare(this.s1.getByteArray(), this.s1.getStartOffset(), this.s1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) < 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) > 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.e2.getByteArray(), this.e2.getStartOffset(), this.e2.getLength()) < 0;
    }

    boolean overlappedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.overlaps(ip2, ip1);
    }

    boolean overlapping(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.s1.reset();
        this.e1.reset();
        this.s2.reset();
        this.e2.reset();
        ip1.getTaggedStart(this.s1.getDataOutput());
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        ip2.getTaggedEnd(this.e2.getDataOutput());
        return this.comp.compare(this.s1.getByteArray(), this.s1.getStartOffset(), this.s1.getLength(), this.e2.getByteArray(), this.e2.getStartOffset(), this.e2.getLength()) < 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) > 0;
    }

    boolean starts(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.s1.reset();
        this.e1.reset();
        this.s2.reset();
        this.e2.reset();
        ip1.getTaggedStart(this.s1.getDataOutput());
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        ip2.getTaggedEnd(this.e2.getDataOutput());
        return this.comp.compare(this.s1.getByteArray(), this.s1.getStartOffset(), this.s1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) == 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.e2.getByteArray(), this.e2.getStartOffset(), this.e2.getLength()) <= 0;
    }

    boolean startedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.starts(ip2, ip1);
    }

    boolean covers(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.s1.reset();
        this.e1.reset();
        this.s2.reset();
        this.e2.reset();
        ip1.getTaggedStart(this.s1.getDataOutput());
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        ip2.getTaggedEnd(this.e2.getDataOutput());
        return this.comp.compare(this.s1.getByteArray(), this.s1.getStartOffset(), this.s1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) <= 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.e2.getByteArray(), this.e2.getStartOffset(), this.e2.getLength()) >= 0;
    }

    boolean coveredBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.covers(ip2, ip1);
    }

    boolean ends(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        this.s1.reset();
        this.e1.reset();
        this.s2.reset();
        this.e2.reset();
        ip1.getTaggedStart(this.s1.getDataOutput());
        ip1.getTaggedEnd(this.e1.getDataOutput());
        ip2.getTaggedStart(this.s2.getDataOutput());
        ip2.getTaggedEnd(this.e2.getDataOutput());
        return this.comp.compare(this.s1.getByteArray(), this.s1.getStartOffset(), this.s1.getLength(), this.s2.getByteArray(), this.s2.getStartOffset(), this.s2.getLength()) >= 0 && this.comp.compare(this.e1.getByteArray(), this.e1.getStartOffset(), this.e1.getLength(), this.e2.getByteArray(), this.e2.getStartOffset(), this.e2.getLength()) == 0;
    }

    boolean endedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.ends(ip2, ip1);
    }
}

