/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class StringToCodePointDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringToCodePointDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    protected final DataOutput out = this.resultStorage.getDataOutput();
                    protected final IPointable argPtr = new VoidPointable();
                    protected final IScalarEvaluator stringEval;
                    protected final AOrderedListType intListType;
                    private OrderedListBuilder listBuilder;
                    private ArrayBackedValueStorage inputVal;
                    private final ISerializerDeserializer<AInt64> int64Serde;
                    private final AMutableInt64 aInt64;
                    {
                        this.stringEval = args[0].createScalarEvaluator(ctx);
                        this.intListType = new AOrderedListType((IAType)BuiltinType.AINT64, null);
                        this.listBuilder = new OrderedListBuilder();
                        this.inputVal = new ArrayBackedValueStorage();
                        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.aInt64 = new AMutableInt64(0L);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            int offset;
                            this.resultStorage.reset();
                            this.stringEval.evaluate(tuple, this.argPtr);
                            if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                                return;
                            }
                            byte[] serString = this.argPtr.getByteArray();
                            if (serString[offset = this.argPtr.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                PointableHelper.setNull(result);
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)StringToCodePointDescriptor.this.sourceLoc, (FunctionIdentifier)StringToCodePointDescriptor.this.getIdentifier(), (byte)serString[offset], (int)0, (ATypeTag)ATypeTag.STRING);
                                return;
                            }
                            int len = UTF8StringUtil.getUTFLength((byte[])serString, (int)(offset + 1));
                            int start = offset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)len);
                            this.listBuilder.reset((AbstractCollectionType)this.intListType);
                            for (int pos = 0; pos < len; pos += UTF8StringUtil.charSize((byte[])serString, (int)(start + pos))) {
                                int codePoint = UTF8StringUtil.UTF8ToCodePoint((byte[])serString, (int)(start + pos));
                                this.inputVal.reset();
                                this.aInt64.setValue((long)codePoint);
                                this.int64Serde.serialize((Object)this.aInt64, this.inputVal.getDataOutput());
                                this.listBuilder.addItem((IValueReference)this.inputVal);
                            }
                            this.listBuilder.write(this.out, true);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e1) {
                            throw HyracksDataException.create((Throwable)e1);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_TO_CODEPOINT;
    }
}

