/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class StringLengthDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringLengthDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private AMutableInt64 result = new AMutableInt64(0L);
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private ISerializerDeserializer<AInt64> int64Serde;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        try {
                            int offset;
                            this.resultStorage.reset();
                            this.eval.evaluate(tuple, this.inputArg);
                            if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.inputArg)) {
                                return;
                            }
                            byte[] serString = this.inputArg.getByteArray();
                            if (serString[offset = this.inputArg.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                PointableHelper.setNull(resultPointable);
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)StringLengthDescriptor.this.sourceLoc, (FunctionIdentifier)StringLengthDescriptor.this.getIdentifier(), (byte)serString[offset], (int)0, (ATypeTag)ATypeTag.STRING);
                                return;
                            }
                            int len = UTF8StringUtil.getUTFLength((byte[])serString, (int)(offset + 1));
                            this.result.setValue((long)len);
                            this.int64Serde.serialize((Object)this.result, this.out);
                            resultPointable.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e1) {
                            throw HyracksDataException.create((Throwable)e1);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_LENGTH;
    }
}

