/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMInvertedIndexAccessor
implements ILSMIndexAccessor,
IInvertedIndexAccessor {
    protected final ILSMHarness lsmHarness;
    protected final ILSMIndexOperationContext ctx;
    private boolean destroyed = false;

    public LSMInvertedIndexAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
        this.lsmHarness = lsmHarness;
        this.ctx = ctx;
    }

    public void insert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public boolean tryInsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    public boolean tryDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.SEARCH);
        this.lsmHarness.search(this.ctx, cursor, searchPred);
    }

    public IIndexCursor createSearchCursor(boolean exclusive) {
        return new LSMInvertedIndexSearchCursor();
    }

    public ILSMIOOperation scheduleFlush() throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.FLUSH);
        return this.lsmHarness.scheduleFlush(this.ctx);
    }

    public void flush(ILSMIOOperation operation) throws HyracksDataException {
        this.lsmHarness.flush(operation);
    }

    public ILSMIOOperation scheduleMerge(List<ILSMDiskComponent> components) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.MERGE);
        this.ctx.getComponentsToBeMerged().clear();
        this.ctx.getComponentsToBeMerged().addAll(components);
        return this.lsmHarness.scheduleMerge(this.ctx);
    }

    public void scheduleReplication(List<ILSMDiskComponent> lsmComponents, LSMOperationType opType) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.REPLICATE);
        this.ctx.getComponentsToBeReplicated().clear();
        this.ctx.getComponentsToBeReplicated().addAll(lsmComponents);
        this.lsmHarness.scheduleReplication(this.ctx, lsmComponents, opType);
    }

    public ILSMIOOperation scheduleFullMerge() throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.FULL_MERGE);
        return this.lsmHarness.scheduleFullMerge(this.ctx);
    }

    public void merge(ILSMIOOperation operation) throws HyracksDataException {
        this.lsmHarness.merge(operation);
    }

    @Override
    public IIndexCursor createRangeSearchCursor() {
        return new LSMInvertedIndexRangeSearchCursor(this.ctx);
    }

    @Override
    public void rangeSearch(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
        this.search(cursor, searchPred);
    }

    public void forcePhysicalDelete(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Physical delete not supported by lsm inverted index.");
    }

    public void forceInsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    public void forceDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    public void physicalDelete(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Physical delete not supported by lsm inverted index.");
    }

    public void update(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Update not supported by lsm inverted index.");
    }

    public void upsert(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Upsert not supported by lsm inverted index.");
    }

    public boolean tryUpdate(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Update not supported by lsm inverted index.");
    }

    public boolean tryUpsert(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Upsert not supported by lsm inverted index.");
    }

    @Override
    public InvertedListCursor createInvertedListCursor() {
        throw new UnsupportedOperationException("Cannot create inverted list cursor on lsm inverted index.");
    }

    @Override
    public void openInvertedListCursor(InvertedListCursor listCursor, ITupleReference searchKey) throws HyracksDataException {
        throw new UnsupportedOperationException("Cannot open inverted list cursor on lsm inverted index.");
    }

    public void updateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.updateMeta(this.ctx, key, value);
    }

    public void forceUpdateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.forceUpdateMeta(this.ctx, key, value);
    }

    public void forceUpsert(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Upsert not supported by lsm inverted index.");
    }

    public void updateFilter(ITupleReference tuple) throws HyracksDataException {
        this.lsmHarness.updateFilter(this.ctx, tuple);
    }

    public void scanDiskComponents(IIndexCursor cursor) throws HyracksDataException {
        throw HyracksDataException.create((int)56, (Serializable[])new Serializable[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ':' + this.lsmHarness.toString();
    }

    public void deleteComponents(Predicate<ILSMComponent> predicate) throws HyracksDataException {
        this.lsmHarness.deleteComponents(this.ctx, predicate);
    }

    public ILSMIndexOperationContext getOpContext() {
        return this.ctx;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.ctx.destroy();
    }
}

