/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tokenizer;

import java.io.Serializable;

public class Token
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CharSequence data;
    private int start;
    private int length;
    private int count;
    private int hash;

    public Token() {
    }

    public Token(CharSequence data, int start, int length, int count) {
        this.set(data, start, length, count);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token t = (Token)o;
        if (t.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (t.data.charAt(t.start + i) == this.data.charAt(this.start + i)) continue;
            return false;
        }
        return true;
    }

    public CharSequence getCharSequence() {
        return this.data;
    }

    public int getCount() {
        return this.count;
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length > 0) {
            for (int i = 0; i < this.length; ++i) {
                h = 31 * h + this.data.charAt(this.start + i);
            }
            this.hash = h = 31 * h + this.count;
        }
        return h;
    }

    public int length() {
        return this.length;
    }

    public void set(CharSequence data, int start, int length, int count) {
        this.data = data;
        this.start = start;
        this.length = length;
        this.count = count;
        this.hash = 0;
    }

    public void set(String data, int count) {
        this.data = data;
        this.start = 0;
        this.length = data.length();
        this.count = count;
        this.hash = 0;
    }

    public String toString() {
        return "(" + this.data.subSequence(this.start, this.start + this.length) + ", " + this.count + ")";
    }
}

