/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tokenizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.fuzzyjoin.tokenizer.Tokenizer;

public class NGramTokenizer
implements Tokenizer {
    private static final long serialVersionUID = 1L;
    private final int gramLength;
    private final char QGRAMENDPADDING = (char)36;
    private final char QGRAMSTARTPADDING = (char)36;

    public static void main(String[] args) {
        NGramTokenizer tokenizer = new NGramTokenizer();
        String a = "hadoopoop";
        System.out.println(a + ":" + tokenizer.tokenize(a));
    }

    public NGramTokenizer() {
        this.gramLength = 3;
    }

    public NGramTokenizer(int gramLength) {
        this.gramLength = gramLength;
    }

    private StringBuffer getAdjustedString(String input) {
        int i;
        StringBuffer adjustedString = new StringBuffer();
        for (i = 0; i < this.gramLength - 1; ++i) {
            adjustedString.append('$');
        }
        adjustedString.append(input);
        for (i = 0; i < this.gramLength - 1; ++i) {
            adjustedString.append('$');
        }
        return adjustedString;
    }

    @Override
    public List<String> tokenize(String input) {
        ArrayList<String> returnVect = new ArrayList<String>();
        StringBuffer adjustedString = this.getAdjustedString(input);
        int length = adjustedString.length() - (this.gramLength - 1);
        HashMap<String, Integer> grams = new HashMap<String, Integer>();
        for (int curPos = 0; curPos < length; ++curPos) {
            String term = adjustedString.substring(curPos, curPos + this.gramLength);
            Integer count = (Integer)grams.get(term);
            if (count == null) {
                count = new Integer(0);
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            grams.put(term, count);
            returnVect.add(term + count);
        }
        return returnVect;
    }
}

