/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import org.apache.hyracks.control.cc.web.util.IJSONOutputFunction;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSONOutputRequestHandler
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IJSONOutputFunction fn;

    public JSONOutputRequestHandler(ConcurrentMap<String, Object> ctx, String[] paths, IJSONOutputFunction fn) {
        super(ctx, paths);
        this.fn = fn;
    }

    protected void get(IServletRequest request, IServletResponse response) {
        String localPath = this.localPath(request);
        String servletPath = this.servletPath(request);
        String host = this.host(request);
        while (localPath.startsWith("/")) {
            localPath = localPath.substring(1);
        }
        String[] parts = localPath.split("/");
        ObjectNode result = this.invoke(response, host, servletPath, parts);
        if (result != null) {
            this.deliver(response, result);
        }
    }

    protected ObjectNode invoke(IServletResponse response, String host, String servletPath, String[] parts) {
        try {
            return this.fn.invoke(host, servletPath, parts);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception invoking " + this.fn.getClass().getName(), (Throwable)e);
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            response.writer().print(e.getMessage());
            return null;
        }
    }

    protected void deliver(IServletResponse response, ObjectNode result) {
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
            ObjectMapper om = new ObjectMapper();
            om.writer().writeValue((Writer)response.writer(), (Object)result);
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Exception delivering result in " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.writer().print(e.getMessage());
        }
    }
}

