/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.partitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionMatchMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PartitionId, List<PartitionDescriptor>> partitionDescriptors = new HashMap<PartitionId, List<PartitionDescriptor>>();
    private final Map<PartitionId, List<PartitionRequest>> partitionRequests = new HashMap<PartitionId, List<PartitionRequest>>();

    public List<Pair<PartitionDescriptor, PartitionRequest>> registerPartitionDescriptor(PartitionDescriptor partitionDescriptor) {
        ArrayList<Pair<PartitionDescriptor, PartitionRequest>> matches = new ArrayList<Pair<PartitionDescriptor, PartitionRequest>>();
        PartitionId pid = partitionDescriptor.getPartitionId();
        boolean matched = false;
        List<PartitionRequest> requests = this.partitionRequests.get(pid);
        if (requests != null) {
            Iterator<PartitionRequest> i = requests.iterator();
            while (i.hasNext()) {
                PartitionRequest req = i.next();
                if (!partitionDescriptor.getState().isAtLeast(req.getMinimumState())) continue;
                matches.add((Pair<PartitionDescriptor, PartitionRequest>)Pair.of((Object)partitionDescriptor, (Object)req));
                i.remove();
                matched = true;
                if (partitionDescriptor.isReusable()) continue;
                break;
            }
            if (requests.isEmpty()) {
                this.partitionRequests.remove(pid);
            }
        }
        if (!matched) {
            List<PartitionDescriptor> descriptors = this.partitionDescriptors.get(pid);
            if (descriptors == null) {
                descriptors = new ArrayList<PartitionDescriptor>();
                this.partitionDescriptors.put(pid, descriptors);
            }
            descriptors.add(partitionDescriptor);
        }
        return matches;
    }

    public Pair<PartitionDescriptor, PartitionRequest> matchPartitionRequest(PartitionRequest partitionRequest) {
        Pair match = null;
        PartitionId pid = partitionRequest.getPartitionId();
        List<PartitionDescriptor> descriptors = this.partitionDescriptors.get(pid);
        if (descriptors != null) {
            Iterator<PartitionDescriptor> i = descriptors.iterator();
            while (i.hasNext()) {
                PartitionDescriptor descriptor = i.next();
                if (!descriptor.getState().isAtLeast(partitionRequest.getMinimumState())) continue;
                match = Pair.of((Object)descriptor, (Object)partitionRequest);
                if (descriptor.isReusable()) break;
                i.remove();
                break;
            }
            if (descriptors.isEmpty()) {
                this.partitionDescriptors.remove(pid);
            }
        }
        if (match == null) {
            List<PartitionRequest> requests = this.partitionRequests.get(pid);
            if (requests == null) {
                requests = new ArrayList<PartitionRequest>();
                this.partitionRequests.put(pid, requests);
            }
            requests.add(partitionRequest);
        }
        return match;
    }

    public PartitionState getMaximumAvailableState(PartitionId pid) {
        List<PartitionDescriptor> descriptors = this.partitionDescriptors.get(pid);
        if (descriptors == null) {
            return null;
        }
        for (PartitionDescriptor descriptor : descriptors) {
            if (descriptor.getState() != PartitionState.COMMITTED) continue;
            return PartitionState.COMMITTED;
        }
        return PartitionState.STARTED;
    }

    private static <T> void removeEntries(List<T> list, IEntryFilter<T> filter) {
        Iterator<T> j = list.iterator();
        while (j.hasNext()) {
            T o = j.next();
            if (!filter.matches(o)) continue;
            j.remove();
        }
    }

    private static <T> void removeEntries(Map<PartitionId, List<T>> map, IEntryFilter<T> filter) {
        Iterator<Map.Entry<PartitionId, List<T>>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<PartitionId, List<T>> e = i.next();
            List<T> list = e.getValue();
            PartitionMatchMaker.removeEntries(list, filter);
            if (!list.isEmpty()) continue;
            i.remove();
        }
    }

    public void notifyNodeFailures(final Collection<String> deadNodes) {
        PartitionMatchMaker.removeEntries(this.partitionDescriptors, new IEntryFilter<PartitionDescriptor>(){

            @Override
            public boolean matches(PartitionDescriptor o) {
                return deadNodes.contains(o.getNodeId());
            }
        });
        PartitionMatchMaker.removeEntries(this.partitionRequests, new IEntryFilter<PartitionRequest>(){

            @Override
            public boolean matches(PartitionRequest o) {
                return deadNodes.contains(o.getNodeId());
            }
        });
    }

    public void removeUncommittedPartitions(Set<PartitionId> partitionIds, final Set<TaskAttemptId> taIds) {
        LOGGER.info("Removing uncommitted partitions: " + partitionIds);
        IEntryFilter<PartitionDescriptor> filter = new IEntryFilter<PartitionDescriptor>(){

            @Override
            public boolean matches(PartitionDescriptor o) {
                return o.getState() != PartitionState.COMMITTED && taIds.contains(o.getProducingTaskAttemptId());
            }
        };
        for (PartitionId pid : partitionIds) {
            List<PartitionDescriptor> descriptors = this.partitionDescriptors.get(pid);
            if (descriptors == null) continue;
            PartitionMatchMaker.removeEntries(descriptors, filter);
            if (!descriptors.isEmpty()) continue;
            this.partitionDescriptors.remove(pid);
        }
    }

    public void removePartitionRequests(Set<PartitionId> partitionIds, final Set<TaskAttemptId> taIds) {
        LOGGER.info("Removing partition requests: " + partitionIds);
        IEntryFilter<PartitionRequest> filter = new IEntryFilter<PartitionRequest>(){

            @Override
            public boolean matches(PartitionRequest o) {
                return taIds.contains(o.getRequestingTaskAttemptId());
            }
        };
        for (PartitionId pid : partitionIds) {
            List<PartitionRequest> requests = this.partitionRequests.get(pid);
            if (requests == null) continue;
            PartitionMatchMaker.removeEntries(requests, filter);
            if (!requests.isEmpty()) continue;
            this.partitionRequests.remove(pid);
        }
    }

    private static interface IEntryFilter<T> {
        public boolean matches(T var1);
    }
}

