/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.scheduler.FIFOJobQueue;
import org.apache.hyracks.control.cc.scheduler.IJobQueue;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.NoOpCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class JobManager
implements IJobManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final Map<JobId, JobRun> activeRunMap;
    private final Map<JobId, JobRun> runMapArchive;
    private final Map<JobId, List<Exception>> runMapHistory;
    private final IJobCapacityController jobCapacityController;
    private IJobQueue jobQueue;

    public JobManager(final CCConfig ccConfig, ClusterControllerService ccs, IJobCapacityController jobCapacityController) {
        this.ccs = ccs;
        this.jobCapacityController = jobCapacityController;
        try {
            Constructor<?> jobQueueConstructor = this.getClass().getClassLoader().loadClass(ccConfig.getJobQueueClass()).getConstructor(IJobManager.class, IJobCapacityController.class);
            this.jobQueue = (IJobQueue)jobQueueConstructor.newInstance(this, this.jobCapacityController);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.log(Level.WARN, "class " + ccConfig.getJobQueueClass() + " could not be used: ", (Throwable)e);
            }
            this.jobQueue = new FIFOJobQueue(this, jobCapacityController);
        }
        this.activeRunMap = new HashMap<JobId, JobRun>();
        this.runMapArchive = new LinkedHashMap<JobId, JobRun>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<JobId, JobRun> eldest) {
                return this.size() > ccConfig.getJobHistorySize();
            }
        };
        this.runMapHistory = new LinkedHashMap<JobId, List<Exception>>(){
            private static final long serialVersionUID = 1L;
            private final int allowedSize;
            {
                this.allowedSize = 100 * (ccConfig.getJobHistorySize() + 1);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<JobId, List<Exception>> eldest) {
                return this.size() > this.allowedSize;
            }
        };
    }

    @Override
    public void add(JobRun jobRun) throws HyracksException {
        this.checkJob(jobRun);
        JobSpecification job = jobRun.getJobSpecification();
        IJobCapacityController.JobSubmissionStatus status = this.jobCapacityController.allocate(job);
        CCServiceContext serviceCtx = this.ccs.getContext();
        serviceCtx.notifyJobCreation(jobRun.getJobId(), job);
        switch (status) {
            case QUEUE: {
                this.queueJob(jobRun);
                break;
            }
            case EXECUTE: {
                this.executeJob(jobRun);
                break;
            }
            default: {
                throw new IllegalStateException("unknown submission status: " + status);
            }
        }
    }

    @Override
    public void cancel(JobId jobId, IResultCallback<Void> callback) throws HyracksException {
        if (this.activeRunMap.containsKey(jobId)) {
            JobRun jobRun = this.activeRunMap.get(jobId);
            jobRun.getExecutor().cancelJob(callback);
            return;
        }
        JobRun jobRun = this.jobQueue.remove(jobId);
        if (jobRun != null) {
            List<HyracksException> exceptions = Collections.singletonList(HyracksException.create((int)25, (Serializable[])new Serializable[]{jobId}));
            jobRun.setStatus(JobStatus.FAILURE_BEFORE_EXECUTION, exceptions);
            this.runMapArchive.put(jobId, jobRun);
            this.runMapHistory.put(jobId, exceptions);
            CCServiceContext serviceCtx = this.ccs.getContext();
            if (serviceCtx != null) {
                try {
                    serviceCtx.notifyJobFinish(jobId, JobStatus.FAILURE_BEFORE_EXECUTION, exceptions);
                }
                catch (Exception e) {
                    LOGGER.error("Exception notifying cancel on pending job {}", (Object)jobId, (Object)e);
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }
        callback.setValue(null);
    }

    @Override
    public void prepareComplete(JobRun run, JobStatus status, List<Exception> exceptions) throws HyracksException {
        this.ccs.removeJobParameterByteStore(run.getJobId());
        this.checkJob(run);
        if (status == JobStatus.FAILURE_BEFORE_EXECUTION) {
            run.setPendingStatus(JobStatus.FAILURE, exceptions);
            this.finalComplete(run);
            return;
        }
        if (run.getPendingStatus() != null && run.getCleanupPendingNodeIds().isEmpty()) {
            this.finalComplete(run);
            return;
        }
        if (run.getPendingStatus() != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = run::getJobId;
            LOGGER.warn("Ignoring duplicate cleanup for JobRun with id: {}", supplierArray);
            return;
        }
        Set<String> targetNodes = run.getParticipatingNodeIds();
        run.getCleanupPendingNodeIds().addAll(targetNodes);
        if (run.getPendingStatus() != JobStatus.FAILURE && run.getPendingStatus() != JobStatus.TERMINATED) {
            run.setPendingStatus(status, exceptions);
        }
        if (!targetNodes.isEmpty()) {
            this.cleanupJobOnNodes(run, status, targetNodes);
        } else {
            this.finalComplete(run);
        }
    }

    private void cleanupJobOnNodes(JobRun run, JobStatus status, Set<String> targetNodes) throws HyracksException {
        Throwable caughtException = null;
        JobId jobId = run.getJobId();
        INodeManager nodeManager = this.ccs.getNodeManager();
        HashSet<String> toDelete = new HashSet<String>();
        for (String n : targetNodes) {
            NodeControllerState ncs = nodeManager.getNodeControllerState(n);
            if (ncs == null) {
                toDelete.add(n);
                continue;
            }
            try {
                ncs.getNodeController().cleanUpJoblet(jobId, status);
            }
            catch (Exception e) {
                LOGGER.error("Exception cleaning up joblet {} on node {}", (Object)jobId, (Object)n, (Object)e);
                caughtException = ExceptionUtils.suppress(caughtException, (Throwable)e);
            }
        }
        targetNodes.removeAll(toDelete);
        run.getCleanupPendingNodeIds().removeAll(toDelete);
        if (run.getCleanupPendingNodeIds().isEmpty()) {
            this.finalComplete(run);
        }
        if (caughtException != null) {
            throw HyracksException.wrapOrThrowUnchecked(caughtException);
        }
    }

    @Override
    public void finalComplete(JobRun run) throws HyracksException {
        this.checkJob(run);
        JobId jobId = run.getJobId();
        Throwable caughtException = null;
        CCServiceContext serviceCtx = this.ccs.getContext();
        if (serviceCtx != null) {
            try {
                serviceCtx.notifyJobFinish(jobId, run.getPendingStatus(), run.getPendingExceptions());
            }
            catch (Exception e) {
                LOGGER.error("Exception notifying job finish {}", (Object)jobId, (Object)e);
                caughtException = e;
            }
        }
        run.setStatus(run.getPendingStatus(), run.getPendingExceptions());
        run.setEndTime(System.currentTimeMillis());
        this.activeRunMap.remove(jobId);
        this.runMapArchive.put(jobId, run);
        this.runMapHistory.put(jobId, run.getExceptions());
        if (run.getActivityClusterGraph().isReportTaskDetails()) {
            try {
                this.ccs.getJobLogFile().log(this.createJobLogObject(run));
            }
            catch (Exception e) {
                LOGGER.error("Exception reporting task details for job {}", (Object)jobId, (Object)e);
                caughtException = ExceptionUtils.suppress((Throwable)caughtException, (Throwable)e);
            }
        }
        JobSpecification job = run.getJobSpecification();
        this.jobCapacityController.release(job);
        this.pickJobsToRun();
        if (caughtException != null) {
            throw HyracksException.wrapOrThrowUnchecked((Throwable)caughtException);
        }
    }

    @Override
    public Collection<JobRun> getRunningJobs() {
        return this.activeRunMap.values();
    }

    @Override
    public Collection<JobRun> getPendingJobs() {
        return this.jobQueue.jobs();
    }

    @Override
    public Collection<JobRun> getArchivedJobs() {
        return this.runMapArchive.values();
    }

    @Override
    public JobRun get(JobId jobId) {
        JobRun jobRun = this.activeRunMap.get(jobId);
        if (jobRun == null) {
            jobRun = this.jobQueue.get(jobId);
        }
        if (jobRun == null) {
            jobRun = this.runMapArchive.get(jobId);
        }
        return jobRun;
    }

    @Override
    public List<Exception> getExceptionHistory(JobId jobId) {
        List<Exception> exceptions = this.runMapHistory.get(jobId);
        return exceptions == null ? (this.runMapHistory.containsKey(jobId) ? Collections.emptyList() : null) : exceptions;
    }

    @Override
    public int getJobQueueCapacity() {
        return this.ccs.getCCConfig().getJobQueueCapacity();
    }

    private void pickJobsToRun() throws HyracksException {
        List<JobRun> selectedRuns = this.jobQueue.pull();
        for (JobRun run : selectedRuns) {
            this.executeJob(run);
        }
    }

    private void executeJob(JobRun run) throws HyracksException {
        run.setStartTime(System.currentTimeMillis());
        JobId jobId = run.getJobId();
        this.activeRunMap.put(jobId, run);
        run.setStatus(JobStatus.RUNNING, null);
        this.executeJobInternal(run);
    }

    private void queueJob(JobRun jobRun) throws HyracksException {
        jobRun.setStatus(JobStatus.PENDING, null);
        this.jobQueue.add(jobRun);
    }

    private void executeJobInternal(JobRun run) {
        try {
            run.getExecutor().startJob();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Aborting " + run.getJobId() + " due to failure during job start", (Throwable)e);
            List<Exception> exceptions = Collections.singletonList(e);
            run.setStatus(JobStatus.FAILURE, exceptions);
            run.getExecutor().abortJob(exceptions, (IResultCallback<Void>)NoOpCallback.INSTANCE);
        }
    }

    private ObjectNode createJobLogObject(JobRun run) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode jobLogObject = om.createObjectNode();
        ActivityClusterGraph acg = run.getActivityClusterGraph();
        jobLogObject.set("activity-cluster-graph", (JsonNode)acg.toJSON());
        jobLogObject.set("job-run", (JsonNode)run.toJSON());
        return jobLogObject;
    }

    private void checkJob(JobRun jobRun) throws HyracksException {
        if (jobRun == null) {
            throw HyracksException.create((int)8, (Serializable[])new Serializable[0]);
        }
    }
}

