/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hyracks.api.application.ICCApplication;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.cc.BaseCCApplication;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.CmdLineException;

public class CCDriver {
    private static final Logger LOGGER = LogManager.getLogger();

    private CCDriver() {
    }

    public static void main(String[] args) throws Exception {
        try {
            ConfigManager configManager = new ConfigManager(args);
            ICCApplication application = CCDriver.getApplication(args);
            application.registerConfig((IConfigManager)configManager);
            CCConfig ccConfig = new CCConfig(configManager);
            ClusterControllerService ccService = new ClusterControllerService(ccConfig, application);
            ccService.start();
            while (true) {
                Thread.sleep(100000L);
            }
        }
        catch (CmdLineException e) {
            LOGGER.log(Level.DEBUG, "Exception parsing command line: " + Arrays.toString(args), (Throwable)e);
            System.exit(2);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Exiting CCDriver due to exception", (Throwable)e);
            System.exit(1);
        }
    }

    private static ICCApplication getApplication(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String appClassName = ConfigUtils.getOptionValue((String[])args, (IOption)CCConfig.Option.APP_CLASS);
        return appClassName != null ? (ICCApplication)Class.forName(appClassName).newInstance() : BaseCCApplication.INSTANCE;
    }
}

