/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.asterix.replication.sync.IndexSynchronizer;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexReplicationJob;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexReplicationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IReplicationManager replicationManager;
    private final Set<ReplicationDestination> destinations = new HashSet<ReplicationDestination>();
    private final LinkedBlockingQueue<IReplicationJob> replicationJobsQ = new LinkedBlockingQueue();
    private final IReplicationStrategy replicationStrategy;
    private final PersistentLocalResourceRepository resourceRepository;
    private final INcApplicationContext appCtx;
    private final Object transferLock = new Object();
    private final Set<ReplicationDestination> failedDest = new HashSet<ReplicationDestination>();

    public IndexReplicationManager(INcApplicationContext appCtx, IReplicationManager replicationManager) {
        this.appCtx = appCtx;
        this.replicationManager = replicationManager;
        this.resourceRepository = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
        this.replicationStrategy = replicationManager.getReplicationStrategy();
        appCtx.getThreadExecutor().execute(new ReplicationJobsProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            LOGGER.info(() -> "register " + dest);
            this.destinations.add(dest);
            this.failedDest.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            LOGGER.info(() -> "unregister " + dest);
            this.destinations.remove(dest);
            this.failedDest.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailure(ReplicationDestination dest, Exception e) {
        Object object = this.transferLock;
        synchronized (object) {
            if (this.failedDest.contains(dest)) {
                return;
            }
            LOGGER.error("Replica failed", (Throwable)e);
            if (this.destinations.contains(dest)) {
                this.failedDest.add(dest);
            }
            this.replicationManager.notifyFailure((IReplicationDestination)dest, e);
        }
    }

    public void accept(IReplicationJob job) {
        if (job.getExecutionType() == IReplicationJob.ReplicationExecutionType.ASYNC) {
            this.replicationJobsQ.add(job);
            return;
        }
        this.process(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(IReplicationJob job) {
        try {
            if (this.skip(job)) {
                return;
            }
            Object object = this.transferLock;
            synchronized (object) {
                block13: {
                    if (!this.destinations.isEmpty()) break block13;
                    return;
                }
                IndexSynchronizer synchronizer = new IndexSynchronizer(job, this.appCtx);
                int indexPartition = this.getJobPartition(job);
                for (ReplicationDestination dest : this.destinations) {
                    try {
                        Optional<IPartitionReplica> partitionReplica = dest.getPartitionReplica(indexPartition);
                        if (!partitionReplica.isPresent()) continue;
                        PartitionReplica replica = (PartitionReplica)partitionReplica.get();
                        synchronizer.sync(replica);
                    }
                    catch (Exception e) {
                        this.handleFailure(dest, e);
                    }
                }
                this.closeChannels();
            }
        }
        finally {
            IndexReplicationManager.afterReplication(job);
        }
    }

    private boolean skip(IReplicationJob job) {
        try {
            DatasetResourceReference indexFileRef = this.resourceRepository.getLocalResourceReference(job.getAnyFile());
            return !this.replicationStrategy.isMatch(indexFileRef.getDatasetId());
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException("Couldn't find resource for " + job.getAnyFile(), e);
        }
    }

    private int getJobPartition(IReplicationJob job) {
        return ResourceReference.of((String)job.getAnyFile()).getPartitionNum();
    }

    private void closeChannels() {
        if (!this.replicationJobsQ.isEmpty()) {
            return;
        }
        LOGGER.log(Level.INFO, "No pending replication jobs. Closing connections to replicas");
        for (ReplicationDestination dest : this.destinations) {
            dest.getReplicas().stream().map(PartitionReplica.class::cast).forEach(PartitionReplica::close);
        }
    }

    private static void afterReplication(IReplicationJob job) {
        try {
            if (job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE && job instanceof ILSMIndexReplicationJob) {
                ((ILSMIndexReplicationJob)job).endReplication();
            }
        }
        catch (HyracksDataException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private class ReplicationJobsProcessor
    implements Runnable {
        private ReplicationJobsProcessor() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName(ReplicationJobsProcessor.class.getSimpleName());
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    IReplicationJob job = (IReplicationJob)IndexReplicationManager.this.replicationJobsQ.take();
                    IndexReplicationManager.this.process(job);
                }
                catch (InterruptedException e) {
                    LOGGER.warn(() -> ReplicationJobsProcessor.class.getSimpleName() + " interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            LOGGER.warn("{} stopped.", (Object)ReplicationJobsProcessor.class.getSimpleName());
        }
    }
}

