/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator.util;

import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class PlanTranslationUtil {
    private static final LogicalVariable DUMMY_VAR = new LogicalVariable(-1);

    public static void prepareMetaKeyAccessExpression(List<String> field, LogicalVariable resVar, List<Mutable<ILogicalExpression>> assignExpressions, List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> varRefs, IVariableContext context) {
        AOrderedList value = field.size() > 1 ? new AOrderedList(field) : new AString(field.get(0));
        ScalarFunctionCallExpression metaKeyFunction = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.META_KEY));
        metaKeyFunction.getArguments().add(new MutableObject((Object)new VariableReferenceExpression(resVar)));
        metaKeyFunction.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)value))));
        assignExpressions.add((Mutable<ILogicalExpression>)new MutableObject((Object)metaKeyFunction));
        LogicalVariable v = context.newVar();
        vars.add(v);
        if (varRefs != null) {
            varRefs.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(v)));
        }
    }

    public static void prepareVarAndExpression(List<String> field, LogicalVariable resVar, List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> assignExpressions, List<Mutable<ILogicalExpression>> varRefs, IVariableContext context) {
        ScalarFunctionCallExpression f = PlanTranslationUtil.createFieldAccessExpression((ILogicalExpression)new VariableReferenceExpression(DUMMY_VAR), field);
        f.substituteVar(DUMMY_VAR, resVar);
        assignExpressions.add((Mutable<ILogicalExpression>)new MutableObject((Object)f));
        LogicalVariable v = context.newVar();
        vars.add(v);
        if (varRefs != null) {
            varRefs.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(v)));
        }
    }

    private static ScalarFunctionCallExpression createFieldAccessExpression(ILogicalExpression target, List<String> field) {
        AOrderedList value;
        FunctionIdentifier functionIdentifier;
        if (field.size() > 1) {
            functionIdentifier = BuiltinFunctions.FIELD_ACCESS_NESTED;
            value = new AOrderedList(field);
        } else {
            functionIdentifier = BuiltinFunctions.FIELD_ACCESS_BY_NAME;
            value = new AString(field.get(0));
        }
        IFunctionInfo finfoAccess = FunctionUtil.getFunctionInfo((FunctionIdentifier)functionIdentifier);
        return new ScalarFunctionCallExpression(finfoAccess, new Mutable[]{new MutableObject((Object)target), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)value)))});
    }
}

