/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.asterix.translator.SessionConfig;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;

public class SessionOutput {
    private final SessionConfig config;
    private final PrintWriter out;
    private StringWriter buffer;
    private PrintWriter bufferedOut;
    private final ResultDecorator preResultDecorator;
    private final ResultDecorator postResultDecorator;
    private final ResultAppender handleAppender;
    private final ResultAppender statusAppender;

    public SessionOutput(SessionConfig config, PrintWriter out) {
        this(config, out, null, null, null, null);
    }

    public SessionOutput(SessionConfig config, PrintWriter out, ResultDecorator preResultDecorator, ResultDecorator postResultDecorator, ResultAppender handleAppender, ResultAppender statusAppender) {
        this.config = config;
        this.out = out;
        this.preResultDecorator = preResultDecorator;
        this.postResultDecorator = postResultDecorator;
        this.handleAppender = handleAppender;
        this.statusAppender = statusAppender;
    }

    public PrintWriter out() {
        return this.bufferedOut != null ? this.bufferedOut : this.out;
    }

    public void hold() {
        if (this.bufferedOut == null) {
            this.buffer = new StringWriter();
            this.bufferedOut = new PrintWriter(this.buffer);
        }
    }

    public void release() {
        if (this.bufferedOut != null) {
            this.bufferedOut.flush();
            this.out.write(this.buffer.toString());
            this.bufferedOut = null;
            this.buffer = null;
        }
    }

    public AlgebricksAppendable resultPrefix(AlgebricksAppendable app) throws AlgebricksException {
        return this.preResultDecorator != null ? this.preResultDecorator.append(app) : app;
    }

    public AlgebricksAppendable resultPostfix(AlgebricksAppendable app) throws AlgebricksException {
        return this.postResultDecorator != null ? this.postResultDecorator.append(app) : app;
    }

    public AlgebricksAppendable appendHandle(AlgebricksAppendable app, String handle) throws AlgebricksException {
        return this.handleAppender != null ? this.handleAppender.append(app, handle) : app;
    }

    public AlgebricksAppendable appendStatus(AlgebricksAppendable app, String status) throws AlgebricksException {
        return this.statusAppender != null ? this.statusAppender.append(app, status) : app;
    }

    public SessionConfig config() {
        return this.config;
    }

    @FunctionalInterface
    public static interface ResultAppender {
        public AlgebricksAppendable append(AlgebricksAppendable var1, String var2) throws AlgebricksException;
    }

    @FunctionalInterface
    public static interface ResultDecorator {
        public AlgebricksAppendable append(AlgebricksAppendable var1) throws AlgebricksException;
    }
}

