/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.JoinClause;
import org.apache.asterix.lang.aql.clause.MetaVariableClause;
import org.apache.asterix.lang.aql.expression.MetaVariableExpr;
import org.apache.asterix.lang.aql.visitor.base.IAQLPlusVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.translator.AqlExpressionToPlanTranslator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;

public class AqlPlusExpressionToPlanTranslator
extends AqlExpressionToPlanTranslator
implements IAQLPlusVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>> {
    private MetaScopeLogicalVariable metaScopeExp = new MetaScopeLogicalVariable();
    private MetaScopeILogicalOperator metaScopeOp = new MetaScopeILogicalOperator();

    public AqlPlusExpressionToPlanTranslator(MetadataProvider metadataProvider, Counter currentVarCounter) throws AlgebricksException {
        super(metadataProvider, currentVarCounter);
        this.context.setTopFlwor(false);
    }

    public ILogicalPlan translate(List<Clause> clauses) throws AlgebricksException, CompilationException {
        if (clauses == null) {
            return null;
        }
        MutableObject opRef = new MutableObject((Object)new EmptyTupleSourceOperator());
        Pair p = null;
        for (Clause c : clauses) {
            p = (Pair)c.accept((ILangVisitor)this, (Object)opRef);
            opRef = new MutableObject(p.first);
        }
        ArrayList<MutableObject> globalPlanRoots = new ArrayList<MutableObject>();
        ILogicalOperator topOp = (ILogicalOperator)p.first;
        globalPlanRoots.add(new MutableObject((Object)topOp));
        ALogicalPlanImpl plan = new ALogicalPlanImpl(globalPlanRoots);
        return plan;
    }

    public Pair<ILogicalOperator, LogicalVariable> visitMetaVariableClause(MetaVariableClause mc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return new Pair((Object)this.metaScopeOp.get((Identifier)mc.getVar()), null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visitJoinClause(JoinClause jc, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        InnerJoinOperator join;
        MutableObject opRef = tupSource;
        Pair leftSide = null;
        for (Object c : jc.getLeftClauses()) {
            leftSide = (Pair)c.accept((ILangVisitor)this, opRef);
            opRef = new MutableObject(leftSide.first);
        }
        opRef = tupSource;
        Pair rightSide = null;
        for (Clause c : jc.getRightClauses()) {
            rightSide = (Pair)c.accept((ILangVisitor)this, (Object)opRef);
            opRef = new MutableObject(rightSide.first);
        }
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> whereCond = this.langExprToAlgExpression(jc.getWhereExpr(), (Mutable<ILogicalOperator>)tupSource);
        switch (jc.getKind()) {
            case INNER: {
                join = new InnerJoinOperator((Mutable)new MutableObject(whereCond.first));
                break;
            }
            case LEFT_OUTER: {
                join = new LeftOuterJoinOperator((Mutable)new MutableObject(whereCond.first));
                break;
            }
            default: {
                throw new CompilationException(1025, new Serializable[0]);
            }
        }
        join.getInputs().add(new MutableObject(leftSide.first));
        join.getInputs().add(new MutableObject(rightSide.first));
        return new Pair((Object)join, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visitMetaVariableExpr(MetaVariableExpr me, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        LogicalVariable var = this.context.newVar();
        AssignOperator a = new AssignOperator(var, (Mutable)new MutableObject((Object)this.metaScopeExp.getVariableReferenceExpression((Identifier)me.getVar())));
        a.getInputs().add(tupSource);
        return new Pair((Object)a, (Object)var);
    }

    public void addVariableToMetaScope(Identifier id, LogicalVariable var) {
        this.metaScopeExp.put(id, var);
    }

    public void addOperatorToMetaScope(Identifier id, ILogicalOperator op) {
        this.metaScopeOp.put(id, op);
    }

    @Override
    protected Pair<ILogicalExpression, Mutable<ILogicalOperator>> langExprToAlgExpression(Expression expr, Mutable<ILogicalOperator> topOpRef) throws CompilationException {
        switch (expr.getKind()) {
            case METAVARIABLE_EXPRESSION: {
                VariableReferenceExpression le = this.metaScopeExp.getVariableReferenceExpression((Identifier)((VariableExpr)expr).getVar());
                return new Pair((Object)le, topOpRef);
            }
        }
        return super.langExprToAlgExpression(expr, topOpRef);
    }

    private class MetaScopeILogicalOperator {
        private HashMap<Identifier, ILogicalOperator> map = new HashMap();

        private MetaScopeILogicalOperator() {
        }

        public ILogicalOperator get(Identifier id) throws CompilationException {
            ILogicalOperator op = this.map.get(id);
            if (op == null) {
                throw new CompilationException(1024, new Serializable[]{id.toString()});
            }
            return op;
        }

        public void put(Identifier id, ILogicalOperator op) {
            this.map.put(id, op);
        }
    }

    private class MetaScopeLogicalVariable {
        private HashMap<Identifier, LogicalVariable> map = new HashMap();

        private MetaScopeLogicalVariable() {
        }

        public VariableReferenceExpression getVariableReferenceExpression(Identifier id) throws CompilationException {
            LogicalVariable var = this.map.get(id);
            if (var == null) {
                throw new CompilationException(1024, new Serializable[]{id.toString()});
            }
            return new VariableReferenceExpression(var);
        }

        public void put(Identifier id, LogicalVariable var) {
            this.map.put(id, var);
        }
    }
}

