/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushAggFuncIntoStandaloneAggregateRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp = (AssignOperator)op;
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
            AggregateOperator aggOp = (AggregateOperator)op2;
            return this.pushAggregateFunction(aggOp, assignOp, context);
        }
        if (op2.getOperatorTag() == LogicalOperatorTag.INNERJOIN || op2.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op2;
            if (this.containsAggregate(assignOp.getExpressions()) && this.pushableThroughJoin(join)) {
                return this.pushAggregateFunctionThroughJoin(join, assignOp, context);
            }
        }
        return false;
    }

    private boolean containsAggregate(List<Mutable<ILogicalExpression>> exprRefs) {
        for (Mutable<ILogicalExpression> exprRef : exprRefs) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            FunctionIdentifier funcIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)funcExpr.getFunctionIdentifier());
            if (funcIdent == null) {
                if (!this.containsAggregate(funcExpr.getArguments())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean pushableThroughJoin(AbstractBinaryJoinOperator join) {
        ILogicalExpression condition = (ILogicalExpression)join.getCondition().getValue();
        if (condition.equals(ConstantExpression.TRUE)) {
            boolean pushable = true;
            for (Mutable branchRef : join.getInputs()) {
                AbstractLogicalOperator branch = (AbstractLogicalOperator)branchRef.getValue();
                if (branch.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                    pushable &= true;
                    continue;
                }
                if (branch.getOperatorTag() == LogicalOperatorTag.INNERJOIN || branch.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
                    AbstractBinaryJoinOperator childJoin = (AbstractBinaryJoinOperator)branch;
                    pushable &= this.pushableThroughJoin(childJoin);
                    continue;
                }
                pushable &= false;
            }
            return pushable;
        }
        return false;
    }

    private boolean pushAggregateFunctionThroughJoin(AbstractBinaryJoinOperator join, AssignOperator assignOp, IOptimizationContext context) throws AlgebricksException {
        boolean applied = false;
        for (Mutable branchRef : join.getInputs()) {
            AbstractLogicalOperator branch = (AbstractLogicalOperator)branchRef.getValue();
            if (branch.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                AggregateOperator aggOp = (AggregateOperator)branch;
                applied |= this.pushAggregateFunction(aggOp, assignOp, context);
                continue;
            }
            if (branch.getOperatorTag() != LogicalOperatorTag.INNERJOIN && branch.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) continue;
            AbstractBinaryJoinOperator childJoin = (AbstractBinaryJoinOperator)branch;
            applied |= this.pushAggregateFunctionThroughJoin(childJoin, assignOp, context);
        }
        return applied;
    }

    private boolean pushAggregateFunction(AggregateOperator aggOp, AssignOperator assignOp, IOptimizationContext context) throws AlgebricksException {
        Mutable opRef3 = (Mutable)aggOp.getInputs().get(0);
        AbstractLogicalOperator op3 = (AbstractLogicalOperator)opRef3.getValue();
        if (op3.getOperatorTag() == LogicalOperatorTag.GROUP && !((GroupByOperator)op3).getNestedPlans().isEmpty()) {
            return false;
        }
        if (aggOp.getVariables().size() != 1) {
            return false;
        }
        ILogicalExpression aggExpr = (ILogicalExpression)((Mutable)aggOp.getExpressions().get(0)).getValue();
        if (aggExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression origAggFuncExpr = (AbstractFunctionCallExpression)aggExpr;
        if (origAggFuncExpr.getFunctionIdentifier() != BuiltinFunctions.LISTIFY) {
            return false;
        }
        LogicalVariable aggVar = (LogicalVariable)aggOp.getVariables().get(0);
        LinkedList used = new LinkedList();
        VariableUtilities.getUsedVariables((ILogicalOperator)assignOp, used);
        if (!used.contains(aggVar)) {
            return false;
        }
        LinkedList<Mutable<ILogicalExpression>> srcAssignExprRefs = new LinkedList<Mutable<ILogicalExpression>>();
        if (!this.fingAggFuncExprRef(assignOp.getExpressions(), aggVar, srcAssignExprRefs)) {
            return false;
        }
        if (srcAssignExprRefs.isEmpty()) {
            return false;
        }
        AbstractFunctionCallExpression aggOpExpr = (AbstractFunctionCallExpression)((Mutable)aggOp.getExpressions().get(0)).getValue();
        aggOp.getExpressions().clear();
        aggOp.getVariables().clear();
        for (Mutable mutable : srcAssignExprRefs) {
            AbstractFunctionCallExpression assignFuncExpr = (AbstractFunctionCallExpression)mutable.getValue();
            FunctionIdentifier aggFuncIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)assignFuncExpr.getFunctionIdentifier());
            ArrayList aggArgs = new ArrayList();
            aggArgs.add(aggOpExpr.getArguments().get(0));
            AggregateFunctionCallExpression aggFuncExpr = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)aggFuncIdent, aggArgs);
            LogicalVariable newVar = context.newVar();
            aggOp.getVariables().add(newVar);
            aggOp.getExpressions().add(new MutableObject((Object)aggFuncExpr));
            mutable.setValue((Object)new VariableReferenceExpression(newVar));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        return true;
    }

    private boolean fingAggFuncExprRef(List<Mutable<ILogicalExpression>> exprRefs, LogicalVariable aggVar, List<Mutable<ILogicalExpression>> srcAssignExprRefs) {
        for (Mutable<ILogicalExpression> exprRef : exprRefs) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE && ((VariableReferenceExpression)expr).getVariableReference().equals((Object)aggVar)) {
                return false;
            }
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            FunctionIdentifier funcIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)funcExpr.getFunctionIdentifier());
            if (funcIdent == null) {
                if (this.fingAggFuncExprRef(funcExpr.getArguments(), aggVar, srcAssignExprRefs)) continue;
                return false;
            }
            HashSet usedVars = new HashSet();
            funcExpr.getUsedVariables(usedVars);
            if (!usedVars.contains(aggVar)) continue;
            srcAssignExprRefs.add(exprRef);
        }
        return true;
    }
}

