/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RandomPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceRandomPartitioningFeedComputationRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!op.getOperatorTag().equals((Object)LogicalOperatorTag.ASSIGN)) {
            return false;
        }
        ILogicalOperator opChild = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (!opChild.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
            return false;
        }
        DataSourceScanOperator scanOp = (DataSourceScanOperator)opChild;
        DataSource dataSource = (DataSource)scanOp.getDataSource();
        if (dataSource.getDatasourceType() != 2) {
            return false;
        }
        FeedDataSource feedDataSource = (FeedDataSource)dataSource;
        FeedConnection feedConnection = feedDataSource.getFeedConnection();
        if (feedConnection.getAppliedFunctions() == null || feedConnection.getAppliedFunctions().size() == 0) {
            return false;
        }
        ExchangeOperator exchangeOp = new ExchangeOperator();
        INodeDomain runtimeDomain = feedDataSource.getComputationNodeDomain();
        exchangeOp.setPhysicalOperator((IPhysicalOperator)new RandomPartitionExchangePOperator(runtimeDomain));
        ((Mutable)op.getInputs().get(0)).setValue((Object)exchangeOp);
        exchangeOp.getInputs().add(new MutableObject((Object)scanOp));
        AbstractLogicalOperator.ExecutionMode em = scanOp.getExecutionMode();
        exchangeOp.setExecutionMode(em);
        exchangeOp.computeDeliveredPhysicalProperties(context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)exchangeOp);
        AssignOperator assignOp = (AssignOperator)opRef.getValue();
        AssignPOperator assignPhyOp = (AssignPOperator)assignOp.getPhysicalOperator();
        DefaultNodeGroupDomain computationNode = (DefaultNodeGroupDomain)runtimeDomain;
        String[] nodes = computationNode.getNodes();
        assignPhyOp.setLocationConstraint(nodes);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

