/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.asterix.aqlplus.parser.AQLPlusParser;
import org.apache.asterix.aqlplus.parser.ParseException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.base.FuzzyUtils;
import org.apache.asterix.translator.AqlPlusExpressionToPlanTranslator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FuzzyJoinRule
implements IAlgebraicRewriteRule {
    private static HashSet<FunctionIdentifier> simFuncs = new HashSet();
    private static final String AQLPLUS = "((#RIGHT),   (join((#LEFT),     (    join(       (       #LEFT_1       let $tokensUnrankedLeft := %s($$LEFT_1)       let $lenLeft := len($tokensUnrankedLeft)       let $tokensLeft :=         for $token in $tokensUnrankedLeft         for $tokenRanked at $i in           #RIGHT_2           let $id := $$RIGHTPK_2           for $token in %s($$RIGHT_2)           /*+ hash */           group by $tokenGroupped := $token with $id           /*+ inmem 34 198608 */           order by count($id), $tokenGroupped           return $tokenGroupped         where $token = /*+ bcast */ $tokenRanked         order by $i         return $i       for $prefixTokenLeft in subset-collection($tokensLeft, 0, prefix-len-%s(len($tokensLeft), %ff))       ),(       #RIGHT_1       let $tokensUnrankedRight := %s($$RIGHT_1)       let $lenRight := len($tokensUnrankedRight)       let $tokensRight :=         for $token in $tokensUnrankedRight         for $tokenRanked at $i in           #RIGHT_3           let $id := $$RIGHTPK_3           for $token in %s($$RIGHT_3)           /*+ hash */           group by $tokenGroupped := $token with $id           /*+ inmem 34 198608 */           order by count($id), $tokenGroupped           return $tokenGroupped         where $token = /*+ bcast */ $tokenRanked         order by $i         return $i       for $prefixTokenRight in subset-collection($tokensRight, 0, prefix-len-%s(len($tokensRight), %ff))       ), $prefixTokenLeft = $prefixTokenRight)     let $sim := similarity-%s-prefix($lenLeft, $tokensLeft, $lenRight, $tokensRight, $prefixTokenLeft, %ff)     where $sim >= %ff     /*+ hash*/     group by $idLeft := $$LEFTPK_1, $idRight := $$RIGHTPK_1 with $sim     ), $$LEFTPK = $idLeft)),  $$RIGHTPK = $idRight)";
    private Collection<LogicalVariable> liveVars = new HashSet<LogicalVariable>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        List<Clause> clauses;
        String prepareJoin;
        IAType right2;
        LogicalVariable rightInputVar;
        LogicalVariable leftInputVar;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        Mutable expRef = joinOp.getCondition();
        Mutable<ILogicalExpression> getItemExprRef = this.getSimilarityExpression((Mutable<ILogicalExpression>)expRef);
        if (getItemExprRef == null) {
            return false;
        }
        AbstractFunctionCallExpression getItemFuncExpr = (AbstractFunctionCallExpression)getItemExprRef.getValue();
        Mutable argRef = (Mutable)getItemFuncExpr.getArguments().get(0);
        AbstractFunctionCallExpression simFuncExpr = (AbstractFunctionCallExpression)argRef.getValue();
        if (!simFuncs.contains(simFuncExpr.getFunctionIdentifier())) {
            return false;
        }
        if (simFuncExpr.getAnnotations().containsKey(IndexedNLJoinExpressionAnnotation.INSTANCE)) {
            return false;
        }
        List inputOps = joinOp.getInputs();
        ILogicalOperator leftInputOp = (ILogicalOperator)((Mutable)inputOps.get(0)).getValue();
        ILogicalOperator rightInputOp = (ILogicalOperator)((Mutable)inputOps.get(1)).getValue();
        List inputExps = simFuncExpr.getArguments();
        ILogicalExpression inputExp0 = (ILogicalExpression)((Mutable)inputExps.get(0)).getValue();
        ILogicalExpression inputExp1 = (ILogicalExpression)((Mutable)inputExps.get(1)).getValue();
        if (inputExp0.getExpressionTag() != LogicalExpressionTag.VARIABLE || inputExp1.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        LogicalVariable inputVar0 = ((VariableReferenceExpression)inputExp0).getVariableReference();
        LogicalVariable inputVar1 = ((VariableReferenceExpression)inputExp1).getVariableReference();
        this.liveVars.clear();
        VariableUtilities.getLiveVariables((ILogicalOperator)leftInputOp, this.liveVars);
        if (this.liveVars.contains(inputVar0)) {
            leftInputVar = inputVar0;
            rightInputVar = inputVar1;
        } else {
            leftInputVar = inputVar1;
            rightInputVar = inputVar0;
        }
        List leftInputPKs = context.findPrimaryKey(leftInputVar);
        List rightInputPKs = context.findPrimaryKey(rightInputVar);
        if (leftInputPKs == null || rightInputPKs == null) {
            return false;
        }
        if (leftInputPKs.size() != 1 || rightInputPKs.size() != 1) {
            return false;
        }
        IAType leftType = (IAType)context.getOutputTypeEnvironment(leftInputOp).getVarType(leftInputVar);
        IAType rightType = (IAType)context.getOutputTypeEnvironment(rightInputOp).getVarType(rightInputVar);
        IAType left2 = TypeComputeUtils.getActualType((IAType)leftType);
        if (!left2.deepEqual((IAObject)(right2 = TypeComputeUtils.getActualType((IAType)rightType)))) {
            return false;
        }
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        FunctionIdentifier funcId = FuzzyUtils.getTokenizer(leftType.getTypeTag());
        String tokenizer = funcId == null ? "" : funcId.getName();
        float simThreshold = FuzzyUtils.getSimThreshold(metadataProvider);
        String simFunction = FuzzyUtils.getSimFunction(metadataProvider);
        switch (joinOp.getJoinKind()) {
            case INNER: {
                prepareJoin = "join((#RIGHT),   (join((#LEFT),     (    join(       (       #LEFT_1       let $tokensUnrankedLeft := %s($$LEFT_1)       let $lenLeft := len($tokensUnrankedLeft)       let $tokensLeft :=         for $token in $tokensUnrankedLeft         for $tokenRanked at $i in           #RIGHT_2           let $id := $$RIGHTPK_2           for $token in %s($$RIGHT_2)           /*+ hash */           group by $tokenGroupped := $token with $id           /*+ inmem 34 198608 */           order by count($id), $tokenGroupped           return $tokenGroupped         where $token = /*+ bcast */ $tokenRanked         order by $i         return $i       for $prefixTokenLeft in subset-collection($tokensLeft, 0, prefix-len-%s(len($tokensLeft), %ff))       ),(       #RIGHT_1       let $tokensUnrankedRight := %s($$RIGHT_1)       let $lenRight := len($tokensUnrankedRight)       let $tokensRight :=         for $token in $tokensUnrankedRight         for $tokenRanked at $i in           #RIGHT_3           let $id := $$RIGHTPK_3           for $token in %s($$RIGHT_3)           /*+ hash */           group by $tokenGroupped := $token with $id           /*+ inmem 34 198608 */           order by count($id), $tokenGroupped           return $tokenGroupped         where $token = /*+ bcast */ $tokenRanked         order by $i         return $i       for $prefixTokenRight in subset-collection($tokensRight, 0, prefix-len-%s(len($tokensRight), %ff))       ), $prefixTokenLeft = $prefixTokenRight)     let $sim := similarity-%s-prefix($lenLeft, $tokensLeft, $lenRight, $tokensRight, $prefixTokenLeft, %ff)     where $sim >= %ff     /*+ hash*/     group by $idLeft := $$LEFTPK_1, $idRight := $$RIGHTPK_1 with $sim     ), $$LEFTPK = $idLeft)),  $$RIGHTPK = $idRight)";
                break;
            }
            case LEFT_OUTER: {
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        String aqlPlus = String.format(Locale.US, prepareJoin, tokenizer, tokenizer, simFunction, Float.valueOf(simThreshold), tokenizer, tokenizer, simFunction, Float.valueOf(simThreshold), simFunction, Float.valueOf(simThreshold), Float.valueOf(simThreshold));
        LogicalVariable leftPKVar = (LogicalVariable)leftInputPKs.get(0);
        LogicalVariable rightPKVar = (LogicalVariable)rightInputPKs.get(0);
        Counter counter = new Counter(context.getVarCounter());
        AQLPlusParser parser = new AQLPlusParser(new StringReader(aqlPlus));
        parser.initScope();
        parser.setVarCounter(counter);
        try {
            clauses = parser.Clauses();
        }
        catch (ParseException e) {
            throw new AlgebricksException((Throwable)e);
        }
        AqlPlusExpressionToPlanTranslator translator = new AqlPlusExpressionToPlanTranslator(metadataProvider, counter);
        context.setVarCounter(counter.get());
        LogicalOperatorDeepCopyWithNewVariablesVisitor deepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, (ITypingContext)context);
        translator.addOperatorToMetaScope(new Identifier("#LEFT"), leftInputOp);
        translator.addVariableToMetaScope(new Identifier("$$LEFT"), leftInputVar);
        translator.addVariableToMetaScope(new Identifier("$$LEFTPK"), leftPKVar);
        translator.addOperatorToMetaScope(new Identifier("#RIGHT"), rightInputOp);
        translator.addVariableToMetaScope(new Identifier("$$RIGHT"), rightInputVar);
        translator.addVariableToMetaScope(new Identifier("$$RIGHTPK"), rightPKVar);
        translator.addOperatorToMetaScope(new Identifier("#LEFT_1"), deepCopyVisitor.deepCopy(leftInputOp));
        translator.addVariableToMetaScope(new Identifier("$$LEFT_1"), deepCopyVisitor.varCopy(leftInputVar));
        translator.addVariableToMetaScope(new Identifier("$$LEFTPK_1"), deepCopyVisitor.varCopy(leftPKVar));
        deepCopyVisitor.updatePrimaryKeys(context);
        deepCopyVisitor.reset();
        translator.addOperatorToMetaScope(new Identifier("#RIGHT_1"), deepCopyVisitor.deepCopy(rightInputOp));
        translator.addVariableToMetaScope(new Identifier("$$RIGHT_1"), deepCopyVisitor.varCopy(rightInputVar));
        translator.addVariableToMetaScope(new Identifier("$$RIGHTPK_1"), deepCopyVisitor.varCopy(rightPKVar));
        deepCopyVisitor.updatePrimaryKeys(context);
        deepCopyVisitor.reset();
        translator.addOperatorToMetaScope(new Identifier("#RIGHT_2"), deepCopyVisitor.deepCopy(rightInputOp));
        translator.addVariableToMetaScope(new Identifier("$$RIGHT_2"), deepCopyVisitor.varCopy(rightInputVar));
        translator.addVariableToMetaScope(new Identifier("$$RIGHTPK_2"), deepCopyVisitor.varCopy(rightPKVar));
        deepCopyVisitor.updatePrimaryKeys(context);
        deepCopyVisitor.reset();
        translator.addOperatorToMetaScope(new Identifier("#RIGHT_3"), deepCopyVisitor.deepCopy(rightInputOp));
        translator.addVariableToMetaScope(new Identifier("$$RIGHT_3"), deepCopyVisitor.varCopy(rightInputVar));
        translator.addVariableToMetaScope(new Identifier("$$RIGHTPK_3"), deepCopyVisitor.varCopy(rightPKVar));
        deepCopyVisitor.updatePrimaryKeys(context);
        deepCopyVisitor.reset();
        ILogicalPlan plan = translator.translate(clauses);
        context.setVarCounter(counter.get());
        ILogicalOperator outputOp = (ILogicalOperator)((Mutable)plan.getRoots().get(0)).getValue();
        SelectOperator extraSelect = null;
        if (getItemExprRef != expRef) {
            getItemExprRef.setValue((Object)ConstantExpression.TRUE);
            switch (joinOp.getJoinKind()) {
                case INNER: {
                    extraSelect = new SelectOperator(expRef, false, null);
                    extraSelect.getInputs().add(new MutableObject((Object)outputOp));
                    outputOp = extraSelect;
                    break;
                }
                case LEFT_OUTER: {
                    if (((AbstractLogicalOperator)outputOp).getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
                        throw new IllegalStateException();
                    }
                    LeftOuterJoinOperator topJoin = (LeftOuterJoinOperator)outputOp;
                    topJoin.getCondition().setValue(expRef.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        opRef.setValue((Object)outputOp);
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return true;
    }

    private Mutable<ILogicalExpression> getSimilarityExpression(Mutable<ILogicalExpression> expRef) {
        ILogicalExpression exp = (ILogicalExpression)expRef.getValue();
        if (exp.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)exp;
            if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.GET_ITEM)) {
                return expRef;
            }
            if (funcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
                for (int i = 0; i < 2; ++i) {
                    Mutable<ILogicalExpression> expRefRet = this.getSimilarityExpression((Mutable<ILogicalExpression>)((Mutable)funcExpr.getArguments().get(i)));
                    if (expRefRet == null) continue;
                    return expRefRet;
                }
            }
        }
        return null;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    static {
        simFuncs.add(BuiltinFunctions.SIMILARITY_JACCARD_CHECK);
    }
}

