/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;

public class AddEquivalenceClassForRecordConstructorRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        PhysicalOptimizationsUtil.computeFDsAndEquivalenceClasses((ILogicalOperator)op, (IOptimizationContext)context);
        AssignOperator assignOp = (AssignOperator)op;
        List vars = assignOp.getVariables();
        List exprRefs = assignOp.getExpressions();
        return this.addEquivalenceClassesForRecordConstructor(vars, exprRefs, assignOp, context);
    }

    private boolean addEquivalenceClassesForRecordConstructor(List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> exprRefs, AssignOperator assignOp, IOptimizationContext context) {
        boolean changed = false;
        for (int exprIndex = 0; exprIndex < exprRefs.size(); ++exprIndex) {
            AbstractFunctionCallExpression funcExpr;
            FunctionIdentifier fid;
            ILogicalExpression expr = (ILogicalExpression)exprRefs.get(exprIndex).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (fid = (funcExpr = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()) != BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR && fid != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) continue;
            changed |= this.propagateEquivalenceClassesForRecordConstructor(vars.get(exprIndex), funcExpr, assignOp, context);
        }
        return changed;
    }

    private boolean propagateEquivalenceClassesForRecordConstructor(LogicalVariable recordVar, AbstractFunctionCallExpression funcExpr, AssignOperator assignOp, IOptimizationContext context) {
        List argRefs = funcExpr.getArguments();
        boolean changed = false;
        for (int parameterIndex = 1; parameterIndex < argRefs.size(); parameterIndex += 2) {
            ILogicalExpression fieldExpr = (ILogicalExpression)((Mutable)argRefs.get(parameterIndex)).getValue();
            if (fieldExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)fieldExpr;
            LogicalVariable fieldVar = varExpr.getVariableReference();
            HashMap<LogicalVariable, EquivalenceClass> ecs = context.getEquivalenceClassMap((ILogicalOperator)assignOp);
            if (ecs == null) {
                ecs = new HashMap<LogicalVariable, EquivalenceClass>();
                context.putEquivalenceClassMap((ILogicalOperator)assignOp, ecs);
            }
            ScalarFunctionCallExpression expr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)new VariableReferenceExpression(recordVar)), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(parameterIndex / 2))))});
            EquivalenceClass equivClass = new EquivalenceClass(Collections.singletonList(fieldVar), fieldVar, Collections.singletonList(expr));
            ecs.put(fieldVar, equivClass);
            changed = true;
        }
        return changed;
    }
}

