/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static List<Exception> getActualExceptions(List<Exception> allExceptions) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Exception exception : allExceptions) {
            if (!ExceptionUtils.possibleRootCause(exception)) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    public static void setNodeIds(Collection<Exception> exceptions, String nodeId) {
        ArrayList<Exception> newExceptions = new ArrayList<Exception>();
        for (Exception e : exceptions) {
            if (e instanceof HyracksDataException) {
                if (((HyracksDataException)e).getNodeId() == null) {
                    newExceptions.add(HyracksDataException.create((HyracksDataException)e, nodeId));
                    continue;
                }
                newExceptions.add(e);
                continue;
            }
            newExceptions.add(new HyracksDataException("HYR", 3, e, new Serializable[]{nodeId}));
        }
        exceptions.clear();
        exceptions.addAll(newExceptions);
    }

    private static boolean possibleRootCause(Throwable exception) {
        Throwable cause = exception;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof InterruptedException) && !(cause instanceof ClosedChannelException)) continue;
            return false;
        }
        return true;
    }

    public static Throwable suppress(Throwable first, Throwable second) {
        if (second != null && second instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first != second) {
            first.addSuppressed(second);
        }
        return first;
    }

    public static Throwable fromThreadStack(Thread thread) {
        Throwable stackThrowable = new Throwable(thread.getName() + " Stack trace");
        stackThrowable.setStackTrace(thread.getStackTrace());
        return stackThrowable;
    }
}

