/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private CleanupUtils() {
    }

    public static Throwable destroy(Throwable root, IDestroyable ... destroyables) {
        for (IDestroyable destroyable : destroyables) {
            if (destroyable == null) continue;
            try {
                destroyable.destroy();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure destroying a destroyable resource", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress(root, th);
            }
        }
        return root;
    }

    public static Throwable close(IFrameWriter writer, Throwable root) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure closing a closeable resource", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress(root, th);
            }
        }
        return root;
    }

    public static void fail(IFrameWriter writer, Throwable root) {
        try {
            writer.fail();
        }
        catch (Throwable th) {
            try {
                LOGGER.log(Level.WARN, "Failure failing " + writer.getClass().getSimpleName(), th);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            root.addSuppressed(th);
        }
    }

    public static Throwable close(AutoCloseable closable, Throwable root) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Throwable th) {
                try {
                    LOGGER.log(Level.WARN, "Failure closing a closeable resource", th);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                root = ExceptionUtils.suppress(root, th);
            }
        }
        return root;
    }
}

