/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.io;

import java.io.File;
import java.io.Serializable;
import org.apache.hyracks.api.io.IODeviceHandle;

public final class FileReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final IODeviceHandle dev;
    private final String path;

    public FileReference(IODeviceHandle dev, String path) {
        this.file = new File(dev.getMount(), path);
        this.dev = dev;
        this.path = path;
    }

    public File getFile() {
        return this.file;
    }

    public IODeviceHandle getDeviceHandle() {
        return this.dev;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileReference)) {
            return false;
        }
        return this.path.equals(((FileReference)o).path) && this.dev.equals(((FileReference)o).dev);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String getRelativePath() {
        return this.path;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public FileReference getChild(String name) {
        return new FileReference(this.dev, this.path + File.separator + name);
    }
}

