/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.IDatasetStateRecord;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.dataset.ResultSetMetaData;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DatasetJobRecord
implements IDatasetStateRecord {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private Status status;
    private Map<ResultSetId, ResultSetMetaData> resultSetMetadataMap = new HashMap<ResultSetId, ResultSetMetaData>();

    public DatasetJobRecord() {
        this.timestamp = System.nanoTime();
        this.status = new Status();
    }

    private void updateState(State newStatus) {
        if (this.status.state != State.FAILED) {
            this.status.setState(newStatus);
        }
    }

    public void start() {
        this.updateState(State.RUNNING);
    }

    public void success() {
        this.updateState(State.SUCCESS);
    }

    public void fail(ResultSetId rsId, int partition) {
        this.getOrCreateDirectoryRecord(rsId, partition).fail();
    }

    public void fail(List<Exception> exceptions) {
        this.updateState(State.FAILED);
        this.status.setExceptions(exceptions);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"status\": ").append(this.status.toString()).append(", ");
        sb.append("\"timestamp\": ").append(this.timestamp).append(", ");
        sb.append("\"resultsets\": ").append(Arrays.toString(this.resultSetMetadataMap.entrySet().toArray())).append(" }");
        return sb.toString();
    }

    public void setResultSetMetaData(ResultSetId rsId, boolean orderedResult, int nPartitions) throws HyracksDataException {
        ResultSetMetaData rsMd = this.resultSetMetadataMap.get(rsId);
        if (rsMd == null) {
            this.resultSetMetadataMap.put(rsId, new ResultSetMetaData(nPartitions, orderedResult));
        } else if (rsMd.getOrderedResult() != orderedResult || rsMd.getRecords().length != nPartitions) {
            throw HyracksDataException.create(18, new Serializable[]{rsId.toString()});
        }
    }

    public ResultSetMetaData getResultSetMetaData(ResultSetId rsId) {
        return this.resultSetMetadataMap.get(rsId);
    }

    public synchronized DatasetDirectoryRecord getOrCreateDirectoryRecord(ResultSetId rsId, int partition) {
        DatasetDirectoryRecord[] records = this.getResultSetMetaData(rsId).getRecords();
        if (records[partition] == null) {
            records[partition] = new DatasetDirectoryRecord();
        }
        return records[partition];
    }

    public synchronized DatasetDirectoryRecord getDirectoryRecord(ResultSetId rsId, int partition) throws HyracksDataException {
        DatasetDirectoryRecord[] records = this.getResultSetMetaData(rsId).getRecords();
        if (records[partition] == null) {
            throw HyracksDataException.create(32, Integer.valueOf(partition), rsId);
        }
        return records[partition];
    }

    public synchronized void updateState(ResultSetId rsId) {
        DatasetDirectoryRecord[] records;
        int successCount = 0;
        for (DatasetDirectoryRecord record : records = this.getResultSetMetaData(rsId).getRecords()) {
            if (record == null || record.getStatus() != DatasetDirectoryRecord.Status.SUCCESS) continue;
            ++successCount;
        }
        if (successCount == records.length) {
            this.success();
        }
    }

    public static class Status
    implements Serializable {
        private static final long serialVersionUID = 1L;
        State state = State.IDLE;
        private List<Exception> exceptions;

        public State getState() {
            return this.state;
        }

        void setState(State state) {
            this.state = state;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        void setExceptions(List<Exception> exceptions) {
            this.exceptions = exceptions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"state\": \"").append(this.state.name()).append("\"");
            if (this.exceptions != null && !this.exceptions.isEmpty()) {
                sb.append(", \"exceptions\": ");
                ArrayList msgs = new ArrayList();
                this.exceptions.forEach(e -> msgs.add("\"" + e.getMessage() + "\""));
                sb.append(Arrays.toString(msgs.toArray()));
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        SUCCESS,
        FAILED;

    }
}

