/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.ActivityClusterId;
import org.apache.hyracks.api.job.JobActivityGraph;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivityClusterGraphBuilder {
    private static final Logger LOGGER = LogManager.getLogger();

    private static Pair<ActivityId, ActivityId> findMergePair(JobActivityGraph jag, Set<Set<ActivityId>> eqSets) {
        for (Set<ActivityId> eqSet : eqSets) {
            for (ActivityId t : eqSet) {
                List<IConnectorDescriptor> outputList;
                List<IConnectorDescriptor> inputList = jag.getActivityInputMap().get(t);
                if (inputList != null) {
                    for (IConnectorDescriptor conn : inputList) {
                        ActivityId inTask = jag.getProducerActivity(conn.getConnectorId());
                        if (eqSet.contains(inTask)) continue;
                        return Pair.of((Object)t, (Object)inTask);
                    }
                }
                if ((outputList = jag.getActivityOutputMap().get(t)) == null) continue;
                for (IConnectorDescriptor conn : outputList) {
                    ActivityId outTask = jag.getConsumerActivity(conn.getConnectorId());
                    if (eqSet.contains(outTask)) continue;
                    return Pair.of((Object)t, (Object)outTask);
                }
            }
        }
        return null;
    }

    public ActivityClusterGraph inferActivityClusters(JobActivityGraph jag) {
        HashMap<ActivityId, Set<ActivityId>> stageMap = new HashMap<ActivityId, Set<ActivityId>>();
        HashSet<Set<ActivityId>> stages = new HashSet<Set<ActivityId>>();
        for (ActivityId taskId : jag.getActivityMap().keySet()) {
            HashSet<ActivityId> eqSet = new HashSet<ActivityId>();
            eqSet.add(taskId);
            stageMap.put(taskId, eqSet);
            stages.add(eqSet);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Pair<ActivityId, ActivityId> pair = ActivityClusterGraphBuilder.findMergePair(jag, stages);
            if (pair == null) continue;
            this.merge(stageMap, stages, (ActivityId)pair.getLeft(), (ActivityId)pair.getRight());
            changed = true;
        }
        ActivityClusterGraph acg = new ActivityClusterGraph();
        HashMap<ActivityId, Object> acMap = new HashMap<ActivityId, Object>();
        int acCounter = 0;
        Map<ActivityId, IActivity> activityNodeMap = jag.getActivityMap();
        ArrayList<ActivityCluster> acList = new ArrayList<ActivityCluster>();
        for (Set set : stages) {
            ActivityCluster ac = new ActivityCluster(acg, new ActivityClusterId(acCounter++));
            acList.add(ac);
            for (ActivityId aid : set) {
                IActivity activity = activityNodeMap.get(aid);
                ac.addActivity(activity);
                acMap.put(aid, ac);
            }
        }
        for (Set set : stages) {
            for (ActivityId aid : set) {
                IActivity activity = activityNodeMap.get(aid);
                ActivityCluster ac = (ActivityCluster)acMap.get(aid);
                List<IConnectorDescriptor> aOutputs = jag.getActivityOutputMap().get(aid);
                if (aOutputs == null || aOutputs.isEmpty()) {
                    ac.addRoot(activity);
                    continue;
                }
                int nActivityOutputs = aOutputs.size();
                for (int i = 0; i < nActivityOutputs; ++i) {
                    IConnectorDescriptor conn = aOutputs.get(i);
                    ac.addConnector(conn);
                    Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> pcPair = jag.getConnectorActivityMap().get(conn.getConnectorId());
                    ac.connect(conn, activity, i, (IActivity)((Pair)pcPair.getRight()).getLeft(), (Integer)((Pair)pcPair.getRight()).getRight(), jag.getConnectorRecordDescriptorMap().get(conn.getConnectorId()));
                }
            }
        }
        Map<ActivityId, Set<ActivityId>> blocked2BlockerMap = jag.getBlocked2BlockerMap();
        for (ActivityCluster s : acList) {
            Map<ActivityId, Set<ActivityId>> acBlocked2BlockerMap = s.getBlocked2BlockerMap();
            HashSet blockerStages = new HashSet();
            for (ActivityId t : s.getActivityMap().keySet()) {
                Set<ActivityId> blockerTasks = blocked2BlockerMap.get(t);
                acBlocked2BlockerMap.put(t, blockerTasks);
                if (blockerTasks == null) continue;
                for (ActivityId bt : blockerTasks) {
                    blockerStages.add(acMap.get(bt));
                }
            }
            for (ActivityCluster bs : blockerStages) {
                s.getDependencies().add(bs);
            }
        }
        acg.addActivityClusters(acList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(acg.toJSON().asText());
        }
        return acg;
    }

    private void merge(Map<ActivityId, Set<ActivityId>> eqSetMap, Set<Set<ActivityId>> eqSets, ActivityId t1, ActivityId t2) {
        Set<ActivityId> stage1 = eqSetMap.get(t1);
        Set<ActivityId> stage2 = eqSetMap.get(t2);
        HashSet<ActivityId> mergedSet = new HashSet<ActivityId>();
        mergedSet.addAll(stage1);
        mergedSet.addAll(stage2);
        eqSets.remove(stage1);
        eqSets.remove(stage2);
        eqSets.add(mergedSet);
        for (ActivityId t : mergedSet) {
            eqSetMap.put(t, mergedSet);
        }
    }
}

