/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class FormUrlEncodedRequest
extends BaseRequest
implements IServletRequest {
    private final List<String> names;
    private final List<String> values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServletRequest create(FullHttpRequest request) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)request);
        try {
            List bodyHttpDatas = decoder.getBodyHttpDatas();
            for (InterfaceHttpData data : bodyHttpDatas) {
                if (!data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) continue;
                MixedAttribute attr = (MixedAttribute)data;
                names.add(data.getName());
                values.add(attr.getValue());
            }
        }
        finally {
            decoder.destroy();
        }
        return new FormUrlEncodedRequest(request, new QueryStringDecoder(request.uri()).parameters(), names, values);
    }

    protected FormUrlEncodedRequest(FullHttpRequest request, Map<String, List<String>> parameters, List<String> names, List<String> values) {
        super(request, parameters);
        this.names = names;
        this.values = values;
    }

    @Override
    public String getParameter(CharSequence name) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (!name.equals(this.names.get(i))) continue;
            return this.values.get(i);
        }
        return HttpUtil.getParameter(this.parameters, name);
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        paramNames.addAll(this.parameters.keySet());
        paramNames.addAll(this.names);
        return Collections.unmodifiableSet(paramNames);
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(super.getParameters());
        for (int i = 0; i < this.names.size(); ++i) {
            paramMap.put(this.names.get(i), this.values.get(i));
        }
        return Collections.unmodifiableMap(paramMap);
    }
}

