/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hyracks.http.server.ChunkedResponse;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkedNettyOutputStream
extends OutputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChannelHandlerContext ctx;
    private final ChunkedResponse response;
    private ByteBuf buffer;
    private boolean closed;

    public ChunkedNettyOutputStream(ChannelHandlerContext ctx, int chunkSize, ChunkedResponse response) {
        this.response = response;
        this.ctx = ctx;
        this.buffer = ctx.alloc().buffer(chunkSize);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            while (len > 0) {
                int space = this.buffer.writableBytes();
                if (space >= len) {
                    this.buffer.writeBytes(b, off, len);
                    len = 0;
                    continue;
                }
                this.buffer.writeBytes(b, off, space);
                len -= space;
                off += space;
                this.flush();
            }
        }
        catch (OutOfDirectMemoryError error) {
            this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            throw error;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.isWritable()) {
            this.flush();
        }
        this.buffer.writeByte(b);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.response.isHeaderSent() || this.response.status() != HttpResponseStatus.OK) {
                try {
                    this.flush();
                }
                finally {
                    if (this.buffer != null) {
                        this.buffer.release();
                    }
                }
            } else {
                this.response.fullReponse(this.buffer);
            }
            super.close();
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.ensureWritable();
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            if (this.response.status() == HttpResponseStatus.OK) {
                int size = this.buffer.capacity();
                this.response.beforeFlush();
                DefaultHttpContent content = new DefaultHttpContent(this.buffer);
                this.ctx.writeAndFlush((Object)content, this.ctx.channel().voidPromise());
                this.buffer = null;
                this.buffer = this.ctx.alloc().buffer(size);
            } else {
                ByteBuf aBuffer = this.ctx.alloc().buffer(this.buffer.readableBytes());
                aBuffer.writeBytes(this.buffer);
                this.response.error(aBuffer);
                this.buffer.clear();
            }
        }
    }

    private synchronized void ensureWritable() throws IOException {
        while (!this.ctx.channel().isWritable()) {
            try {
                if (!this.ctx.channel().isActive()) {
                    throw new IOException("Inactive channel");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.WARN, "Interupted while waiting for channel to be writable", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    public synchronized void resume() {
        this.notifyAll();
    }
}

