/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class BaseRequest
implements IServletRequest {
    protected final FullHttpRequest request;
    protected final Map<String, List<String>> parameters;

    public static IServletRequest create(FullHttpRequest request) throws IOException {
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map param = decoder.parameters();
        return new BaseRequest(request, param);
    }

    protected BaseRequest(FullHttpRequest request, Map<String, List<String>> parameters) {
        this.request = request;
        this.parameters = parameters;
    }

    @Override
    public FullHttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getParameter(CharSequence name) {
        return HttpUtil.getParameter(this.parameters, name);
    }

    @Override
    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String name : this.parameters.keySet()) {
            paramMap.put(name, HttpUtil.getParameter(this.parameters, name));
        }
        return Collections.unmodifiableMap(paramMap);
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.request.headers().get(name);
    }
}

