/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.DoubleParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.FloatParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IntegerParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.LongParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.UTF8StringParserFactory;

public class ExternalDataUtils {
    private static Map<ATypeTag, IValueParserFactory> valueParserFactoryMap = ExternalDataUtils.initializeValueParserFactoryMap();

    public static char getDelimiter(Map<String, String> configuration) throws AsterixException {
        String delimiterValue = configuration.get("delimiter");
        if (delimiterValue == null) {
            delimiterValue = ",";
        } else if (delimiterValue.length() != 1) {
            throw new AsterixException("'" + delimiterValue + "' is not a valid delimiter. The length of a delimiter should be 1.");
        }
        return delimiterValue.charAt(0);
    }

    public static char getQuote(Map<String, String> configuration, char delimiter) throws AsterixException {
        String quoteValue = configuration.get("quote");
        if (quoteValue == null) {
            quoteValue = "\"";
        } else if (quoteValue.length() != 1) {
            throw new AsterixException("'" + quoteValue + "' is not a valid quote. The length of a quote should be 1.");
        }
        if (quoteValue.charAt(0) == delimiter) {
            throw new AsterixException("Quote '" + quoteValue + "' cannot be used with the delimiter '" + delimiter + "'. ");
        }
        return quoteValue.charAt(0);
    }

    public static boolean getHasHeader(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("header"));
    }

    public static void validateParameters(Map<String, String> configuration) throws AsterixException {
        ExternalDataUtils.validateDataSourceParameters(configuration);
        ExternalDataUtils.validateDataParserParameters(configuration);
    }

    public static void validateDataParserParameters(Map<String, String> configuration) throws AsterixException {
        String parserFactory;
        String parser = configuration.get("format");
        if (parser == null && (parserFactory = configuration.get("parser-factory")) == null) {
            throw new AsterixException("The parameter format or parser-factory must be specified.");
        }
    }

    public static void validateDataSourceParameters(Map<String, String> configuration) throws AsterixException {
        String reader = configuration.get("reader");
        if (reader == null) {
            throw new AsterixException("The parameter reader must be specified.");
        }
    }

    public static IExternalDataSourceFactory.DataSourceType getDataSourceType(Map<String, String> configuration) {
        String reader = configuration.get("reader");
        if (reader != null && reader.equals("stream")) {
            return IExternalDataSourceFactory.DataSourceType.STREAM;
        }
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    public static boolean isExternal(String aString) {
        return aString != null && aString.contains("#") && aString.trim().length() > 1;
    }

    public static ClassLoader getClassLoader(ILibraryManager libraryManager, String dataverse, String library) {
        return libraryManager.getLibraryClassLoader(dataverse, library);
    }

    public static String getLibraryName(String aString) {
        return aString.trim().split("#")[0];
    }

    public static String getExternalClassName(String aString) {
        return aString.trim().split("#")[1];
    }

    public static IInputStreamFactory createExternalInputStreamFactory(ILibraryManager libraryManager, String dataverse, String stream) throws HyracksDataException {
        try {
            String libraryName = ExternalDataUtils.getLibraryName(stream);
            String className = ExternalDataUtils.getExternalClassName(stream);
            ClassLoader classLoader = ExternalDataUtils.getClassLoader(libraryManager, dataverse, libraryName);
            return (IInputStreamFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(3024, (Throwable)e, new Serializable[0]);
        }
    }

    public static String getDataverse(Map<String, String> configuration) {
        return configuration.get("dataverse");
    }

    public static String getRecordFormat(Map<String, String> configuration) {
        String parserFormat = configuration.get("parser");
        return parserFormat != null ? parserFormat : configuration.get("format");
    }

    public static void setRecordFormat(Map<String, String> configuration, String format) {
        if (!configuration.containsKey("parser")) {
            configuration.put("parser", format);
        }
        if (!configuration.containsKey("format")) {
            configuration.put("format", format);
        }
    }

    private static Map<ATypeTag, IValueParserFactory> initializeValueParserFactoryMap() {
        EnumMap<ATypeTag, IValueParserFactory> m = new EnumMap<ATypeTag, IValueParserFactory>(ATypeTag.class);
        m.put(ATypeTag.INTEGER, IntegerParserFactory.INSTANCE);
        m.put(ATypeTag.FLOAT, FloatParserFactory.INSTANCE);
        m.put(ATypeTag.DOUBLE, DoubleParserFactory.INSTANCE);
        m.put(ATypeTag.BIGINT, LongParserFactory.INSTANCE);
        m.put(ATypeTag.STRING, UTF8StringParserFactory.INSTANCE);
        return m;
    }

    public static IValueParserFactory[] getValueParserFactories(ARecordType recordType) {
        int n = recordType.getFieldTypes().length;
        IValueParserFactory[] fieldParserFactories = new IValueParserFactory[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = null;
            if (recordType.getFieldTypes()[i].getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)recordType.getFieldTypes()[i];
                if (!unionType.isUnknownableType()) {
                    throw new NotImplementedException("Non-optional UNION type is not supported.");
                }
                tag = unionType.getActualType().getTypeTag();
            } else {
                tag = recordType.getFieldTypes()[i].getTypeTag();
            }
            if (tag == null) {
                throw new NotImplementedException("Failed to get the type information for field " + i + ".");
            }
            fieldParserFactories[i] = ExternalDataUtils.getParserFactory(tag);
        }
        return fieldParserFactories;
    }

    public static IValueParserFactory getParserFactory(ATypeTag tag) {
        IValueParserFactory vpf = valueParserFactoryMap.get(tag);
        if (vpf == null) {
            throw new NotImplementedException("No value parser factory for fields of type " + tag);
        }
        return vpf;
    }

    public static String getRecordReaderStreamName(Map<String, String> configuration) {
        return configuration.get("stream");
    }

    public static boolean hasHeader(Map<String, String> configuration) {
        String value = configuration.get("header");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static IRecordReaderFactory<?> createExternalRecordReaderFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws AsterixException {
        String readerFactory = configuration.get("reader-factory");
        if (readerFactory == null) {
            throw new AsterixException("to use external reader, the parameter reader-factory must be specified.");
        }
        String[] libraryAndFactory = readerFactory.split("#");
        if (libraryAndFactory.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        String[] dataverseAndLibrary = libraryAndFactory[0].split(".");
        if (dataverseAndLibrary.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        ClassLoader classLoader = libraryManager.getLibraryClassLoader(dataverseAndLibrary[0], dataverseAndLibrary[1]);
        try {
            return (IRecordReaderFactory)classLoader.loadClass(libraryAndFactory[1]).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create record reader factory", (Throwable)e);
        }
    }

    public static IDataParserFactory createExternalParserFactory(ILibraryManager libraryManager, String dataverse, String parserFactoryName) throws AsterixException {
        try {
            String library = parserFactoryName.substring(0, parserFactoryName.indexOf("#"));
            ClassLoader classLoader = libraryManager.getLibraryClassLoader(dataverse, library);
            return (IDataParserFactory)classLoader.loadClass(parserFactoryName.substring(parserFactoryName.indexOf("#") + 1)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create an external parser factory", (Throwable)e);
        }
    }

    public static boolean isFeed(Map<String, String> configuration) {
        if (!configuration.containsKey("is-feed")) {
            return false;
        }
        return Boolean.parseBoolean(configuration.get("is-feed"));
    }

    public static void prepareFeed(Map<String, String> configuration, String dataverseName, String feedName) {
        if (!configuration.containsKey("is-feed")) {
            configuration.put("is-feed", "true");
        }
        configuration.put("dataverse", dataverseName);
        configuration.put("feed", feedName);
    }

    public static boolean keepDataSourceOpen(Map<String, String> configuration) {
        if (!configuration.containsKey("wait-for-data")) {
            return true;
        }
        return Boolean.parseBoolean(configuration.get("wait-for-data"));
    }

    public static String getFeedName(Map<String, String> configuration) {
        return configuration.get("feed");
    }

    public static int getQueueSize(Map<String, String> configuration) {
        return configuration.containsKey("queue-size") ? Integer.parseInt(configuration.get("queue-size")) : 64;
    }

    public static boolean isRecordWithMeta(Map<String, String> configuration) {
        return configuration.containsKey("meta-type-name");
    }

    public static void setRecordWithMeta(Map<String, String> configuration, String booleanString) {
        configuration.put("record-with-metadata", booleanString);
    }

    public static boolean isChangeFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("change-feed"));
    }

    public static boolean isInsertFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("insert-feed"));
    }

    public static int getNumberOfKeys(Map<String, String> configuration) throws AsterixException {
        String keyIndexes = configuration.get("key-indexes");
        if (keyIndexes == null) {
            throw new AsterixException("A change feed must have the parameter key-indexes");
        }
        return keyIndexes.split(",").length;
    }

    public static void setNumberOfKeys(Map<String, String> configuration, int value) {
        configuration.put("key-size", String.valueOf(value));
    }

    public static void setChangeFeed(Map<String, String> configuration, String booleanString) {
        configuration.put("change-feed", booleanString);
    }

    public static int[] getPKIndexes(Map<String, String> configuration) {
        String keyIndexes = configuration.get("key-indexes");
        String[] stringIndexes = keyIndexes.split(",");
        int[] intIndexes = new int[stringIndexes.length];
        for (int i = 0; i < stringIndexes.length; ++i) {
            intIndexes[i] = Integer.parseInt(stringIndexes[i]);
        }
        return intIndexes;
    }

    public static int[] getPKSourceIndicators(Map<String, String> configuration) {
        String keyIndicators = configuration.get("key-indicators");
        String[] stringIndicators = keyIndicators.split(",");
        int[] intIndicators = new int[stringIndicators.length];
        for (int i = 0; i < stringIndicators.length; ++i) {
            intIndicators[i] = Integer.parseInt(stringIndicators[i]);
        }
        return intIndicators;
    }
}

