/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.jackson;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.asterix.om.util.container.IObjectFactory;

public class ObjectPool<E, T> {
    private final IObjectFactory<E, T> objectFactory;
    private final Queue<E> recycledObjects;
    private final T element;

    public ObjectPool() {
        this(null, null);
    }

    public ObjectPool(IObjectFactory<E, T> objectFactory) {
        this(objectFactory, null);
    }

    public ObjectPool(IObjectFactory<E, T> objectFactory, T element) {
        this.objectFactory = objectFactory;
        this.recycledObjects = new ArrayDeque();
        this.element = element;
    }

    public E getInstance() {
        Object instance = this.recycledObjects.poll();
        if (this.objectFactory != null && instance == null) {
            instance = this.objectFactory.create(this.element);
        }
        return instance;
    }

    public void recycle(E object) {
        if (object != null) {
            this.recycledObjects.add(object);
        }
    }
}

