/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AsterixInputStreamReader
extends Reader {
    private AsterixInputStream in;
    private byte[] bytes = new byte[4096];
    private ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
    private CharBuffer charBuffer = CharBuffer.allocate(4096);
    private CharsetDecoder decoder;
    private boolean done = false;
    private boolean remaining = false;

    public AsterixInputStreamReader(AsterixInputStream in) {
        this.in = in;
        this.decoder = StandardCharsets.UTF_8.newDecoder();
        this.byteBuffer.flip();
    }

    public void stop() throws IOException {
        try {
            this.in.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setController(AbstractFeedDataFlowController controller) {
        this.in.setController(controller);
    }

    public void setFeedLogManager(FeedLogManager feedLogManager) throws HyracksDataException {
        this.in.setFeedLogManager(feedLogManager);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (this.done) {
            return -1;
        }
        int len = 0;
        this.charBuffer.clear();
        while (this.charBuffer.position() == 0) {
            if (this.byteBuffer.hasRemaining()) {
                this.remaining = true;
                this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                System.arraycopy(this.charBuffer.array(), 0, cbuf, offset, this.charBuffer.position());
                if (this.charBuffer.position() > 0) {
                    return this.charBuffer.position();
                }
                System.arraycopy(this.bytes, this.byteBuffer.position(), this.bytes, 0, this.byteBuffer.remaining());
                this.byteBuffer.position(this.byteBuffer.remaining());
                while (len == 0) {
                    len = this.in.read(this.bytes, this.byteBuffer.position(), this.bytes.length - this.byteBuffer.position());
                }
            } else {
                this.byteBuffer.clear();
                while (len == 0) {
                    len = this.in.read(this.bytes, 0, this.bytes.length);
                }
            }
            if (len == -1) {
                this.done = true;
                return len;
            }
            if (this.remaining) {
                this.byteBuffer.position(len + this.byteBuffer.position());
            } else {
                this.byteBuffer.position(len);
            }
            this.byteBuffer.flip();
            this.remaining = false;
            this.decoder.decode(this.byteBuffer, this.charBuffer, false);
            System.arraycopy(this.charBuffer.array(), 0, cbuf, offset, this.charBuffer.position());
        }
        return this.charBuffer.position();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public boolean handleException(Throwable th) {
        return this.in.handleException(th);
    }

    @Override
    public void reset() throws IOException {
        this.byteBuffer.limit(0);
    }
}

