/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.converter;

import java.io.IOException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.IRecordToRecordWithMetadataAndPKConverter;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;

public class CSVToRecordWithMetadataAndPKConverter
implements IRecordToRecordWithMetadataAndPKConverter<char[], char[]> {
    private final FieldCursorForDelimitedDataParser cursor;
    private final int valueIndex;
    private final RecordWithMetadataAndPK<char[]> recordWithMetadata;
    private final CharArrayRecord record;

    public CSVToRecordWithMetadataAndPKConverter(int valueIndex, char delimiter, ARecordType metaType, ARecordType recordType, int[] keyIndicator, int[] keyIndexes, IAType[] keyTypes) {
        this.cursor = new FieldCursorForDelimitedDataParser(null, delimiter, '\"');
        this.record = new CharArrayRecord();
        this.valueIndex = valueIndex;
        this.recordWithMetadata = new RecordWithMetadataAndPK<char[]>(this.record, metaType.getFieldTypes(), recordType, keyIndicator, keyIndexes, keyTypes);
    }

    @Override
    public RecordWithMetadataAndPK<char[]> convert(IRawRecord<? extends char[]> input) throws IOException {
        this.record.reset();
        this.recordWithMetadata.reset();
        this.cursor.nextRecord(input.get(), input.size());
        int i = 0;
        int j = 0;
        while (this.cursor.nextField()) {
            if (this.cursor.isDoubleQuoteIncludedInThisField) {
                this.cursor.eliminateDoubleQuote(this.cursor.buffer, this.cursor.fStart, this.cursor.fEnd - this.cursor.fStart);
                this.cursor.fEnd -= this.cursor.doubleQuoteCount;
                this.cursor.isDoubleQuoteIncludedInThisField = false;
            }
            if (i == this.valueIndex) {
                this.record.setValue(this.cursor.buffer, this.cursor.fStart, this.cursor.fEnd - this.cursor.fStart);
                this.record.endRecord();
            } else {
                this.recordWithMetadata.setRawMetadata(j, this.cursor.buffer, this.cursor.fStart, this.cursor.fEnd - this.cursor.fStart);
                ++j;
            }
            ++i;
        }
        return this.recordWithMetadata;
    }
}

